/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// CustomFieldContextDefaultValueSingleVersionPicker : The default value for a version picker custom field.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct CustomFieldContextDefaultValueSingleVersionPicker {
    /// The ID of the default version.
    #[serde(rename = "versionId")]
    pub version_id: String,
    /// The order the pickable versions are displayed in. If not provided, the released-first order is used. Available version orders are `\"releasedFirst\"` and `\"unreleasedFirst\"`.
    #[serde(rename = "versionOrder", skip_serializing_if = "Option::is_none")]
    pub version_order: Option<String>,
    #[serde(rename = "type")]
    pub _type: String,
}

impl CustomFieldContextDefaultValueSingleVersionPicker {
    /// The default value for a version picker custom field.
    pub fn new(version_id: String, _type: String) -> CustomFieldContextDefaultValueSingleVersionPicker {
        CustomFieldContextDefaultValueSingleVersionPicker {
            version_id,
            version_order: None,
            _type,
        }
    }
}


