/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// ApplicationRole : Details of an application role.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ApplicationRole {
    /// The key of the application role.
    #[serde(rename = "key", skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    /// The groups associated with the application role. As a group's name can change, use of `groupDetails` is recommended to identify a groups.
    #[serde(rename = "groups", skip_serializing_if = "Option::is_none")]
    pub groups: Option<Vec<String>>,
    /// The groups associated with the application role.
    #[serde(rename = "groupDetails", skip_serializing_if = "Option::is_none")]
    pub group_details: Option<Vec<crate::models::GroupName>>,
    /// The display name of the application role.
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// The groups that are granted default access for this application role. As a group's name can change, use of `defaultGroupsDetails` is recommended to identify a groups.
    #[serde(rename = "defaultGroups", skip_serializing_if = "Option::is_none")]
    pub default_groups: Option<Vec<String>>,
    /// The groups that are granted default access for this application role.
    #[serde(rename = "defaultGroupsDetails", skip_serializing_if = "Option::is_none")]
    pub default_groups_details: Option<Vec<crate::models::GroupName>>,
    /// Determines whether this application role should be selected by default on user creation.
    #[serde(rename = "selectedByDefault", skip_serializing_if = "Option::is_none")]
    pub selected_by_default: Option<bool>,
    /// Deprecated.
    #[serde(rename = "defined", skip_serializing_if = "Option::is_none")]
    pub defined: Option<bool>,
    /// The maximum count of users on your license.
    #[serde(rename = "numberOfSeats", skip_serializing_if = "Option::is_none")]
    pub number_of_seats: Option<i32>,
    /// The count of users remaining on your license.
    #[serde(rename = "remainingSeats", skip_serializing_if = "Option::is_none")]
    pub remaining_seats: Option<i32>,
    /// The number of users counting against your license.
    #[serde(rename = "userCount", skip_serializing_if = "Option::is_none")]
    pub user_count: Option<i32>,
    /// The [type of users](https://confluence.atlassian.com/x/lRW3Ng) being counted against your license.
    #[serde(rename = "userCountDescription", skip_serializing_if = "Option::is_none")]
    pub user_count_description: Option<String>,
    #[serde(rename = "hasUnlimitedSeats", skip_serializing_if = "Option::is_none")]
    pub has_unlimited_seats: Option<bool>,
    /// Indicates if the application role belongs to Jira platform (`jira-core`).
    #[serde(rename = "platform", skip_serializing_if = "Option::is_none")]
    pub platform: Option<bool>,
}

impl ApplicationRole {
    /// Details of an application role.
    pub fn new() -> ApplicationRole {
        ApplicationRole {
            key: None,
            groups: None,
            group_details: None,
            name: None,
            default_groups: None,
            default_groups_details: None,
            selected_by_default: None,
            defined: None,
            number_of_seats: None,
            remaining_seats: None,
            user_count: None,
            user_count_description: None,
            has_unlimited_seats: None,
            platform: None,
        }
    }
}


