/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};

/// struct for passing parameters to the method [`add_screen_tab_field`]
#[derive(Clone, Debug, Default)]
pub struct AddScreenTabFieldParams {
    /// The ID of the screen.
    pub screen_id: i64,
    /// The ID of the screen tab.
    pub tab_id: i64,
    pub add_field_bean: crate::models::AddFieldBean
}

/// struct for passing parameters to the method [`get_all_screen_tab_fields`]
#[derive(Clone, Debug, Default)]
pub struct GetAllScreenTabFieldsParams {
    /// The ID of the screen.
    pub screen_id: i64,
    /// The ID of the screen tab.
    pub tab_id: i64,
    /// The key of the project.
    pub project_key: Option<String>
}

/// struct for passing parameters to the method [`move_screen_tab_field`]
#[derive(Clone, Debug, Default)]
pub struct MoveScreenTabFieldParams {
    /// The ID of the screen.
    pub screen_id: i64,
    /// The ID of the screen tab.
    pub tab_id: i64,
    /// The ID of the field.
    pub id: String,
    pub move_field_bean: crate::models::MoveFieldBean
}

/// struct for passing parameters to the method [`remove_screen_tab_field`]
#[derive(Clone, Debug, Default)]
pub struct RemoveScreenTabFieldParams {
    /// The ID of the screen.
    pub screen_id: i64,
    /// The ID of the screen tab.
    pub tab_id: i64,
    /// The ID of the field.
    pub id: String
}


/// struct for typed successes of method [`add_screen_tab_field`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AddScreenTabFieldSuccess {
    Status200(crate::models::ScreenableField),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`get_all_screen_tab_fields`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetAllScreenTabFieldsSuccess {
    Status200(Vec<crate::models::ScreenableField>),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`move_screen_tab_field`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum MoveScreenTabFieldSuccess {
    Status204(serde_json::Value),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`remove_screen_tab_field`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RemoveScreenTabFieldSuccess {
    Status204(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`add_screen_tab_field`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AddScreenTabFieldError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_all_screen_tab_fields`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetAllScreenTabFieldsError {
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`move_screen_tab_field`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum MoveScreenTabFieldError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`remove_screen_tab_field`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RemoveScreenTabFieldError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}


/// Adds a field to a screen tab.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
pub async fn add_screen_tab_field(configuration: &configuration::Configuration, params: AddScreenTabFieldParams) -> Result<ResponseContent<AddScreenTabFieldSuccess>, Error<AddScreenTabFieldError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let screen_id = params.screen_id;
    let tab_id = params.tab_id;
    let add_field_bean = params.add_field_bean;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/screens/{screenId}/tabs/{tabId}/fields", local_var_configuration.base_path, screenId=screen_id, tabId=tab_id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&add_field_bean);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<AddScreenTabFieldSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<AddScreenTabFieldError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Returns all fields for a screen tab.  **[Permissions](#permissions) required:**   *  *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).  *  *Administer projects* [project permission](https://confluence.atlassian.com/x/yodKLg) when the project key is specified, providing that the screen is associated with the project through a Screen Scheme and Issue Type Screen Scheme.
pub async fn get_all_screen_tab_fields(configuration: &configuration::Configuration, params: GetAllScreenTabFieldsParams) -> Result<ResponseContent<GetAllScreenTabFieldsSuccess>, Error<GetAllScreenTabFieldsError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let screen_id = params.screen_id;
    let tab_id = params.tab_id;
    let project_key = params.project_key;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/screens/{screenId}/tabs/{tabId}/fields", local_var_configuration.base_path, screenId=screen_id, tabId=tab_id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = project_key {
        local_var_req_builder = local_var_req_builder.query(&[("projectKey", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<GetAllScreenTabFieldsSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<GetAllScreenTabFieldsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Moves a screen tab field.  If `after` and `position` are provided in the request, `position` is ignored.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
pub async fn move_screen_tab_field(configuration: &configuration::Configuration, params: MoveScreenTabFieldParams) -> Result<ResponseContent<MoveScreenTabFieldSuccess>, Error<MoveScreenTabFieldError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let screen_id = params.screen_id;
    let tab_id = params.tab_id;
    let id = params.id;
    let move_field_bean = params.move_field_bean;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/screens/{screenId}/tabs/{tabId}/fields/{id}/move", local_var_configuration.base_path, screenId=screen_id, tabId=tab_id, id=crate::apis::urlencode(id));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&move_field_bean);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<MoveScreenTabFieldSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<MoveScreenTabFieldError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Removes a field from a screen tab.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
pub async fn remove_screen_tab_field(configuration: &configuration::Configuration, params: RemoveScreenTabFieldParams) -> Result<ResponseContent<RemoveScreenTabFieldSuccess>, Error<RemoveScreenTabFieldError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let screen_id = params.screen_id;
    let tab_id = params.tab_id;
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/screens/{screenId}/tabs/{tabId}/fields/{id}", local_var_configuration.base_path, screenId=screen_id, tabId=tab_id, id=crate::apis::urlencode(id));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::DELETE, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<RemoveScreenTabFieldSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<RemoveScreenTabFieldError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

