/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};

/// struct for passing parameters to the method [`update_custom_field_value`]
#[derive(Clone, Debug, Default)]
pub struct UpdateCustomFieldValueParams {
    /// The ID or key of the custom field. For example, `customfield_10010`.
    pub field_id_or_key: String,
    pub custom_field_value_update_details: crate::models::CustomFieldValueUpdateDetails,
    /// Whether to generate a changelog for this update.
    pub generate_changelog: Option<bool>
}

/// struct for passing parameters to the method [`update_multiple_custom_field_values`]
#[derive(Clone, Debug, Default)]
pub struct UpdateMultipleCustomFieldValuesParams {
    pub multiple_custom_field_values_update_details: crate::models::MultipleCustomFieldValuesUpdateDetails,
    /// Whether to generate a changelog for this update.
    pub generate_changelog: Option<bool>
}


/// struct for typed successes of method [`update_custom_field_value`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateCustomFieldValueSuccess {
    Status204(serde_json::Value),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`update_multiple_custom_field_values`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateMultipleCustomFieldValuesSuccess {
    Status204(serde_json::Value),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`update_custom_field_value`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateCustomFieldValueError {
    Status400(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`update_multiple_custom_field_values`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateMultipleCustomFieldValuesError {
    Status400(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}


/// Updates the value of a custom field on one or more issues. Custom fields can only be updated by the Forge app that created them.  **[Permissions](#permissions) required:** Only the app that created the custom field can update its values with this operation.
pub async fn update_custom_field_value(configuration: &configuration::Configuration, params: UpdateCustomFieldValueParams) -> Result<ResponseContent<UpdateCustomFieldValueSuccess>, Error<UpdateCustomFieldValueError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let field_id_or_key = params.field_id_or_key;
    let custom_field_value_update_details = params.custom_field_value_update_details;
    let generate_changelog = params.generate_changelog;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/app/field/{fieldIdOrKey}/value", local_var_configuration.base_path, fieldIdOrKey=crate::apis::urlencode(field_id_or_key));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::PUT, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = generate_changelog {
        local_var_req_builder = local_var_req_builder.query(&[("generateChangelog", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&custom_field_value_update_details);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<UpdateCustomFieldValueSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<UpdateCustomFieldValueError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Updates the value of one or more custom fields on one or more issues. Combinations of custom field and issue should be unique within the request. Custom fields can only be updated by the Forge app that created them.  **[Permissions](#permissions) required:** Only the app that created the custom field can update its values with this operation.
pub async fn update_multiple_custom_field_values(configuration: &configuration::Configuration, params: UpdateMultipleCustomFieldValuesParams) -> Result<ResponseContent<UpdateMultipleCustomFieldValuesSuccess>, Error<UpdateMultipleCustomFieldValuesError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let multiple_custom_field_values_update_details = params.multiple_custom_field_values_update_details;
    let generate_changelog = params.generate_changelog;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/app/field/value", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = generate_changelog {
        local_var_req_builder = local_var_req_builder.query(&[("generateChangelog", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&multiple_custom_field_values_update_details);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<UpdateMultipleCustomFieldValuesSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<UpdateMultipleCustomFieldValuesError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

