/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// WorkflowTransitionRulesUpdateErrorDetails : Details of any errors encountered while updating workflow transition rules for a workflow.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct WorkflowTransitionRulesUpdateErrorDetails {
    #[serde(rename = "workflowId")]
    pub workflow_id: crate::models::WorkflowId,
    /// A list of transition rule update errors, indexed by the transition rule ID. Any transition rule that appears here wasn't updated.
    #[serde(rename = "ruleUpdateErrors")]
    pub rule_update_errors: ::std::collections::HashMap<String, Vec<String>>,
    /// The list of errors that specify why the workflow update failed. The workflow was not updated if the list contains any entries.
    #[serde(rename = "updateErrors")]
    pub update_errors: Vec<String>,
}

impl WorkflowTransitionRulesUpdateErrorDetails {
    /// Details of any errors encountered while updating workflow transition rules for a workflow.
    pub fn new(workflow_id: crate::models::WorkflowId, rule_update_errors: ::std::collections::HashMap<String, Vec<String>>, update_errors: Vec<String>) -> WorkflowTransitionRulesUpdateErrorDetails {
        WorkflowTransitionRulesUpdateErrorDetails {
            workflow_id: workflow_id,
            rule_update_errors,
            update_errors,
        }
    }
}


