/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// Workflow : Details about a workflow.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Workflow {
    #[serde(rename = "id")]
    pub id: crate::models::PublishedWorkflowId,
    /// The description of the workflow.
    #[serde(rename = "description")]
    pub description: String,
    /// The transitions of the workflow.
    #[serde(rename = "transitions", skip_serializing_if = "Option::is_none")]
    pub transitions: Option<Vec<crate::models::Transition>>,
    /// The statuses of the workflow.
    #[serde(rename = "statuses", skip_serializing_if = "Option::is_none")]
    pub statuses: Option<Vec<crate::models::WorkflowStatus>>,
    /// Whether this is the default workflow.
    #[serde(rename = "isDefault", skip_serializing_if = "Option::is_none")]
    pub is_default: Option<bool>,
    /// The workflow schemes the workflow is assigned to.
    #[serde(rename = "schemes", skip_serializing_if = "Option::is_none")]
    pub schemes: Option<Vec<crate::models::WorkflowSchemeIdName>>,
    /// The projects the workflow is assigned to, through workflow schemes.
    #[serde(rename = "projects", skip_serializing_if = "Option::is_none")]
    pub projects: Option<Vec<crate::models::ProjectDetails>>,
    /// Whether the workflow has a draft version.
    #[serde(rename = "hasDraftWorkflow", skip_serializing_if = "Option::is_none")]
    pub has_draft_workflow: Option<bool>,
    #[serde(rename = "operations", skip_serializing_if = "Option::is_none")]
    pub operations: Option<crate::models::WorkflowOperations>,
    /// The creation date of the workflow.
    #[serde(rename = "created", skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    /// The last edited date of the workflow.
    #[serde(rename = "updated", skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
}

impl Workflow {
    /// Details about a workflow.
    pub fn new(id: crate::models::PublishedWorkflowId, description: String) -> Workflow {
        Workflow {
            id: id,
            description,
            transitions: None,
            statuses: None,
            is_default: None,
            schemes: None,
            projects: None,
            has_draft_workflow: None,
            operations: None,
            created: None,
            updated: None,
        }
    }
}


