/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// TimeTrackingConfiguration : Details of the time tracking configuration.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct TimeTrackingConfiguration {
    /// The number of hours in a working day.
    #[serde(rename = "workingHoursPerDay")]
    pub working_hours_per_day: f64,
    /// The number of days in a working week.
    #[serde(rename = "workingDaysPerWeek")]
    pub working_days_per_week: f64,
    /// The format that will appear on an issue's *Time Spent* field.
    #[serde(rename = "timeFormat")]
    pub time_format: TimeFormat,
    /// The default unit of time applied to logged time.
    #[serde(rename = "defaultUnit")]
    pub default_unit: DefaultUnit,
}

impl TimeTrackingConfiguration {
    /// Details of the time tracking configuration.
    pub fn new(working_hours_per_day: f64, working_days_per_week: f64, time_format: TimeFormat, default_unit: DefaultUnit) -> TimeTrackingConfiguration {
        TimeTrackingConfiguration {
            working_hours_per_day,
            working_days_per_week,
            time_format,
            default_unit,
        }
    }
}

/// The format that will appear on an issue's *Time Spent* field.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum TimeFormat {
    #[serde(rename = "pretty")]
    Pretty,
    #[serde(rename = "days")]
    Days,
    #[serde(rename = "hours")]
    Hours,
}

impl Default for TimeFormat {
    fn default() -> TimeFormat {
        Self::Pretty
    }
}
/// The default unit of time applied to logged time.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum DefaultUnit {
    #[serde(rename = "minute")]
    Minute,
    #[serde(rename = "hour")]
    Hour,
    #[serde(rename = "day")]
    Day,
    #[serde(rename = "week")]
    Week,
}

impl Default for DefaultUnit {
    fn default() -> DefaultUnit {
        Self::Minute
    }
}

