/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// JqlQueryToSanitize : The JQL query to sanitize for the account ID. If the account ID is null, sanitizing is performed for an anonymous user.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct JqlQueryToSanitize {
    /// The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
    #[serde(rename = "accountId", skip_serializing_if = "Option::is_none")]
    pub account_id: Option<String>,
    /// The query to sanitize.
    #[serde(rename = "query")]
    pub query: String,
}

impl JqlQueryToSanitize {
    /// The JQL query to sanitize for the account ID. If the account ID is null, sanitizing is performed for an anonymous user.
    pub fn new(query: String) -> JqlQueryToSanitize {
        JqlQueryToSanitize {
            account_id: None,
            query,
        }
    }
}


