/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// JqlQueryField : A field used in a JQL query. See [Advanced searching - fields reference](https://confluence.atlassian.com/x/dAiiLQ) for more information about fields in JQL queries.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct JqlQueryField {
    /// The name of the field.
    #[serde(rename = "name")]
    pub name: String,
    /// When the field refers to a value in an entity property, details of the entity property value.
    #[serde(rename = "property", skip_serializing_if = "Option::is_none")]
    pub property: Option<Vec<crate::models::JqlQueryFieldEntityProperty>>,
}

impl JqlQueryField {
    /// A field used in a JQL query. See [Advanced searching - fields reference](https://confluence.atlassian.com/x/dAiiLQ) for more information about fields in JQL queries.
    pub fn new(name: String) -> JqlQueryField {
        JqlQueryField {
            name,
            property: None,
        }
    }
}


