/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// IssueTypeSchemeDetails : Details of an issue type scheme and its associated issue types.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct IssueTypeSchemeDetails {
    /// The name of the issue type scheme. The name must be unique. The maximum length is 255 characters.
    #[serde(rename = "name")]
    pub name: String,
    /// The description of the issue type scheme. The maximum length is 4000 characters.
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// The ID of the default issue type of the issue type scheme. This ID must be included in `issueTypeIds`.
    #[serde(rename = "defaultIssueTypeId", skip_serializing_if = "Option::is_none")]
    pub default_issue_type_id: Option<String>,
    /// The list of issue types IDs of the issue type scheme. At least one standard issue type ID is required.
    #[serde(rename = "issueTypeIds")]
    pub issue_type_ids: Vec<String>,
}

impl IssueTypeSchemeDetails {
    /// Details of an issue type scheme and its associated issue types.
    pub fn new(name: String, issue_type_ids: Vec<String>) -> IssueTypeSchemeDetails {
        IssueTypeSchemeDetails {
            name,
            description: None,
            default_issue_type_id: None,
            issue_type_ids,
        }
    }
}


