/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// IssueSecurityLevelMember : Issue security level member.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct IssueSecurityLevelMember {
    /// The ID of the issue security level member.
    #[serde(rename = "id")]
    pub id: i64,
    /// The ID of the issue security level.
    #[serde(rename = "issueSecurityLevelId")]
    pub issue_security_level_id: i64,
    /// The user or group being granted the permission. It consists of a `type` and a type-dependent `parameter`. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.
    #[serde(rename = "holder")]
    pub holder: Option<crate::models::PermissionHolder>,
}

impl IssueSecurityLevelMember {
    /// Issue security level member.
    pub fn new(id: i64, issue_security_level_id: i64, holder: Option<crate::models::PermissionHolder>) -> IssueSecurityLevelMember {
        IssueSecurityLevelMember {
            id,
            issue_security_level_id,
            holder: holder,
        }
    }
}


