/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// FieldChangedClause : A clause that asserts whether a field was changed. For example, `status CHANGED AFTER startOfMonth(-1M)`.See [CHANGED](https://confluence.atlassian.com/x/dgiiLQ#Advancedsearching-operatorsreference-CHANGEDCHANGED) for more information about the CHANGED operator.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FieldChangedClause {
    #[serde(rename = "field")]
    pub field: crate::models::JqlQueryField,
    /// The operator applied to the field.
    #[serde(rename = "operator")]
    pub operator: Operator,
    /// The list of time predicates.
    #[serde(rename = "predicates")]
    pub predicates: Vec<crate::models::JqlQueryClauseTimePredicate>,
}

impl FieldChangedClause {
    /// A clause that asserts whether a field was changed. For example, `status CHANGED AFTER startOfMonth(-1M)`.See [CHANGED](https://confluence.atlassian.com/x/dgiiLQ#Advancedsearching-operatorsreference-CHANGEDCHANGED) for more information about the CHANGED operator.
    pub fn new(field: crate::models::JqlQueryField, operator: Operator, predicates: Vec<crate::models::JqlQueryClauseTimePredicate>) -> FieldChangedClause {
        FieldChangedClause {
            field: field,
            operator,
            predicates,
        }
    }
}

/// The operator applied to the field.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Operator {
    #[serde(rename = "changed")]
    Changed,
}

impl Default for Operator {
    fn default() -> Operator {
        Self::Changed
    }
}

