/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// CustomFieldOptionUpdate : Details of a custom field option for a context.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct CustomFieldOptionUpdate {
    /// The ID of the custom field option.
    #[serde(rename = "id")]
    pub id: String,
    /// The value of the custom field option.
    #[serde(rename = "value", skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    /// Whether the option is disabled.
    #[serde(rename = "disabled", skip_serializing_if = "Option::is_none")]
    pub disabled: Option<bool>,
}

impl CustomFieldOptionUpdate {
    /// Details of a custom field option for a context.
    pub fn new(id: String) -> CustomFieldOptionUpdate {
        CustomFieldOptionUpdate {
            id,
            value: None,
            disabled: None,
        }
    }
}


