/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// CreateWorkflowCondition : A workflow transition condition.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct CreateWorkflowCondition {
    /// The compound condition operator.
    #[serde(rename = "operator", skip_serializing_if = "Option::is_none")]
    pub operator: Option<Operator>,
    /// The list of workflow conditions.
    #[serde(rename = "conditions", skip_serializing_if = "Option::is_none")]
    pub conditions: Option<Vec<crate::models::CreateWorkflowCondition>>,
    /// The type of the transition rule.
    #[serde(rename = "type", skip_serializing_if = "Option::is_none")]
    pub _type: Option<String>,
    /// EXPERIMENTAL. The configuration of the transition rule.
    #[serde(rename = "configuration", skip_serializing_if = "Option::is_none")]
    pub configuration: Option<::std::collections::HashMap<String, serde_json::Value>>,
}

impl CreateWorkflowCondition {
    /// A workflow transition condition.
    pub fn new() -> CreateWorkflowCondition {
        CreateWorkflowCondition {
            operator: None,
            conditions: None,
            _type: None,
            configuration: None,
        }
    }
}

/// The compound condition operator.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Operator {
    #[serde(rename = "AND")]
    AND,
    #[serde(rename = "OR")]
    OR,
}

impl Default for Operator {
    fn default() -> Operator {
        Self::AND
    }
}

