/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// ContextualConfiguration : Details of the contextual configuration for a custom field.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ContextualConfiguration {
    /// The ID of the configuration.
    #[serde(rename = "id")]
    pub id: String,
    /// Deprecated, do not use.
    #[serde(rename = "contextId", skip_serializing_if = "Option::is_none")]
    pub context_id: Option<i64>,
    /// The ID of the field context the configuration is associated with.
    #[serde(rename = "fieldContextId")]
    pub field_context_id: String,
    /// The field configuration.
    #[serde(rename = "configuration", skip_serializing_if = "Option::is_none")]
    pub configuration: Option<serde_json::Value>,
    /// The field value schema.
    #[serde(rename = "schema", skip_serializing_if = "Option::is_none")]
    pub schema: Option<serde_json::Value>,
}

impl ContextualConfiguration {
    /// Details of the contextual configuration for a custom field.
    pub fn new(id: String, field_context_id: String) -> ContextualConfiguration {
        ContextualConfiguration {
            id,
            context_id: None,
            field_context_id,
            configuration: None,
            schema: None,
        }
    }
}


