/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// BulkProjectPermissions : Details of project permissions and associated issues and projects to look up.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct BulkProjectPermissions {
    /// List of issue IDs.
    #[serde(rename = "issues", skip_serializing_if = "Option::is_none")]
    pub issues: Option<Vec<i64>>,
    /// List of project IDs.
    #[serde(rename = "projects", skip_serializing_if = "Option::is_none")]
    pub projects: Option<Vec<i64>>,
    /// List of project permissions.
    #[serde(rename = "permissions")]
    pub permissions: Vec<String>,
}

impl BulkProjectPermissions {
    /// Details of project permissions and associated issues and projects to look up.
    pub fn new(permissions: Vec<String>) -> BulkProjectPermissions {
        BulkProjectPermissions {
            issues: None,
            projects: None,
            permissions,
        }
    }
}


