/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};

/// struct for passing parameters to the method [`find_users_and_groups`]
#[derive(Clone, Debug, Default)]
pub struct FindUsersAndGroupsParams {
    /// The search string.
    pub query: String,
    /// The maximum number of items to return in each list.
    pub max_results: Option<i32>,
    /// Whether the user avatar should be returned. If an invalid value is provided, the default value is used.
    pub show_avatar: Option<bool>,
    /// The custom field ID of the field this request is for.
    pub field_id: Option<String>,
    /// The ID of a project that returned users and groups must have permission to view. To include multiple projects, provide an ampersand-separated list. For example, `projectId=10000&projectId=10001`. This parameter is only used when `fieldId` is present.
    pub project_id: Option<Vec<String>>,
    /// The ID of an issue type that returned users and groups must have permission to view. To include multiple issue types, provide an ampersand-separated list. For example, `issueTypeId=10000&issueTypeId=10001`. Special values, such as `-1` (all standard issue types) and `-2` (all subtask issue types), are supported. This parameter is only used when `fieldId` is present.
    pub issue_type_id: Option<Vec<String>>,
    /// The size of the avatar to return. If an invalid value is provided, the default value is used.
    pub avatar_size: Option<String>,
    /// Whether the search for groups should be case insensitive.
    pub case_insensitive: Option<bool>,
    /// Whether Connect app users and groups should be excluded from the search results. If an invalid value is provided, the default value is used.
    pub exclude_connect_addons: Option<bool>
}


/// struct for typed errors of method [`find_users_and_groups`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum FindUsersAndGroupsError {
    Status400(),
    Status401(),
    Status403(),
    UnknownValue(serde_json::Value),
}


/// Returns a list of users and groups matching a string. The string is used:   *  for users, to find a case-insensitive match with display name and e-mail address. Note that if a user has hidden their email address in their user profile, partial matches of the email address will not find the user. An exact match is required.  *  for groups, to find a case-sensitive match with group name.  For example, if the string *tin* is used, records with the display name *Tina*, email address *sarah@tinplatetraining.com*, and the group *accounting* would be returned.  Optionally, the search can be refined to:   *  the projects and issue types associated with a custom field, such as a user picker. The search can then be further refined to return only users and groups that have permission to view specific:           *  projects.      *  issue types.          If multiple projects or issue types are specified, they must be a subset of those enabled for the custom field or no results are returned. For example, if a field is enabled for projects A, B, and C then the search could be limited to projects B and C. However, if the search is limited to projects B and D, nothing is returned.  *  not return Connect app users and groups.  *  return groups that have a case-insensitive match with the query.  The primary use case for this resource is to populate a picker field suggestion list with users or groups. To this end, the returned object includes an `html` field for each list. This field highlights the matched query term in the item name with the HTML strong tag. Also, each list is wrapped in a response object that contains a header for use in a picker, specifically *Showing X of Y matching groups*.  This operation can be accessed anonymously.  **[Permissions](#permissions) required:** *Browse users and groups* [global permission](https://confluence.atlassian.com/x/yodKLg).
pub async fn find_users_and_groups(configuration: &configuration::Configuration, params: FindUsersAndGroupsParams) -> Result<crate::models::FoundUsersAndGroups, Error<FindUsersAndGroupsError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let query = params.query;
    let max_results = params.max_results;
    let show_avatar = params.show_avatar;
    let field_id = params.field_id;
    let project_id = params.project_id;
    let issue_type_id = params.issue_type_id;
    let avatar_size = params.avatar_size;
    let case_insensitive = params.case_insensitive;
    let exclude_connect_addons = params.exclude_connect_addons;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/groupuserpicker", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("query", &query.to_string())]);
    if let Some(ref local_var_str) = max_results {
        local_var_req_builder = local_var_req_builder.query(&[("maxResults", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = show_avatar {
        local_var_req_builder = local_var_req_builder.query(&[("showAvatar", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = field_id {
        local_var_req_builder = local_var_req_builder.query(&[("fieldId", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = project_id {
        local_var_req_builder = match "multi" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("projectId".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("projectId", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = issue_type_id {
        local_var_req_builder = match "multi" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("issueTypeId".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("issueTypeId", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = avatar_size {
        local_var_req_builder = local_var_req_builder.query(&[("avatarSize", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = case_insensitive {
        local_var_req_builder = local_var_req_builder.query(&[("caseInsensitive", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = exclude_connect_addons {
        local_var_req_builder = local_var_req_builder.query(&[("excludeConnectAddons", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<FindUsersAndGroupsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

