/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};

/// struct for passing parameters to the method [`addon_properties_resource_delete_addon_property_delete`]
#[derive(Clone, Debug, Default)]
pub struct AddonPropertiesResourceDeleteAddonPropertyDeleteParams {
    /// The key of the app, as defined in its descriptor.
    pub addon_key: String,
    /// The key of the property.
    pub property_key: String
}

/// struct for passing parameters to the method [`addon_properties_resource_get_addon_properties_get`]
#[derive(Clone, Debug, Default)]
pub struct AddonPropertiesResourceGetAddonPropertiesGetParams {
    /// The key of the app, as defined in its descriptor.
    pub addon_key: String
}

/// struct for passing parameters to the method [`addon_properties_resource_get_addon_property_get`]
#[derive(Clone, Debug, Default)]
pub struct AddonPropertiesResourceGetAddonPropertyGetParams {
    /// The key of the app, as defined in its descriptor.
    pub addon_key: String,
    /// The key of the property.
    pub property_key: String
}

/// struct for passing parameters to the method [`addon_properties_resource_put_addon_property_put`]
#[derive(Clone, Debug, Default)]
pub struct AddonPropertiesResourcePutAddonPropertyPutParams {
    /// The key of the app, as defined in its descriptor.
    pub addon_key: String,
    /// The key of the property.
    pub property_key: String,
    pub body: Option<serde_json::Value>
}


/// struct for typed errors of method [`addon_properties_resource_delete_addon_property_delete`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AddonPropertiesResourceDeleteAddonPropertyDeleteError {
    Status400(crate::models::OperationMessage),
    Status401(crate::models::OperationMessage),
    Status404(crate::models::OperationMessage),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`addon_properties_resource_get_addon_properties_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AddonPropertiesResourceGetAddonPropertiesGetError {
    Status401(crate::models::OperationMessage),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`addon_properties_resource_get_addon_property_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AddonPropertiesResourceGetAddonPropertyGetError {
    Status400(crate::models::OperationMessage),
    Status401(crate::models::OperationMessage),
    Status404(crate::models::OperationMessage),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`addon_properties_resource_put_addon_property_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AddonPropertiesResourcePutAddonPropertyPutError {
    Status400(crate::models::OperationMessage),
    Status401(crate::models::OperationMessage),
    UnknownValue(serde_json::Value),
}


/// Deletes an app's property.  **[Permissions](#permissions) required:** Only a Connect app whose key matches `addonKey` can make this request.
pub async fn addon_properties_resource_delete_addon_property_delete(configuration: &configuration::Configuration, params: AddonPropertiesResourceDeleteAddonPropertyDeleteParams) -> Result<(), Error<AddonPropertiesResourceDeleteAddonPropertyDeleteError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let addon_key = params.addon_key;
    let property_key = params.property_key;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/atlassian-connect/1/addons/{addonKey}/properties/{propertyKey}", local_var_configuration.base_path, addonKey=crate::apis::urlencode(addon_key), propertyKey=crate::apis::urlencode(property_key));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::DELETE, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<AddonPropertiesResourceDeleteAddonPropertyDeleteError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Gets all the properties of an app.  **[Permissions](#permissions) required:** Only a Connect app whose key matches `addonKey` can make this request.
pub async fn addon_properties_resource_get_addon_properties_get(configuration: &configuration::Configuration, params: AddonPropertiesResourceGetAddonPropertiesGetParams) -> Result<crate::models::PropertyKeys, Error<AddonPropertiesResourceGetAddonPropertiesGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let addon_key = params.addon_key;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/atlassian-connect/1/addons/{addonKey}/properties", local_var_configuration.base_path, addonKey=crate::apis::urlencode(addon_key));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<AddonPropertiesResourceGetAddonPropertiesGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Returns the key and value of an app's property.  **[Permissions](#permissions) required:** Only a Connect app whose key matches `addonKey` can make this request.
pub async fn addon_properties_resource_get_addon_property_get(configuration: &configuration::Configuration, params: AddonPropertiesResourceGetAddonPropertyGetParams) -> Result<crate::models::EntityProperty, Error<AddonPropertiesResourceGetAddonPropertyGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let addon_key = params.addon_key;
    let property_key = params.property_key;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/atlassian-connect/1/addons/{addonKey}/properties/{propertyKey}", local_var_configuration.base_path, addonKey=crate::apis::urlencode(addon_key), propertyKey=crate::apis::urlencode(property_key));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<AddonPropertiesResourceGetAddonPropertyGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Sets the value of an app's property. Use this resource to store custom data for your app.  The value of the request body must be a [valid](http://tools.ietf.org/html/rfc4627), non-empty JSON blob. The maximum length is 32768 characters.  **[Permissions](#permissions) required:** Only a Connect app whose key matches `addonKey` can make this request.
pub async fn addon_properties_resource_put_addon_property_put(configuration: &configuration::Configuration, params: AddonPropertiesResourcePutAddonPropertyPutParams) -> Result<crate::models::OperationMessage, Error<AddonPropertiesResourcePutAddonPropertyPutError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let addon_key = params.addon_key;
    let property_key = params.property_key;
    let body = params.body;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/atlassian-connect/1/addons/{addonKey}/properties/{propertyKey}", local_var_configuration.base_path, addonKey=crate::apis::urlencode(addon_key), propertyKey=crate::apis::urlencode(property_key));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::PUT, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    local_var_req_builder = local_var_req_builder.json(&body);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<AddonPropertiesResourcePutAddonPropertyPutError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

