/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// WorkflowCompoundCondition : A compound workflow transition rule condition. This object returns `nodeType` as `compound`.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct WorkflowCompoundCondition {
    /// The compound condition operator.
    #[serde(rename = "operator")]
    pub operator: Operator,
    /// The list of workflow conditions.
    #[serde(rename = "conditions")]
    pub conditions: Vec<crate::models::WorkflowCondition>,
    #[serde(rename = "nodeType")]
    pub node_type: String,
}

impl WorkflowCompoundCondition {
    /// A compound workflow transition rule condition. This object returns `nodeType` as `compound`.
    pub fn new(operator: Operator, conditions: Vec<crate::models::WorkflowCondition>, node_type: String) -> WorkflowCompoundCondition {
        WorkflowCompoundCondition {
            operator,
            conditions,
            node_type,
        }
    }
}

/// The compound condition operator.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Operator {
    #[serde(rename = "AND")]
    AND,
    #[serde(rename = "OR")]
    OR,
}

impl Default for Operator {
    fn default() -> Operator {
        Self::AND
    }
}

