/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// RoleActor : Details about a user assigned to a project role.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct RoleActor {
    /// The ID of the role actor.
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<i64>,
    /// The display name of the role actor. For users, depending on the user’s privacy setting, this may return an alternative value for the user's name.
    #[serde(rename = "displayName", skip_serializing_if = "Option::is_none")]
    pub display_name: Option<String>,
    /// The type of role actor.
    #[serde(rename = "type", skip_serializing_if = "Option::is_none")]
    pub _type: Option<Type>,
    /// This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// The avatar of the role actor.
    #[serde(rename = "avatarUrl", skip_serializing_if = "Option::is_none")]
    pub avatar_url: Option<String>,
    #[serde(rename = "actorUser", skip_serializing_if = "Option::is_none")]
    pub actor_user: Option<crate::models::ProjectRoleUser>,
    #[serde(rename = "actorGroup", skip_serializing_if = "Option::is_none")]
    pub actor_group: Option<crate::models::ProjectRoleGroup>,
}

impl RoleActor {
    /// Details about a user assigned to a project role.
    pub fn new() -> RoleActor {
        RoleActor {
            id: None,
            display_name: None,
            _type: None,
            name: None,
            avatar_url: None,
            actor_user: None,
            actor_group: None,
        }
    }
}

/// The type of role actor.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Type {
    #[serde(rename = "atlassian-group-role-actor")]
    GroupRoleActor,
    #[serde(rename = "atlassian-user-role-actor")]
    UserRoleActor,
}

impl Default for Type {
    fn default() -> Type {
        Self::GroupRoleActor
    }
}

