/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// ProjectIssueTypesHierarchyLevel : Details of an issue type hierarchy level.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ProjectIssueTypesHierarchyLevel {
    /// The ID of the issue type hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
    #[serde(rename = "entityId", skip_serializing_if = "Option::is_none")]
    pub entity_id: Option<String>,
    /// The level of the issue type hierarchy level.
    #[serde(rename = "level", skip_serializing_if = "Option::is_none")]
    pub level: Option<i32>,
    /// The name of the issue type hierarchy level.
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// The list of issue types in the hierarchy level.
    #[serde(rename = "issueTypes", skip_serializing_if = "Option::is_none")]
    pub issue_types: Option<Vec<crate::models::IssueTypeInfo>>,
}

impl ProjectIssueTypesHierarchyLevel {
    /// Details of an issue type hierarchy level.
    pub fn new() -> ProjectIssueTypesHierarchyLevel {
        ProjectIssueTypesHierarchyLevel {
            entity_id: None,
            level: None,
            name: None,
            issue_types: None,
        }
    }
}


