/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// Priority : An issue priority.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Priority {
    /// The URL of the issue priority.
    #[serde(rename = "self", skip_serializing_if = "Option::is_none")]
    pub _self: Option<String>,
    /// The color used to indicate the issue priority.
    #[serde(rename = "statusColor", skip_serializing_if = "Option::is_none")]
    pub status_color: Option<String>,
    /// The description of the issue priority.
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// The URL of the icon for the issue priority.
    #[serde(rename = "iconUrl", skip_serializing_if = "Option::is_none")]
    pub icon_url: Option<String>,
    /// The name of the issue priority.
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// The ID of the issue priority.
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// Whether this priority is the default.
    #[serde(rename = "isDefault", skip_serializing_if = "Option::is_none")]
    pub is_default: Option<bool>,
}

impl Priority {
    /// An issue priority.
    pub fn new() -> Priority {
        Priority {
            _self: None,
            status_color: None,
            description: None,
            icon_url: None,
            name: None,
            id: None,
            is_default: None,
        }
    }
}


