/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// IssueBean : Details about an issue.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct IssueBean {
    /// Expand options that include additional issue details in the response.
    #[serde(rename = "expand", skip_serializing_if = "Option::is_none")]
    pub expand: Option<String>,
    /// The ID of the issue.
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// The URL of the issue details.
    #[serde(rename = "self", skip_serializing_if = "Option::is_none")]
    pub _self: Option<String>,
    /// The key of the issue.
    #[serde(rename = "key", skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    /// The rendered value of each field present on the issue.
    #[serde(rename = "renderedFields", skip_serializing_if = "Option::is_none")]
    pub rendered_fields: Option<::std::collections::HashMap<String, serde_json::Value>>,
    /// Details of the issue properties identified in the request.
    #[serde(rename = "properties", skip_serializing_if = "Option::is_none")]
    pub properties: Option<::std::collections::HashMap<String, serde_json::Value>>,
    /// The ID and name of each field present on the issue.
    #[serde(rename = "names", skip_serializing_if = "Option::is_none")]
    pub names: Option<::std::collections::HashMap<String, String>>,
    /// The schema describing each field present on the issue.
    #[serde(rename = "schema", skip_serializing_if = "Option::is_none")]
    pub schema: Option<::std::collections::HashMap<String, crate::models::JsonTypeBean>>,
    /// The transitions that can be performed on the issue.
    #[serde(rename = "transitions", skip_serializing_if = "Option::is_none")]
    pub transitions: Option<Vec<crate::models::IssueTransition>>,
    /// The operations that can be performed on the issue.
    #[serde(rename = "operations", skip_serializing_if = "Option::is_none")]
    pub operations: Option<crate::models::Operations>,
    /// The metadata for the fields on the issue that can be amended.
    #[serde(rename = "editmeta", skip_serializing_if = "Option::is_none")]
    pub editmeta: Option<crate::models::IssueUpdateMetadata>,
    /// Details of changelogs associated with the issue.
    #[serde(rename = "changelog", skip_serializing_if = "Option::is_none")]
    pub changelog: Option<crate::models::PageOfChangelogs>,
    /// The versions of each field on the issue.
    #[serde(rename = "versionedRepresentations", skip_serializing_if = "Option::is_none")]
    pub versioned_representations: Option<::std::collections::HashMap<String, ::std::collections::HashMap<String, serde_json::Value>>>,
    #[serde(rename = "fieldsToInclude", skip_serializing_if = "Option::is_none")]
    pub fields_to_include: Option<crate::models::IncludedFields>,
    #[serde(rename = "fields", skip_serializing_if = "Option::is_none")]
    pub fields: Option<::std::collections::HashMap<String, serde_json::Value>>,
}

impl IssueBean {
    /// Details about an issue.
    pub fn new() -> IssueBean {
        IssueBean {
            expand: None,
            id: None,
            _self: None,
            key: None,
            rendered_fields: None,
            properties: None,
            names: None,
            schema: None,
            transitions: None,
            operations: None,
            editmeta: None,
            changelog: None,
            versioned_representations: None,
            fields_to_include: None,
            fields: None,
        }
    }
}


