/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// HealthCheckResult : Jira instance health check results. Deprecated and no longer returned.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct HealthCheckResult {
    /// The name of the Jira health check item.
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// The description of the Jira health check item.
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// Whether the Jira health check item passed or failed.
    #[serde(rename = "passed", skip_serializing_if = "Option::is_none")]
    pub passed: Option<bool>,
}

impl HealthCheckResult {
    /// Jira instance health check results. Deprecated and no longer returned.
    pub fn new() -> HealthCheckResult {
        HealthCheckResult {
            name: None,
            description: None,
            passed: None,
        }
    }
}


