/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// Attachment : Details about an attachment.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Attachment {
    /// The URL of the attachment details response.
    #[serde(rename = "self", skip_serializing_if = "Option::is_none")]
    pub _self: Option<String>,
    /// The ID of the attachment.
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// The file name of the attachment.
    #[serde(rename = "filename", skip_serializing_if = "Option::is_none")]
    pub filename: Option<String>,
    /// Details of the user who added the attachment.
    #[serde(rename = "author", skip_serializing_if = "Option::is_none")]
    pub author: Option<crate::models::UserDetails>,
    /// The datetime the attachment was created.
    #[serde(rename = "created", skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    /// The size of the attachment.
    #[serde(rename = "size", skip_serializing_if = "Option::is_none")]
    pub size: Option<i64>,
    /// The MIME type of the attachment.
    #[serde(rename = "mimeType", skip_serializing_if = "Option::is_none")]
    pub mime_type: Option<String>,
    /// The content of the attachment.
    #[serde(rename = "content", skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    /// The URL of a thumbnail representing the attachment.
    #[serde(rename = "thumbnail", skip_serializing_if = "Option::is_none")]
    pub thumbnail: Option<String>,
}

impl Attachment {
    /// Details about an attachment.
    pub fn new() -> Attachment {
        Attachment {
            _self: None,
            id: None,
            filename: None,
            author: None,
            created: None,
            size: None,
            mime_type: None,
            content: None,
            thumbnail: None,
        }
    }
}


