/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};

/// struct for passing parameters to the method [`dynamic_modules_resource_register_modules_post`]
#[derive(Clone, Debug, Default)]
pub struct DynamicModulesResourceRegisterModulesPostParams {
    pub connect_modules: crate::models::ConnectModules
}

/// struct for passing parameters to the method [`dynamic_modules_resource_remove_modules_delete`]
#[derive(Clone, Debug, Default)]
pub struct DynamicModulesResourceRemoveModulesDeleteParams {
    /// The key of the module to remove. To include multiple module keys, provide multiple copies of this parameter. For example, `moduleKey=dynamic-attachment-entity-property&moduleKey=dynamic-select-field`. Nonexistent keys are ignored.
    pub module_key: Option<Vec<String>>
}


/// struct for typed errors of method [`dynamic_modules_resource_get_modules_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DynamicModulesResourceGetModulesGetError {
    Status401(crate::models::ErrorMessage),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`dynamic_modules_resource_register_modules_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DynamicModulesResourceRegisterModulesPostError {
    Status400(crate::models::ErrorMessage),
    Status401(crate::models::ErrorMessage),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`dynamic_modules_resource_remove_modules_delete`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DynamicModulesResourceRemoveModulesDeleteError {
    Status401(crate::models::ErrorMessage),
    UnknownValue(serde_json::Value),
}


/// Returns all modules registered dynamically by the calling app.  **[Permissions](#permissions) required:** Only Connect apps can make this request.
pub async fn dynamic_modules_resource_get_modules_get(configuration: &configuration::Configuration) -> Result<crate::models::ConnectModules, Error<DynamicModulesResourceGetModulesGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/atlassian-connect/1/app/module/dynamic", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<DynamicModulesResourceGetModulesGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Registers a list of modules.  **[Permissions](#permissions) required:** Only Connect apps can make this request.
pub async fn dynamic_modules_resource_register_modules_post(configuration: &configuration::Configuration, params: DynamicModulesResourceRegisterModulesPostParams) -> Result<(), Error<DynamicModulesResourceRegisterModulesPostError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let connect_modules = params.connect_modules;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/atlassian-connect/1/app/module/dynamic", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    local_var_req_builder = local_var_req_builder.json(&connect_modules);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<DynamicModulesResourceRegisterModulesPostError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Remove all or a list of modules registered by the calling app.  **[Permissions](#permissions) required:** Only Connect apps can make this request.
pub async fn dynamic_modules_resource_remove_modules_delete(configuration: &configuration::Configuration, params: DynamicModulesResourceRemoveModulesDeleteParams) -> Result<(), Error<DynamicModulesResourceRemoveModulesDeleteError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let module_key = params.module_key;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/atlassian-connect/1/app/module/dynamic", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::DELETE, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = module_key {
        local_var_req_builder = match "multi" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("moduleKey".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("moduleKey", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<DynamicModulesResourceRemoveModulesDeleteError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

