/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// Worklog : Details of a worklog.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Worklog {
    /// The URL of the worklog item.
    #[serde(rename = "self", skip_serializing_if = "Option::is_none")]
    pub _self: Option<String>,
    /// Details of the user who created the worklog.
    #[serde(rename = "author", skip_serializing_if = "Option::is_none")]
    pub author: Option<crate::models::UserDetails>,
    /// Details of the user who last updated the worklog.
    #[serde(rename = "updateAuthor", skip_serializing_if = "Option::is_none")]
    pub update_author: Option<crate::models::UserDetails>,
    /// A comment about the worklog. Optional when creating or updating a worklog.
    #[serde(rename = "comment", skip_serializing_if = "Option::is_none")]
    pub comment: Option<String>,
    /// The datetime on which the worklog was created.
    #[serde(rename = "created", skip_serializing_if = "Option::is_none")]
    pub created: Option<String>,
    /// The datetime on which the worklog was last updated.
    #[serde(rename = "updated", skip_serializing_if = "Option::is_none")]
    pub updated: Option<String>,
    /// Details about any restrictions in the visibility of the worklog. Optional when creating or updating a worklog.
    #[serde(rename = "visibility", skip_serializing_if = "Option::is_none")]
    pub visibility: Option<crate::models::Visibility>,
    /// The datetime on which the worklog effort was started. Required when creating a worklog. Optional when updating a worklog.
    #[serde(rename = "started", skip_serializing_if = "Option::is_none")]
    pub started: Option<String>,
    /// The time spent working on the issue as days (\\#d), hours (\\#h), or minutes (\\#m or \\#). Required when creating a worklog if `timeSpentSeconds` isn't provided. Optional when updating a worklog. Cannot be provided if `timeSpentSecond` is provided.
    #[serde(rename = "timeSpent", skip_serializing_if = "Option::is_none")]
    pub time_spent: Option<String>,
    /// The time in seconds spent working on the issue. Required when creating a worklog if `timeSpent` isn't provided. Optional when updating a worklog. Cannot be provided if `timeSpent` is provided.
    #[serde(rename = "timeSpentSeconds", skip_serializing_if = "Option::is_none")]
    pub time_spent_seconds: Option<i64>,
    /// The ID of the worklog record.
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// The ID of the issue this worklog is for.
    #[serde(rename = "issueId", skip_serializing_if = "Option::is_none")]
    pub issue_id: Option<String>,
    /// Details of properties for the worklog. Optional when creating or updating a worklog.
    #[serde(rename = "properties", skip_serializing_if = "Option::is_none")]
    pub properties: Option<Vec<crate::models::EntityProperty>>,
}

impl Worklog {
    /// Details of a worklog.
    pub fn new() -> Worklog {
        Worklog {
            _self: None,
            author: None,
            update_author: None,
            comment: None,
            created: None,
            updated: None,
            visibility: None,
            started: None,
            time_spent: None,
            time_spent_seconds: None,
            id: None,
            issue_id: None,
            properties: None,
        }
    }
}


