/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// ParsedJqlQuery : Details of a parsed JQL query.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ParsedJqlQuery {
    /// The JQL query that was parsed and validated.
    #[serde(rename = "query")]
    pub query: String,
    /// The syntax tree of the query. Empty if the query was invalid.
    #[serde(rename = "structure", skip_serializing_if = "Option::is_none")]
    pub structure: Option<crate::models::JqlQuery>,
    /// The list of syntax or validation errors.
    #[serde(rename = "errors", skip_serializing_if = "Option::is_none")]
    pub errors: Option<Vec<String>>,
}

impl ParsedJqlQuery {
    /// Details of a parsed JQL query.
    pub fn new(query: String) -> ParsedJqlQuery {
        ParsedJqlQuery {
            query,
            structure: None,
            errors: None,
        }
    }
}


