/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// IssueTypeScheme : Details of an issue type scheme.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct IssueTypeScheme {
    /// The ID of the issue type scheme.
    #[serde(rename = "id")]
    pub id: String,
    /// The name of the issue type scheme.
    #[serde(rename = "name")]
    pub name: String,
    /// The description of the issue type scheme.
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// The ID of the default issue type of the issue type scheme.
    #[serde(rename = "defaultIssueTypeId", skip_serializing_if = "Option::is_none")]
    pub default_issue_type_id: Option<String>,
    /// Whether the issue type scheme is the default.
    #[serde(rename = "isDefault", skip_serializing_if = "Option::is_none")]
    pub is_default: Option<bool>,
}

impl IssueTypeScheme {
    /// Details of an issue type scheme.
    pub fn new(id: String, name: String) -> IssueTypeScheme {
        IssueTypeScheme {
            id,
            name,
            description: None,
            default_issue_type_id: None,
            is_default: None,
        }
    }
}


