/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// GroupLabel : A group label.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct GroupLabel {
    /// The group label name.
    #[serde(rename = "text", skip_serializing_if = "Option::is_none")]
    pub text: Option<String>,
    /// The title of the group label.
    #[serde(rename = "title", skip_serializing_if = "Option::is_none")]
    pub title: Option<String>,
    /// The type of the group label.
    #[serde(rename = "type", skip_serializing_if = "Option::is_none")]
    pub _type: Option<Type>,
}

impl GroupLabel {
    /// A group label.
    pub fn new() -> GroupLabel {
        GroupLabel {
            text: None,
            title: None,
            _type: None,
        }
    }
}

/// The type of the group label.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Type {
    #[serde(rename = "ADMIN")]
    ADMIN,
    #[serde(rename = "SINGLE")]
    SINGLE,
    #[serde(rename = "MULTIPLE")]
    MULTIPLE,
}

impl Default for Type {
    fn default() -> Type {
        Self::ADMIN
    }
}

