/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// Filter : Details about a filter.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct Filter {
    /// The URL of the filter.
    #[serde(rename = "self", skip_serializing_if = "Option::is_none")]
    pub _self: Option<String>,
    /// The unique identifier for the filter.
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// The name of the filter. Must be unique.
    #[serde(rename = "name")]
    pub name: String,
    /// A description of the filter.
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// The user who owns the filter. This is defaulted to the creator of the filter, however Jira administrators can change the owner of a shared filter in the admin settings.
    #[serde(rename = "owner", skip_serializing_if = "Option::is_none")]
    pub owner: Option<crate::models::User>,
    /// The JQL query for the filter. For example, *project = SSP AND issuetype = Bug*.
    #[serde(rename = "jql", skip_serializing_if = "Option::is_none")]
    pub jql: Option<String>,
    /// A URL to view the filter results in Jira, using the ID of the filter. For example, *https://your-domain.atlassian.net/issues/?filter=10100*.
    #[serde(rename = "viewUrl", skip_serializing_if = "Option::is_none")]
    pub view_url: Option<String>,
    /// A URL to view the filter results in Jira, using the [Search for issues using JQL](#api-rest-api-2-filter-search-get) operation with the filter's JQL string to return the filter results. For example, *https://your-domain.atlassian.net/rest/api/2/search?jql=project+%3D+SSP+AND+issuetype+%3D+Bug*.
    #[serde(rename = "searchUrl", skip_serializing_if = "Option::is_none")]
    pub search_url: Option<String>,
    /// Whether the filter is selected as a favorite.
    #[serde(rename = "favourite", skip_serializing_if = "Option::is_none")]
    pub favourite: Option<bool>,
    /// The count of how many users have selected this filter as a favorite, including the filter owner.
    #[serde(rename = "favouritedCount", skip_serializing_if = "Option::is_none")]
    pub favourited_count: Option<i64>,
    /// The groups and projects that the filter is shared with.
    #[serde(rename = "sharePermissions", skip_serializing_if = "Option::is_none")]
    pub share_permissions: Option<Vec<crate::models::SharePermission>>,
    /// The groups and projects that can edit the filter.
    #[serde(rename = "editPermissions", skip_serializing_if = "Option::is_none")]
    pub edit_permissions: Option<Vec<crate::models::SharePermission>>,
    /// A paginated list of the users that the filter is shared with. This includes users that are members of the groups or can browse the projects that the filter is shared with.
    #[serde(rename = "sharedUsers", skip_serializing_if = "Option::is_none")]
    pub shared_users: Option<crate::models::UserList>,
    /// A paginated list of the users that are subscribed to the filter.
    #[serde(rename = "subscriptions", skip_serializing_if = "Option::is_none")]
    pub subscriptions: Option<crate::models::FilterSubscriptionsList>,
}

impl Filter {
    /// Details about a filter.
    pub fn new(name: String) -> Filter {
        Filter {
            _self: None,
            id: None,
            name,
            description: None,
            owner: None,
            jql: None,
            view_url: None,
            search_url: None,
            favourite: None,
            favourited_count: None,
            share_permissions: None,
            edit_permissions: None,
            shared_users: None,
            subscriptions: None,
        }
    }
}


