/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// FieldValueClause : A clause that asserts the current value of a field. For example, `summary ~ test`.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FieldValueClause {
    #[serde(rename = "field")]
    pub field: crate::models::JqlQueryField,
    /// The operator between the field and operand.
    #[serde(rename = "operator")]
    pub operator: Operator,
    #[serde(rename = "operand")]
    pub operand: crate::models::JqlQueryClauseOperand,
}

impl FieldValueClause {
    /// A clause that asserts the current value of a field. For example, `summary ~ test`.
    pub fn new(field: crate::models::JqlQueryField, operator: Operator, operand: crate::models::JqlQueryClauseOperand) -> FieldValueClause {
        FieldValueClause {
            field: (field),
            operator,
            operand: (operand),
        }
    }
}

/// The operator between the field and operand.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Operator {
    #[serde(rename = "=")]
    Equal,
    #[serde(rename = "!=")]
    Not_Equal,
    #[serde(rename = ">")]
    Greater_Than,
    #[serde(rename = "<")]
    Less_Than,
    #[serde(rename = ">=")]
    Greater_Than_Or_Equal_To,
    #[serde(rename = "<=")]
    Less_Than_Or_Equal_To,
    #[serde(rename = "in")]
    _In,
    #[serde(rename = "not in")]
    NotIn,
    #[serde(rename = "~")]
    Tilde,
    #[serde(rename = "~=")]
    Tilde_Equal,
    #[serde(rename = "is")]
    Is,
    #[serde(rename = "is not")]
    IsNot,
}

impl Default for Operator {
    fn default() -> Operator {
        Self::Equal
    }
}

