/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// ConnectCustomFieldValue : A list of custom field details.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ConnectCustomFieldValue {
    /// The type of custom field.
    #[serde(rename = "_type")]
    pub _type: Type,
    /// The issue ID.
    #[serde(rename = "issueID")]
    pub issue_id: i32,
    /// The custom field ID.
    #[serde(rename = "fieldID")]
    pub field_id: i32,
    /// The value of string type custom field when `_type` is `StringIssueField`.
    #[serde(rename = "string", skip_serializing_if = "Option::is_none")]
    pub string: Option<String>,
    /// The value of number type custom field when `_type` is `NumberIssueField`.
    #[serde(rename = "number", skip_serializing_if = "Option::is_none")]
    pub number: Option<f32>,
    /// The value of richText type custom field when `_type` is `RichTextIssueField`.
    #[serde(rename = "richText", skip_serializing_if = "Option::is_none")]
    pub rich_text: Option<String>,
    /// The value of single select and multiselect custom field type when `_type` is `SingleSelectIssueField` or `MultiSelectIssueField`.
    #[serde(rename = "optionID", skip_serializing_if = "Option::is_none")]
    pub option_id: Option<String>,
    /// The value of of text custom field type when `_type` is `TextIssueField`.
    #[serde(rename = "text", skip_serializing_if = "Option::is_none")]
    pub text: Option<String>,
}

impl ConnectCustomFieldValue {
    /// A list of custom field details.
    pub fn new(_type: Type, issue_id: i32, field_id: i32) -> ConnectCustomFieldValue {
        ConnectCustomFieldValue {
            _type,
            issue_id,
            field_id,
            string: None,
            number: None,
            rich_text: None,
            option_id: None,
            text: None,
        }
    }
}

/// The type of custom field.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Type {
    #[serde(rename = "StringIssueField")]
    StringIssueField,
    #[serde(rename = "NumberIssueField")]
    NumberIssueField,
    #[serde(rename = "RichTextIssueField")]
    RichTextIssueField,
    #[serde(rename = "SingleSelectIssueField")]
    SingleSelectIssueField,
    #[serde(rename = "MultiSelectIssueField")]
    MultiSelectIssueField,
    #[serde(rename = "TextIssueField")]
    TextIssueField,
}

impl Default for Type {
    fn default() -> Type {
        Self::StringIssueField
    }
}

