/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};

/// struct for passing parameters to the method [`append_mappings_for_issue_type_screen_scheme`]
#[derive(Clone, Debug, Default)]
pub struct AppendMappingsForIssueTypeScreenSchemeParams {
    /// The ID of the issue type screen scheme.
    pub issue_type_screen_scheme_id: String,
    pub issue_type_screen_scheme_mapping_details: crate::models::IssueTypeScreenSchemeMappingDetails
}

/// struct for passing parameters to the method [`assign_issue_type_screen_scheme_to_project`]
#[derive(Clone, Debug, Default)]
pub struct AssignIssueTypeScreenSchemeToProjectParams {
    pub issue_type_screen_scheme_project_association: crate::models::IssueTypeScreenSchemeProjectAssociation
}

/// struct for passing parameters to the method [`create_issue_type_screen_scheme`]
#[derive(Clone, Debug, Default)]
pub struct CreateIssueTypeScreenSchemeParams {
    /// An issue type screen scheme bean.
    pub issue_type_screen_scheme_details: crate::models::IssueTypeScreenSchemeDetails
}

/// struct for passing parameters to the method [`delete_issue_type_screen_scheme`]
#[derive(Clone, Debug, Default)]
pub struct DeleteIssueTypeScreenSchemeParams {
    /// The ID of the issue type screen scheme.
    pub issue_type_screen_scheme_id: String
}

/// struct for passing parameters to the method [`get_issue_type_screen_scheme_mappings`]
#[derive(Clone, Debug, Default)]
pub struct GetIssueTypeScreenSchemeMappingsParams {
    /// The index of the first item to return in a page of results (page offset).
    pub start_at: Option<i64>,
    /// The maximum number of items to return per page.
    pub max_results: Option<i32>,
    /// The list of issue type screen scheme IDs. To include multiple issue type screen schemes, separate IDs with ampersand: `issueTypeScreenSchemeId=10000&issueTypeScreenSchemeId=10001`.
    pub issue_type_screen_scheme_id: Option<Vec<i64>>
}

/// struct for passing parameters to the method [`get_issue_type_screen_scheme_project_associations`]
#[derive(Clone, Debug, Default)]
pub struct GetIssueTypeScreenSchemeProjectAssociationsParams {
    /// The list of project IDs. To include multiple projects, separate IDs with ampersand: `projectId=10000&projectId=10001`.
    pub project_id: Vec<i64>,
    /// The index of the first item to return in a page of results (page offset).
    pub start_at: Option<i64>,
    /// The maximum number of items to return per page.
    pub max_results: Option<i32>
}

/// struct for passing parameters to the method [`get_issue_type_screen_schemes`]
#[derive(Clone, Debug, Default)]
pub struct GetIssueTypeScreenSchemesParams {
    /// The index of the first item to return in a page of results (page offset).
    pub start_at: Option<i64>,
    /// The maximum number of items to return per page.
    pub max_results: Option<i32>,
    /// The list of issue type screen scheme IDs. To include multiple IDs, provide an ampersand-separated list. For example, `id=10000&id=10001`.
    pub id: Option<Vec<i64>>,
    /// String used to perform a case-insensitive partial match with issue type screen scheme name.
    pub query_string: Option<String>,
    /// [Order](#ordering) the results by a field:   *  `name` Sorts by issue type screen scheme name.  *  `id` Sorts by issue type screen scheme ID.
    pub order_by: Option<String>,
    /// Use [expand](#expansion) to include additional information in the response. This parameter accepts `projects` that, for each issue type screen schemes, returns information about the projects the issue type screen scheme is assigned to.
    pub expand: Option<String>
}

/// struct for passing parameters to the method [`get_projects_for_issue_type_screen_scheme`]
#[derive(Clone, Debug, Default)]
pub struct GetProjectsForIssueTypeScreenSchemeParams {
    /// The ID of the issue type screen scheme.
    pub issue_type_screen_scheme_id: i64,
    /// The index of the first item to return in a page of results (page offset).
    pub start_at: Option<i64>,
    /// The maximum number of items to return per page.
    pub max_results: Option<i32>
}

/// struct for passing parameters to the method [`remove_mappings_from_issue_type_screen_scheme`]
#[derive(Clone, Debug, Default)]
pub struct RemoveMappingsFromIssueTypeScreenSchemeParams {
    /// The ID of the issue type screen scheme.
    pub issue_type_screen_scheme_id: String,
    pub issue_type_ids: crate::models::IssueTypeIds
}

/// struct for passing parameters to the method [`update_default_screen_scheme`]
#[derive(Clone, Debug, Default)]
pub struct UpdateDefaultScreenSchemeParams {
    /// The ID of the issue type screen scheme.
    pub issue_type_screen_scheme_id: String,
    pub update_default_screen_scheme: crate::models::UpdateDefaultScreenScheme
}

/// struct for passing parameters to the method [`update_issue_type_screen_scheme`]
#[derive(Clone, Debug, Default)]
pub struct UpdateIssueTypeScreenSchemeParams {
    /// The ID of the issue type screen scheme.
    pub issue_type_screen_scheme_id: String,
    /// The issue type screen scheme update details.
    pub issue_type_screen_scheme_update_details: crate::models::IssueTypeScreenSchemeUpdateDetails
}


/// struct for typed successes of method [`append_mappings_for_issue_type_screen_scheme`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AppendMappingsForIssueTypeScreenSchemeSuccess {
    Status204(serde_json::Value),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`assign_issue_type_screen_scheme_to_project`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AssignIssueTypeScreenSchemeToProjectSuccess {
    Status204(serde_json::Value),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`create_issue_type_screen_scheme`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateIssueTypeScreenSchemeSuccess {
    Status201(crate::models::IssueTypeScreenSchemeId),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`delete_issue_type_screen_scheme`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteIssueTypeScreenSchemeSuccess {
    Status204(serde_json::Value),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`get_issue_type_screen_scheme_mappings`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetIssueTypeScreenSchemeMappingsSuccess {
    Status200(crate::models::PageBeanIssueTypeScreenSchemeItem),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`get_issue_type_screen_scheme_project_associations`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetIssueTypeScreenSchemeProjectAssociationsSuccess {
    Status200(crate::models::PageBeanIssueTypeScreenSchemesProjects),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`get_issue_type_screen_schemes`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetIssueTypeScreenSchemesSuccess {
    Status200(crate::models::PageBeanIssueTypeScreenScheme),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`get_projects_for_issue_type_screen_scheme`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetProjectsForIssueTypeScreenSchemeSuccess {
    Status200(crate::models::PageBeanProjectDetails),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`remove_mappings_from_issue_type_screen_scheme`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RemoveMappingsFromIssueTypeScreenSchemeSuccess {
    Status204(serde_json::Value),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`update_default_screen_scheme`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateDefaultScreenSchemeSuccess {
    Status204(serde_json::Value),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`update_issue_type_screen_scheme`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateIssueTypeScreenSchemeSuccess {
    Status204(serde_json::Value),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`append_mappings_for_issue_type_screen_scheme`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AppendMappingsForIssueTypeScreenSchemeError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status409(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`assign_issue_type_screen_scheme_to_project`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum AssignIssueTypeScreenSchemeToProjectError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`create_issue_type_screen_scheme`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateIssueTypeScreenSchemeError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    Status409(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`delete_issue_type_screen_scheme`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteIssueTypeScreenSchemeError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_issue_type_screen_scheme_mappings`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetIssueTypeScreenSchemeMappingsError {
    Status400(),
    Status401(),
    Status403(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_issue_type_screen_scheme_project_associations`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetIssueTypeScreenSchemeProjectAssociationsError {
    Status400(),
    Status401(),
    Status403(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_issue_type_screen_schemes`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetIssueTypeScreenSchemesError {
    Status400(),
    Status401(),
    Status403(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`get_projects_for_issue_type_screen_scheme`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetProjectsForIssueTypeScreenSchemeError {
    Status400(),
    Status401(),
    Status403(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`remove_mappings_from_issue_type_screen_scheme`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RemoveMappingsFromIssueTypeScreenSchemeError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`update_default_screen_scheme`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateDefaultScreenSchemeError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`update_issue_type_screen_scheme`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateIssueTypeScreenSchemeError {
    Status400(),
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}


/// Appends issue type to screen scheme mappings to an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
pub async fn append_mappings_for_issue_type_screen_scheme(configuration: &configuration::Configuration, params: AppendMappingsForIssueTypeScreenSchemeParams) -> Result<ResponseContent<AppendMappingsForIssueTypeScreenSchemeSuccess>, Error<AppendMappingsForIssueTypeScreenSchemeError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let issue_type_screen_scheme_id = params.issue_type_screen_scheme_id;
    let issue_type_screen_scheme_mapping_details = params.issue_type_screen_scheme_mapping_details;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/issuetypescreenscheme/{issueTypeScreenSchemeId}/mapping", local_var_configuration.base_path, issueTypeScreenSchemeId=crate::apis::urlencode(issue_type_screen_scheme_id));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::PUT, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&issue_type_screen_scheme_mapping_details);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<AppendMappingsForIssueTypeScreenSchemeSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<AppendMappingsForIssueTypeScreenSchemeError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Assigns an issue type screen scheme to a project.  Issue type screen schemes can only be assigned to classic projects.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
pub async fn assign_issue_type_screen_scheme_to_project(configuration: &configuration::Configuration, params: AssignIssueTypeScreenSchemeToProjectParams) -> Result<ResponseContent<AssignIssueTypeScreenSchemeToProjectSuccess>, Error<AssignIssueTypeScreenSchemeToProjectError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let issue_type_screen_scheme_project_association = params.issue_type_screen_scheme_project_association;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/issuetypescreenscheme/project", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::PUT, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&issue_type_screen_scheme_project_association);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<AssignIssueTypeScreenSchemeToProjectSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<AssignIssueTypeScreenSchemeToProjectError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Creates an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
pub async fn create_issue_type_screen_scheme(configuration: &configuration::Configuration, params: CreateIssueTypeScreenSchemeParams) -> Result<ResponseContent<CreateIssueTypeScreenSchemeSuccess>, Error<CreateIssueTypeScreenSchemeError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let issue_type_screen_scheme_details = params.issue_type_screen_scheme_details;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/issuetypescreenscheme", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&issue_type_screen_scheme_details);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<CreateIssueTypeScreenSchemeSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<CreateIssueTypeScreenSchemeError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Deletes an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
pub async fn delete_issue_type_screen_scheme(configuration: &configuration::Configuration, params: DeleteIssueTypeScreenSchemeParams) -> Result<ResponseContent<DeleteIssueTypeScreenSchemeSuccess>, Error<DeleteIssueTypeScreenSchemeError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let issue_type_screen_scheme_id = params.issue_type_screen_scheme_id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/issuetypescreenscheme/{issueTypeScreenSchemeId}", local_var_configuration.base_path, issueTypeScreenSchemeId=crate::apis::urlencode(issue_type_screen_scheme_id));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::DELETE, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<DeleteIssueTypeScreenSchemeSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<DeleteIssueTypeScreenSchemeError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Returns a [paginated](#pagination) list of issue type screen scheme items.  Only issue type screen schemes used in classic projects are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
pub async fn get_issue_type_screen_scheme_mappings(configuration: &configuration::Configuration, params: GetIssueTypeScreenSchemeMappingsParams) -> Result<ResponseContent<GetIssueTypeScreenSchemeMappingsSuccess>, Error<GetIssueTypeScreenSchemeMappingsError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let start_at = params.start_at;
    let max_results = params.max_results;
    let issue_type_screen_scheme_id = params.issue_type_screen_scheme_id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/issuetypescreenscheme/mapping", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = start_at {
        local_var_req_builder = local_var_req_builder.query(&[("startAt", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = max_results {
        local_var_req_builder = local_var_req_builder.query(&[("maxResults", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = issue_type_screen_scheme_id {
        local_var_req_builder = match "multi" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("issueTypeScreenSchemeId".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("issueTypeScreenSchemeId", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<GetIssueTypeScreenSchemeMappingsSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<GetIssueTypeScreenSchemeMappingsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Returns a [paginated](#pagination) list of issue type screen schemes and, for each issue type screen scheme, a list of the projects that use it.  Only issue type screen schemes used in classic projects are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
pub async fn get_issue_type_screen_scheme_project_associations(configuration: &configuration::Configuration, params: GetIssueTypeScreenSchemeProjectAssociationsParams) -> Result<ResponseContent<GetIssueTypeScreenSchemeProjectAssociationsSuccess>, Error<GetIssueTypeScreenSchemeProjectAssociationsError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let project_id = params.project_id;
    let start_at = params.start_at;
    let max_results = params.max_results;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/issuetypescreenscheme/project", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = start_at {
        local_var_req_builder = local_var_req_builder.query(&[("startAt", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = max_results {
        local_var_req_builder = local_var_req_builder.query(&[("maxResults", &local_var_str.to_string())]);
    }
    local_var_req_builder = match "multi" {
        "multi" => local_var_req_builder.query(&project_id.into_iter().map(|p| ("projectId".to_owned(), p)).collect::<Vec<(std::string::String, i64)>>()),
        _ => local_var_req_builder.query(&[("projectId", &project_id.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
    };
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<GetIssueTypeScreenSchemeProjectAssociationsSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<GetIssueTypeScreenSchemeProjectAssociationsError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Returns a [paginated](#pagination) list of issue type screen schemes.  Only issue type screen schemes used in classic projects are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
pub async fn get_issue_type_screen_schemes(configuration: &configuration::Configuration, params: GetIssueTypeScreenSchemesParams) -> Result<ResponseContent<GetIssueTypeScreenSchemesSuccess>, Error<GetIssueTypeScreenSchemesError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let start_at = params.start_at;
    let max_results = params.max_results;
    let id = params.id;
    let query_string = params.query_string;
    let order_by = params.order_by;
    let expand = params.expand;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/issuetypescreenscheme", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = start_at {
        local_var_req_builder = local_var_req_builder.query(&[("startAt", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = max_results {
        local_var_req_builder = local_var_req_builder.query(&[("maxResults", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id {
        local_var_req_builder = match "multi" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = query_string {
        local_var_req_builder = local_var_req_builder.query(&[("queryString", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = order_by {
        local_var_req_builder = local_var_req_builder.query(&[("orderBy", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = expand {
        local_var_req_builder = local_var_req_builder.query(&[("expand", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<GetIssueTypeScreenSchemesSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<GetIssueTypeScreenSchemesError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Returns a [paginated](#pagination) list of projects associated with an issue type screen scheme.  Only company-managed projects associated with an issue type screen scheme are returned.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
pub async fn get_projects_for_issue_type_screen_scheme(configuration: &configuration::Configuration, params: GetProjectsForIssueTypeScreenSchemeParams) -> Result<ResponseContent<GetProjectsForIssueTypeScreenSchemeSuccess>, Error<GetProjectsForIssueTypeScreenSchemeError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let issue_type_screen_scheme_id = params.issue_type_screen_scheme_id;
    let start_at = params.start_at;
    let max_results = params.max_results;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/issuetypescreenscheme/{issueTypeScreenSchemeId}/project", local_var_configuration.base_path, issueTypeScreenSchemeId=issue_type_screen_scheme_id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = start_at {
        local_var_req_builder = local_var_req_builder.query(&[("startAt", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = max_results {
        local_var_req_builder = local_var_req_builder.query(&[("maxResults", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<GetProjectsForIssueTypeScreenSchemeSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<GetProjectsForIssueTypeScreenSchemeError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Removes issue type to screen scheme mappings from an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
pub async fn remove_mappings_from_issue_type_screen_scheme(configuration: &configuration::Configuration, params: RemoveMappingsFromIssueTypeScreenSchemeParams) -> Result<ResponseContent<RemoveMappingsFromIssueTypeScreenSchemeSuccess>, Error<RemoveMappingsFromIssueTypeScreenSchemeError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let issue_type_screen_scheme_id = params.issue_type_screen_scheme_id;
    let issue_type_ids = params.issue_type_ids;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/issuetypescreenscheme/{issueTypeScreenSchemeId}/mapping/remove", local_var_configuration.base_path, issueTypeScreenSchemeId=crate::apis::urlencode(issue_type_screen_scheme_id));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&issue_type_ids);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<RemoveMappingsFromIssueTypeScreenSchemeSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<RemoveMappingsFromIssueTypeScreenSchemeError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Updates the default screen scheme of an issue type screen scheme. The default screen scheme is used for all unmapped issue types.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
pub async fn update_default_screen_scheme(configuration: &configuration::Configuration, params: UpdateDefaultScreenSchemeParams) -> Result<ResponseContent<UpdateDefaultScreenSchemeSuccess>, Error<UpdateDefaultScreenSchemeError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let issue_type_screen_scheme_id = params.issue_type_screen_scheme_id;
    let update_default_screen_scheme = params.update_default_screen_scheme;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/issuetypescreenscheme/{issueTypeScreenSchemeId}/mapping/default", local_var_configuration.base_path, issueTypeScreenSchemeId=crate::apis::urlencode(issue_type_screen_scheme_id));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::PUT, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&update_default_screen_scheme);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<UpdateDefaultScreenSchemeSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<UpdateDefaultScreenSchemeError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Updates an issue type screen scheme.  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
pub async fn update_issue_type_screen_scheme(configuration: &configuration::Configuration, params: UpdateIssueTypeScreenSchemeParams) -> Result<ResponseContent<UpdateIssueTypeScreenSchemeSuccess>, Error<UpdateIssueTypeScreenSchemeError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let issue_type_screen_scheme_id = params.issue_type_screen_scheme_id;
    let issue_type_screen_scheme_update_details = params.issue_type_screen_scheme_update_details;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/rest/api/2/issuetypescreenscheme/{issueTypeScreenSchemeId}", local_var_configuration.base_path, issueTypeScreenSchemeId=crate::apis::urlencode(issue_type_screen_scheme_id));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::PUT, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
        local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
    };
    if let Some(ref local_var_auth_conf) = local_var_configuration.basic_auth {
        local_var_req_builder = local_var_req_builder.basic_auth(local_var_auth_conf.0.to_owned(), local_var_auth_conf.1.to_owned());
    };
    local_var_req_builder = local_var_req_builder.json(&issue_type_screen_scheme_update_details);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        let local_var_entity: Option<UpdateIssueTypeScreenSchemeSuccess> = serde_json::from_str(&local_var_content).ok();
        let local_var_result = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Ok(local_var_result)
    } else {
        let local_var_entity: Option<UpdateIssueTypeScreenSchemeError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

