# Rust API client for openapi

Jira Cloud platform REST API documentation


## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 1001.0.0-SNAPSHOT
- Package version: 1001.0.0-SNAPSHOT
- Build package: `org.openapitools.codegen.languages.RustClientCodegen`

## Installation

Put the package under your project folder in a directory named `openapi` and add the following to `Cargo.toml` under `[dependencies]`:

```
openapi = { path = "./openapi" }
```

## Documentation for API Endpoints

All URIs are relative to *https://your-domain.atlassian.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AppMigrationApi* | [**app_issue_field_value_update_resource_update_issue_fields_put**](docs/AppMigrationApi.md#app_issue_field_value_update_resource_update_issue_fields_put) | **PUT** /rest/atlassian-connect/1/migration/field | Bulk update custom field value
*AppMigrationApi* | [**migration_resource_update_entity_properties_value_put**](docs/AppMigrationApi.md#migration_resource_update_entity_properties_value_put) | **PUT** /rest/atlassian-connect/1/migration/properties/{entityType} | Bulk update entity properties
*AppMigrationApi* | [**migration_resource_workflow_rule_search_post**](docs/AppMigrationApi.md#migration_resource_workflow_rule_search_post) | **POST** /rest/atlassian-connect/1/migration/workflow/rule/search | Get workflow transition rule configurations
*AppPropertiesApi* | [**addon_properties_resource_delete_addon_property_delete**](docs/AppPropertiesApi.md#addon_properties_resource_delete_addon_property_delete) | **DELETE** /rest/atlassian-connect/1/addons/{addonKey}/properties/{propertyKey} | Delete app property
*AppPropertiesApi* | [**addon_properties_resource_get_addon_properties_get**](docs/AppPropertiesApi.md#addon_properties_resource_get_addon_properties_get) | **GET** /rest/atlassian-connect/1/addons/{addonKey}/properties | Get app properties
*AppPropertiesApi* | [**addon_properties_resource_get_addon_property_get**](docs/AppPropertiesApi.md#addon_properties_resource_get_addon_property_get) | **GET** /rest/atlassian-connect/1/addons/{addonKey}/properties/{propertyKey} | Get app property
*AppPropertiesApi* | [**addon_properties_resource_put_addon_property_put**](docs/AppPropertiesApi.md#addon_properties_resource_put_addon_property_put) | **PUT** /rest/atlassian-connect/1/addons/{addonKey}/properties/{propertyKey} | Set app property
*ApplicationRolesApi* | [**get_all_application_roles**](docs/ApplicationRolesApi.md#get_all_application_roles) | **GET** /rest/api/2/applicationrole | Get all application roles
*ApplicationRolesApi* | [**get_application_role**](docs/ApplicationRolesApi.md#get_application_role) | **GET** /rest/api/2/applicationrole/{key} | Get application role
*AuditRecordsApi* | [**get_audit_records**](docs/AuditRecordsApi.md#get_audit_records) | **GET** /rest/api/2/auditing/record | Get audit records
*AvatarsApi* | [**delete_avatar**](docs/AvatarsApi.md#delete_avatar) | **DELETE** /rest/api/2/universal_avatar/type/{type}/owner/{owningObjectId}/avatar/{id} | Delete avatar
*AvatarsApi* | [**get_all_system_avatars**](docs/AvatarsApi.md#get_all_system_avatars) | **GET** /rest/api/2/avatar/{type}/system | Get system avatars by type
*AvatarsApi* | [**get_avatar_image_by_id**](docs/AvatarsApi.md#get_avatar_image_by_id) | **GET** /rest/api/2/universal_avatar/view/type/{type}/avatar/{id} | Get avatar image by ID
*AvatarsApi* | [**get_avatar_image_by_owner**](docs/AvatarsApi.md#get_avatar_image_by_owner) | **GET** /rest/api/2/universal_avatar/view/type/{type}/owner/{entityId} | Get avatar image by owner
*AvatarsApi* | [**get_avatar_image_by_type**](docs/AvatarsApi.md#get_avatar_image_by_type) | **GET** /rest/api/2/universal_avatar/view/type/{type} | Get avatar image by type
*AvatarsApi* | [**get_avatars**](docs/AvatarsApi.md#get_avatars) | **GET** /rest/api/2/universal_avatar/type/{type}/owner/{entityId} | Get avatars
*AvatarsApi* | [**store_avatar**](docs/AvatarsApi.md#store_avatar) | **POST** /rest/api/2/universal_avatar/type/{type}/owner/{entityId} | Load avatar
*DashboardsApi* | [**add_gadget**](docs/DashboardsApi.md#add_gadget) | **POST** /rest/api/2/dashboard/{dashboardId}/gadget | Add gadget to dashboard
*DashboardsApi* | [**copy_dashboard**](docs/DashboardsApi.md#copy_dashboard) | **POST** /rest/api/2/dashboard/{id}/copy | Copy dashboard
*DashboardsApi* | [**create_dashboard**](docs/DashboardsApi.md#create_dashboard) | **POST** /rest/api/2/dashboard | Create dashboard
*DashboardsApi* | [**delete_dashboard**](docs/DashboardsApi.md#delete_dashboard) | **DELETE** /rest/api/2/dashboard/{id} | Delete dashboard
*DashboardsApi* | [**delete_dashboard_item_property**](docs/DashboardsApi.md#delete_dashboard_item_property) | **DELETE** /rest/api/2/dashboard/{dashboardId}/items/{itemId}/properties/{propertyKey} | Delete dashboard item property
*DashboardsApi* | [**get_all_available_dashboard_gadgets**](docs/DashboardsApi.md#get_all_available_dashboard_gadgets) | **GET** /rest/api/2/dashboard/gadgets | Get available gadgets
*DashboardsApi* | [**get_all_dashboards**](docs/DashboardsApi.md#get_all_dashboards) | **GET** /rest/api/2/dashboard | Get all dashboards
*DashboardsApi* | [**get_all_gadgets**](docs/DashboardsApi.md#get_all_gadgets) | **GET** /rest/api/2/dashboard/{dashboardId}/gadget | Get gadgets
*DashboardsApi* | [**get_dashboard**](docs/DashboardsApi.md#get_dashboard) | **GET** /rest/api/2/dashboard/{id} | Get dashboard
*DashboardsApi* | [**get_dashboard_item_property**](docs/DashboardsApi.md#get_dashboard_item_property) | **GET** /rest/api/2/dashboard/{dashboardId}/items/{itemId}/properties/{propertyKey} | Get dashboard item property
*DashboardsApi* | [**get_dashboard_item_property_keys**](docs/DashboardsApi.md#get_dashboard_item_property_keys) | **GET** /rest/api/2/dashboard/{dashboardId}/items/{itemId}/properties | Get dashboard item property keys
*DashboardsApi* | [**get_dashboards_paginated**](docs/DashboardsApi.md#get_dashboards_paginated) | **GET** /rest/api/2/dashboard/search | Search for dashboards
*DashboardsApi* | [**remove_gadget**](docs/DashboardsApi.md#remove_gadget) | **DELETE** /rest/api/2/dashboard/{dashboardId}/gadget/{gadgetId} | Remove gadget from dashboard
*DashboardsApi* | [**set_dashboard_item_property**](docs/DashboardsApi.md#set_dashboard_item_property) | **PUT** /rest/api/2/dashboard/{dashboardId}/items/{itemId}/properties/{propertyKey} | Set dashboard item property
*DashboardsApi* | [**update_dashboard**](docs/DashboardsApi.md#update_dashboard) | **PUT** /rest/api/2/dashboard/{id} | Update dashboard
*DashboardsApi* | [**update_gadget**](docs/DashboardsApi.md#update_gadget) | **PUT** /rest/api/2/dashboard/{dashboardId}/gadget/{gadgetId} | Update gadget on dashboard
*DynamicModulesApi* | [**dynamic_modules_resource_get_modules_get**](docs/DynamicModulesApi.md#dynamic_modules_resource_get_modules_get) | **GET** /rest/atlassian-connect/1/app/module/dynamic | Get modules
*DynamicModulesApi* | [**dynamic_modules_resource_register_modules_post**](docs/DynamicModulesApi.md#dynamic_modules_resource_register_modules_post) | **POST** /rest/atlassian-connect/1/app/module/dynamic | Register modules
*DynamicModulesApi* | [**dynamic_modules_resource_remove_modules_delete**](docs/DynamicModulesApi.md#dynamic_modules_resource_remove_modules_delete) | **DELETE** /rest/atlassian-connect/1/app/module/dynamic | Remove modules
*FilterSharingApi* | [**add_share_permission**](docs/FilterSharingApi.md#add_share_permission) | **POST** /rest/api/2/filter/{id}/permission | Add share permission
*FilterSharingApi* | [**delete_share_permission**](docs/FilterSharingApi.md#delete_share_permission) | **DELETE** /rest/api/2/filter/{id}/permission/{permissionId} | Delete share permission
*FilterSharingApi* | [**get_default_share_scope**](docs/FilterSharingApi.md#get_default_share_scope) | **GET** /rest/api/2/filter/defaultShareScope | Get default share scope
*FilterSharingApi* | [**get_share_permission**](docs/FilterSharingApi.md#get_share_permission) | **GET** /rest/api/2/filter/{id}/permission/{permissionId} | Get share permission
*FilterSharingApi* | [**get_share_permissions**](docs/FilterSharingApi.md#get_share_permissions) | **GET** /rest/api/2/filter/{id}/permission | Get share permissions
*FilterSharingApi* | [**set_default_share_scope**](docs/FilterSharingApi.md#set_default_share_scope) | **PUT** /rest/api/2/filter/defaultShareScope | Set default share scope
*FiltersApi* | [**change_filter_owner**](docs/FiltersApi.md#change_filter_owner) | **PUT** /rest/api/2/filter/{id}/owner | Change filter owner
*FiltersApi* | [**create_filter**](docs/FiltersApi.md#create_filter) | **POST** /rest/api/2/filter | Create filter
*FiltersApi* | [**delete_favourite_for_filter**](docs/FiltersApi.md#delete_favourite_for_filter) | **DELETE** /rest/api/2/filter/{id}/favourite | Remove filter as favorite
*FiltersApi* | [**delete_filter**](docs/FiltersApi.md#delete_filter) | **DELETE** /rest/api/2/filter/{id} | Delete filter
*FiltersApi* | [**get_columns**](docs/FiltersApi.md#get_columns) | **GET** /rest/api/2/filter/{id}/columns | Get columns
*FiltersApi* | [**get_favourite_filters**](docs/FiltersApi.md#get_favourite_filters) | **GET** /rest/api/2/filter/favourite | Get favorite filters
*FiltersApi* | [**get_filter**](docs/FiltersApi.md#get_filter) | **GET** /rest/api/2/filter/{id} | Get filter
*FiltersApi* | [**get_filters**](docs/FiltersApi.md#get_filters) | **GET** /rest/api/2/filter | Get filters
*FiltersApi* | [**get_filters_paginated**](docs/FiltersApi.md#get_filters_paginated) | **GET** /rest/api/2/filter/search | Search for filters
*FiltersApi* | [**get_my_filters**](docs/FiltersApi.md#get_my_filters) | **GET** /rest/api/2/filter/my | Get my filters
*FiltersApi* | [**reset_columns**](docs/FiltersApi.md#reset_columns) | **DELETE** /rest/api/2/filter/{id}/columns | Reset columns
*FiltersApi* | [**set_columns**](docs/FiltersApi.md#set_columns) | **PUT** /rest/api/2/filter/{id}/columns | Set columns
*FiltersApi* | [**set_favourite_for_filter**](docs/FiltersApi.md#set_favourite_for_filter) | **PUT** /rest/api/2/filter/{id}/favourite | Add filter as favorite
*FiltersApi* | [**update_filter**](docs/FiltersApi.md#update_filter) | **PUT** /rest/api/2/filter/{id} | Update filter
*GroupAndUserPickerApi* | [**find_users_and_groups**](docs/GroupAndUserPickerApi.md#find_users_and_groups) | **GET** /rest/api/2/groupuserpicker | Find users and groups
*GroupsApi* | [**add_user_to_group**](docs/GroupsApi.md#add_user_to_group) | **POST** /rest/api/2/group/user | Add user to group
*GroupsApi* | [**bulk_get_groups**](docs/GroupsApi.md#bulk_get_groups) | **GET** /rest/api/2/group/bulk | Bulk get groups
*GroupsApi* | [**create_group**](docs/GroupsApi.md#create_group) | **POST** /rest/api/2/group | Create group
*GroupsApi* | [**find_groups**](docs/GroupsApi.md#find_groups) | **GET** /rest/api/2/groups/picker | Find groups
*GroupsApi* | [**get_group**](docs/GroupsApi.md#get_group) | **GET** /rest/api/2/group | Get group
*GroupsApi* | [**get_users_from_group**](docs/GroupsApi.md#get_users_from_group) | **GET** /rest/api/2/group/member | Get users from group
*GroupsApi* | [**remove_group**](docs/GroupsApi.md#remove_group) | **DELETE** /rest/api/2/group | Remove group
*GroupsApi* | [**remove_user_from_group**](docs/GroupsApi.md#remove_user_from_group) | **DELETE** /rest/api/2/group/user | Remove user from group
*InstanceInformationApi* | [**get_license**](docs/InstanceInformationApi.md#get_license) | **GET** /rest/api/2/instance/license | Get license
*IssueAttachmentsApi* | [**add_attachment**](docs/IssueAttachmentsApi.md#add_attachment) | **POST** /rest/api/2/issue/{issueIdOrKey}/attachments | Add attachment
*IssueAttachmentsApi* | [**expand_attachment_for_humans**](docs/IssueAttachmentsApi.md#expand_attachment_for_humans) | **GET** /rest/api/2/attachment/{id}/expand/human | Get all metadata for an expanded attachment
*IssueAttachmentsApi* | [**expand_attachment_for_machines**](docs/IssueAttachmentsApi.md#expand_attachment_for_machines) | **GET** /rest/api/2/attachment/{id}/expand/raw | Get contents metadata for an expanded attachment
*IssueAttachmentsApi* | [**get_attachment**](docs/IssueAttachmentsApi.md#get_attachment) | **GET** /rest/api/2/attachment/{id} | Get attachment metadata
*IssueAttachmentsApi* | [**get_attachment_content**](docs/IssueAttachmentsApi.md#get_attachment_content) | **GET** /rest/api/2/attachment/content/{id} | Get attachment content
*IssueAttachmentsApi* | [**get_attachment_meta**](docs/IssueAttachmentsApi.md#get_attachment_meta) | **GET** /rest/api/2/attachment/meta | Get Jira attachment settings
*IssueAttachmentsApi* | [**get_attachment_thumbnail**](docs/IssueAttachmentsApi.md#get_attachment_thumbnail) | **GET** /rest/api/2/attachment/thumbnail/{id} | Get attachment thumbnail
*IssueAttachmentsApi* | [**remove_attachment**](docs/IssueAttachmentsApi.md#remove_attachment) | **DELETE** /rest/api/2/attachment/{id} | Delete attachment
*IssueCommentPropertiesApi* | [**delete_comment_property**](docs/IssueCommentPropertiesApi.md#delete_comment_property) | **DELETE** /rest/api/2/comment/{commentId}/properties/{propertyKey} | Delete comment property
*IssueCommentPropertiesApi* | [**get_comment_property**](docs/IssueCommentPropertiesApi.md#get_comment_property) | **GET** /rest/api/2/comment/{commentId}/properties/{propertyKey} | Get comment property
*IssueCommentPropertiesApi* | [**get_comment_property_keys**](docs/IssueCommentPropertiesApi.md#get_comment_property_keys) | **GET** /rest/api/2/comment/{commentId}/properties | Get comment property keys
*IssueCommentPropertiesApi* | [**set_comment_property**](docs/IssueCommentPropertiesApi.md#set_comment_property) | **PUT** /rest/api/2/comment/{commentId}/properties/{propertyKey} | Set comment property
*IssueCommentsApi* | [**add_comment**](docs/IssueCommentsApi.md#add_comment) | **POST** /rest/api/2/issue/{issueIdOrKey}/comment | Add comment
*IssueCommentsApi* | [**delete_comment**](docs/IssueCommentsApi.md#delete_comment) | **DELETE** /rest/api/2/issue/{issueIdOrKey}/comment/{id} | Delete comment
*IssueCommentsApi* | [**get_comment**](docs/IssueCommentsApi.md#get_comment) | **GET** /rest/api/2/issue/{issueIdOrKey}/comment/{id} | Get comment
*IssueCommentsApi* | [**get_comments**](docs/IssueCommentsApi.md#get_comments) | **GET** /rest/api/2/issue/{issueIdOrKey}/comment | Get comments
*IssueCommentsApi* | [**get_comments_by_ids**](docs/IssueCommentsApi.md#get_comments_by_ids) | **POST** /rest/api/2/comment/list | Get comments by IDs
*IssueCommentsApi* | [**update_comment**](docs/IssueCommentsApi.md#update_comment) | **PUT** /rest/api/2/issue/{issueIdOrKey}/comment/{id} | Update comment
*IssueCustomFieldConfigurationAppsApi* | [**get_custom_field_configuration**](docs/IssueCustomFieldConfigurationAppsApi.md#get_custom_field_configuration) | **GET** /rest/api/2/app/field/{fieldIdOrKey}/context/configuration | Get custom field configurations
*IssueCustomFieldConfigurationAppsApi* | [**update_custom_field_configuration**](docs/IssueCustomFieldConfigurationAppsApi.md#update_custom_field_configuration) | **PUT** /rest/api/2/app/field/{fieldIdOrKey}/context/configuration | Update custom field configurations
*IssueCustomFieldContextsApi* | [**add_issue_types_to_context**](docs/IssueCustomFieldContextsApi.md#add_issue_types_to_context) | **PUT** /rest/api/2/field/{fieldId}/context/{contextId}/issuetype | Add issue types to context
*IssueCustomFieldContextsApi* | [**assign_projects_to_custom_field_context**](docs/IssueCustomFieldContextsApi.md#assign_projects_to_custom_field_context) | **PUT** /rest/api/2/field/{fieldId}/context/{contextId}/project | Assign custom field context to projects
*IssueCustomFieldContextsApi* | [**create_custom_field_context**](docs/IssueCustomFieldContextsApi.md#create_custom_field_context) | **POST** /rest/api/2/field/{fieldId}/context | Create custom field context
*IssueCustomFieldContextsApi* | [**delete_custom_field_context**](docs/IssueCustomFieldContextsApi.md#delete_custom_field_context) | **DELETE** /rest/api/2/field/{fieldId}/context/{contextId} | Delete custom field context
*IssueCustomFieldContextsApi* | [**get_contexts_for_field**](docs/IssueCustomFieldContextsApi.md#get_contexts_for_field) | **GET** /rest/api/2/field/{fieldId}/context | Get custom field contexts
*IssueCustomFieldContextsApi* | [**get_custom_field_contexts_for_projects_and_issue_types**](docs/IssueCustomFieldContextsApi.md#get_custom_field_contexts_for_projects_and_issue_types) | **POST** /rest/api/2/field/{fieldId}/context/mapping | Get custom field contexts for projects and issue types
*IssueCustomFieldContextsApi* | [**get_default_values**](docs/IssueCustomFieldContextsApi.md#get_default_values) | **GET** /rest/api/2/field/{fieldId}/context/defaultValue | Get custom field contexts default values
*IssueCustomFieldContextsApi* | [**get_issue_type_mappings_for_contexts**](docs/IssueCustomFieldContextsApi.md#get_issue_type_mappings_for_contexts) | **GET** /rest/api/2/field/{fieldId}/context/issuetypemapping | Get issue types for custom field context
*IssueCustomFieldContextsApi* | [**get_project_context_mapping**](docs/IssueCustomFieldContextsApi.md#get_project_context_mapping) | **GET** /rest/api/2/field/{fieldId}/context/projectmapping | Get project mappings for custom field context
*IssueCustomFieldContextsApi* | [**remove_custom_field_context_from_projects**](docs/IssueCustomFieldContextsApi.md#remove_custom_field_context_from_projects) | **POST** /rest/api/2/field/{fieldId}/context/{contextId}/project/remove | Remove custom field context from projects
*IssueCustomFieldContextsApi* | [**remove_issue_types_from_context**](docs/IssueCustomFieldContextsApi.md#remove_issue_types_from_context) | **POST** /rest/api/2/field/{fieldId}/context/{contextId}/issuetype/remove | Remove issue types from context
*IssueCustomFieldContextsApi* | [**set_default_values**](docs/IssueCustomFieldContextsApi.md#set_default_values) | **PUT** /rest/api/2/field/{fieldId}/context/defaultValue | Set custom field contexts default values
*IssueCustomFieldContextsApi* | [**update_custom_field_context**](docs/IssueCustomFieldContextsApi.md#update_custom_field_context) | **PUT** /rest/api/2/field/{fieldId}/context/{contextId} | Update custom field context
*IssueCustomFieldOptionsApi* | [**create_custom_field_option**](docs/IssueCustomFieldOptionsApi.md#create_custom_field_option) | **POST** /rest/api/2/field/{fieldId}/context/{contextId}/option | Create custom field options (context)
*IssueCustomFieldOptionsApi* | [**delete_custom_field_option**](docs/IssueCustomFieldOptionsApi.md#delete_custom_field_option) | **DELETE** /rest/api/2/field/{fieldId}/context/{contextId}/option/{optionId} | Delete custom field options (context)
*IssueCustomFieldOptionsApi* | [**get_custom_field_option**](docs/IssueCustomFieldOptionsApi.md#get_custom_field_option) | **GET** /rest/api/2/customFieldOption/{id} | Get custom field option
*IssueCustomFieldOptionsApi* | [**get_options_for_context**](docs/IssueCustomFieldOptionsApi.md#get_options_for_context) | **GET** /rest/api/2/field/{fieldId}/context/{contextId}/option | Get custom field options (context)
*IssueCustomFieldOptionsApi* | [**reorder_custom_field_options**](docs/IssueCustomFieldOptionsApi.md#reorder_custom_field_options) | **PUT** /rest/api/2/field/{fieldId}/context/{contextId}/option/move | Reorder custom field options (context)
*IssueCustomFieldOptionsApi* | [**update_custom_field_option**](docs/IssueCustomFieldOptionsApi.md#update_custom_field_option) | **PUT** /rest/api/2/field/{fieldId}/context/{contextId}/option | Update custom field options (context)
*IssueCustomFieldOptionsAppsApi* | [**create_issue_field_option**](docs/IssueCustomFieldOptionsAppsApi.md#create_issue_field_option) | **POST** /rest/api/2/field/{fieldKey}/option | Create issue field option
*IssueCustomFieldOptionsAppsApi* | [**delete_issue_field_option**](docs/IssueCustomFieldOptionsAppsApi.md#delete_issue_field_option) | **DELETE** /rest/api/2/field/{fieldKey}/option/{optionId} | Delete issue field option
*IssueCustomFieldOptionsAppsApi* | [**get_all_issue_field_options**](docs/IssueCustomFieldOptionsAppsApi.md#get_all_issue_field_options) | **GET** /rest/api/2/field/{fieldKey}/option | Get all issue field options
*IssueCustomFieldOptionsAppsApi* | [**get_issue_field_option**](docs/IssueCustomFieldOptionsAppsApi.md#get_issue_field_option) | **GET** /rest/api/2/field/{fieldKey}/option/{optionId} | Get issue field option
*IssueCustomFieldOptionsAppsApi* | [**get_selectable_issue_field_options**](docs/IssueCustomFieldOptionsAppsApi.md#get_selectable_issue_field_options) | **GET** /rest/api/2/field/{fieldKey}/option/suggestions/edit | Get selectable issue field options
*IssueCustomFieldOptionsAppsApi* | [**get_visible_issue_field_options**](docs/IssueCustomFieldOptionsAppsApi.md#get_visible_issue_field_options) | **GET** /rest/api/2/field/{fieldKey}/option/suggestions/search | Get visible issue field options
*IssueCustomFieldOptionsAppsApi* | [**replace_issue_field_option**](docs/IssueCustomFieldOptionsAppsApi.md#replace_issue_field_option) | **DELETE** /rest/api/2/field/{fieldKey}/option/{optionId}/issue | Replace issue field option
*IssueCustomFieldOptionsAppsApi* | [**update_issue_field_option**](docs/IssueCustomFieldOptionsAppsApi.md#update_issue_field_option) | **PUT** /rest/api/2/field/{fieldKey}/option/{optionId} | Update issue field option
*IssueCustomFieldValuesAppsApi* | [**update_custom_field_value**](docs/IssueCustomFieldValuesAppsApi.md#update_custom_field_value) | **PUT** /rest/api/2/app/field/{fieldIdOrKey}/value | Update custom field value
*IssueCustomFieldValuesAppsApi* | [**update_multiple_custom_field_values**](docs/IssueCustomFieldValuesAppsApi.md#update_multiple_custom_field_values) | **POST** /rest/api/2/app/field/value | Update custom fields
*IssueFieldConfigurationsApi* | [**assign_field_configuration_scheme_to_project**](docs/IssueFieldConfigurationsApi.md#assign_field_configuration_scheme_to_project) | **PUT** /rest/api/2/fieldconfigurationscheme/project | Assign field configuration scheme to project
*IssueFieldConfigurationsApi* | [**create_field_configuration**](docs/IssueFieldConfigurationsApi.md#create_field_configuration) | **POST** /rest/api/2/fieldconfiguration | Create field configuration
*IssueFieldConfigurationsApi* | [**create_field_configuration_scheme**](docs/IssueFieldConfigurationsApi.md#create_field_configuration_scheme) | **POST** /rest/api/2/fieldconfigurationscheme | Create field configuration scheme
*IssueFieldConfigurationsApi* | [**delete_field_configuration**](docs/IssueFieldConfigurationsApi.md#delete_field_configuration) | **DELETE** /rest/api/2/fieldconfiguration/{id} | Delete field configuration
*IssueFieldConfigurationsApi* | [**delete_field_configuration_scheme**](docs/IssueFieldConfigurationsApi.md#delete_field_configuration_scheme) | **DELETE** /rest/api/2/fieldconfigurationscheme/{id} | Delete field configuration scheme
*IssueFieldConfigurationsApi* | [**get_all_field_configuration_schemes**](docs/IssueFieldConfigurationsApi.md#get_all_field_configuration_schemes) | **GET** /rest/api/2/fieldconfigurationscheme | Get all field configuration schemes
*IssueFieldConfigurationsApi* | [**get_all_field_configurations**](docs/IssueFieldConfigurationsApi.md#get_all_field_configurations) | **GET** /rest/api/2/fieldconfiguration | Get all field configurations
*IssueFieldConfigurationsApi* | [**get_field_configuration_items**](docs/IssueFieldConfigurationsApi.md#get_field_configuration_items) | **GET** /rest/api/2/fieldconfiguration/{id}/fields | Get field configuration items
*IssueFieldConfigurationsApi* | [**get_field_configuration_scheme_mappings**](docs/IssueFieldConfigurationsApi.md#get_field_configuration_scheme_mappings) | **GET** /rest/api/2/fieldconfigurationscheme/mapping | Get field configuration issue type items
*IssueFieldConfigurationsApi* | [**get_field_configuration_scheme_project_mapping**](docs/IssueFieldConfigurationsApi.md#get_field_configuration_scheme_project_mapping) | **GET** /rest/api/2/fieldconfigurationscheme/project | Get field configuration schemes for projects
*IssueFieldConfigurationsApi* | [**remove_issue_types_from_global_field_configuration_scheme**](docs/IssueFieldConfigurationsApi.md#remove_issue_types_from_global_field_configuration_scheme) | **POST** /rest/api/2/fieldconfigurationscheme/{id}/mapping/delete | Remove issue types from field configuration scheme
*IssueFieldConfigurationsApi* | [**set_field_configuration_scheme_mapping**](docs/IssueFieldConfigurationsApi.md#set_field_configuration_scheme_mapping) | **PUT** /rest/api/2/fieldconfigurationscheme/{id}/mapping | Assign issue types to field configurations
*IssueFieldConfigurationsApi* | [**update_field_configuration**](docs/IssueFieldConfigurationsApi.md#update_field_configuration) | **PUT** /rest/api/2/fieldconfiguration/{id} | Update field configuration
*IssueFieldConfigurationsApi* | [**update_field_configuration_items**](docs/IssueFieldConfigurationsApi.md#update_field_configuration_items) | **PUT** /rest/api/2/fieldconfiguration/{id}/fields | Update field configuration items
*IssueFieldConfigurationsApi* | [**update_field_configuration_scheme**](docs/IssueFieldConfigurationsApi.md#update_field_configuration_scheme) | **PUT** /rest/api/2/fieldconfigurationscheme/{id} | Update field configuration scheme
*IssueFieldsApi* | [**create_custom_field**](docs/IssueFieldsApi.md#create_custom_field) | **POST** /rest/api/2/field | Create custom field
*IssueFieldsApi* | [**delete_custom_field**](docs/IssueFieldsApi.md#delete_custom_field) | **DELETE** /rest/api/2/field/{id} | Delete custom field
*IssueFieldsApi* | [**get_contexts_for_field_deprecated**](docs/IssueFieldsApi.md#get_contexts_for_field_deprecated) | **GET** /rest/api/2/field/{fieldId}/contexts | Get contexts for a field
*IssueFieldsApi* | [**get_fields**](docs/IssueFieldsApi.md#get_fields) | **GET** /rest/api/2/field | Get fields
*IssueFieldsApi* | [**get_fields_paginated**](docs/IssueFieldsApi.md#get_fields_paginated) | **GET** /rest/api/2/field/search | Get fields paginated
*IssueFieldsApi* | [**restore_custom_field**](docs/IssueFieldsApi.md#restore_custom_field) | **POST** /rest/api/2/field/{id}/restore | Restore custom field from trash
*IssueFieldsApi* | [**trash_custom_field**](docs/IssueFieldsApi.md#trash_custom_field) | **POST** /rest/api/2/field/{id}/trash | Move custom field to trash
*IssueFieldsApi* | [**update_custom_field**](docs/IssueFieldsApi.md#update_custom_field) | **PUT** /rest/api/2/field/{fieldId} | Update custom field
*IssueLinkTypesApi* | [**create_issue_link_type**](docs/IssueLinkTypesApi.md#create_issue_link_type) | **POST** /rest/api/2/issueLinkType | Create issue link type
*IssueLinkTypesApi* | [**delete_issue_link_type**](docs/IssueLinkTypesApi.md#delete_issue_link_type) | **DELETE** /rest/api/2/issueLinkType/{issueLinkTypeId} | Delete issue link type
*IssueLinkTypesApi* | [**get_issue_link_type**](docs/IssueLinkTypesApi.md#get_issue_link_type) | **GET** /rest/api/2/issueLinkType/{issueLinkTypeId} | Get issue link type
*IssueLinkTypesApi* | [**get_issue_link_types**](docs/IssueLinkTypesApi.md#get_issue_link_types) | **GET** /rest/api/2/issueLinkType | Get issue link types
*IssueLinkTypesApi* | [**update_issue_link_type**](docs/IssueLinkTypesApi.md#update_issue_link_type) | **PUT** /rest/api/2/issueLinkType/{issueLinkTypeId} | Update issue link type
*IssueLinksApi* | [**delete_issue_link**](docs/IssueLinksApi.md#delete_issue_link) | **DELETE** /rest/api/2/issueLink/{linkId} | Delete issue link
*IssueLinksApi* | [**get_issue_link**](docs/IssueLinksApi.md#get_issue_link) | **GET** /rest/api/2/issueLink/{linkId} | Get issue link
*IssueLinksApi* | [**link_issues**](docs/IssueLinksApi.md#link_issues) | **POST** /rest/api/2/issueLink | Create issue link
*IssueNavigatorSettingsApi* | [**get_issue_navigator_default_columns**](docs/IssueNavigatorSettingsApi.md#get_issue_navigator_default_columns) | **GET** /rest/api/2/settings/columns | Get issue navigator default columns
*IssueNavigatorSettingsApi* | [**set_issue_navigator_default_columns**](docs/IssueNavigatorSettingsApi.md#set_issue_navigator_default_columns) | **PUT** /rest/api/2/settings/columns | Set issue navigator default columns
*IssueNotificationSchemesApi* | [**get_notification_scheme**](docs/IssueNotificationSchemesApi.md#get_notification_scheme) | **GET** /rest/api/2/notificationscheme/{id} | Get notification scheme
*IssueNotificationSchemesApi* | [**get_notification_schemes**](docs/IssueNotificationSchemesApi.md#get_notification_schemes) | **GET** /rest/api/2/notificationscheme | Get notification schemes paginated
*IssuePrioritiesApi* | [**get_priorities**](docs/IssuePrioritiesApi.md#get_priorities) | **GET** /rest/api/2/priority | Get priorities
*IssuePrioritiesApi* | [**get_priority**](docs/IssuePrioritiesApi.md#get_priority) | **GET** /rest/api/2/priority/{id} | Get priority
*IssuePropertiesApi* | [**bulk_delete_issue_property**](docs/IssuePropertiesApi.md#bulk_delete_issue_property) | **DELETE** /rest/api/2/issue/properties/{propertyKey} | Bulk delete issue property
*IssuePropertiesApi* | [**bulk_set_issue_properties_by_issue**](docs/IssuePropertiesApi.md#bulk_set_issue_properties_by_issue) | **POST** /rest/api/2/issue/properties/multi | Bulk set issue properties by issue
*IssuePropertiesApi* | [**bulk_set_issue_property**](docs/IssuePropertiesApi.md#bulk_set_issue_property) | **PUT** /rest/api/2/issue/properties/{propertyKey} | Bulk set issue property
*IssuePropertiesApi* | [**bulk_set_issues_properties_list**](docs/IssuePropertiesApi.md#bulk_set_issues_properties_list) | **POST** /rest/api/2/issue/properties | Bulk set issues properties by list
*IssuePropertiesApi* | [**delete_issue_property**](docs/IssuePropertiesApi.md#delete_issue_property) | **DELETE** /rest/api/2/issue/{issueIdOrKey}/properties/{propertyKey} | Delete issue property
*IssuePropertiesApi* | [**get_issue_property**](docs/IssuePropertiesApi.md#get_issue_property) | **GET** /rest/api/2/issue/{issueIdOrKey}/properties/{propertyKey} | Get issue property
*IssuePropertiesApi* | [**get_issue_property_keys**](docs/IssuePropertiesApi.md#get_issue_property_keys) | **GET** /rest/api/2/issue/{issueIdOrKey}/properties | Get issue property keys
*IssuePropertiesApi* | [**set_issue_property**](docs/IssuePropertiesApi.md#set_issue_property) | **PUT** /rest/api/2/issue/{issueIdOrKey}/properties/{propertyKey} | Set issue property
*IssueRemoteLinksApi* | [**create_or_update_remote_issue_link**](docs/IssueRemoteLinksApi.md#create_or_update_remote_issue_link) | **POST** /rest/api/2/issue/{issueIdOrKey}/remotelink | Create or update remote issue link
*IssueRemoteLinksApi* | [**delete_remote_issue_link_by_global_id**](docs/IssueRemoteLinksApi.md#delete_remote_issue_link_by_global_id) | **DELETE** /rest/api/2/issue/{issueIdOrKey}/remotelink | Delete remote issue link by global ID
*IssueRemoteLinksApi* | [**delete_remote_issue_link_by_id**](docs/IssueRemoteLinksApi.md#delete_remote_issue_link_by_id) | **DELETE** /rest/api/2/issue/{issueIdOrKey}/remotelink/{linkId} | Delete remote issue link by ID
*IssueRemoteLinksApi* | [**get_remote_issue_link_by_id**](docs/IssueRemoteLinksApi.md#get_remote_issue_link_by_id) | **GET** /rest/api/2/issue/{issueIdOrKey}/remotelink/{linkId} | Get remote issue link by ID
*IssueRemoteLinksApi* | [**get_remote_issue_links**](docs/IssueRemoteLinksApi.md#get_remote_issue_links) | **GET** /rest/api/2/issue/{issueIdOrKey}/remotelink | Get remote issue links
*IssueRemoteLinksApi* | [**update_remote_issue_link**](docs/IssueRemoteLinksApi.md#update_remote_issue_link) | **PUT** /rest/api/2/issue/{issueIdOrKey}/remotelink/{linkId} | Update remote issue link by ID
*IssueResolutionsApi* | [**get_resolution**](docs/IssueResolutionsApi.md#get_resolution) | **GET** /rest/api/2/resolution/{id} | Get resolution
*IssueResolutionsApi* | [**get_resolutions**](docs/IssueResolutionsApi.md#get_resolutions) | **GET** /rest/api/2/resolution | Get resolutions
*IssueSearchApi* | [**get_issue_picker_resource**](docs/IssueSearchApi.md#get_issue_picker_resource) | **GET** /rest/api/2/issue/picker | Get issue picker suggestions
*IssueSearchApi* | [**match_issues**](docs/IssueSearchApi.md#match_issues) | **POST** /rest/api/2/jql/match | Check issues against JQL
*IssueSearchApi* | [**search_for_issues_using_jql**](docs/IssueSearchApi.md#search_for_issues_using_jql) | **GET** /rest/api/2/search | Search for issues using JQL (GET)
*IssueSearchApi* | [**search_for_issues_using_jql_post**](docs/IssueSearchApi.md#search_for_issues_using_jql_post) | **POST** /rest/api/2/search | Search for issues using JQL (POST)
*IssueSecurityLevelApi* | [**get_issue_security_level**](docs/IssueSecurityLevelApi.md#get_issue_security_level) | **GET** /rest/api/2/securitylevel/{id} | Get issue security level
*IssueSecurityLevelApi* | [**get_issue_security_level_members**](docs/IssueSecurityLevelApi.md#get_issue_security_level_members) | **GET** /rest/api/2/issuesecurityschemes/{issueSecuritySchemeId}/members | Get issue security level members
*IssueSecuritySchemesApi* | [**get_issue_security_scheme**](docs/IssueSecuritySchemesApi.md#get_issue_security_scheme) | **GET** /rest/api/2/issuesecurityschemes/{id} | Get issue security scheme
*IssueSecuritySchemesApi* | [**get_issue_security_schemes**](docs/IssueSecuritySchemesApi.md#get_issue_security_schemes) | **GET** /rest/api/2/issuesecurityschemes | Get issue security schemes
*IssueTypePropertiesApi* | [**delete_issue_type_property**](docs/IssueTypePropertiesApi.md#delete_issue_type_property) | **DELETE** /rest/api/2/issuetype/{issueTypeId}/properties/{propertyKey} | Delete issue type property
*IssueTypePropertiesApi* | [**get_issue_type_property**](docs/IssueTypePropertiesApi.md#get_issue_type_property) | **GET** /rest/api/2/issuetype/{issueTypeId}/properties/{propertyKey} | Get issue type property
*IssueTypePropertiesApi* | [**get_issue_type_property_keys**](docs/IssueTypePropertiesApi.md#get_issue_type_property_keys) | **GET** /rest/api/2/issuetype/{issueTypeId}/properties | Get issue type property keys
*IssueTypePropertiesApi* | [**set_issue_type_property**](docs/IssueTypePropertiesApi.md#set_issue_type_property) | **PUT** /rest/api/2/issuetype/{issueTypeId}/properties/{propertyKey} | Set issue type property
*IssueTypeSchemesApi* | [**add_issue_types_to_issue_type_scheme**](docs/IssueTypeSchemesApi.md#add_issue_types_to_issue_type_scheme) | **PUT** /rest/api/2/issuetypescheme/{issueTypeSchemeId}/issuetype | Add issue types to issue type scheme
*IssueTypeSchemesApi* | [**assign_issue_type_scheme_to_project**](docs/IssueTypeSchemesApi.md#assign_issue_type_scheme_to_project) | **PUT** /rest/api/2/issuetypescheme/project | Assign issue type scheme to project
*IssueTypeSchemesApi* | [**create_issue_type_scheme**](docs/IssueTypeSchemesApi.md#create_issue_type_scheme) | **POST** /rest/api/2/issuetypescheme | Create issue type scheme
*IssueTypeSchemesApi* | [**delete_issue_type_scheme**](docs/IssueTypeSchemesApi.md#delete_issue_type_scheme) | **DELETE** /rest/api/2/issuetypescheme/{issueTypeSchemeId} | Delete issue type scheme
*IssueTypeSchemesApi* | [**get_all_issue_type_schemes**](docs/IssueTypeSchemesApi.md#get_all_issue_type_schemes) | **GET** /rest/api/2/issuetypescheme | Get all issue type schemes
*IssueTypeSchemesApi* | [**get_issue_type_scheme_for_projects**](docs/IssueTypeSchemesApi.md#get_issue_type_scheme_for_projects) | **GET** /rest/api/2/issuetypescheme/project | Get issue type schemes for projects
*IssueTypeSchemesApi* | [**get_issue_type_schemes_mapping**](docs/IssueTypeSchemesApi.md#get_issue_type_schemes_mapping) | **GET** /rest/api/2/issuetypescheme/mapping | Get issue type scheme items
*IssueTypeSchemesApi* | [**remove_issue_type_from_issue_type_scheme**](docs/IssueTypeSchemesApi.md#remove_issue_type_from_issue_type_scheme) | **DELETE** /rest/api/2/issuetypescheme/{issueTypeSchemeId}/issuetype/{issueTypeId} | Remove issue type from issue type scheme
*IssueTypeSchemesApi* | [**reorder_issue_types_in_issue_type_scheme**](docs/IssueTypeSchemesApi.md#reorder_issue_types_in_issue_type_scheme) | **PUT** /rest/api/2/issuetypescheme/{issueTypeSchemeId}/issuetype/move | Change order of issue types
*IssueTypeSchemesApi* | [**update_issue_type_scheme**](docs/IssueTypeSchemesApi.md#update_issue_type_scheme) | **PUT** /rest/api/2/issuetypescheme/{issueTypeSchemeId} | Update issue type scheme
*IssueTypeScreenSchemesApi* | [**append_mappings_for_issue_type_screen_scheme**](docs/IssueTypeScreenSchemesApi.md#append_mappings_for_issue_type_screen_scheme) | **PUT** /rest/api/2/issuetypescreenscheme/{issueTypeScreenSchemeId}/mapping | Append mappings to issue type screen scheme
*IssueTypeScreenSchemesApi* | [**assign_issue_type_screen_scheme_to_project**](docs/IssueTypeScreenSchemesApi.md#assign_issue_type_screen_scheme_to_project) | **PUT** /rest/api/2/issuetypescreenscheme/project | Assign issue type screen scheme to project
*IssueTypeScreenSchemesApi* | [**create_issue_type_screen_scheme**](docs/IssueTypeScreenSchemesApi.md#create_issue_type_screen_scheme) | **POST** /rest/api/2/issuetypescreenscheme | Create issue type screen scheme
*IssueTypeScreenSchemesApi* | [**delete_issue_type_screen_scheme**](docs/IssueTypeScreenSchemesApi.md#delete_issue_type_screen_scheme) | **DELETE** /rest/api/2/issuetypescreenscheme/{issueTypeScreenSchemeId} | Delete issue type screen scheme
*IssueTypeScreenSchemesApi* | [**get_issue_type_screen_scheme_mappings**](docs/IssueTypeScreenSchemesApi.md#get_issue_type_screen_scheme_mappings) | **GET** /rest/api/2/issuetypescreenscheme/mapping | Get issue type screen scheme items
*IssueTypeScreenSchemesApi* | [**get_issue_type_screen_scheme_project_associations**](docs/IssueTypeScreenSchemesApi.md#get_issue_type_screen_scheme_project_associations) | **GET** /rest/api/2/issuetypescreenscheme/project | Get issue type screen schemes for projects
*IssueTypeScreenSchemesApi* | [**get_issue_type_screen_schemes**](docs/IssueTypeScreenSchemesApi.md#get_issue_type_screen_schemes) | **GET** /rest/api/2/issuetypescreenscheme | Get issue type screen schemes
*IssueTypeScreenSchemesApi* | [**get_projects_for_issue_type_screen_scheme**](docs/IssueTypeScreenSchemesApi.md#get_projects_for_issue_type_screen_scheme) | **GET** /rest/api/2/issuetypescreenscheme/{issueTypeScreenSchemeId}/project | Get issue type screen scheme projects
*IssueTypeScreenSchemesApi* | [**remove_mappings_from_issue_type_screen_scheme**](docs/IssueTypeScreenSchemesApi.md#remove_mappings_from_issue_type_screen_scheme) | **POST** /rest/api/2/issuetypescreenscheme/{issueTypeScreenSchemeId}/mapping/remove | Remove mappings from issue type screen scheme
*IssueTypeScreenSchemesApi* | [**update_default_screen_scheme**](docs/IssueTypeScreenSchemesApi.md#update_default_screen_scheme) | **PUT** /rest/api/2/issuetypescreenscheme/{issueTypeScreenSchemeId}/mapping/default | Update issue type screen scheme default screen scheme
*IssueTypeScreenSchemesApi* | [**update_issue_type_screen_scheme**](docs/IssueTypeScreenSchemesApi.md#update_issue_type_screen_scheme) | **PUT** /rest/api/2/issuetypescreenscheme/{issueTypeScreenSchemeId} | Update issue type screen scheme
*IssueTypesApi* | [**create_issue_type**](docs/IssueTypesApi.md#create_issue_type) | **POST** /rest/api/2/issuetype | Create issue type
*IssueTypesApi* | [**create_issue_type_avatar**](docs/IssueTypesApi.md#create_issue_type_avatar) | **POST** /rest/api/2/issuetype/{id}/avatar2 | Load issue type avatar
*IssueTypesApi* | [**delete_issue_type**](docs/IssueTypesApi.md#delete_issue_type) | **DELETE** /rest/api/2/issuetype/{id} | Delete issue type
*IssueTypesApi* | [**get_alternative_issue_types**](docs/IssueTypesApi.md#get_alternative_issue_types) | **GET** /rest/api/2/issuetype/{id}/alternatives | Get alternative issue types
*IssueTypesApi* | [**get_issue_all_types**](docs/IssueTypesApi.md#get_issue_all_types) | **GET** /rest/api/2/issuetype | Get all issue types for user
*IssueTypesApi* | [**get_issue_type**](docs/IssueTypesApi.md#get_issue_type) | **GET** /rest/api/2/issuetype/{id} | Get issue type
*IssueTypesApi* | [**get_issue_types_for_project**](docs/IssueTypesApi.md#get_issue_types_for_project) | **GET** /rest/api/2/issuetype/project | Get issue types for project
*IssueTypesApi* | [**update_issue_type**](docs/IssueTypesApi.md#update_issue_type) | **PUT** /rest/api/2/issuetype/{id} | Update issue type
*IssueVotesApi* | [**add_vote**](docs/IssueVotesApi.md#add_vote) | **POST** /rest/api/2/issue/{issueIdOrKey}/votes | Add vote
*IssueVotesApi* | [**get_votes**](docs/IssueVotesApi.md#get_votes) | **GET** /rest/api/2/issue/{issueIdOrKey}/votes | Get votes
*IssueVotesApi* | [**remove_vote**](docs/IssueVotesApi.md#remove_vote) | **DELETE** /rest/api/2/issue/{issueIdOrKey}/votes | Delete vote
*IssueWatchersApi* | [**add_watcher**](docs/IssueWatchersApi.md#add_watcher) | **POST** /rest/api/2/issue/{issueIdOrKey}/watchers | Add watcher
*IssueWatchersApi* | [**get_is_watching_issue_bulk**](docs/IssueWatchersApi.md#get_is_watching_issue_bulk) | **POST** /rest/api/2/issue/watching | Get is watching issue bulk
*IssueWatchersApi* | [**get_issue_watchers**](docs/IssueWatchersApi.md#get_issue_watchers) | **GET** /rest/api/2/issue/{issueIdOrKey}/watchers | Get issue watchers
*IssueWatchersApi* | [**remove_watcher**](docs/IssueWatchersApi.md#remove_watcher) | **DELETE** /rest/api/2/issue/{issueIdOrKey}/watchers | Delete watcher
*IssueWorklogPropertiesApi* | [**delete_worklog_property**](docs/IssueWorklogPropertiesApi.md#delete_worklog_property) | **DELETE** /rest/api/2/issue/{issueIdOrKey}/worklog/{worklogId}/properties/{propertyKey} | Delete worklog property
*IssueWorklogPropertiesApi* | [**get_worklog_property**](docs/IssueWorklogPropertiesApi.md#get_worklog_property) | **GET** /rest/api/2/issue/{issueIdOrKey}/worklog/{worklogId}/properties/{propertyKey} | Get worklog property
*IssueWorklogPropertiesApi* | [**get_worklog_property_keys**](docs/IssueWorklogPropertiesApi.md#get_worklog_property_keys) | **GET** /rest/api/2/issue/{issueIdOrKey}/worklog/{worklogId}/properties | Get worklog property keys
*IssueWorklogPropertiesApi* | [**set_worklog_property**](docs/IssueWorklogPropertiesApi.md#set_worklog_property) | **PUT** /rest/api/2/issue/{issueIdOrKey}/worklog/{worklogId}/properties/{propertyKey} | Set worklog property
*IssueWorklogsApi* | [**add_worklog**](docs/IssueWorklogsApi.md#add_worklog) | **POST** /rest/api/2/issue/{issueIdOrKey}/worklog | Add worklog
*IssueWorklogsApi* | [**delete_worklog**](docs/IssueWorklogsApi.md#delete_worklog) | **DELETE** /rest/api/2/issue/{issueIdOrKey}/worklog/{id} | Delete worklog
*IssueWorklogsApi* | [**get_ids_of_worklogs_deleted_since**](docs/IssueWorklogsApi.md#get_ids_of_worklogs_deleted_since) | **GET** /rest/api/2/worklog/deleted | Get IDs of deleted worklogs
*IssueWorklogsApi* | [**get_ids_of_worklogs_modified_since**](docs/IssueWorklogsApi.md#get_ids_of_worklogs_modified_since) | **GET** /rest/api/2/worklog/updated | Get IDs of updated worklogs
*IssueWorklogsApi* | [**get_issue_worklog**](docs/IssueWorklogsApi.md#get_issue_worklog) | **GET** /rest/api/2/issue/{issueIdOrKey}/worklog | Get issue worklogs
*IssueWorklogsApi* | [**get_worklog**](docs/IssueWorklogsApi.md#get_worklog) | **GET** /rest/api/2/issue/{issueIdOrKey}/worklog/{id} | Get worklog
*IssueWorklogsApi* | [**get_worklogs_for_ids**](docs/IssueWorklogsApi.md#get_worklogs_for_ids) | **POST** /rest/api/2/worklog/list | Get worklogs
*IssueWorklogsApi* | [**update_worklog**](docs/IssueWorklogsApi.md#update_worklog) | **PUT** /rest/api/2/issue/{issueIdOrKey}/worklog/{id} | Update worklog
*IssuesApi* | [**assign_issue**](docs/IssuesApi.md#assign_issue) | **PUT** /rest/api/2/issue/{issueIdOrKey}/assignee | Assign issue
*IssuesApi* | [**create_issue**](docs/IssuesApi.md#create_issue) | **POST** /rest/api/2/issue | Create issue
*IssuesApi* | [**create_issues**](docs/IssuesApi.md#create_issues) | **POST** /rest/api/2/issue/bulk | Bulk create issue
*IssuesApi* | [**delete_issue**](docs/IssuesApi.md#delete_issue) | **DELETE** /rest/api/2/issue/{issueIdOrKey} | Delete issue
*IssuesApi* | [**do_transition**](docs/IssuesApi.md#do_transition) | **POST** /rest/api/2/issue/{issueIdOrKey}/transitions | Transition issue
*IssuesApi* | [**edit_issue**](docs/IssuesApi.md#edit_issue) | **PUT** /rest/api/2/issue/{issueIdOrKey} | Edit issue
*IssuesApi* | [**get_change_logs**](docs/IssuesApi.md#get_change_logs) | **GET** /rest/api/2/issue/{issueIdOrKey}/changelog | Get changelogs
*IssuesApi* | [**get_change_logs_by_ids**](docs/IssuesApi.md#get_change_logs_by_ids) | **POST** /rest/api/2/issue/{issueIdOrKey}/changelog/list | Get changelogs by IDs
*IssuesApi* | [**get_create_issue_meta**](docs/IssuesApi.md#get_create_issue_meta) | **GET** /rest/api/2/issue/createmeta | Get create issue metadata
*IssuesApi* | [**get_edit_issue_meta**](docs/IssuesApi.md#get_edit_issue_meta) | **GET** /rest/api/2/issue/{issueIdOrKey}/editmeta | Get edit issue metadata
*IssuesApi* | [**get_events**](docs/IssuesApi.md#get_events) | **GET** /rest/api/2/events | Get events
*IssuesApi* | [**get_issue**](docs/IssuesApi.md#get_issue) | **GET** /rest/api/2/issue/{issueIdOrKey} | Get issue
*IssuesApi* | [**get_transitions**](docs/IssuesApi.md#get_transitions) | **GET** /rest/api/2/issue/{issueIdOrKey}/transitions | Get transitions
*IssuesApi* | [**notify**](docs/IssuesApi.md#notify) | **POST** /rest/api/2/issue/{issueIdOrKey}/notify | Send notification for issue
*JQLApi* | [**get_auto_complete**](docs/JQLApi.md#get_auto_complete) | **GET** /rest/api/2/jql/autocompletedata | Get field reference data (GET)
*JQLApi* | [**get_auto_complete_post**](docs/JQLApi.md#get_auto_complete_post) | **POST** /rest/api/2/jql/autocompletedata | Get field reference data (POST)
*JQLApi* | [**get_field_auto_complete_for_query_string**](docs/JQLApi.md#get_field_auto_complete_for_query_string) | **GET** /rest/api/2/jql/autocompletedata/suggestions | Get field auto complete suggestions
*JQLApi* | [**migrate_queries**](docs/JQLApi.md#migrate_queries) | **POST** /rest/api/2/jql/pdcleaner | Convert user identifiers to account IDs in JQL queries
*JQLApi* | [**parse_jql_queries**](docs/JQLApi.md#parse_jql_queries) | **POST** /rest/api/2/jql/parse | Parse JQL query
*JQLApi* | [**sanitise_jql_queries**](docs/JQLApi.md#sanitise_jql_queries) | **POST** /rest/api/2/jql/sanitize | Sanitize JQL queries
*JiraExpressionsApi* | [**analyse_expression**](docs/JiraExpressionsApi.md#analyse_expression) | **POST** /rest/api/2/expression/analyse | Analyse Jira expression
*JiraExpressionsApi* | [**evaluate_jira_expression**](docs/JiraExpressionsApi.md#evaluate_jira_expression) | **POST** /rest/api/2/expression/eval | Evaluate Jira expression
*JiraSettingsApi* | [**get_advanced_settings**](docs/JiraSettingsApi.md#get_advanced_settings) | **GET** /rest/api/2/application-properties/advanced-settings | Get advanced settings
*JiraSettingsApi* | [**get_application_property**](docs/JiraSettingsApi.md#get_application_property) | **GET** /rest/api/2/application-properties | Get application property
*JiraSettingsApi* | [**get_configuration**](docs/JiraSettingsApi.md#get_configuration) | **GET** /rest/api/2/configuration | Get global settings
*JiraSettingsApi* | [**set_application_property**](docs/JiraSettingsApi.md#set_application_property) | **PUT** /rest/api/2/application-properties/{id} | Set application property
*LabelsApi* | [**get_all_labels**](docs/LabelsApi.md#get_all_labels) | **GET** /rest/api/2/label | Get all labels
*MyselfApi* | [**delete_locale**](docs/MyselfApi.md#delete_locale) | **DELETE** /rest/api/2/mypreferences/locale | Delete locale
*MyselfApi* | [**get_current_user**](docs/MyselfApi.md#get_current_user) | **GET** /rest/api/2/myself | Get current user
*MyselfApi* | [**get_locale**](docs/MyselfApi.md#get_locale) | **GET** /rest/api/2/mypreferences/locale | Get locale
*MyselfApi* | [**get_preference**](docs/MyselfApi.md#get_preference) | **GET** /rest/api/2/mypreferences | Get preference
*MyselfApi* | [**remove_preference**](docs/MyselfApi.md#remove_preference) | **DELETE** /rest/api/2/mypreferences | Delete preference
*MyselfApi* | [**set_locale**](docs/MyselfApi.md#set_locale) | **PUT** /rest/api/2/mypreferences/locale | Set locale
*MyselfApi* | [**set_preference**](docs/MyselfApi.md#set_preference) | **PUT** /rest/api/2/mypreferences | Set preference
*PermissionSchemesApi* | [**create_permission_grant**](docs/PermissionSchemesApi.md#create_permission_grant) | **POST** /rest/api/2/permissionscheme/{schemeId}/permission | Create permission grant
*PermissionSchemesApi* | [**create_permission_scheme**](docs/PermissionSchemesApi.md#create_permission_scheme) | **POST** /rest/api/2/permissionscheme | Create permission scheme
*PermissionSchemesApi* | [**delete_permission_scheme**](docs/PermissionSchemesApi.md#delete_permission_scheme) | **DELETE** /rest/api/2/permissionscheme/{schemeId} | Delete permission scheme
*PermissionSchemesApi* | [**delete_permission_scheme_entity**](docs/PermissionSchemesApi.md#delete_permission_scheme_entity) | **DELETE** /rest/api/2/permissionscheme/{schemeId}/permission/{permissionId} | Delete permission scheme grant
*PermissionSchemesApi* | [**get_all_permission_schemes**](docs/PermissionSchemesApi.md#get_all_permission_schemes) | **GET** /rest/api/2/permissionscheme | Get all permission schemes
*PermissionSchemesApi* | [**get_permission_scheme**](docs/PermissionSchemesApi.md#get_permission_scheme) | **GET** /rest/api/2/permissionscheme/{schemeId} | Get permission scheme
*PermissionSchemesApi* | [**get_permission_scheme_grant**](docs/PermissionSchemesApi.md#get_permission_scheme_grant) | **GET** /rest/api/2/permissionscheme/{schemeId}/permission/{permissionId} | Get permission scheme grant
*PermissionSchemesApi* | [**get_permission_scheme_grants**](docs/PermissionSchemesApi.md#get_permission_scheme_grants) | **GET** /rest/api/2/permissionscheme/{schemeId}/permission | Get permission scheme grants
*PermissionSchemesApi* | [**update_permission_scheme**](docs/PermissionSchemesApi.md#update_permission_scheme) | **PUT** /rest/api/2/permissionscheme/{schemeId} | Update permission scheme
*PermissionsApi* | [**get_all_permissions**](docs/PermissionsApi.md#get_all_permissions) | **GET** /rest/api/2/permissions | Get all permissions
*PermissionsApi* | [**get_bulk_permissions**](docs/PermissionsApi.md#get_bulk_permissions) | **POST** /rest/api/2/permissions/check | Get bulk permissions
*PermissionsApi* | [**get_my_permissions**](docs/PermissionsApi.md#get_my_permissions) | **GET** /rest/api/2/mypermissions | Get my permissions
*PermissionsApi* | [**get_permitted_projects**](docs/PermissionsApi.md#get_permitted_projects) | **POST** /rest/api/2/permissions/project | Get permitted projects
*ProjectAvatarsApi* | [**create_project_avatar**](docs/ProjectAvatarsApi.md#create_project_avatar) | **POST** /rest/api/2/project/{projectIdOrKey}/avatar2 | Load project avatar
*ProjectAvatarsApi* | [**delete_project_avatar**](docs/ProjectAvatarsApi.md#delete_project_avatar) | **DELETE** /rest/api/2/project/{projectIdOrKey}/avatar/{id} | Delete project avatar
*ProjectAvatarsApi* | [**get_all_project_avatars**](docs/ProjectAvatarsApi.md#get_all_project_avatars) | **GET** /rest/api/2/project/{projectIdOrKey}/avatars | Get all project avatars
*ProjectAvatarsApi* | [**update_project_avatar**](docs/ProjectAvatarsApi.md#update_project_avatar) | **PUT** /rest/api/2/project/{projectIdOrKey}/avatar | Set project avatar
*ProjectCategoriesApi* | [**create_project_category**](docs/ProjectCategoriesApi.md#create_project_category) | **POST** /rest/api/2/projectCategory | Create project category
*ProjectCategoriesApi* | [**get_all_project_categories**](docs/ProjectCategoriesApi.md#get_all_project_categories) | **GET** /rest/api/2/projectCategory | Get all project categories
*ProjectCategoriesApi* | [**get_project_category_by_id**](docs/ProjectCategoriesApi.md#get_project_category_by_id) | **GET** /rest/api/2/projectCategory/{id} | Get project category by ID
*ProjectCategoriesApi* | [**remove_project_category**](docs/ProjectCategoriesApi.md#remove_project_category) | **DELETE** /rest/api/2/projectCategory/{id} | Delete project category
*ProjectCategoriesApi* | [**update_project_category**](docs/ProjectCategoriesApi.md#update_project_category) | **PUT** /rest/api/2/projectCategory/{id} | Update project category
*ProjectComponentsApi* | [**create_component**](docs/ProjectComponentsApi.md#create_component) | **POST** /rest/api/2/component | Create component
*ProjectComponentsApi* | [**delete_component**](docs/ProjectComponentsApi.md#delete_component) | **DELETE** /rest/api/2/component/{id} | Delete component
*ProjectComponentsApi* | [**get_component**](docs/ProjectComponentsApi.md#get_component) | **GET** /rest/api/2/component/{id} | Get component
*ProjectComponentsApi* | [**get_component_related_issues**](docs/ProjectComponentsApi.md#get_component_related_issues) | **GET** /rest/api/2/component/{id}/relatedIssueCounts | Get component issues count
*ProjectComponentsApi* | [**get_project_components**](docs/ProjectComponentsApi.md#get_project_components) | **GET** /rest/api/2/project/{projectIdOrKey}/components | Get project components
*ProjectComponentsApi* | [**get_project_components_paginated**](docs/ProjectComponentsApi.md#get_project_components_paginated) | **GET** /rest/api/2/project/{projectIdOrKey}/component | Get project components paginated
*ProjectComponentsApi* | [**update_component**](docs/ProjectComponentsApi.md#update_component) | **PUT** /rest/api/2/component/{id} | Update component
*ProjectEmailApi* | [**get_project_email**](docs/ProjectEmailApi.md#get_project_email) | **GET** /rest/api/2/project/{projectId}/email | Get project's sender email
*ProjectEmailApi* | [**update_project_email**](docs/ProjectEmailApi.md#update_project_email) | **PUT** /rest/api/2/project/{projectId}/email | Set project's sender email
*ProjectFeaturesApi* | [**get_features_for_project**](docs/ProjectFeaturesApi.md#get_features_for_project) | **GET** /rest/api/2/project/{projectIdOrKey}/features | Get project features
*ProjectFeaturesApi* | [**toggle_feature_for_project**](docs/ProjectFeaturesApi.md#toggle_feature_for_project) | **PUT** /rest/api/2/project/{projectIdOrKey}/features/{featureKey} | Set project feature state
*ProjectKeyAndNameValidationApi* | [**get_valid_project_key**](docs/ProjectKeyAndNameValidationApi.md#get_valid_project_key) | **GET** /rest/api/2/projectvalidate/validProjectKey | Get valid project key
*ProjectKeyAndNameValidationApi* | [**get_valid_project_name**](docs/ProjectKeyAndNameValidationApi.md#get_valid_project_name) | **GET** /rest/api/2/projectvalidate/validProjectName | Get valid project name
*ProjectKeyAndNameValidationApi* | [**validate_project_key**](docs/ProjectKeyAndNameValidationApi.md#validate_project_key) | **GET** /rest/api/2/projectvalidate/key | Validate project key
*ProjectPermissionSchemesApi* | [**assign_permission_scheme**](docs/ProjectPermissionSchemesApi.md#assign_permission_scheme) | **PUT** /rest/api/2/project/{projectKeyOrId}/permissionscheme | Assign permission scheme
*ProjectPermissionSchemesApi* | [**get_assigned_permission_scheme**](docs/ProjectPermissionSchemesApi.md#get_assigned_permission_scheme) | **GET** /rest/api/2/project/{projectKeyOrId}/permissionscheme | Get assigned permission scheme
*ProjectPermissionSchemesApi* | [**get_project_issue_security_scheme**](docs/ProjectPermissionSchemesApi.md#get_project_issue_security_scheme) | **GET** /rest/api/2/project/{projectKeyOrId}/issuesecuritylevelscheme | Get project issue security scheme
*ProjectPermissionSchemesApi* | [**get_security_levels_for_project**](docs/ProjectPermissionSchemesApi.md#get_security_levels_for_project) | **GET** /rest/api/2/project/{projectKeyOrId}/securitylevel | Get project issue security levels
*ProjectPropertiesApi* | [**delete_project_property**](docs/ProjectPropertiesApi.md#delete_project_property) | **DELETE** /rest/api/2/project/{projectIdOrKey}/properties/{propertyKey} | Delete project property
*ProjectPropertiesApi* | [**get_project_property**](docs/ProjectPropertiesApi.md#get_project_property) | **GET** /rest/api/2/project/{projectIdOrKey}/properties/{propertyKey} | Get project property
*ProjectPropertiesApi* | [**get_project_property_keys**](docs/ProjectPropertiesApi.md#get_project_property_keys) | **GET** /rest/api/2/project/{projectIdOrKey}/properties | Get project property keys
*ProjectPropertiesApi* | [**set_project_property**](docs/ProjectPropertiesApi.md#set_project_property) | **PUT** /rest/api/2/project/{projectIdOrKey}/properties/{propertyKey} | Set project property
*ProjectRoleActorsApi* | [**add_actor_users**](docs/ProjectRoleActorsApi.md#add_actor_users) | **POST** /rest/api/2/project/{projectIdOrKey}/role/{id} | Add actors to project role
*ProjectRoleActorsApi* | [**add_project_role_actors_to_role**](docs/ProjectRoleActorsApi.md#add_project_role_actors_to_role) | **POST** /rest/api/2/role/{id}/actors | Add default actors to project role
*ProjectRoleActorsApi* | [**delete_actor**](docs/ProjectRoleActorsApi.md#delete_actor) | **DELETE** /rest/api/2/project/{projectIdOrKey}/role/{id} | Delete actors from project role
*ProjectRoleActorsApi* | [**delete_project_role_actors_from_role**](docs/ProjectRoleActorsApi.md#delete_project_role_actors_from_role) | **DELETE** /rest/api/2/role/{id}/actors | Delete default actors from project role
*ProjectRoleActorsApi* | [**get_project_role_actors_for_role**](docs/ProjectRoleActorsApi.md#get_project_role_actors_for_role) | **GET** /rest/api/2/role/{id}/actors | Get default actors for project role
*ProjectRoleActorsApi* | [**set_actors**](docs/ProjectRoleActorsApi.md#set_actors) | **PUT** /rest/api/2/project/{projectIdOrKey}/role/{id} | Set actors for project role
*ProjectRolesApi* | [**create_project_role**](docs/ProjectRolesApi.md#create_project_role) | **POST** /rest/api/2/role | Create project role
*ProjectRolesApi* | [**delete_project_role**](docs/ProjectRolesApi.md#delete_project_role) | **DELETE** /rest/api/2/role/{id} | Delete project role
*ProjectRolesApi* | [**fully_update_project_role**](docs/ProjectRolesApi.md#fully_update_project_role) | **PUT** /rest/api/2/role/{id} | Fully update project role
*ProjectRolesApi* | [**get_all_project_roles**](docs/ProjectRolesApi.md#get_all_project_roles) | **GET** /rest/api/2/role | Get all project roles
*ProjectRolesApi* | [**get_project_role**](docs/ProjectRolesApi.md#get_project_role) | **GET** /rest/api/2/project/{projectIdOrKey}/role/{id} | Get project role for project
*ProjectRolesApi* | [**get_project_role_by_id**](docs/ProjectRolesApi.md#get_project_role_by_id) | **GET** /rest/api/2/role/{id} | Get project role by ID
*ProjectRolesApi* | [**get_project_role_details**](docs/ProjectRolesApi.md#get_project_role_details) | **GET** /rest/api/2/project/{projectIdOrKey}/roledetails | Get project role details
*ProjectRolesApi* | [**get_project_roles**](docs/ProjectRolesApi.md#get_project_roles) | **GET** /rest/api/2/project/{projectIdOrKey}/role | Get project roles for project
*ProjectRolesApi* | [**partial_update_project_role**](docs/ProjectRolesApi.md#partial_update_project_role) | **POST** /rest/api/2/role/{id} | Partial update project role
*ProjectTypesApi* | [**get_accessible_project_type_by_key**](docs/ProjectTypesApi.md#get_accessible_project_type_by_key) | **GET** /rest/api/2/project/type/{projectTypeKey}/accessible | Get accessible project type by key
*ProjectTypesApi* | [**get_all_accessible_project_types**](docs/ProjectTypesApi.md#get_all_accessible_project_types) | **GET** /rest/api/2/project/type/accessible | Get licensed project types
*ProjectTypesApi* | [**get_all_project_types**](docs/ProjectTypesApi.md#get_all_project_types) | **GET** /rest/api/2/project/type | Get all project types
*ProjectTypesApi* | [**get_project_type_by_key**](docs/ProjectTypesApi.md#get_project_type_by_key) | **GET** /rest/api/2/project/type/{projectTypeKey} | Get project type by key
*ProjectVersionsApi* | [**create_version**](docs/ProjectVersionsApi.md#create_version) | **POST** /rest/api/2/version | Create version
*ProjectVersionsApi* | [**delete_and_replace_version**](docs/ProjectVersionsApi.md#delete_and_replace_version) | **POST** /rest/api/2/version/{id}/removeAndSwap | Delete and replace version
*ProjectVersionsApi* | [**delete_version**](docs/ProjectVersionsApi.md#delete_version) | **DELETE** /rest/api/2/version/{id} | Delete version
*ProjectVersionsApi* | [**get_project_versions**](docs/ProjectVersionsApi.md#get_project_versions) | **GET** /rest/api/2/project/{projectIdOrKey}/versions | Get project versions
*ProjectVersionsApi* | [**get_project_versions_paginated**](docs/ProjectVersionsApi.md#get_project_versions_paginated) | **GET** /rest/api/2/project/{projectIdOrKey}/version | Get project versions paginated
*ProjectVersionsApi* | [**get_version**](docs/ProjectVersionsApi.md#get_version) | **GET** /rest/api/2/version/{id} | Get version
*ProjectVersionsApi* | [**get_version_related_issues**](docs/ProjectVersionsApi.md#get_version_related_issues) | **GET** /rest/api/2/version/{id}/relatedIssueCounts | Get version's related issues count
*ProjectVersionsApi* | [**get_version_unresolved_issues**](docs/ProjectVersionsApi.md#get_version_unresolved_issues) | **GET** /rest/api/2/version/{id}/unresolvedIssueCount | Get version's unresolved issues count
*ProjectVersionsApi* | [**merge_versions**](docs/ProjectVersionsApi.md#merge_versions) | **PUT** /rest/api/2/version/{id}/mergeto/{moveIssuesTo} | Merge versions
*ProjectVersionsApi* | [**move_version**](docs/ProjectVersionsApi.md#move_version) | **POST** /rest/api/2/version/{id}/move | Move version
*ProjectVersionsApi* | [**update_version**](docs/ProjectVersionsApi.md#update_version) | **PUT** /rest/api/2/version/{id} | Update version
*ProjectsApi* | [**archive_project**](docs/ProjectsApi.md#archive_project) | **POST** /rest/api/2/project/{projectIdOrKey}/archive | Archive project
*ProjectsApi* | [**create_project**](docs/ProjectsApi.md#create_project) | **POST** /rest/api/2/project | Create project
*ProjectsApi* | [**delete_project**](docs/ProjectsApi.md#delete_project) | **DELETE** /rest/api/2/project/{projectIdOrKey} | Delete project
*ProjectsApi* | [**delete_project_asynchronously**](docs/ProjectsApi.md#delete_project_asynchronously) | **POST** /rest/api/2/project/{projectIdOrKey}/delete | Delete project asynchronously
*ProjectsApi* | [**get_all_projects**](docs/ProjectsApi.md#get_all_projects) | **GET** /rest/api/2/project | Get all projects
*ProjectsApi* | [**get_all_statuses**](docs/ProjectsApi.md#get_all_statuses) | **GET** /rest/api/2/project/{projectIdOrKey}/statuses | Get all statuses for project
*ProjectsApi* | [**get_hierarchy**](docs/ProjectsApi.md#get_hierarchy) | **GET** /rest/api/2/project/{projectId}/hierarchy | Get project issue type hierarchy
*ProjectsApi* | [**get_notification_scheme_for_project**](docs/ProjectsApi.md#get_notification_scheme_for_project) | **GET** /rest/api/2/project/{projectKeyOrId}/notificationscheme | Get project notification scheme
*ProjectsApi* | [**get_project**](docs/ProjectsApi.md#get_project) | **GET** /rest/api/2/project/{projectIdOrKey} | Get project
*ProjectsApi* | [**get_recent**](docs/ProjectsApi.md#get_recent) | **GET** /rest/api/2/project/recent | Get recent projects
*ProjectsApi* | [**restore**](docs/ProjectsApi.md#restore) | **POST** /rest/api/2/project/{projectIdOrKey}/restore | Restore deleted project
*ProjectsApi* | [**search_projects**](docs/ProjectsApi.md#search_projects) | **GET** /rest/api/2/project/search | Get projects paginated
*ProjectsApi* | [**update_project**](docs/ProjectsApi.md#update_project) | **PUT** /rest/api/2/project/{projectIdOrKey} | Update project
*ProjectsApi* | [**update_project_type**](docs/ProjectsApi.md#update_project_type) | **PUT** /rest/api/2/project/{projectIdOrKey}/type/{newProjectTypeKey} | Update project type
*ScreenSchemesApi* | [**create_screen_scheme**](docs/ScreenSchemesApi.md#create_screen_scheme) | **POST** /rest/api/2/screenscheme | Create screen scheme
*ScreenSchemesApi* | [**delete_screen_scheme**](docs/ScreenSchemesApi.md#delete_screen_scheme) | **DELETE** /rest/api/2/screenscheme/{screenSchemeId} | Delete screen scheme
*ScreenSchemesApi* | [**get_screen_schemes**](docs/ScreenSchemesApi.md#get_screen_schemes) | **GET** /rest/api/2/screenscheme | Get screen schemes
*ScreenSchemesApi* | [**update_screen_scheme**](docs/ScreenSchemesApi.md#update_screen_scheme) | **PUT** /rest/api/2/screenscheme/{screenSchemeId} | Update screen scheme
*ScreenTabFieldsApi* | [**add_screen_tab_field**](docs/ScreenTabFieldsApi.md#add_screen_tab_field) | **POST** /rest/api/2/screens/{screenId}/tabs/{tabId}/fields | Add screen tab field
*ScreenTabFieldsApi* | [**get_all_screen_tab_fields**](docs/ScreenTabFieldsApi.md#get_all_screen_tab_fields) | **GET** /rest/api/2/screens/{screenId}/tabs/{tabId}/fields | Get all screen tab fields
*ScreenTabFieldsApi* | [**move_screen_tab_field**](docs/ScreenTabFieldsApi.md#move_screen_tab_field) | **POST** /rest/api/2/screens/{screenId}/tabs/{tabId}/fields/{id}/move | Move screen tab field
*ScreenTabFieldsApi* | [**remove_screen_tab_field**](docs/ScreenTabFieldsApi.md#remove_screen_tab_field) | **DELETE** /rest/api/2/screens/{screenId}/tabs/{tabId}/fields/{id} | Remove screen tab field
*ScreenTabsApi* | [**add_screen_tab**](docs/ScreenTabsApi.md#add_screen_tab) | **POST** /rest/api/2/screens/{screenId}/tabs | Create screen tab
*ScreenTabsApi* | [**delete_screen_tab**](docs/ScreenTabsApi.md#delete_screen_tab) | **DELETE** /rest/api/2/screens/{screenId}/tabs/{tabId} | Delete screen tab
*ScreenTabsApi* | [**get_all_screen_tabs**](docs/ScreenTabsApi.md#get_all_screen_tabs) | **GET** /rest/api/2/screens/{screenId}/tabs | Get all screen tabs
*ScreenTabsApi* | [**move_screen_tab**](docs/ScreenTabsApi.md#move_screen_tab) | **POST** /rest/api/2/screens/{screenId}/tabs/{tabId}/move/{pos} | Move screen tab
*ScreenTabsApi* | [**rename_screen_tab**](docs/ScreenTabsApi.md#rename_screen_tab) | **PUT** /rest/api/2/screens/{screenId}/tabs/{tabId} | Update screen tab
*ScreensApi* | [**add_field_to_default_screen**](docs/ScreensApi.md#add_field_to_default_screen) | **POST** /rest/api/2/screens/addToDefault/{fieldId} | Add field to default screen
*ScreensApi* | [**create_screen**](docs/ScreensApi.md#create_screen) | **POST** /rest/api/2/screens | Create screen
*ScreensApi* | [**delete_screen**](docs/ScreensApi.md#delete_screen) | **DELETE** /rest/api/2/screens/{screenId} | Delete screen
*ScreensApi* | [**get_available_screen_fields**](docs/ScreensApi.md#get_available_screen_fields) | **GET** /rest/api/2/screens/{screenId}/availableFields | Get available screen fields
*ScreensApi* | [**get_screens**](docs/ScreensApi.md#get_screens) | **GET** /rest/api/2/screens | Get screens
*ScreensApi* | [**get_screens_for_field**](docs/ScreensApi.md#get_screens_for_field) | **GET** /rest/api/2/field/{fieldId}/screens | Get screens for a field
*ScreensApi* | [**update_screen**](docs/ScreensApi.md#update_screen) | **PUT** /rest/api/2/screens/{screenId} | Update screen
*ServerInfoApi* | [**get_server_info**](docs/ServerInfoApi.md#get_server_info) | **GET** /rest/api/2/serverInfo | Get Jira instance info
*TasksApi* | [**cancel_task**](docs/TasksApi.md#cancel_task) | **POST** /rest/api/2/task/{taskId}/cancel | Cancel task
*TasksApi* | [**get_task**](docs/TasksApi.md#get_task) | **GET** /rest/api/2/task/{taskId} | Get task
*TimeTrackingApi* | [**get_available_time_tracking_implementations**](docs/TimeTrackingApi.md#get_available_time_tracking_implementations) | **GET** /rest/api/2/configuration/timetracking/list | Get all time tracking providers
*TimeTrackingApi* | [**get_selected_time_tracking_implementation**](docs/TimeTrackingApi.md#get_selected_time_tracking_implementation) | **GET** /rest/api/2/configuration/timetracking | Get selected time tracking provider
*TimeTrackingApi* | [**get_shared_time_tracking_configuration**](docs/TimeTrackingApi.md#get_shared_time_tracking_configuration) | **GET** /rest/api/2/configuration/timetracking/options | Get time tracking settings
*TimeTrackingApi* | [**select_time_tracking_implementation**](docs/TimeTrackingApi.md#select_time_tracking_implementation) | **PUT** /rest/api/2/configuration/timetracking | Select time tracking provider
*TimeTrackingApi* | [**set_shared_time_tracking_configuration**](docs/TimeTrackingApi.md#set_shared_time_tracking_configuration) | **PUT** /rest/api/2/configuration/timetracking/options | Set time tracking settings
*UserPropertiesApi* | [**delete_user_property**](docs/UserPropertiesApi.md#delete_user_property) | **DELETE** /rest/api/2/user/properties/{propertyKey} | Delete user property
*UserPropertiesApi* | [**get_user_property**](docs/UserPropertiesApi.md#get_user_property) | **GET** /rest/api/2/user/properties/{propertyKey} | Get user property
*UserPropertiesApi* | [**get_user_property_keys**](docs/UserPropertiesApi.md#get_user_property_keys) | **GET** /rest/api/2/user/properties | Get user property keys
*UserPropertiesApi* | [**set_user_property**](docs/UserPropertiesApi.md#set_user_property) | **PUT** /rest/api/2/user/properties/{propertyKey} | Set user property
*UserSearchApi* | [**find_assignable_users**](docs/UserSearchApi.md#find_assignable_users) | **GET** /rest/api/2/user/assignable/search | Find users assignable to issues
*UserSearchApi* | [**find_bulk_assignable_users**](docs/UserSearchApi.md#find_bulk_assignable_users) | **GET** /rest/api/2/user/assignable/multiProjectSearch | Find users assignable to projects
*UserSearchApi* | [**find_user_keys_by_query**](docs/UserSearchApi.md#find_user_keys_by_query) | **GET** /rest/api/2/user/search/query/key | Find user keys by query
*UserSearchApi* | [**find_users**](docs/UserSearchApi.md#find_users) | **GET** /rest/api/2/user/search | Find users
*UserSearchApi* | [**find_users_by_query**](docs/UserSearchApi.md#find_users_by_query) | **GET** /rest/api/2/user/search/query | Find users by query
*UserSearchApi* | [**find_users_for_picker**](docs/UserSearchApi.md#find_users_for_picker) | **GET** /rest/api/2/user/picker | Find users for picker
*UserSearchApi* | [**find_users_with_all_permissions**](docs/UserSearchApi.md#find_users_with_all_permissions) | **GET** /rest/api/2/user/permission/search | Find users with permissions
*UserSearchApi* | [**find_users_with_browse_permission**](docs/UserSearchApi.md#find_users_with_browse_permission) | **GET** /rest/api/2/user/viewissue/search | Find users with browse permission
*UsersApi* | [**bulk_get_users**](docs/UsersApi.md#bulk_get_users) | **GET** /rest/api/2/user/bulk | Bulk get users
*UsersApi* | [**bulk_get_users_migration**](docs/UsersApi.md#bulk_get_users_migration) | **GET** /rest/api/2/user/bulk/migration | Get account IDs for users
*UsersApi* | [**create_user**](docs/UsersApi.md#create_user) | **POST** /rest/api/2/user | Create user
*UsersApi* | [**get_all_users**](docs/UsersApi.md#get_all_users) | **GET** /rest/api/2/users/search | Get all users
*UsersApi* | [**get_all_users_default**](docs/UsersApi.md#get_all_users_default) | **GET** /rest/api/2/users | Get all users default
*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /rest/api/2/user | Get user
*UsersApi* | [**get_user_default_columns**](docs/UsersApi.md#get_user_default_columns) | **GET** /rest/api/2/user/columns | Get user default columns
*UsersApi* | [**get_user_email**](docs/UsersApi.md#get_user_email) | **GET** /rest/api/2/user/email | Get user email
*UsersApi* | [**get_user_email_bulk**](docs/UsersApi.md#get_user_email_bulk) | **GET** /rest/api/2/user/email/bulk | Get user email bulk
*UsersApi* | [**get_user_groups**](docs/UsersApi.md#get_user_groups) | **GET** /rest/api/2/user/groups | Get user groups
*UsersApi* | [**remove_user**](docs/UsersApi.md#remove_user) | **DELETE** /rest/api/2/user | Delete user
*UsersApi* | [**reset_user_columns**](docs/UsersApi.md#reset_user_columns) | **DELETE** /rest/api/2/user/columns | Reset user default columns
*UsersApi* | [**set_user_columns**](docs/UsersApi.md#set_user_columns) | **PUT** /rest/api/2/user/columns | Set user default columns
*WebhooksApi* | [**delete_webhook_by_id**](docs/WebhooksApi.md#delete_webhook_by_id) | **DELETE** /rest/api/2/webhook | Delete webhooks by ID
*WebhooksApi* | [**get_dynamic_webhooks_for_app**](docs/WebhooksApi.md#get_dynamic_webhooks_for_app) | **GET** /rest/api/2/webhook | Get dynamic webhooks for app
*WebhooksApi* | [**get_failed_webhooks**](docs/WebhooksApi.md#get_failed_webhooks) | **GET** /rest/api/2/webhook/failed | Get failed webhooks
*WebhooksApi* | [**refresh_webhooks**](docs/WebhooksApi.md#refresh_webhooks) | **PUT** /rest/api/2/webhook/refresh | Extend webhook life
*WebhooksApi* | [**register_dynamic_webhooks**](docs/WebhooksApi.md#register_dynamic_webhooks) | **POST** /rest/api/2/webhook | Register dynamic webhooks
*WorkflowSchemeDraftsApi* | [**create_workflow_scheme_draft_from_parent**](docs/WorkflowSchemeDraftsApi.md#create_workflow_scheme_draft_from_parent) | **POST** /rest/api/2/workflowscheme/{id}/createdraft | Create draft workflow scheme
*WorkflowSchemeDraftsApi* | [**delete_draft_default_workflow**](docs/WorkflowSchemeDraftsApi.md#delete_draft_default_workflow) | **DELETE** /rest/api/2/workflowscheme/{id}/draft/default | Delete draft default workflow
*WorkflowSchemeDraftsApi* | [**delete_draft_workflow_mapping**](docs/WorkflowSchemeDraftsApi.md#delete_draft_workflow_mapping) | **DELETE** /rest/api/2/workflowscheme/{id}/draft/workflow | Delete issue types for workflow in draft workflow scheme
*WorkflowSchemeDraftsApi* | [**delete_workflow_scheme_draft**](docs/WorkflowSchemeDraftsApi.md#delete_workflow_scheme_draft) | **DELETE** /rest/api/2/workflowscheme/{id}/draft | Delete draft workflow scheme
*WorkflowSchemeDraftsApi* | [**delete_workflow_scheme_draft_issue_type**](docs/WorkflowSchemeDraftsApi.md#delete_workflow_scheme_draft_issue_type) | **DELETE** /rest/api/2/workflowscheme/{id}/draft/issuetype/{issueType} | Delete workflow for issue type in draft workflow scheme
*WorkflowSchemeDraftsApi* | [**get_draft_default_workflow**](docs/WorkflowSchemeDraftsApi.md#get_draft_default_workflow) | **GET** /rest/api/2/workflowscheme/{id}/draft/default | Get draft default workflow
*WorkflowSchemeDraftsApi* | [**get_draft_workflow**](docs/WorkflowSchemeDraftsApi.md#get_draft_workflow) | **GET** /rest/api/2/workflowscheme/{id}/draft/workflow | Get issue types for workflows in draft workflow scheme
*WorkflowSchemeDraftsApi* | [**get_workflow_scheme_draft**](docs/WorkflowSchemeDraftsApi.md#get_workflow_scheme_draft) | **GET** /rest/api/2/workflowscheme/{id}/draft | Get draft workflow scheme
*WorkflowSchemeDraftsApi* | [**get_workflow_scheme_draft_issue_type**](docs/WorkflowSchemeDraftsApi.md#get_workflow_scheme_draft_issue_type) | **GET** /rest/api/2/workflowscheme/{id}/draft/issuetype/{issueType} | Get workflow for issue type in draft workflow scheme
*WorkflowSchemeDraftsApi* | [**publish_draft_workflow_scheme**](docs/WorkflowSchemeDraftsApi.md#publish_draft_workflow_scheme) | **POST** /rest/api/2/workflowscheme/{id}/draft/publish | Publish draft workflow scheme
*WorkflowSchemeDraftsApi* | [**set_workflow_scheme_draft_issue_type**](docs/WorkflowSchemeDraftsApi.md#set_workflow_scheme_draft_issue_type) | **PUT** /rest/api/2/workflowscheme/{id}/draft/issuetype/{issueType} | Set workflow for issue type in draft workflow scheme
*WorkflowSchemeDraftsApi* | [**update_draft_default_workflow**](docs/WorkflowSchemeDraftsApi.md#update_draft_default_workflow) | **PUT** /rest/api/2/workflowscheme/{id}/draft/default | Update draft default workflow
*WorkflowSchemeDraftsApi* | [**update_draft_workflow_mapping**](docs/WorkflowSchemeDraftsApi.md#update_draft_workflow_mapping) | **PUT** /rest/api/2/workflowscheme/{id}/draft/workflow | Set issue types for workflow in workflow scheme
*WorkflowSchemeDraftsApi* | [**update_workflow_scheme_draft**](docs/WorkflowSchemeDraftsApi.md#update_workflow_scheme_draft) | **PUT** /rest/api/2/workflowscheme/{id}/draft | Update draft workflow scheme
*WorkflowSchemeProjectAssociationsApi* | [**assign_scheme_to_project**](docs/WorkflowSchemeProjectAssociationsApi.md#assign_scheme_to_project) | **PUT** /rest/api/2/workflowscheme/project | Assign workflow scheme to project
*WorkflowSchemeProjectAssociationsApi* | [**get_workflow_scheme_project_associations**](docs/WorkflowSchemeProjectAssociationsApi.md#get_workflow_scheme_project_associations) | **GET** /rest/api/2/workflowscheme/project | Get workflow scheme project associations
*WorkflowSchemesApi* | [**create_workflow_scheme**](docs/WorkflowSchemesApi.md#create_workflow_scheme) | **POST** /rest/api/2/workflowscheme | Create workflow scheme
*WorkflowSchemesApi* | [**delete_default_workflow**](docs/WorkflowSchemesApi.md#delete_default_workflow) | **DELETE** /rest/api/2/workflowscheme/{id}/default | Delete default workflow
*WorkflowSchemesApi* | [**delete_workflow_mapping**](docs/WorkflowSchemesApi.md#delete_workflow_mapping) | **DELETE** /rest/api/2/workflowscheme/{id}/workflow | Delete issue types for workflow in workflow scheme
*WorkflowSchemesApi* | [**delete_workflow_scheme**](docs/WorkflowSchemesApi.md#delete_workflow_scheme) | **DELETE** /rest/api/2/workflowscheme/{id} | Delete workflow scheme
*WorkflowSchemesApi* | [**delete_workflow_scheme_issue_type**](docs/WorkflowSchemesApi.md#delete_workflow_scheme_issue_type) | **DELETE** /rest/api/2/workflowscheme/{id}/issuetype/{issueType} | Delete workflow for issue type in workflow scheme
*WorkflowSchemesApi* | [**get_all_workflow_schemes**](docs/WorkflowSchemesApi.md#get_all_workflow_schemes) | **GET** /rest/api/2/workflowscheme | Get all workflow schemes
*WorkflowSchemesApi* | [**get_default_workflow**](docs/WorkflowSchemesApi.md#get_default_workflow) | **GET** /rest/api/2/workflowscheme/{id}/default | Get default workflow
*WorkflowSchemesApi* | [**get_workflow**](docs/WorkflowSchemesApi.md#get_workflow) | **GET** /rest/api/2/workflowscheme/{id}/workflow | Get issue types for workflows in workflow scheme
*WorkflowSchemesApi* | [**get_workflow_scheme**](docs/WorkflowSchemesApi.md#get_workflow_scheme) | **GET** /rest/api/2/workflowscheme/{id} | Get workflow scheme
*WorkflowSchemesApi* | [**get_workflow_scheme_issue_type**](docs/WorkflowSchemesApi.md#get_workflow_scheme_issue_type) | **GET** /rest/api/2/workflowscheme/{id}/issuetype/{issueType} | Get workflow for issue type in workflow scheme
*WorkflowSchemesApi* | [**set_workflow_scheme_issue_type**](docs/WorkflowSchemesApi.md#set_workflow_scheme_issue_type) | **PUT** /rest/api/2/workflowscheme/{id}/issuetype/{issueType} | Set workflow for issue type in workflow scheme
*WorkflowSchemesApi* | [**update_default_workflow**](docs/WorkflowSchemesApi.md#update_default_workflow) | **PUT** /rest/api/2/workflowscheme/{id}/default | Update default workflow
*WorkflowSchemesApi* | [**update_workflow_mapping**](docs/WorkflowSchemesApi.md#update_workflow_mapping) | **PUT** /rest/api/2/workflowscheme/{id}/workflow | Set issue types for workflow in workflow scheme
*WorkflowSchemesApi* | [**update_workflow_scheme**](docs/WorkflowSchemesApi.md#update_workflow_scheme) | **PUT** /rest/api/2/workflowscheme/{id} | Update workflow scheme
*WorkflowStatusCategoriesApi* | [**get_status_categories**](docs/WorkflowStatusCategoriesApi.md#get_status_categories) | **GET** /rest/api/2/statuscategory | Get all status categories
*WorkflowStatusCategoriesApi* | [**get_status_category**](docs/WorkflowStatusCategoriesApi.md#get_status_category) | **GET** /rest/api/2/statuscategory/{idOrKey} | Get status category
*WorkflowStatusesApi* | [**get_status**](docs/WorkflowStatusesApi.md#get_status) | **GET** /rest/api/2/status/{idOrName} | Get status
*WorkflowStatusesApi* | [**get_statuses**](docs/WorkflowStatusesApi.md#get_statuses) | **GET** /rest/api/2/status | Get all statuses
*WorkflowTransitionPropertiesApi* | [**create_workflow_transition_property**](docs/WorkflowTransitionPropertiesApi.md#create_workflow_transition_property) | **POST** /rest/api/2/workflow/transitions/{transitionId}/properties | Create workflow transition property
*WorkflowTransitionPropertiesApi* | [**delete_workflow_transition_property**](docs/WorkflowTransitionPropertiesApi.md#delete_workflow_transition_property) | **DELETE** /rest/api/2/workflow/transitions/{transitionId}/properties | Delete workflow transition property
*WorkflowTransitionPropertiesApi* | [**get_workflow_transition_properties**](docs/WorkflowTransitionPropertiesApi.md#get_workflow_transition_properties) | **GET** /rest/api/2/workflow/transitions/{transitionId}/properties | Get workflow transition properties
*WorkflowTransitionPropertiesApi* | [**update_workflow_transition_property**](docs/WorkflowTransitionPropertiesApi.md#update_workflow_transition_property) | **PUT** /rest/api/2/workflow/transitions/{transitionId}/properties | Update workflow transition property
*WorkflowTransitionRulesApi* | [**delete_workflow_transition_rule_configurations**](docs/WorkflowTransitionRulesApi.md#delete_workflow_transition_rule_configurations) | **PUT** /rest/api/2/workflow/rule/config/delete | Delete workflow transition rule configurations
*WorkflowTransitionRulesApi* | [**get_workflow_transition_rule_configurations**](docs/WorkflowTransitionRulesApi.md#get_workflow_transition_rule_configurations) | **GET** /rest/api/2/workflow/rule/config | Get workflow transition rule configurations
*WorkflowTransitionRulesApi* | [**update_workflow_transition_rule_configurations**](docs/WorkflowTransitionRulesApi.md#update_workflow_transition_rule_configurations) | **PUT** /rest/api/2/workflow/rule/config | Update workflow transition rule configurations
*WorkflowsApi* | [**create_workflow**](docs/WorkflowsApi.md#create_workflow) | **POST** /rest/api/2/workflow | Create workflow
*WorkflowsApi* | [**delete_inactive_workflow**](docs/WorkflowsApi.md#delete_inactive_workflow) | **DELETE** /rest/api/2/workflow/{entityId} | Delete inactive workflow
*WorkflowsApi* | [**get_all_workflows**](docs/WorkflowsApi.md#get_all_workflows) | **GET** /rest/api/2/workflow | Get all workflows
*WorkflowsApi* | [**get_workflows_paginated**](docs/WorkflowsApi.md#get_workflows_paginated) | **GET** /rest/api/2/workflow/search | Get workflows paginated


## Documentation For Models

 - [ActorInputBean](docs/ActorInputBean.md)
 - [ActorsMap](docs/ActorsMap.md)
 - [AddFieldBean](docs/AddFieldBean.md)
 - [AddGroupBean](docs/AddGroupBean.md)
 - [Application](docs/Application.md)
 - [ApplicationProperty](docs/ApplicationProperty.md)
 - [ApplicationRole](docs/ApplicationRole.md)
 - [AssociateFieldConfigurationsWithIssueTypesRequest](docs/AssociateFieldConfigurationsWithIssueTypesRequest.md)
 - [AssociatedItemBean](docs/AssociatedItemBean.md)
 - [Attachment](docs/Attachment.md)
 - [AttachmentArchive](docs/AttachmentArchive.md)
 - [AttachmentArchiveEntry](docs/AttachmentArchiveEntry.md)
 - [AttachmentArchiveImpl](docs/AttachmentArchiveImpl.md)
 - [AttachmentArchiveItemReadable](docs/AttachmentArchiveItemReadable.md)
 - [AttachmentArchiveMetadataReadable](docs/AttachmentArchiveMetadataReadable.md)
 - [AttachmentMetadata](docs/AttachmentMetadata.md)
 - [AttachmentSettings](docs/AttachmentSettings.md)
 - [AuditRecordBean](docs/AuditRecordBean.md)
 - [AuditRecords](docs/AuditRecords.md)
 - [AutoCompleteSuggestion](docs/AutoCompleteSuggestion.md)
 - [AutoCompleteSuggestions](docs/AutoCompleteSuggestions.md)
 - [AvailableDashboardGadget](docs/AvailableDashboardGadget.md)
 - [AvailableDashboardGadgetsResponse](docs/AvailableDashboardGadgetsResponse.md)
 - [Avatar](docs/Avatar.md)
 - [AvatarUrlsBean](docs/AvatarUrlsBean.md)
 - [Avatars](docs/Avatars.md)
 - [BulkCustomFieldOptionCreateRequest](docs/BulkCustomFieldOptionCreateRequest.md)
 - [BulkCustomFieldOptionUpdateRequest](docs/BulkCustomFieldOptionUpdateRequest.md)
 - [BulkIssueIsWatching](docs/BulkIssueIsWatching.md)
 - [BulkIssuePropertyUpdateRequest](docs/BulkIssuePropertyUpdateRequest.md)
 - [BulkOperationErrorResult](docs/BulkOperationErrorResult.md)
 - [BulkPermissionGrants](docs/BulkPermissionGrants.md)
 - [BulkPermissionsRequestBean](docs/BulkPermissionsRequestBean.md)
 - [BulkProjectPermissionGrants](docs/BulkProjectPermissionGrants.md)
 - [BulkProjectPermissions](docs/BulkProjectPermissions.md)
 - [ChangeDetails](docs/ChangeDetails.md)
 - [ChangeFilterOwner](docs/ChangeFilterOwner.md)
 - [ChangedValueBean](docs/ChangedValueBean.md)
 - [ChangedWorklog](docs/ChangedWorklog.md)
 - [ChangedWorklogs](docs/ChangedWorklogs.md)
 - [Changelog](docs/Changelog.md)
 - [ColumnItem](docs/ColumnItem.md)
 - [Comment](docs/Comment.md)
 - [ComponentIssuesCount](docs/ComponentIssuesCount.md)
 - [ComponentWithIssueCount](docs/ComponentWithIssueCount.md)
 - [CompoundClause](docs/CompoundClause.md)
 - [Configuration](docs/Configuration.md)
 - [ConnectCustomFieldValue](docs/ConnectCustomFieldValue.md)
 - [ConnectCustomFieldValues](docs/ConnectCustomFieldValues.md)
 - [ConnectModules](docs/ConnectModules.md)
 - [ConnectWorkflowTransitionRule](docs/ConnectWorkflowTransitionRule.md)
 - [ContainerForProjectFeatures](docs/ContainerForProjectFeatures.md)
 - [ContainerForRegisteredWebhooks](docs/ContainerForRegisteredWebhooks.md)
 - [ContainerForWebhookIds](docs/ContainerForWebhookIds.md)
 - [ContainerOfWorkflowSchemeAssociations](docs/ContainerOfWorkflowSchemeAssociations.md)
 - [Context](docs/Context.md)
 - [ContextForProjectAndIssueType](docs/ContextForProjectAndIssueType.md)
 - [ContextualConfiguration](docs/ContextualConfiguration.md)
 - [ConvertedJqlQueries](docs/ConvertedJqlQueries.md)
 - [CreateCustomFieldContext](docs/CreateCustomFieldContext.md)
 - [CreateProjectDetails](docs/CreateProjectDetails.md)
 - [CreateUpdateRoleRequestBean](docs/CreateUpdateRoleRequestBean.md)
 - [CreateWorkflowCondition](docs/CreateWorkflowCondition.md)
 - [CreateWorkflowDetails](docs/CreateWorkflowDetails.md)
 - [CreateWorkflowStatusDetails](docs/CreateWorkflowStatusDetails.md)
 - [CreateWorkflowTransitionDetails](docs/CreateWorkflowTransitionDetails.md)
 - [CreateWorkflowTransitionRule](docs/CreateWorkflowTransitionRule.md)
 - [CreateWorkflowTransitionRulesDetails](docs/CreateWorkflowTransitionRulesDetails.md)
 - [CreateWorkflowTransitionScreenDetails](docs/CreateWorkflowTransitionScreenDetails.md)
 - [CreatedIssue](docs/CreatedIssue.md)
 - [CreatedIssues](docs/CreatedIssues.md)
 - [CustomContextVariable](docs/CustomContextVariable.md)
 - [CustomFieldConfigurations](docs/CustomFieldConfigurations.md)
 - [CustomFieldContext](docs/CustomFieldContext.md)
 - [CustomFieldContextDefaultValue](docs/CustomFieldContextDefaultValue.md)
 - [CustomFieldContextDefaultValueCascadingOption](docs/CustomFieldContextDefaultValueCascadingOption.md)
 - [CustomFieldContextDefaultValueDate](docs/CustomFieldContextDefaultValueDate.md)
 - [CustomFieldContextDefaultValueDateTime](docs/CustomFieldContextDefaultValueDateTime.md)
 - [CustomFieldContextDefaultValueFloat](docs/CustomFieldContextDefaultValueFloat.md)
 - [CustomFieldContextDefaultValueForgeDateTimeField](docs/CustomFieldContextDefaultValueForgeDateTimeField.md)
 - [CustomFieldContextDefaultValueForgeGroupField](docs/CustomFieldContextDefaultValueForgeGroupField.md)
 - [CustomFieldContextDefaultValueForgeMultiGroupField](docs/CustomFieldContextDefaultValueForgeMultiGroupField.md)
 - [CustomFieldContextDefaultValueForgeMultiStringField](docs/CustomFieldContextDefaultValueForgeMultiStringField.md)
 - [CustomFieldContextDefaultValueForgeMultiUserField](docs/CustomFieldContextDefaultValueForgeMultiUserField.md)
 - [CustomFieldContextDefaultValueForgeNumberField](docs/CustomFieldContextDefaultValueForgeNumberField.md)
 - [CustomFieldContextDefaultValueForgeObjectField](docs/CustomFieldContextDefaultValueForgeObjectField.md)
 - [CustomFieldContextDefaultValueForgeStringField](docs/CustomFieldContextDefaultValueForgeStringField.md)
 - [CustomFieldContextDefaultValueForgeUserField](docs/CustomFieldContextDefaultValueForgeUserField.md)
 - [CustomFieldContextDefaultValueLabels](docs/CustomFieldContextDefaultValueLabels.md)
 - [CustomFieldContextDefaultValueMultiUserPicker](docs/CustomFieldContextDefaultValueMultiUserPicker.md)
 - [CustomFieldContextDefaultValueMultipleGroupPicker](docs/CustomFieldContextDefaultValueMultipleGroupPicker.md)
 - [CustomFieldContextDefaultValueMultipleOption](docs/CustomFieldContextDefaultValueMultipleOption.md)
 - [CustomFieldContextDefaultValueMultipleVersionPicker](docs/CustomFieldContextDefaultValueMultipleVersionPicker.md)
 - [CustomFieldContextDefaultValueProject](docs/CustomFieldContextDefaultValueProject.md)
 - [CustomFieldContextDefaultValueReadOnly](docs/CustomFieldContextDefaultValueReadOnly.md)
 - [CustomFieldContextDefaultValueSingleGroupPicker](docs/CustomFieldContextDefaultValueSingleGroupPicker.md)
 - [CustomFieldContextDefaultValueSingleOption](docs/CustomFieldContextDefaultValueSingleOption.md)
 - [CustomFieldContextDefaultValueSingleVersionPicker](docs/CustomFieldContextDefaultValueSingleVersionPicker.md)
 - [CustomFieldContextDefaultValueTextArea](docs/CustomFieldContextDefaultValueTextArea.md)
 - [CustomFieldContextDefaultValueTextField](docs/CustomFieldContextDefaultValueTextField.md)
 - [CustomFieldContextDefaultValueUpdate](docs/CustomFieldContextDefaultValueUpdate.md)
 - [CustomFieldContextDefaultValueUrl](docs/CustomFieldContextDefaultValueUrl.md)
 - [CustomFieldContextOption](docs/CustomFieldContextOption.md)
 - [CustomFieldContextProjectMapping](docs/CustomFieldContextProjectMapping.md)
 - [CustomFieldContextSingleUserPickerDefaults](docs/CustomFieldContextSingleUserPickerDefaults.md)
 - [CustomFieldContextUpdateDetails](docs/CustomFieldContextUpdateDetails.md)
 - [CustomFieldCreatedContextOptionsList](docs/CustomFieldCreatedContextOptionsList.md)
 - [CustomFieldDefinitionJsonBean](docs/CustomFieldDefinitionJsonBean.md)
 - [CustomFieldOption](docs/CustomFieldOption.md)
 - [CustomFieldOptionCreate](docs/CustomFieldOptionCreate.md)
 - [CustomFieldOptionUpdate](docs/CustomFieldOptionUpdate.md)
 - [CustomFieldReplacement](docs/CustomFieldReplacement.md)
 - [CustomFieldUpdatedContextOptionsList](docs/CustomFieldUpdatedContextOptionsList.md)
 - [CustomFieldValueUpdate](docs/CustomFieldValueUpdate.md)
 - [CustomFieldValueUpdateDetails](docs/CustomFieldValueUpdateDetails.md)
 - [Dashboard](docs/Dashboard.md)
 - [DashboardDetails](docs/DashboardDetails.md)
 - [DashboardGadget](docs/DashboardGadget.md)
 - [DashboardGadgetPosition](docs/DashboardGadgetPosition.md)
 - [DashboardGadgetResponse](docs/DashboardGadgetResponse.md)
 - [DashboardGadgetSettings](docs/DashboardGadgetSettings.md)
 - [DashboardGadgetUpdateRequest](docs/DashboardGadgetUpdateRequest.md)
 - [DefaultShareScope](docs/DefaultShareScope.md)
 - [DefaultWorkflow](docs/DefaultWorkflow.md)
 - [DeleteAndReplaceVersionBean](docs/DeleteAndReplaceVersionBean.md)
 - [DeprecatedWorkflow](docs/DeprecatedWorkflow.md)
 - [EntityProperty](docs/EntityProperty.md)
 - [EntityPropertyDetails](docs/EntityPropertyDetails.md)
 - [ErrorCollection](docs/ErrorCollection.md)
 - [ErrorMessage](docs/ErrorMessage.md)
 - [EventNotification](docs/EventNotification.md)
 - [FailedWebhook](docs/FailedWebhook.md)
 - [FailedWebhooks](docs/FailedWebhooks.md)
 - [Field](docs/Field.md)
 - [FieldChangedClause](docs/FieldChangedClause.md)
 - [FieldConfiguration](docs/FieldConfiguration.md)
 - [FieldConfigurationDetails](docs/FieldConfigurationDetails.md)
 - [FieldConfigurationIssueTypeItem](docs/FieldConfigurationIssueTypeItem.md)
 - [FieldConfigurationItem](docs/FieldConfigurationItem.md)
 - [FieldConfigurationItemsDetails](docs/FieldConfigurationItemsDetails.md)
 - [FieldConfigurationScheme](docs/FieldConfigurationScheme.md)
 - [FieldConfigurationSchemeProjectAssociation](docs/FieldConfigurationSchemeProjectAssociation.md)
 - [FieldConfigurationSchemeProjects](docs/FieldConfigurationSchemeProjects.md)
 - [FieldConfigurationToIssueTypeMapping](docs/FieldConfigurationToIssueTypeMapping.md)
 - [FieldDetails](docs/FieldDetails.md)
 - [FieldLastUsed](docs/FieldLastUsed.md)
 - [FieldMetadata](docs/FieldMetadata.md)
 - [FieldReferenceData](docs/FieldReferenceData.md)
 - [FieldUpdateOperation](docs/FieldUpdateOperation.md)
 - [FieldValueClause](docs/FieldValueClause.md)
 - [FieldWasClause](docs/FieldWasClause.md)
 - [Fields](docs/Fields.md)
 - [Filter](docs/Filter.md)
 - [FilterDetails](docs/FilterDetails.md)
 - [FilterSubscription](docs/FilterSubscription.md)
 - [FilterSubscriptionsList](docs/FilterSubscriptionsList.md)
 - [FoundGroup](docs/FoundGroup.md)
 - [FoundGroups](docs/FoundGroups.md)
 - [FoundUsers](docs/FoundUsers.md)
 - [FoundUsersAndGroups](docs/FoundUsersAndGroups.md)
 - [FunctionOperand](docs/FunctionOperand.md)
 - [FunctionReferenceData](docs/FunctionReferenceData.md)
 - [GlobalScopeBean](docs/GlobalScopeBean.md)
 - [Group](docs/Group.md)
 - [GroupDetails](docs/GroupDetails.md)
 - [GroupLabel](docs/GroupLabel.md)
 - [GroupName](docs/GroupName.md)
 - [HealthCheckResult](docs/HealthCheckResult.md)
 - [Hierarchy](docs/Hierarchy.md)
 - [HistoryMetadata](docs/HistoryMetadata.md)
 - [HistoryMetadataParticipant](docs/HistoryMetadataParticipant.md)
 - [Icon](docs/Icon.md)
 - [IconBean](docs/IconBean.md)
 - [IdBean](docs/IdBean.md)
 - [IdOrKeyBean](docs/IdOrKeyBean.md)
 - [IncludedFields](docs/IncludedFields.md)
 - [IssueBean](docs/IssueBean.md)
 - [IssueChangelogIds](docs/IssueChangelogIds.md)
 - [IssueCommentListRequestBean](docs/IssueCommentListRequestBean.md)
 - [IssueContextVariable](docs/IssueContextVariable.md)
 - [IssueCreateMetadata](docs/IssueCreateMetadata.md)
 - [IssueEntityProperties](docs/IssueEntityProperties.md)
 - [IssueEntityPropertiesForMultiUpdate](docs/IssueEntityPropertiesForMultiUpdate.md)
 - [IssueEvent](docs/IssueEvent.md)
 - [IssueFieldOption](docs/IssueFieldOption.md)
 - [IssueFieldOptionConfiguration](docs/IssueFieldOptionConfiguration.md)
 - [IssueFieldOptionCreateBean](docs/IssueFieldOptionCreateBean.md)
 - [IssueFieldOptionScopeBean](docs/IssueFieldOptionScopeBean.md)
 - [IssueFilterForBulkPropertyDelete](docs/IssueFilterForBulkPropertyDelete.md)
 - [IssueFilterForBulkPropertySet](docs/IssueFilterForBulkPropertySet.md)
 - [IssueLink](docs/IssueLink.md)
 - [IssueLinkType](docs/IssueLinkType.md)
 - [IssueLinkTypes](docs/IssueLinkTypes.md)
 - [IssueList](docs/IssueList.md)
 - [IssueMatches](docs/IssueMatches.md)
 - [IssueMatchesForJql](docs/IssueMatchesForJql.md)
 - [IssuePickerSuggestions](docs/IssuePickerSuggestions.md)
 - [IssuePickerSuggestionsIssueType](docs/IssuePickerSuggestionsIssueType.md)
 - [IssueSecurityLevelMember](docs/IssueSecurityLevelMember.md)
 - [IssueTransition](docs/IssueTransition.md)
 - [IssueTypeCreateBean](docs/IssueTypeCreateBean.md)
 - [IssueTypeDetails](docs/IssueTypeDetails.md)
 - [IssueTypeIds](docs/IssueTypeIds.md)
 - [IssueTypeIdsToRemove](docs/IssueTypeIdsToRemove.md)
 - [IssueTypeInfo](docs/IssueTypeInfo.md)
 - [IssueTypeIssueCreateMetadata](docs/IssueTypeIssueCreateMetadata.md)
 - [IssueTypeScheme](docs/IssueTypeScheme.md)
 - [IssueTypeSchemeDetails](docs/IssueTypeSchemeDetails.md)
 - [IssueTypeSchemeId](docs/IssueTypeSchemeId.md)
 - [IssueTypeSchemeMapping](docs/IssueTypeSchemeMapping.md)
 - [IssueTypeSchemeProjectAssociation](docs/IssueTypeSchemeProjectAssociation.md)
 - [IssueTypeSchemeProjects](docs/IssueTypeSchemeProjects.md)
 - [IssueTypeSchemeUpdateDetails](docs/IssueTypeSchemeUpdateDetails.md)
 - [IssueTypeScreenScheme](docs/IssueTypeScreenScheme.md)
 - [IssueTypeScreenSchemeDetails](docs/IssueTypeScreenSchemeDetails.md)
 - [IssueTypeScreenSchemeId](docs/IssueTypeScreenSchemeId.md)
 - [IssueTypeScreenSchemeItem](docs/IssueTypeScreenSchemeItem.md)
 - [IssueTypeScreenSchemeMapping](docs/IssueTypeScreenSchemeMapping.md)
 - [IssueTypeScreenSchemeMappingDetails](docs/IssueTypeScreenSchemeMappingDetails.md)
 - [IssueTypeScreenSchemeProjectAssociation](docs/IssueTypeScreenSchemeProjectAssociation.md)
 - [IssueTypeScreenSchemeUpdateDetails](docs/IssueTypeScreenSchemeUpdateDetails.md)
 - [IssueTypeScreenSchemesProjects](docs/IssueTypeScreenSchemesProjects.md)
 - [IssueTypeToContextMapping](docs/IssueTypeToContextMapping.md)
 - [IssueTypeUpdateBean](docs/IssueTypeUpdateBean.md)
 - [IssueTypeWithStatus](docs/IssueTypeWithStatus.md)
 - [IssueTypeWorkflowMapping](docs/IssueTypeWorkflowMapping.md)
 - [IssueTypesWorkflowMapping](docs/IssueTypesWorkflowMapping.md)
 - [IssueUpdateDetails](docs/IssueUpdateDetails.md)
 - [IssueUpdateMetadata](docs/IssueUpdateMetadata.md)
 - [IssuesAndJqlQueries](docs/IssuesAndJqlQueries.md)
 - [IssuesJqlMetaDataBean](docs/IssuesJqlMetaDataBean.md)
 - [IssuesMetaBean](docs/IssuesMetaBean.md)
 - [IssuesUpdateBean](docs/IssuesUpdateBean.md)
 - [JexpIssues](docs/JexpIssues.md)
 - [JexpJqlIssues](docs/JexpJqlIssues.md)
 - [JiraExpressionAnalysis](docs/JiraExpressionAnalysis.md)
 - [JiraExpressionComplexity](docs/JiraExpressionComplexity.md)
 - [JiraExpressionEvalContextBean](docs/JiraExpressionEvalContextBean.md)
 - [JiraExpressionEvalRequestBean](docs/JiraExpressionEvalRequestBean.md)
 - [JiraExpressionEvaluationMetaDataBean](docs/JiraExpressionEvaluationMetaDataBean.md)
 - [JiraExpressionForAnalysis](docs/JiraExpressionForAnalysis.md)
 - [JiraExpressionResult](docs/JiraExpressionResult.md)
 - [JiraExpressionValidationError](docs/JiraExpressionValidationError.md)
 - [JiraExpressionsAnalysis](docs/JiraExpressionsAnalysis.md)
 - [JiraExpressionsComplexityBean](docs/JiraExpressionsComplexityBean.md)
 - [JiraExpressionsComplexityValueBean](docs/JiraExpressionsComplexityValueBean.md)
 - [JqlPersonalDataMigrationRequest](docs/JqlPersonalDataMigrationRequest.md)
 - [JqlQueriesToParse](docs/JqlQueriesToParse.md)
 - [JqlQueriesToSanitize](docs/JqlQueriesToSanitize.md)
 - [JqlQuery](docs/JqlQuery.md)
 - [JqlQueryClause](docs/JqlQueryClause.md)
 - [JqlQueryClauseOperand](docs/JqlQueryClauseOperand.md)
 - [JqlQueryClauseTimePredicate](docs/JqlQueryClauseTimePredicate.md)
 - [JqlQueryField](docs/JqlQueryField.md)
 - [JqlQueryFieldEntityProperty](docs/JqlQueryFieldEntityProperty.md)
 - [JqlQueryOrderByClause](docs/JqlQueryOrderByClause.md)
 - [JqlQueryOrderByClauseElement](docs/JqlQueryOrderByClauseElement.md)
 - [JqlQueryToSanitize](docs/JqlQueryToSanitize.md)
 - [JqlQueryUnitaryOperand](docs/JqlQueryUnitaryOperand.md)
 - [JqlQueryWithUnknownUsers](docs/JqlQueryWithUnknownUsers.md)
 - [JqlReferenceData](docs/JqlReferenceData.md)
 - [JsonContextVariable](docs/JsonContextVariable.md)
 - [JsonNode](docs/JsonNode.md)
 - [JsonTypeBean](docs/JsonTypeBean.md)
 - [KeywordOperand](docs/KeywordOperand.md)
 - [License](docs/License.md)
 - [LicensedApplication](docs/LicensedApplication.md)
 - [LinkGroup](docs/LinkGroup.md)
 - [LinkIssueRequestJsonBean](docs/LinkIssueRequestJsonBean.md)
 - [LinkedIssue](docs/LinkedIssue.md)
 - [ListOperand](docs/ListOperand.md)
 - [Locale](docs/Locale.md)
 - [MoveFieldBean](docs/MoveFieldBean.md)
 - [MultiIssueEntityProperties](docs/MultiIssueEntityProperties.md)
 - [MultipleCustomFieldValuesUpdate](docs/MultipleCustomFieldValuesUpdate.md)
 - [MultipleCustomFieldValuesUpdateDetails](docs/MultipleCustomFieldValuesUpdateDetails.md)
 - [NestedResponse](docs/NestedResponse.md)
 - [NewUserDetails](docs/NewUserDetails.md)
 - [Notification](docs/Notification.md)
 - [NotificationEvent](docs/NotificationEvent.md)
 - [NotificationRecipients](docs/NotificationRecipients.md)
 - [NotificationRecipientsRestrictions](docs/NotificationRecipientsRestrictions.md)
 - [NotificationScheme](docs/NotificationScheme.md)
 - [NotificationSchemeEvent](docs/NotificationSchemeEvent.md)
 - [OperationMessage](docs/OperationMessage.md)
 - [Operations](docs/Operations.md)
 - [OrderOfCustomFieldOptions](docs/OrderOfCustomFieldOptions.md)
 - [OrderOfIssueTypes](docs/OrderOfIssueTypes.md)
 - [PageBeanChangelog](docs/PageBeanChangelog.md)
 - [PageBeanComment](docs/PageBeanComment.md)
 - [PageBeanComponentWithIssueCount](docs/PageBeanComponentWithIssueCount.md)
 - [PageBeanContext](docs/PageBeanContext.md)
 - [PageBeanContextForProjectAndIssueType](docs/PageBeanContextForProjectAndIssueType.md)
 - [PageBeanContextualConfiguration](docs/PageBeanContextualConfiguration.md)
 - [PageBeanCustomFieldContext](docs/PageBeanCustomFieldContext.md)
 - [PageBeanCustomFieldContextDefaultValue](docs/PageBeanCustomFieldContextDefaultValue.md)
 - [PageBeanCustomFieldContextOption](docs/PageBeanCustomFieldContextOption.md)
 - [PageBeanCustomFieldContextProjectMapping](docs/PageBeanCustomFieldContextProjectMapping.md)
 - [PageBeanDashboard](docs/PageBeanDashboard.md)
 - [PageBeanField](docs/PageBeanField.md)
 - [PageBeanFieldConfigurationDetails](docs/PageBeanFieldConfigurationDetails.md)
 - [PageBeanFieldConfigurationIssueTypeItem](docs/PageBeanFieldConfigurationIssueTypeItem.md)
 - [PageBeanFieldConfigurationItem](docs/PageBeanFieldConfigurationItem.md)
 - [PageBeanFieldConfigurationScheme](docs/PageBeanFieldConfigurationScheme.md)
 - [PageBeanFieldConfigurationSchemeProjects](docs/PageBeanFieldConfigurationSchemeProjects.md)
 - [PageBeanFilterDetails](docs/PageBeanFilterDetails.md)
 - [PageBeanGroupDetails](docs/PageBeanGroupDetails.md)
 - [PageBeanIssueFieldOption](docs/PageBeanIssueFieldOption.md)
 - [PageBeanIssueSecurityLevelMember](docs/PageBeanIssueSecurityLevelMember.md)
 - [PageBeanIssueTypeScheme](docs/PageBeanIssueTypeScheme.md)
 - [PageBeanIssueTypeSchemeMapping](docs/PageBeanIssueTypeSchemeMapping.md)
 - [PageBeanIssueTypeSchemeProjects](docs/PageBeanIssueTypeSchemeProjects.md)
 - [PageBeanIssueTypeScreenScheme](docs/PageBeanIssueTypeScreenScheme.md)
 - [PageBeanIssueTypeScreenSchemeItem](docs/PageBeanIssueTypeScreenSchemeItem.md)
 - [PageBeanIssueTypeScreenSchemesProjects](docs/PageBeanIssueTypeScreenSchemesProjects.md)
 - [PageBeanIssueTypeToContextMapping](docs/PageBeanIssueTypeToContextMapping.md)
 - [PageBeanNotificationScheme](docs/PageBeanNotificationScheme.md)
 - [PageBeanProject](docs/PageBeanProject.md)
 - [PageBeanProjectDetails](docs/PageBeanProjectDetails.md)
 - [PageBeanScreen](docs/PageBeanScreen.md)
 - [PageBeanScreenScheme](docs/PageBeanScreenScheme.md)
 - [PageBeanScreenWithTab](docs/PageBeanScreenWithTab.md)
 - [PageBeanString](docs/PageBeanString.md)
 - [PageBeanUser](docs/PageBeanUser.md)
 - [PageBeanUserDetails](docs/PageBeanUserDetails.md)
 - [PageBeanUserKey](docs/PageBeanUserKey.md)
 - [PageBeanVersion](docs/PageBeanVersion.md)
 - [PageBeanWebhook](docs/PageBeanWebhook.md)
 - [PageBeanWorkflow](docs/PageBeanWorkflow.md)
 - [PageBeanWorkflowScheme](docs/PageBeanWorkflowScheme.md)
 - [PageBeanWorkflowTransitionRules](docs/PageBeanWorkflowTransitionRules.md)
 - [PageOfChangelogs](docs/PageOfChangelogs.md)
 - [PageOfComments](docs/PageOfComments.md)
 - [PageOfDashboards](docs/PageOfDashboards.md)
 - [PageOfWorklogs](docs/PageOfWorklogs.md)
 - [PagedListUserDetailsApplicationUser](docs/PagedListUserDetailsApplicationUser.md)
 - [PaginatedResponseComment](docs/PaginatedResponseComment.md)
 - [ParsedJqlQueries](docs/ParsedJqlQueries.md)
 - [ParsedJqlQuery](docs/ParsedJqlQuery.md)
 - [PermissionGrant](docs/PermissionGrant.md)
 - [PermissionGrants](docs/PermissionGrants.md)
 - [PermissionHolder](docs/PermissionHolder.md)
 - [PermissionScheme](docs/PermissionScheme.md)
 - [PermissionSchemes](docs/PermissionSchemes.md)
 - [Permissions](docs/Permissions.md)
 - [PermissionsKeysBean](docs/PermissionsKeysBean.md)
 - [PermittedProjects](docs/PermittedProjects.md)
 - [Priority](docs/Priority.md)
 - [Project](docs/Project.md)
 - [ProjectAvatars](docs/ProjectAvatars.md)
 - [ProjectCategory](docs/ProjectCategory.md)
 - [ProjectComponent](docs/ProjectComponent.md)
 - [ProjectDetails](docs/ProjectDetails.md)
 - [ProjectEmailAddress](docs/ProjectEmailAddress.md)
 - [ProjectFeature](docs/ProjectFeature.md)
 - [ProjectFeatureState](docs/ProjectFeatureState.md)
 - [ProjectIdentifierBean](docs/ProjectIdentifierBean.md)
 - [ProjectIdentifiers](docs/ProjectIdentifiers.md)
 - [ProjectIds](docs/ProjectIds.md)
 - [ProjectInsight](docs/ProjectInsight.md)
 - [ProjectIssueCreateMetadata](docs/ProjectIssueCreateMetadata.md)
 - [ProjectIssueSecurityLevels](docs/ProjectIssueSecurityLevels.md)
 - [ProjectIssueTypeHierarchy](docs/ProjectIssueTypeHierarchy.md)
 - [ProjectIssueTypeMapping](docs/ProjectIssueTypeMapping.md)
 - [ProjectIssueTypeMappings](docs/ProjectIssueTypeMappings.md)
 - [ProjectIssueTypesHierarchyLevel](docs/ProjectIssueTypesHierarchyLevel.md)
 - [ProjectLandingPageInfo](docs/ProjectLandingPageInfo.md)
 - [ProjectPermissions](docs/ProjectPermissions.md)
 - [ProjectRole](docs/ProjectRole.md)
 - [ProjectRoleActorsUpdateBean](docs/ProjectRoleActorsUpdateBean.md)
 - [ProjectRoleDetails](docs/ProjectRoleDetails.md)
 - [ProjectRoleGroup](docs/ProjectRoleGroup.md)
 - [ProjectRoleUser](docs/ProjectRoleUser.md)
 - [ProjectScopeBean](docs/ProjectScopeBean.md)
 - [ProjectType](docs/ProjectType.md)
 - [PropertyKey](docs/PropertyKey.md)
 - [PropertyKeys](docs/PropertyKeys.md)
 - [PublishDraftWorkflowScheme](docs/PublishDraftWorkflowScheme.md)
 - [PublishedWorkflowId](docs/PublishedWorkflowId.md)
 - [RegisteredWebhook](docs/RegisteredWebhook.md)
 - [RemoteIssueLink](docs/RemoteIssueLink.md)
 - [RemoteIssueLinkIdentifies](docs/RemoteIssueLinkIdentifies.md)
 - [RemoteIssueLinkRequest](docs/RemoteIssueLinkRequest.md)
 - [RemoteObject](docs/RemoteObject.md)
 - [RemoveOptionFromIssuesResult](docs/RemoveOptionFromIssuesResult.md)
 - [Resolution](docs/Resolution.md)
 - [RestrictedPermission](docs/RestrictedPermission.md)
 - [RichText](docs/RichText.md)
 - [RoleActor](docs/RoleActor.md)
 - [RuleConfiguration](docs/RuleConfiguration.md)
 - [SanitizedJqlQueries](docs/SanitizedJqlQueries.md)
 - [SanitizedJqlQuery](docs/SanitizedJqlQuery.md)
 - [Scope](docs/Scope.md)
 - [Screen](docs/Screen.md)
 - [ScreenDetails](docs/ScreenDetails.md)
 - [ScreenScheme](docs/ScreenScheme.md)
 - [ScreenSchemeDetails](docs/ScreenSchemeDetails.md)
 - [ScreenSchemeId](docs/ScreenSchemeId.md)
 - [ScreenTypes](docs/ScreenTypes.md)
 - [ScreenWithTab](docs/ScreenWithTab.md)
 - [ScreenableField](docs/ScreenableField.md)
 - [ScreenableTab](docs/ScreenableTab.md)
 - [SearchAutoCompleteFilter](docs/SearchAutoCompleteFilter.md)
 - [SearchRequestBean](docs/SearchRequestBean.md)
 - [SearchResults](docs/SearchResults.md)
 - [SecurityLevel](docs/SecurityLevel.md)
 - [SecurityScheme](docs/SecurityScheme.md)
 - [SecuritySchemes](docs/SecuritySchemes.md)
 - [ServerInformation](docs/ServerInformation.md)
 - [SharePermission](docs/SharePermission.md)
 - [SharePermissionInputBean](docs/SharePermissionInputBean.md)
 - [SimpleApplicationPropertyBean](docs/SimpleApplicationPropertyBean.md)
 - [SimpleErrorCollection](docs/SimpleErrorCollection.md)
 - [SimpleLink](docs/SimpleLink.md)
 - [SimpleListWrapperApplicationRole](docs/SimpleListWrapperApplicationRole.md)
 - [SimpleListWrapperGroupName](docs/SimpleListWrapperGroupName.md)
 - [SimplifiedHierarchyLevel](docs/SimplifiedHierarchyLevel.md)
 - [Status](docs/Status.md)
 - [StatusCategory](docs/StatusCategory.md)
 - [StatusDetails](docs/StatusDetails.md)
 - [StatusMapping](docs/StatusMapping.md)
 - [SuggestedIssue](docs/SuggestedIssue.md)
 - [SystemAvatars](docs/SystemAvatars.md)
 - [TaskProgressBeanObject](docs/TaskProgressBeanObject.md)
 - [TaskProgressBeanRemoveOptionFromIssuesResult](docs/TaskProgressBeanRemoveOptionFromIssuesResult.md)
 - [TimeTrackingConfiguration](docs/TimeTrackingConfiguration.md)
 - [TimeTrackingDetails](docs/TimeTrackingDetails.md)
 - [TimeTrackingProvider](docs/TimeTrackingProvider.md)
 - [Transition](docs/Transition.md)
 - [TransitionScreenDetails](docs/TransitionScreenDetails.md)
 - [Transitions](docs/Transitions.md)
 - [UnrestrictedUserEmail](docs/UnrestrictedUserEmail.md)
 - [UpdateCustomFieldDetails](docs/UpdateCustomFieldDetails.md)
 - [UpdateDefaultScreenScheme](docs/UpdateDefaultScreenScheme.md)
 - [UpdateFieldConfigurationSchemeDetails](docs/UpdateFieldConfigurationSchemeDetails.md)
 - [UpdateProjectDetails](docs/UpdateProjectDetails.md)
 - [UpdateScreenDetails](docs/UpdateScreenDetails.md)
 - [UpdateScreenSchemeDetails](docs/UpdateScreenSchemeDetails.md)
 - [UpdateScreenTypes](docs/UpdateScreenTypes.md)
 - [UpdateUserToGroupBean](docs/UpdateUserToGroupBean.md)
 - [UpdatedProjectCategory](docs/UpdatedProjectCategory.md)
 - [User](docs/User.md)
 - [UserBean](docs/UserBean.md)
 - [UserBeanAvatarUrls](docs/UserBeanAvatarUrls.md)
 - [UserContextVariable](docs/UserContextVariable.md)
 - [UserDetails](docs/UserDetails.md)
 - [UserFilter](docs/UserFilter.md)
 - [UserKey](docs/UserKey.md)
 - [UserList](docs/UserList.md)
 - [UserMigrationBean](docs/UserMigrationBean.md)
 - [UserPermission](docs/UserPermission.md)
 - [UserPickerUser](docs/UserPickerUser.md)
 - [ValueOperand](docs/ValueOperand.md)
 - [Version](docs/Version.md)
 - [VersionIssueCounts](docs/VersionIssueCounts.md)
 - [VersionIssuesStatus](docs/VersionIssuesStatus.md)
 - [VersionMoveBean](docs/VersionMoveBean.md)
 - [VersionUnresolvedIssuesCount](docs/VersionUnresolvedIssuesCount.md)
 - [VersionUsageInCustomField](docs/VersionUsageInCustomField.md)
 - [Visibility](docs/Visibility.md)
 - [Votes](docs/Votes.md)
 - [Watchers](docs/Watchers.md)
 - [Webhook](docs/Webhook.md)
 - [WebhookDetails](docs/WebhookDetails.md)
 - [WebhookRegistrationDetails](docs/WebhookRegistrationDetails.md)
 - [WebhooksExpirationDate](docs/WebhooksExpirationDate.md)
 - [Workflow](docs/Workflow.md)
 - [WorkflowCompoundCondition](docs/WorkflowCompoundCondition.md)
 - [WorkflowCondition](docs/WorkflowCondition.md)
 - [WorkflowId](docs/WorkflowId.md)
 - [WorkflowIds](docs/WorkflowIds.md)
 - [WorkflowOperations](docs/WorkflowOperations.md)
 - [WorkflowRules](docs/WorkflowRules.md)
 - [WorkflowRulesSearch](docs/WorkflowRulesSearch.md)
 - [WorkflowRulesSearchDetails](docs/WorkflowRulesSearchDetails.md)
 - [WorkflowScheme](docs/WorkflowScheme.md)
 - [WorkflowSchemeAssociations](docs/WorkflowSchemeAssociations.md)
 - [WorkflowSchemeIdName](docs/WorkflowSchemeIdName.md)
 - [WorkflowSchemeProjectAssociation](docs/WorkflowSchemeProjectAssociation.md)
 - [WorkflowSimpleCondition](docs/WorkflowSimpleCondition.md)
 - [WorkflowStatus](docs/WorkflowStatus.md)
 - [WorkflowTransition](docs/WorkflowTransition.md)
 - [WorkflowTransitionProperty](docs/WorkflowTransitionProperty.md)
 - [WorkflowTransitionRule](docs/WorkflowTransitionRule.md)
 - [WorkflowTransitionRules](docs/WorkflowTransitionRules.md)
 - [WorkflowTransitionRulesDetails](docs/WorkflowTransitionRulesDetails.md)
 - [WorkflowTransitionRulesUpdate](docs/WorkflowTransitionRulesUpdate.md)
 - [WorkflowTransitionRulesUpdateErrorDetails](docs/WorkflowTransitionRulesUpdateErrorDetails.md)
 - [WorkflowTransitionRulesUpdateErrors](docs/WorkflowTransitionRulesUpdateErrors.md)
 - [WorkflowsWithTransitionRulesDetails](docs/WorkflowsWithTransitionRulesDetails.md)
 - [Worklog](docs/Worklog.md)
 - [WorklogIdsRequestBean](docs/WorklogIdsRequestBean.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

ecosystem@atlassian.com

