## Developer changelog

This is quite a small release as the code inclusion bug was really nasty... and prevented any possible development using `jinko`. A bunch of other bugs regarding generics have been fixed.

- #474

Multiple instructions such as `VarAssign` and `FieldAssign` did not expand generics properly. This has been fixed in the PR aiming for generic method calls to resolve correctly.

- #475

Previously, non-generic types were getting generically-mapped during the expansion pass. This meant that code like this:
```rust
type Something;
func takes_generic_and_some[T](one: T, two: Something) {}
```
would error out for not mapping the generic type `Something` properly.

- #477

Typechecking had broken test functions by forbidding the user to declare a test with the same name as an existing function. This is now fixed. Test functions are also now typechecked properly, which wasn't the case before.

- #478

You are no longer allowed to perform generic function calls if the function does not contain generics.

```rust
func no_gen(a: int, b: string) -> float {
    15.4
}

no_gen[int, string, bool](15, true); // Error
```

- #480

`fmt_int` has been reimplemented completely in jinko! There is a small performance hit, and the implementation is extremely ugly due to a weird recursion argument mapping bug and the lack of switch cases/pattern matching.

The implementation was benchmarked against a similarly ugly python implementation, and a call to the previous version of `fmt_int()`, which is simply a wrapper around rust's `Display<i64>` implementation.

```
~/G/j/jinko (int-to-string|✚2…) $ hyperfine --warmup 10 'python python_impl.py' 'target/release/jinko jinko_impl.jk' 'target/release/jinko native_rust_fmt.jk'
Benchmark #1: python python_impl.py
  Time (mean ± σ):      20.5 ms ±   1.4 ms    [User: 16.9 ms, System: 3.9 ms]
  Range (min … max):    15.7 ms …  23.8 ms    113 runs

Benchmark #2: target/release/jinko jinko_impl.jk
  Time (mean ± σ):       6.1 ms ±   0.9 ms    [User: 4.7 ms, System: 2.0 ms]
  Range (min … max):     2.5 ms …   8.7 ms    258 runs

  Warning: Command took less than 5 ms to complete. Results might be inaccurate.

Benchmark #3: target/release/jinko native_rust_fmt.jk
  Time (mean ± σ):       2.4 ms ±   1.0 ms    [User: 2.7 ms, System: 1.1 ms]
  Range (min … max):     0.0 ms …   6.0 ms    543 runs

  Warning: Command took less than 5 ms to complete. Results might be inaccurate.

Summary
  'target/release/jinko native_rust_fmt.jk' ran
    2.51 ± 1.05 times faster than 'target/release/jinko jinko_impl.jk'
    8.40 ± 3.32 times faster than 'python python_impl.py'
```

A side-effect of these fixes is that we also accidentally gained the power to do generic type inference... But this behavior needs to be standardized and tested on its own:

```rust
ext func debug[T](instance: T); // builtin function

debug(15);
debug("s");

type Complex(real: int, imaginary: int);

debug(Complex(real: 15, imaginary: 12));
```

No need to call `debug[int](15)` anymore!

## Language changelog

- #474: You can now call generic methods properly
- #472: Code Inclusion was fixed!

**Full Changelog**: https://github.com/jinko-core/jinko/compare/v0.3.0-jinx3...v0.3.0-jinx4
