#![allow(non_upper_case_globals)]

use bincode::{Decode, Encode};

#[derive(Encode, Decode, Copy, Clone, Eq, PartialEq, Hash, Debug)]
pub struct KeySym(pub u32);

pub const SYM_BackSpace: KeySym = KeySym(0xff08);
pub const SYM_Tab: KeySym = KeySym(0xff09);
pub const SYM_Linefeed: KeySym = KeySym(0xff0a);
pub const SYM_Clear: KeySym = KeySym(0xff0b);
pub const SYM_Return: KeySym = KeySym(0xff0d);
pub const SYM_Pause: KeySym = KeySym(0xff13);
pub const SYM_Scroll_Lock: KeySym = KeySym(0xff14);
pub const SYM_Sys_Req: KeySym = KeySym(0xff15);
pub const SYM_Escape: KeySym = KeySym(0xff1b);
pub const SYM_Delete: KeySym = KeySym(0xffff);
pub const SYM_Multi_key: KeySym = KeySym(0xff20);
pub const SYM_Codeinput: KeySym = KeySym(0xff37);
pub const SYM_SingleCandidate: KeySym = KeySym(0xff3c);
pub const SYM_MultipleCandidate: KeySym = KeySym(0xff3d);
pub const SYM_PreviousCandidate: KeySym = KeySym(0xff3e);
pub const SYM_Kanji: KeySym = KeySym(0xff21);
pub const SYM_Muhenkan: KeySym = KeySym(0xff22);
pub const SYM_Henkan_Mode: KeySym = KeySym(0xff23);
pub const SYM_Henkan: KeySym = KeySym(0xff23);
pub const SYM_Romaji: KeySym = KeySym(0xff24);
pub const SYM_Hiragana: KeySym = KeySym(0xff25);
pub const SYM_Katakana: KeySym = KeySym(0xff26);
pub const SYM_Hiragana_Katakana: KeySym = KeySym(0xff27);
pub const SYM_Zenkaku: KeySym = KeySym(0xff28);
pub const SYM_Hankaku: KeySym = KeySym(0xff29);
pub const SYM_Zenkaku_Hankaku: KeySym = KeySym(0xff2a);
pub const SYM_Touroku: KeySym = KeySym(0xff2b);
pub const SYM_Massyo: KeySym = KeySym(0xff2c);
pub const SYM_Kana_Lock: KeySym = KeySym(0xff2d);
pub const SYM_Kana_Shift: KeySym = KeySym(0xff2e);
pub const SYM_Eisu_Shift: KeySym = KeySym(0xff2f);
pub const SYM_Eisu_toggle: KeySym = KeySym(0xff30);
pub const SYM_Kanji_Bangou: KeySym = KeySym(0xff37);
pub const SYM_Zen_Koho: KeySym = KeySym(0xff3d);
pub const SYM_Mae_Koho: KeySym = KeySym(0xff3e);
pub const SYM_Home: KeySym = KeySym(0xff50);
pub const SYM_Left: KeySym = KeySym(0xff51);
pub const SYM_Up: KeySym = KeySym(0xff52);
pub const SYM_Right: KeySym = KeySym(0xff53);
pub const SYM_Down: KeySym = KeySym(0xff54);
pub const SYM_Prior: KeySym = KeySym(0xff55);
pub const SYM_Page_Up: KeySym = KeySym(0xff55);
pub const SYM_Next: KeySym = KeySym(0xff56);
pub const SYM_Page_Down: KeySym = KeySym(0xff56);
pub const SYM_End: KeySym = KeySym(0xff57);
pub const SYM_Begin: KeySym = KeySym(0xff58);
pub const SYM_Select: KeySym = KeySym(0xff60);
pub const SYM_Print: KeySym = KeySym(0xff61);
pub const SYM_Execute: KeySym = KeySym(0xff62);
pub const SYM_Insert: KeySym = KeySym(0xff63);
pub const SYM_Undo: KeySym = KeySym(0xff65);
pub const SYM_Redo: KeySym = KeySym(0xff66);
pub const SYM_Menu: KeySym = KeySym(0xff67);
pub const SYM_Find: KeySym = KeySym(0xff68);
pub const SYM_Cancel: KeySym = KeySym(0xff69);
pub const SYM_Help: KeySym = KeySym(0xff6a);
pub const SYM_Break: KeySym = KeySym(0xff6b);
pub const SYM_Mode_switch: KeySym = KeySym(0xff7e);
pub const SYM_script_switch: KeySym = KeySym(0xff7e);
pub const SYM_Num_Lock: KeySym = KeySym(0xff7f);
pub const SYM_KP_Space: KeySym = KeySym(0xff80);
pub const SYM_KP_Tab: KeySym = KeySym(0xff89);
pub const SYM_KP_Enter: KeySym = KeySym(0xff8d);
pub const SYM_KP_F1: KeySym = KeySym(0xff91);
pub const SYM_KP_F2: KeySym = KeySym(0xff92);
pub const SYM_KP_F3: KeySym = KeySym(0xff93);
pub const SYM_KP_F4: KeySym = KeySym(0xff94);
pub const SYM_KP_Home: KeySym = KeySym(0xff95);
pub const SYM_KP_Left: KeySym = KeySym(0xff96);
pub const SYM_KP_Up: KeySym = KeySym(0xff97);
pub const SYM_KP_Right: KeySym = KeySym(0xff98);
pub const SYM_KP_Down: KeySym = KeySym(0xff99);
pub const SYM_KP_Prior: KeySym = KeySym(0xff9a);
pub const SYM_KP_Page_Up: KeySym = KeySym(0xff9a);
pub const SYM_KP_Next: KeySym = KeySym(0xff9b);
pub const SYM_KP_Page_Down: KeySym = KeySym(0xff9b);
pub const SYM_KP_End: KeySym = KeySym(0xff9c);
pub const SYM_KP_Begin: KeySym = KeySym(0xff9d);
pub const SYM_KP_Insert: KeySym = KeySym(0xff9e);
pub const SYM_KP_Delete: KeySym = KeySym(0xff9f);
pub const SYM_KP_Equal: KeySym = KeySym(0xffbd);
pub const SYM_KP_Multiply: KeySym = KeySym(0xffaa);
pub const SYM_KP_Add: KeySym = KeySym(0xffab);
pub const SYM_KP_Separator: KeySym = KeySym(0xffac);
pub const SYM_KP_Subtract: KeySym = KeySym(0xffad);
pub const SYM_KP_Decimal: KeySym = KeySym(0xffae);
pub const SYM_KP_Divide: KeySym = KeySym(0xffaf);
pub const SYM_KP_0: KeySym = KeySym(0xffb0);
pub const SYM_KP_1: KeySym = KeySym(0xffb1);
pub const SYM_KP_2: KeySym = KeySym(0xffb2);
pub const SYM_KP_3: KeySym = KeySym(0xffb3);
pub const SYM_KP_4: KeySym = KeySym(0xffb4);
pub const SYM_KP_5: KeySym = KeySym(0xffb5);
pub const SYM_KP_6: KeySym = KeySym(0xffb6);
pub const SYM_KP_7: KeySym = KeySym(0xffb7);
pub const SYM_KP_8: KeySym = KeySym(0xffb8);
pub const SYM_KP_9: KeySym = KeySym(0xffb9);
pub const SYM_F1: KeySym = KeySym(0xffbe);
pub const SYM_F2: KeySym = KeySym(0xffbf);
pub const SYM_F3: KeySym = KeySym(0xffc0);
pub const SYM_F4: KeySym = KeySym(0xffc1);
pub const SYM_F5: KeySym = KeySym(0xffc2);
pub const SYM_F6: KeySym = KeySym(0xffc3);
pub const SYM_F7: KeySym = KeySym(0xffc4);
pub const SYM_F8: KeySym = KeySym(0xffc5);
pub const SYM_F9: KeySym = KeySym(0xffc6);
pub const SYM_F10: KeySym = KeySym(0xffc7);
pub const SYM_F11: KeySym = KeySym(0xffc8);
pub const SYM_L1: KeySym = KeySym(0xffc8);
pub const SYM_F12: KeySym = KeySym(0xffc9);
pub const SYM_L2: KeySym = KeySym(0xffc9);
pub const SYM_F13: KeySym = KeySym(0xffca);
pub const SYM_L3: KeySym = KeySym(0xffca);
pub const SYM_F14: KeySym = KeySym(0xffcb);
pub const SYM_L4: KeySym = KeySym(0xffcb);
pub const SYM_F15: KeySym = KeySym(0xffcc);
pub const SYM_L5: KeySym = KeySym(0xffcc);
pub const SYM_F16: KeySym = KeySym(0xffcd);
pub const SYM_L6: KeySym = KeySym(0xffcd);
pub const SYM_F17: KeySym = KeySym(0xffce);
pub const SYM_L7: KeySym = KeySym(0xffce);
pub const SYM_F18: KeySym = KeySym(0xffcf);
pub const SYM_L8: KeySym = KeySym(0xffcf);
pub const SYM_F19: KeySym = KeySym(0xffd0);
pub const SYM_L9: KeySym = KeySym(0xffd0);
pub const SYM_F20: KeySym = KeySym(0xffd1);
pub const SYM_L10: KeySym = KeySym(0xffd1);
pub const SYM_F21: KeySym = KeySym(0xffd2);
pub const SYM_R1: KeySym = KeySym(0xffd2);
pub const SYM_F22: KeySym = KeySym(0xffd3);
pub const SYM_R2: KeySym = KeySym(0xffd3);
pub const SYM_F23: KeySym = KeySym(0xffd4);
pub const SYM_R3: KeySym = KeySym(0xffd4);
pub const SYM_F24: KeySym = KeySym(0xffd5);
pub const SYM_R4: KeySym = KeySym(0xffd5);
pub const SYM_F25: KeySym = KeySym(0xffd6);
pub const SYM_R5: KeySym = KeySym(0xffd6);
pub const SYM_F26: KeySym = KeySym(0xffd7);
pub const SYM_R6: KeySym = KeySym(0xffd7);
pub const SYM_F27: KeySym = KeySym(0xffd8);
pub const SYM_R7: KeySym = KeySym(0xffd8);
pub const SYM_F28: KeySym = KeySym(0xffd9);
pub const SYM_R8: KeySym = KeySym(0xffd9);
pub const SYM_F29: KeySym = KeySym(0xffda);
pub const SYM_R9: KeySym = KeySym(0xffda);
pub const SYM_F30: KeySym = KeySym(0xffdb);
pub const SYM_R10: KeySym = KeySym(0xffdb);
pub const SYM_F31: KeySym = KeySym(0xffdc);
pub const SYM_R11: KeySym = KeySym(0xffdc);
pub const SYM_F32: KeySym = KeySym(0xffdd);
pub const SYM_R12: KeySym = KeySym(0xffdd);
pub const SYM_F33: KeySym = KeySym(0xffde);
pub const SYM_R13: KeySym = KeySym(0xffde);
pub const SYM_F34: KeySym = KeySym(0xffdf);
pub const SYM_R14: KeySym = KeySym(0xffdf);
pub const SYM_F35: KeySym = KeySym(0xffe0);
pub const SYM_R15: KeySym = KeySym(0xffe0);
pub const SYM_Shift_L: KeySym = KeySym(0xffe1);
pub const SYM_Shift_R: KeySym = KeySym(0xffe2);
pub const SYM_Control_L: KeySym = KeySym(0xffe3);
pub const SYM_Control_R: KeySym = KeySym(0xffe4);
pub const SYM_Caps_Lock: KeySym = KeySym(0xffe5);
pub const SYM_Shift_Lock: KeySym = KeySym(0xffe6);
pub const SYM_Meta_L: KeySym = KeySym(0xffe7);
pub const SYM_Meta_R: KeySym = KeySym(0xffe8);
pub const SYM_Alt_L: KeySym = KeySym(0xffe9);
pub const SYM_Alt_R: KeySym = KeySym(0xffea);
pub const SYM_Super_L: KeySym = KeySym(0xffeb);
pub const SYM_Super_R: KeySym = KeySym(0xffec);
pub const SYM_Hyper_L: KeySym = KeySym(0xffed);
pub const SYM_Hyper_R: KeySym = KeySym(0xffee);
pub const SYM_ISO_Lock: KeySym = KeySym(0xfe01);
pub const SYM_ISO_Level2_Latch: KeySym = KeySym(0xfe02);
pub const SYM_ISO_Level3_Shift: KeySym = KeySym(0xfe03);
pub const SYM_ISO_Level3_Latch: KeySym = KeySym(0xfe04);
pub const SYM_ISO_Level3_Lock: KeySym = KeySym(0xfe05);
pub const SYM_ISO_Level5_Shift: KeySym = KeySym(0xfe11);
pub const SYM_ISO_Level5_Latch: KeySym = KeySym(0xfe12);
pub const SYM_ISO_Level5_Lock: KeySym = KeySym(0xfe13);
pub const SYM_ISO_Group_Shift: KeySym = KeySym(0xff7e);
pub const SYM_ISO_Group_Latch: KeySym = KeySym(0xfe06);
pub const SYM_ISO_Group_Lock: KeySym = KeySym(0xfe07);
pub const SYM_ISO_Next_Group: KeySym = KeySym(0xfe08);
pub const SYM_ISO_Next_Group_Lock: KeySym = KeySym(0xfe09);
pub const SYM_ISO_Prev_Group: KeySym = KeySym(0xfe0a);
pub const SYM_ISO_Prev_Group_Lock: KeySym = KeySym(0xfe0b);
pub const SYM_ISO_First_Group: KeySym = KeySym(0xfe0c);
pub const SYM_ISO_First_Group_Lock: KeySym = KeySym(0xfe0d);
pub const SYM_ISO_Last_Group: KeySym = KeySym(0xfe0e);
pub const SYM_ISO_Last_Group_Lock: KeySym = KeySym(0xfe0f);
pub const SYM_ISO_Left_Tab: KeySym = KeySym(0xfe20);
pub const SYM_ISO_Move_Line_Up: KeySym = KeySym(0xfe21);
pub const SYM_ISO_Move_Line_Down: KeySym = KeySym(0xfe22);
pub const SYM_ISO_Partial_Line_Up: KeySym = KeySym(0xfe23);
pub const SYM_ISO_Partial_Line_Down: KeySym = KeySym(0xfe24);
pub const SYM_ISO_Partial_Space_Left: KeySym = KeySym(0xfe25);
pub const SYM_ISO_Partial_Space_Right: KeySym = KeySym(0xfe26);
pub const SYM_ISO_Set_Margin_Left: KeySym = KeySym(0xfe27);
pub const SYM_ISO_Set_Margin_Right: KeySym = KeySym(0xfe28);
pub const SYM_ISO_Release_Margin_Left: KeySym = KeySym(0xfe29);
pub const SYM_ISO_Release_Margin_Right: KeySym = KeySym(0xfe2a);
pub const SYM_ISO_Release_Both_Margins: KeySym = KeySym(0xfe2b);
pub const SYM_ISO_Fast_Cursor_Left: KeySym = KeySym(0xfe2c);
pub const SYM_ISO_Fast_Cursor_Right: KeySym = KeySym(0xfe2d);
pub const SYM_ISO_Fast_Cursor_Up: KeySym = KeySym(0xfe2e);
pub const SYM_ISO_Fast_Cursor_Down: KeySym = KeySym(0xfe2f);
pub const SYM_ISO_Continuous_Underline: KeySym = KeySym(0xfe30);
pub const SYM_ISO_Discontinuous_Underline: KeySym = KeySym(0xfe31);
pub const SYM_ISO_Emphasize: KeySym = KeySym(0xfe32);
pub const SYM_ISO_Center_Object: KeySym = KeySym(0xfe33);
pub const SYM_ISO_Enter: KeySym = KeySym(0xfe34);
pub const SYM_dead_grave: KeySym = KeySym(0xfe50);
pub const SYM_dead_acute: KeySym = KeySym(0xfe51);
pub const SYM_dead_circumflex: KeySym = KeySym(0xfe52);
pub const SYM_dead_tilde: KeySym = KeySym(0xfe53);
pub const SYM_dead_perispomeni: KeySym = KeySym(0xfe53);
pub const SYM_dead_macron: KeySym = KeySym(0xfe54);
pub const SYM_dead_breve: KeySym = KeySym(0xfe55);
pub const SYM_dead_abovedot: KeySym = KeySym(0xfe56);
pub const SYM_dead_diaeresis: KeySym = KeySym(0xfe57);
pub const SYM_dead_abovering: KeySym = KeySym(0xfe58);
pub const SYM_dead_doubleacute: KeySym = KeySym(0xfe59);
pub const SYM_dead_caron: KeySym = KeySym(0xfe5a);
pub const SYM_dead_cedilla: KeySym = KeySym(0xfe5b);
pub const SYM_dead_ogonek: KeySym = KeySym(0xfe5c);
pub const SYM_dead_iota: KeySym = KeySym(0xfe5d);
pub const SYM_dead_voiced_sound: KeySym = KeySym(0xfe5e);
pub const SYM_dead_semivoiced_sound: KeySym = KeySym(0xfe5f);
pub const SYM_dead_belowdot: KeySym = KeySym(0xfe60);
pub const SYM_dead_hook: KeySym = KeySym(0xfe61);
pub const SYM_dead_horn: KeySym = KeySym(0xfe62);
pub const SYM_dead_stroke: KeySym = KeySym(0xfe63);
pub const SYM_dead_abovecomma: KeySym = KeySym(0xfe64);
pub const SYM_dead_psili: KeySym = KeySym(0xfe64);
pub const SYM_dead_abovereversedcomma: KeySym = KeySym(0xfe65);
pub const SYM_dead_dasia: KeySym = KeySym(0xfe65);
pub const SYM_dead_doublegrave: KeySym = KeySym(0xfe66);
pub const SYM_dead_belowring: KeySym = KeySym(0xfe67);
pub const SYM_dead_belowmacron: KeySym = KeySym(0xfe68);
pub const SYM_dead_belowcircumflex: KeySym = KeySym(0xfe69);
pub const SYM_dead_belowtilde: KeySym = KeySym(0xfe6a);
pub const SYM_dead_belowbreve: KeySym = KeySym(0xfe6b);
pub const SYM_dead_belowdiaeresis: KeySym = KeySym(0xfe6c);
pub const SYM_dead_invertedbreve: KeySym = KeySym(0xfe6d);
pub const SYM_dead_belowcomma: KeySym = KeySym(0xfe6e);
pub const SYM_dead_currency: KeySym = KeySym(0xfe6f);
pub const SYM_dead_lowline: KeySym = KeySym(0xfe90);
pub const SYM_dead_aboveverticalline: KeySym = KeySym(0xfe91);
pub const SYM_dead_belowverticalline: KeySym = KeySym(0xfe92);
pub const SYM_dead_longsolidusoverlay: KeySym = KeySym(0xfe93);
pub const SYM_dead_a: KeySym = KeySym(0xfe80);
pub const SYM_dead_A: KeySym = KeySym(0xfe81);
pub const SYM_dead_e: KeySym = KeySym(0xfe82);
pub const SYM_dead_E: KeySym = KeySym(0xfe83);
pub const SYM_dead_i: KeySym = KeySym(0xfe84);
pub const SYM_dead_I: KeySym = KeySym(0xfe85);
pub const SYM_dead_o: KeySym = KeySym(0xfe86);
pub const SYM_dead_O: KeySym = KeySym(0xfe87);
pub const SYM_dead_u: KeySym = KeySym(0xfe88);
pub const SYM_dead_U: KeySym = KeySym(0xfe89);
pub const SYM_dead_small_schwa: KeySym = KeySym(0xfe8a);
pub const SYM_dead_capital_schwa: KeySym = KeySym(0xfe8b);
pub const SYM_dead_greek: KeySym = KeySym(0xfe8c);
pub const SYM_First_Virtual_Screen: KeySym = KeySym(0xfed0);
pub const SYM_Prev_Virtual_Screen: KeySym = KeySym(0xfed1);
pub const SYM_Next_Virtual_Screen: KeySym = KeySym(0xfed2);
pub const SYM_Last_Virtual_Screen: KeySym = KeySym(0xfed4);
pub const SYM_Terminate_Server: KeySym = KeySym(0xfed5);
pub const SYM_AccessX_Enable: KeySym = KeySym(0xfe70);
pub const SYM_AccessX_Feedback_Enable: KeySym = KeySym(0xfe71);
pub const SYM_RepeatKeys_Enable: KeySym = KeySym(0xfe72);
pub const SYM_SlowKeys_Enable: KeySym = KeySym(0xfe73);
pub const SYM_BounceKeys_Enable: KeySym = KeySym(0xfe74);
pub const SYM_StickyKeys_Enable: KeySym = KeySym(0xfe75);
pub const SYM_MouseKeys_Enable: KeySym = KeySym(0xfe76);
pub const SYM_MouseKeys_Accel_Enable: KeySym = KeySym(0xfe77);
pub const SYM_Overlay1_Enable: KeySym = KeySym(0xfe78);
pub const SYM_Overlay2_Enable: KeySym = KeySym(0xfe79);
pub const SYM_AudibleBell_Enable: KeySym = KeySym(0xfe7a);
pub const SYM_Pointer_Left: KeySym = KeySym(0xfee0);
pub const SYM_Pointer_Right: KeySym = KeySym(0xfee1);
pub const SYM_Pointer_Up: KeySym = KeySym(0xfee2);
pub const SYM_Pointer_Down: KeySym = KeySym(0xfee3);
pub const SYM_Pointer_UpLeft: KeySym = KeySym(0xfee4);
pub const SYM_Pointer_UpRight: KeySym = KeySym(0xfee5);
pub const SYM_Pointer_DownLeft: KeySym = KeySym(0xfee6);
pub const SYM_Pointer_DownRight: KeySym = KeySym(0xfee7);
pub const SYM_Pointer_Button_Dflt: KeySym = KeySym(0xfee8);
pub const SYM_Pointer_Button1: KeySym = KeySym(0xfee9);
pub const SYM_Pointer_Button2: KeySym = KeySym(0xfeea);
pub const SYM_Pointer_Button3: KeySym = KeySym(0xfeeb);
pub const SYM_Pointer_Button4: KeySym = KeySym(0xfeec);
pub const SYM_Pointer_Button5: KeySym = KeySym(0xfeed);
pub const SYM_Pointer_DblClick_Dflt: KeySym = KeySym(0xfeee);
pub const SYM_Pointer_DblClick1: KeySym = KeySym(0xfeef);
pub const SYM_Pointer_DblClick2: KeySym = KeySym(0xfef0);
pub const SYM_Pointer_DblClick3: KeySym = KeySym(0xfef1);
pub const SYM_Pointer_DblClick4: KeySym = KeySym(0xfef2);
pub const SYM_Pointer_DblClick5: KeySym = KeySym(0xfef3);
pub const SYM_Pointer_Drag_Dflt: KeySym = KeySym(0xfef4);
pub const SYM_Pointer_Drag1: KeySym = KeySym(0xfef5);
pub const SYM_Pointer_Drag2: KeySym = KeySym(0xfef6);
pub const SYM_Pointer_Drag3: KeySym = KeySym(0xfef7);
pub const SYM_Pointer_Drag4: KeySym = KeySym(0xfef8);
pub const SYM_Pointer_Drag5: KeySym = KeySym(0xfefd);
pub const SYM_Pointer_EnableKeys: KeySym = KeySym(0xfef9);
pub const SYM_Pointer_Accelerate: KeySym = KeySym(0xfefa);
pub const SYM_Pointer_DfltBtnNext: KeySym = KeySym(0xfefb);
pub const SYM_Pointer_DfltBtnPrev: KeySym = KeySym(0xfefc);
pub const SYM_ch: KeySym = KeySym(0xfea0);
pub const SYM_Ch: KeySym = KeySym(0xfea1);
pub const SYM_CH: KeySym = KeySym(0xfea2);
pub const SYM_c_h: KeySym = KeySym(0xfea3);
pub const SYM_C_h: KeySym = KeySym(0xfea4);
pub const SYM_C_H: KeySym = KeySym(0xfea5);
pub const SYM_3270_Duplicate: KeySym = KeySym(0xfd01);
pub const SYM_3270_FieldMark: KeySym = KeySym(0xfd02);
pub const SYM_3270_Right2: KeySym = KeySym(0xfd03);
pub const SYM_3270_Left2: KeySym = KeySym(0xfd04);
pub const SYM_3270_BackTab: KeySym = KeySym(0xfd05);
pub const SYM_3270_EraseEOF: KeySym = KeySym(0xfd06);
pub const SYM_3270_EraseInput: KeySym = KeySym(0xfd07);
pub const SYM_3270_Reset: KeySym = KeySym(0xfd08);
pub const SYM_3270_Quit: KeySym = KeySym(0xfd09);
pub const SYM_3270_PA1: KeySym = KeySym(0xfd0a);
pub const SYM_3270_PA2: KeySym = KeySym(0xfd0b);
pub const SYM_3270_PA3: KeySym = KeySym(0xfd0c);
pub const SYM_3270_Test: KeySym = KeySym(0xfd0d);
pub const SYM_3270_Attn: KeySym = KeySym(0xfd0e);
pub const SYM_3270_CursorBlink: KeySym = KeySym(0xfd0f);
pub const SYM_3270_AltCursor: KeySym = KeySym(0xfd10);
pub const SYM_3270_KeyClick: KeySym = KeySym(0xfd11);
pub const SYM_3270_Jump: KeySym = KeySym(0xfd12);
pub const SYM_3270_Ident: KeySym = KeySym(0xfd13);
pub const SYM_3270_Rule: KeySym = KeySym(0xfd14);
pub const SYM_3270_Copy: KeySym = KeySym(0xfd15);
pub const SYM_3270_Play: KeySym = KeySym(0xfd16);
pub const SYM_3270_Setup: KeySym = KeySym(0xfd17);
pub const SYM_3270_Record: KeySym = KeySym(0xfd18);
pub const SYM_3270_ChangeScreen: KeySym = KeySym(0xfd19);
pub const SYM_3270_DeleteWord: KeySym = KeySym(0xfd1a);
pub const SYM_3270_ExSelect: KeySym = KeySym(0xfd1b);
pub const SYM_3270_CursorSelect: KeySym = KeySym(0xfd1c);
pub const SYM_3270_PrintScreen: KeySym = KeySym(0xfd1d);
pub const SYM_3270_Enter: KeySym = KeySym(0xfd1e);
pub const SYM_space: KeySym = KeySym(0x0020);
pub const SYM_exclam: KeySym = KeySym(0x0021);
pub const SYM_quotedbl: KeySym = KeySym(0x0022);
pub const SYM_numbersign: KeySym = KeySym(0x0023);
pub const SYM_dollar: KeySym = KeySym(0x0024);
pub const SYM_percent: KeySym = KeySym(0x0025);
pub const SYM_ampersand: KeySym = KeySym(0x0026);
pub const SYM_apostrophe: KeySym = KeySym(0x0027);
pub const SYM_quoteright: KeySym = KeySym(0x0027);
pub const SYM_parenleft: KeySym = KeySym(0x0028);
pub const SYM_parenright: KeySym = KeySym(0x0029);
pub const SYM_asterisk: KeySym = KeySym(0x002a);
pub const SYM_plus: KeySym = KeySym(0x002b);
pub const SYM_comma: KeySym = KeySym(0x002c);
pub const SYM_minus: KeySym = KeySym(0x002d);
pub const SYM_period: KeySym = KeySym(0x002e);
pub const SYM_slash: KeySym = KeySym(0x002f);
pub const SYM_0: KeySym = KeySym(0x0030);
pub const SYM_1: KeySym = KeySym(0x0031);
pub const SYM_2: KeySym = KeySym(0x0032);
pub const SYM_3: KeySym = KeySym(0x0033);
pub const SYM_4: KeySym = KeySym(0x0034);
pub const SYM_5: KeySym = KeySym(0x0035);
pub const SYM_6: KeySym = KeySym(0x0036);
pub const SYM_7: KeySym = KeySym(0x0037);
pub const SYM_8: KeySym = KeySym(0x0038);
pub const SYM_9: KeySym = KeySym(0x0039);
pub const SYM_colon: KeySym = KeySym(0x003a);
pub const SYM_semicolon: KeySym = KeySym(0x003b);
pub const SYM_less: KeySym = KeySym(0x003c);
pub const SYM_equal: KeySym = KeySym(0x003d);
pub const SYM_greater: KeySym = KeySym(0x003e);
pub const SYM_question: KeySym = KeySym(0x003f);
pub const SYM_at: KeySym = KeySym(0x0040);
pub const SYM_A: KeySym = KeySym(0x0041);
pub const SYM_B: KeySym = KeySym(0x0042);
pub const SYM_C: KeySym = KeySym(0x0043);
pub const SYM_D: KeySym = KeySym(0x0044);
pub const SYM_E: KeySym = KeySym(0x0045);
pub const SYM_F: KeySym = KeySym(0x0046);
pub const SYM_G: KeySym = KeySym(0x0047);
pub const SYM_H: KeySym = KeySym(0x0048);
pub const SYM_I: KeySym = KeySym(0x0049);
pub const SYM_J: KeySym = KeySym(0x004a);
pub const SYM_K: KeySym = KeySym(0x004b);
pub const SYM_L: KeySym = KeySym(0x004c);
pub const SYM_M: KeySym = KeySym(0x004d);
pub const SYM_N: KeySym = KeySym(0x004e);
pub const SYM_O: KeySym = KeySym(0x004f);
pub const SYM_P: KeySym = KeySym(0x0050);
pub const SYM_Q: KeySym = KeySym(0x0051);
pub const SYM_R: KeySym = KeySym(0x0052);
pub const SYM_S: KeySym = KeySym(0x0053);
pub const SYM_T: KeySym = KeySym(0x0054);
pub const SYM_U: KeySym = KeySym(0x0055);
pub const SYM_V: KeySym = KeySym(0x0056);
pub const SYM_W: KeySym = KeySym(0x0057);
pub const SYM_X: KeySym = KeySym(0x0058);
pub const SYM_Y: KeySym = KeySym(0x0059);
pub const SYM_Z: KeySym = KeySym(0x005a);
pub const SYM_bracketleft: KeySym = KeySym(0x005b);
pub const SYM_backslash: KeySym = KeySym(0x005c);
pub const SYM_bracketright: KeySym = KeySym(0x005d);
pub const SYM_asciicircum: KeySym = KeySym(0x005e);
pub const SYM_underscore: KeySym = KeySym(0x005f);
pub const SYM_grave: KeySym = KeySym(0x0060);
pub const SYM_quoteleft: KeySym = KeySym(0x0060);
pub const SYM_a: KeySym = KeySym(0x0061);
pub const SYM_b: KeySym = KeySym(0x0062);
pub const SYM_c: KeySym = KeySym(0x0063);
pub const SYM_d: KeySym = KeySym(0x0064);
pub const SYM_e: KeySym = KeySym(0x0065);
pub const SYM_f: KeySym = KeySym(0x0066);
pub const SYM_g: KeySym = KeySym(0x0067);
pub const SYM_h: KeySym = KeySym(0x0068);
pub const SYM_i: KeySym = KeySym(0x0069);
pub const SYM_j: KeySym = KeySym(0x006a);
pub const SYM_k: KeySym = KeySym(0x006b);
pub const SYM_l: KeySym = KeySym(0x006c);
pub const SYM_m: KeySym = KeySym(0x006d);
pub const SYM_n: KeySym = KeySym(0x006e);
pub const SYM_o: KeySym = KeySym(0x006f);
pub const SYM_p: KeySym = KeySym(0x0070);
pub const SYM_q: KeySym = KeySym(0x0071);
pub const SYM_r: KeySym = KeySym(0x0072);
pub const SYM_s: KeySym = KeySym(0x0073);
pub const SYM_t: KeySym = KeySym(0x0074);
pub const SYM_u: KeySym = KeySym(0x0075);
pub const SYM_v: KeySym = KeySym(0x0076);
pub const SYM_w: KeySym = KeySym(0x0077);
pub const SYM_x: KeySym = KeySym(0x0078);
pub const SYM_y: KeySym = KeySym(0x0079);
pub const SYM_z: KeySym = KeySym(0x007a);
pub const SYM_braceleft: KeySym = KeySym(0x007b);
pub const SYM_bar: KeySym = KeySym(0x007c);
pub const SYM_braceright: KeySym = KeySym(0x007d);
pub const SYM_asciitilde: KeySym = KeySym(0x007e);
pub const SYM_nobreakspace: KeySym = KeySym(0x00a0);
pub const SYM_exclamdown: KeySym = KeySym(0x00a1);
pub const SYM_cent: KeySym = KeySym(0x00a2);
pub const SYM_sterling: KeySym = KeySym(0x00a3);
pub const SYM_currency: KeySym = KeySym(0x00a4);
pub const SYM_yen: KeySym = KeySym(0x00a5);
pub const SYM_brokenbar: KeySym = KeySym(0x00a6);
pub const SYM_section: KeySym = KeySym(0x00a7);
pub const SYM_diaeresis: KeySym = KeySym(0x00a8);
pub const SYM_copyright: KeySym = KeySym(0x00a9);
pub const SYM_ordfeminine: KeySym = KeySym(0x00aa);
pub const SYM_guillemotleft: KeySym = KeySym(0x00ab);
pub const SYM_notsign: KeySym = KeySym(0x00ac);
pub const SYM_hyphen: KeySym = KeySym(0x00ad);
pub const SYM_registered: KeySym = KeySym(0x00ae);
pub const SYM_macron: KeySym = KeySym(0x00af);
pub const SYM_degree: KeySym = KeySym(0x00b0);
pub const SYM_plusminus: KeySym = KeySym(0x00b1);
pub const SYM_twosuperior: KeySym = KeySym(0x00b2);
pub const SYM_threesuperior: KeySym = KeySym(0x00b3);
pub const SYM_acute: KeySym = KeySym(0x00b4);
pub const SYM_mu: KeySym = KeySym(0x00b5);
pub const SYM_paragraph: KeySym = KeySym(0x00b6);
pub const SYM_periodcentered: KeySym = KeySym(0x00b7);
pub const SYM_cedilla: KeySym = KeySym(0x00b8);
pub const SYM_onesuperior: KeySym = KeySym(0x00b9);
pub const SYM_masculine: KeySym = KeySym(0x00ba);
pub const SYM_guillemotright: KeySym = KeySym(0x00bb);
pub const SYM_onequarter: KeySym = KeySym(0x00bc);
pub const SYM_onehalf: KeySym = KeySym(0x00bd);
pub const SYM_threequarters: KeySym = KeySym(0x00be);
pub const SYM_questiondown: KeySym = KeySym(0x00bf);
pub const SYM_Agrave: KeySym = KeySym(0x00c0);
pub const SYM_Aacute: KeySym = KeySym(0x00c1);
pub const SYM_Acircumflex: KeySym = KeySym(0x00c2);
pub const SYM_Atilde: KeySym = KeySym(0x00c3);
pub const SYM_Adiaeresis: KeySym = KeySym(0x00c4);
pub const SYM_Aring: KeySym = KeySym(0x00c5);
pub const SYM_AE: KeySym = KeySym(0x00c6);
pub const SYM_Ccedilla: KeySym = KeySym(0x00c7);
pub const SYM_Egrave: KeySym = KeySym(0x00c8);
pub const SYM_Eacute: KeySym = KeySym(0x00c9);
pub const SYM_Ecircumflex: KeySym = KeySym(0x00ca);
pub const SYM_Ediaeresis: KeySym = KeySym(0x00cb);
pub const SYM_Igrave: KeySym = KeySym(0x00cc);
pub const SYM_Iacute: KeySym = KeySym(0x00cd);
pub const SYM_Icircumflex: KeySym = KeySym(0x00ce);
pub const SYM_Idiaeresis: KeySym = KeySym(0x00cf);
pub const SYM_ETH: KeySym = KeySym(0x00d0);
pub const SYM_Eth: KeySym = KeySym(0x00d0);
pub const SYM_Ntilde: KeySym = KeySym(0x00d1);
pub const SYM_Ograve: KeySym = KeySym(0x00d2);
pub const SYM_Oacute: KeySym = KeySym(0x00d3);
pub const SYM_Ocircumflex: KeySym = KeySym(0x00d4);
pub const SYM_Otilde: KeySym = KeySym(0x00d5);
pub const SYM_Odiaeresis: KeySym = KeySym(0x00d6);
pub const SYM_multiply: KeySym = KeySym(0x00d7);
pub const SYM_Oslash: KeySym = KeySym(0x00d8);
pub const SYM_Ooblique: KeySym = KeySym(0x00d8);
pub const SYM_Ugrave: KeySym = KeySym(0x00d9);
pub const SYM_Uacute: KeySym = KeySym(0x00da);
pub const SYM_Ucircumflex: KeySym = KeySym(0x00db);
pub const SYM_Udiaeresis: KeySym = KeySym(0x00dc);
pub const SYM_Yacute: KeySym = KeySym(0x00dd);
pub const SYM_THORN: KeySym = KeySym(0x00de);
pub const SYM_Thorn: KeySym = KeySym(0x00de);
pub const SYM_ssharp: KeySym = KeySym(0x00df);
pub const SYM_agrave: KeySym = KeySym(0x00e0);
pub const SYM_aacute: KeySym = KeySym(0x00e1);
pub const SYM_acircumflex: KeySym = KeySym(0x00e2);
pub const SYM_atilde: KeySym = KeySym(0x00e3);
pub const SYM_adiaeresis: KeySym = KeySym(0x00e4);
pub const SYM_aring: KeySym = KeySym(0x00e5);
pub const SYM_ae: KeySym = KeySym(0x00e6);
pub const SYM_ccedilla: KeySym = KeySym(0x00e7);
pub const SYM_egrave: KeySym = KeySym(0x00e8);
pub const SYM_eacute: KeySym = KeySym(0x00e9);
pub const SYM_ecircumflex: KeySym = KeySym(0x00ea);
pub const SYM_ediaeresis: KeySym = KeySym(0x00eb);
pub const SYM_igrave: KeySym = KeySym(0x00ec);
pub const SYM_iacute: KeySym = KeySym(0x00ed);
pub const SYM_icircumflex: KeySym = KeySym(0x00ee);
pub const SYM_idiaeresis: KeySym = KeySym(0x00ef);
pub const SYM_eth: KeySym = KeySym(0x00f0);
pub const SYM_ntilde: KeySym = KeySym(0x00f1);
pub const SYM_ograve: KeySym = KeySym(0x00f2);
pub const SYM_oacute: KeySym = KeySym(0x00f3);
pub const SYM_ocircumflex: KeySym = KeySym(0x00f4);
pub const SYM_otilde: KeySym = KeySym(0x00f5);
pub const SYM_odiaeresis: KeySym = KeySym(0x00f6);
pub const SYM_division: KeySym = KeySym(0x00f7);
pub const SYM_oslash: KeySym = KeySym(0x00f8);
pub const SYM_ooblique: KeySym = KeySym(0x00f8);
pub const SYM_ugrave: KeySym = KeySym(0x00f9);
pub const SYM_uacute: KeySym = KeySym(0x00fa);
pub const SYM_ucircumflex: KeySym = KeySym(0x00fb);
pub const SYM_udiaeresis: KeySym = KeySym(0x00fc);
pub const SYM_yacute: KeySym = KeySym(0x00fd);
pub const SYM_thorn: KeySym = KeySym(0x00fe);
pub const SYM_ydiaeresis: KeySym = KeySym(0x00ff);
pub const SYM_Aogonek: KeySym = KeySym(0x01a1);
pub const SYM_breve: KeySym = KeySym(0x01a2);
pub const SYM_Lstroke: KeySym = KeySym(0x01a3);
pub const SYM_Lcaron: KeySym = KeySym(0x01a5);
pub const SYM_Sacute: KeySym = KeySym(0x01a6);
pub const SYM_Scaron: KeySym = KeySym(0x01a9);
pub const SYM_Scedilla: KeySym = KeySym(0x01aa);
pub const SYM_Tcaron: KeySym = KeySym(0x01ab);
pub const SYM_Zacute: KeySym = KeySym(0x01ac);
pub const SYM_Zcaron: KeySym = KeySym(0x01ae);
pub const SYM_Zabovedot: KeySym = KeySym(0x01af);
pub const SYM_aogonek: KeySym = KeySym(0x01b1);
pub const SYM_ogonek: KeySym = KeySym(0x01b2);
pub const SYM_lstroke: KeySym = KeySym(0x01b3);
pub const SYM_lcaron: KeySym = KeySym(0x01b5);
pub const SYM_sacute: KeySym = KeySym(0x01b6);
pub const SYM_caron: KeySym = KeySym(0x01b7);
pub const SYM_scaron: KeySym = KeySym(0x01b9);
pub const SYM_scedilla: KeySym = KeySym(0x01ba);
pub const SYM_tcaron: KeySym = KeySym(0x01bb);
pub const SYM_zacute: KeySym = KeySym(0x01bc);
pub const SYM_doubleacute: KeySym = KeySym(0x01bd);
pub const SYM_zcaron: KeySym = KeySym(0x01be);
pub const SYM_zabovedot: KeySym = KeySym(0x01bf);
pub const SYM_Racute: KeySym = KeySym(0x01c0);
pub const SYM_Abreve: KeySym = KeySym(0x01c3);
pub const SYM_Lacute: KeySym = KeySym(0x01c5);
pub const SYM_Cacute: KeySym = KeySym(0x01c6);
pub const SYM_Ccaron: KeySym = KeySym(0x01c8);
pub const SYM_Eogonek: KeySym = KeySym(0x01ca);
pub const SYM_Ecaron: KeySym = KeySym(0x01cc);
pub const SYM_Dcaron: KeySym = KeySym(0x01cf);
pub const SYM_Dstroke: KeySym = KeySym(0x01d0);
pub const SYM_Nacute: KeySym = KeySym(0x01d1);
pub const SYM_Ncaron: KeySym = KeySym(0x01d2);
pub const SYM_Odoubleacute: KeySym = KeySym(0x01d5);
pub const SYM_Rcaron: KeySym = KeySym(0x01d8);
pub const SYM_Uring: KeySym = KeySym(0x01d9);
pub const SYM_Udoubleacute: KeySym = KeySym(0x01db);
pub const SYM_Tcedilla: KeySym = KeySym(0x01de);
pub const SYM_racute: KeySym = KeySym(0x01e0);
pub const SYM_abreve: KeySym = KeySym(0x01e3);
pub const SYM_lacute: KeySym = KeySym(0x01e5);
pub const SYM_cacute: KeySym = KeySym(0x01e6);
pub const SYM_ccaron: KeySym = KeySym(0x01e8);
pub const SYM_eogonek: KeySym = KeySym(0x01ea);
pub const SYM_ecaron: KeySym = KeySym(0x01ec);
pub const SYM_dcaron: KeySym = KeySym(0x01ef);
pub const SYM_dstroke: KeySym = KeySym(0x01f0);
pub const SYM_nacute: KeySym = KeySym(0x01f1);
pub const SYM_ncaron: KeySym = KeySym(0x01f2);
pub const SYM_odoubleacute: KeySym = KeySym(0x01f5);
pub const SYM_rcaron: KeySym = KeySym(0x01f8);
pub const SYM_uring: KeySym = KeySym(0x01f9);
pub const SYM_udoubleacute: KeySym = KeySym(0x01fb);
pub const SYM_tcedilla: KeySym = KeySym(0x01fe);
pub const SYM_abovedot: KeySym = KeySym(0x01ff);
pub const SYM_Hstroke: KeySym = KeySym(0x02a1);
pub const SYM_Hcircumflex: KeySym = KeySym(0x02a6);
pub const SYM_Iabovedot: KeySym = KeySym(0x02a9);
pub const SYM_Gbreve: KeySym = KeySym(0x02ab);
pub const SYM_Jcircumflex: KeySym = KeySym(0x02ac);
pub const SYM_hstroke: KeySym = KeySym(0x02b1);
pub const SYM_hcircumflex: KeySym = KeySym(0x02b6);
pub const SYM_idotless: KeySym = KeySym(0x02b9);
pub const SYM_gbreve: KeySym = KeySym(0x02bb);
pub const SYM_jcircumflex: KeySym = KeySym(0x02bc);
pub const SYM_Cabovedot: KeySym = KeySym(0x02c5);
pub const SYM_Ccircumflex: KeySym = KeySym(0x02c6);
pub const SYM_Gabovedot: KeySym = KeySym(0x02d5);
pub const SYM_Gcircumflex: KeySym = KeySym(0x02d8);
pub const SYM_Ubreve: KeySym = KeySym(0x02dd);
pub const SYM_Scircumflex: KeySym = KeySym(0x02de);
pub const SYM_cabovedot: KeySym = KeySym(0x02e5);
pub const SYM_ccircumflex: KeySym = KeySym(0x02e6);
pub const SYM_gabovedot: KeySym = KeySym(0x02f5);
pub const SYM_gcircumflex: KeySym = KeySym(0x02f8);
pub const SYM_ubreve: KeySym = KeySym(0x02fd);
pub const SYM_scircumflex: KeySym = KeySym(0x02fe);
pub const SYM_kra: KeySym = KeySym(0x03a2);
pub const SYM_kappa: KeySym = KeySym(0x03a2);
pub const SYM_Rcedilla: KeySym = KeySym(0x03a3);
pub const SYM_Itilde: KeySym = KeySym(0x03a5);
pub const SYM_Lcedilla: KeySym = KeySym(0x03a6);
pub const SYM_Emacron: KeySym = KeySym(0x03aa);
pub const SYM_Gcedilla: KeySym = KeySym(0x03ab);
pub const SYM_Tslash: KeySym = KeySym(0x03ac);
pub const SYM_rcedilla: KeySym = KeySym(0x03b3);
pub const SYM_itilde: KeySym = KeySym(0x03b5);
pub const SYM_lcedilla: KeySym = KeySym(0x03b6);
pub const SYM_emacron: KeySym = KeySym(0x03ba);
pub const SYM_gcedilla: KeySym = KeySym(0x03bb);
pub const SYM_tslash: KeySym = KeySym(0x03bc);
pub const SYM_ENG: KeySym = KeySym(0x03bd);
pub const SYM_eng: KeySym = KeySym(0x03bf);
pub const SYM_Amacron: KeySym = KeySym(0x03c0);
pub const SYM_Iogonek: KeySym = KeySym(0x03c7);
pub const SYM_Eabovedot: KeySym = KeySym(0x03cc);
pub const SYM_Imacron: KeySym = KeySym(0x03cf);
pub const SYM_Ncedilla: KeySym = KeySym(0x03d1);
pub const SYM_Omacron: KeySym = KeySym(0x03d2);
pub const SYM_Kcedilla: KeySym = KeySym(0x03d3);
pub const SYM_Uogonek: KeySym = KeySym(0x03d9);
pub const SYM_Utilde: KeySym = KeySym(0x03dd);
pub const SYM_Umacron: KeySym = KeySym(0x03de);
pub const SYM_amacron: KeySym = KeySym(0x03e0);
pub const SYM_iogonek: KeySym = KeySym(0x03e7);
pub const SYM_eabovedot: KeySym = KeySym(0x03ec);
pub const SYM_imacron: KeySym = KeySym(0x03ef);
pub const SYM_ncedilla: KeySym = KeySym(0x03f1);
pub const SYM_omacron: KeySym = KeySym(0x03f2);
pub const SYM_kcedilla: KeySym = KeySym(0x03f3);
pub const SYM_uogonek: KeySym = KeySym(0x03f9);
pub const SYM_utilde: KeySym = KeySym(0x03fd);
pub const SYM_umacron: KeySym = KeySym(0x03fe);
pub const SYM_Wcircumflex: KeySym = KeySym(0x1000174);
pub const SYM_wcircumflex: KeySym = KeySym(0x1000175);
pub const SYM_Ycircumflex: KeySym = KeySym(0x1000176);
pub const SYM_ycircumflex: KeySym = KeySym(0x1000177);
pub const SYM_Babovedot: KeySym = KeySym(0x1001e02);
pub const SYM_babovedot: KeySym = KeySym(0x1001e03);
pub const SYM_Dabovedot: KeySym = KeySym(0x1001e0a);
pub const SYM_dabovedot: KeySym = KeySym(0x1001e0b);
pub const SYM_Fabovedot: KeySym = KeySym(0x1001e1e);
pub const SYM_fabovedot: KeySym = KeySym(0x1001e1f);
pub const SYM_Mabovedot: KeySym = KeySym(0x1001e40);
pub const SYM_mabovedot: KeySym = KeySym(0x1001e41);
pub const SYM_Pabovedot: KeySym = KeySym(0x1001e56);
pub const SYM_pabovedot: KeySym = KeySym(0x1001e57);
pub const SYM_Sabovedot: KeySym = KeySym(0x1001e60);
pub const SYM_sabovedot: KeySym = KeySym(0x1001e61);
pub const SYM_Tabovedot: KeySym = KeySym(0x1001e6a);
pub const SYM_tabovedot: KeySym = KeySym(0x1001e6b);
pub const SYM_Wgrave: KeySym = KeySym(0x1001e80);
pub const SYM_wgrave: KeySym = KeySym(0x1001e81);
pub const SYM_Wacute: KeySym = KeySym(0x1001e82);
pub const SYM_wacute: KeySym = KeySym(0x1001e83);
pub const SYM_Wdiaeresis: KeySym = KeySym(0x1001e84);
pub const SYM_wdiaeresis: KeySym = KeySym(0x1001e85);
pub const SYM_Ygrave: KeySym = KeySym(0x1001ef2);
pub const SYM_ygrave: KeySym = KeySym(0x1001ef3);
pub const SYM_OE: KeySym = KeySym(0x13bc);
pub const SYM_oe: KeySym = KeySym(0x13bd);
pub const SYM_Ydiaeresis: KeySym = KeySym(0x13be);
pub const SYM_overline: KeySym = KeySym(0x047e);
pub const SYM_kana_fullstop: KeySym = KeySym(0x04a1);
pub const SYM_kana_openingbracket: KeySym = KeySym(0x04a2);
pub const SYM_kana_closingbracket: KeySym = KeySym(0x04a3);
pub const SYM_kana_comma: KeySym = KeySym(0x04a4);
pub const SYM_kana_conjunctive: KeySym = KeySym(0x04a5);
pub const SYM_kana_middledot: KeySym = KeySym(0x04a5);
pub const SYM_kana_WO: KeySym = KeySym(0x04a6);
pub const SYM_kana_a: KeySym = KeySym(0x04a7);
pub const SYM_kana_i: KeySym = KeySym(0x04a8);
pub const SYM_kana_u: KeySym = KeySym(0x04a9);
pub const SYM_kana_e: KeySym = KeySym(0x04aa);
pub const SYM_kana_o: KeySym = KeySym(0x04ab);
pub const SYM_kana_ya: KeySym = KeySym(0x04ac);
pub const SYM_kana_yu: KeySym = KeySym(0x04ad);
pub const SYM_kana_yo: KeySym = KeySym(0x04ae);
pub const SYM_kana_tsu: KeySym = KeySym(0x04af);
pub const SYM_kana_tu: KeySym = KeySym(0x04af);
pub const SYM_prolongedsound: KeySym = KeySym(0x04b0);
pub const SYM_kana_A: KeySym = KeySym(0x04b1);
pub const SYM_kana_I: KeySym = KeySym(0x04b2);
pub const SYM_kana_U: KeySym = KeySym(0x04b3);
pub const SYM_kana_E: KeySym = KeySym(0x04b4);
pub const SYM_kana_O: KeySym = KeySym(0x04b5);
pub const SYM_kana_KA: KeySym = KeySym(0x04b6);
pub const SYM_kana_KI: KeySym = KeySym(0x04b7);
pub const SYM_kana_KU: KeySym = KeySym(0x04b8);
pub const SYM_kana_KE: KeySym = KeySym(0x04b9);
pub const SYM_kana_KO: KeySym = KeySym(0x04ba);
pub const SYM_kana_SA: KeySym = KeySym(0x04bb);
pub const SYM_kana_SHI: KeySym = KeySym(0x04bc);
pub const SYM_kana_SU: KeySym = KeySym(0x04bd);
pub const SYM_kana_SE: KeySym = KeySym(0x04be);
pub const SYM_kana_SO: KeySym = KeySym(0x04bf);
pub const SYM_kana_TA: KeySym = KeySym(0x04c0);
pub const SYM_kana_CHI: KeySym = KeySym(0x04c1);
pub const SYM_kana_TI: KeySym = KeySym(0x04c1);
pub const SYM_kana_TSU: KeySym = KeySym(0x04c2);
pub const SYM_kana_TU: KeySym = KeySym(0x04c2);
pub const SYM_kana_TE: KeySym = KeySym(0x04c3);
pub const SYM_kana_TO: KeySym = KeySym(0x04c4);
pub const SYM_kana_NA: KeySym = KeySym(0x04c5);
pub const SYM_kana_NI: KeySym = KeySym(0x04c6);
pub const SYM_kana_NU: KeySym = KeySym(0x04c7);
pub const SYM_kana_NE: KeySym = KeySym(0x04c8);
pub const SYM_kana_NO: KeySym = KeySym(0x04c9);
pub const SYM_kana_HA: KeySym = KeySym(0x04ca);
pub const SYM_kana_HI: KeySym = KeySym(0x04cb);
pub const SYM_kana_FU: KeySym = KeySym(0x04cc);
pub const SYM_kana_HU: KeySym = KeySym(0x04cc);
pub const SYM_kana_HE: KeySym = KeySym(0x04cd);
pub const SYM_kana_HO: KeySym = KeySym(0x04ce);
pub const SYM_kana_MA: KeySym = KeySym(0x04cf);
pub const SYM_kana_MI: KeySym = KeySym(0x04d0);
pub const SYM_kana_MU: KeySym = KeySym(0x04d1);
pub const SYM_kana_ME: KeySym = KeySym(0x04d2);
pub const SYM_kana_MO: KeySym = KeySym(0x04d3);
pub const SYM_kana_YA: KeySym = KeySym(0x04d4);
pub const SYM_kana_YU: KeySym = KeySym(0x04d5);
pub const SYM_kana_YO: KeySym = KeySym(0x04d6);
pub const SYM_kana_RA: KeySym = KeySym(0x04d7);
pub const SYM_kana_RI: KeySym = KeySym(0x04d8);
pub const SYM_kana_RU: KeySym = KeySym(0x04d9);
pub const SYM_kana_RE: KeySym = KeySym(0x04da);
pub const SYM_kana_RO: KeySym = KeySym(0x04db);
pub const SYM_kana_WA: KeySym = KeySym(0x04dc);
pub const SYM_kana_N: KeySym = KeySym(0x04dd);
pub const SYM_voicedsound: KeySym = KeySym(0x04de);
pub const SYM_semivoicedsound: KeySym = KeySym(0x04df);
pub const SYM_kana_switch: KeySym = KeySym(0xff7e);
pub const SYM_Farsi_0: KeySym = KeySym(0x10006f0);
pub const SYM_Farsi_1: KeySym = KeySym(0x10006f1);
pub const SYM_Farsi_2: KeySym = KeySym(0x10006f2);
pub const SYM_Farsi_3: KeySym = KeySym(0x10006f3);
pub const SYM_Farsi_4: KeySym = KeySym(0x10006f4);
pub const SYM_Farsi_5: KeySym = KeySym(0x10006f5);
pub const SYM_Farsi_6: KeySym = KeySym(0x10006f6);
pub const SYM_Farsi_7: KeySym = KeySym(0x10006f7);
pub const SYM_Farsi_8: KeySym = KeySym(0x10006f8);
pub const SYM_Farsi_9: KeySym = KeySym(0x10006f9);
pub const SYM_Arabic_percent: KeySym = KeySym(0x100066a);
pub const SYM_Arabic_superscript_alef: KeySym = KeySym(0x1000670);
pub const SYM_Arabic_tteh: KeySym = KeySym(0x1000679);
pub const SYM_Arabic_peh: KeySym = KeySym(0x100067e);
pub const SYM_Arabic_tcheh: KeySym = KeySym(0x1000686);
pub const SYM_Arabic_ddal: KeySym = KeySym(0x1000688);
pub const SYM_Arabic_rreh: KeySym = KeySym(0x1000691);
pub const SYM_Arabic_comma: KeySym = KeySym(0x05ac);
pub const SYM_Arabic_fullstop: KeySym = KeySym(0x10006d4);
pub const SYM_Arabic_0: KeySym = KeySym(0x1000660);
pub const SYM_Arabic_1: KeySym = KeySym(0x1000661);
pub const SYM_Arabic_2: KeySym = KeySym(0x1000662);
pub const SYM_Arabic_3: KeySym = KeySym(0x1000663);
pub const SYM_Arabic_4: KeySym = KeySym(0x1000664);
pub const SYM_Arabic_5: KeySym = KeySym(0x1000665);
pub const SYM_Arabic_6: KeySym = KeySym(0x1000666);
pub const SYM_Arabic_7: KeySym = KeySym(0x1000667);
pub const SYM_Arabic_8: KeySym = KeySym(0x1000668);
pub const SYM_Arabic_9: KeySym = KeySym(0x1000669);
pub const SYM_Arabic_semicolon: KeySym = KeySym(0x05bb);
pub const SYM_Arabic_question_mark: KeySym = KeySym(0x05bf);
pub const SYM_Arabic_hamza: KeySym = KeySym(0x05c1);
pub const SYM_Arabic_maddaonalef: KeySym = KeySym(0x05c2);
pub const SYM_Arabic_hamzaonalef: KeySym = KeySym(0x05c3);
pub const SYM_Arabic_hamzaonwaw: KeySym = KeySym(0x05c4);
pub const SYM_Arabic_hamzaunderalef: KeySym = KeySym(0x05c5);
pub const SYM_Arabic_hamzaonyeh: KeySym = KeySym(0x05c6);
pub const SYM_Arabic_alef: KeySym = KeySym(0x05c7);
pub const SYM_Arabic_beh: KeySym = KeySym(0x05c8);
pub const SYM_Arabic_tehmarbuta: KeySym = KeySym(0x05c9);
pub const SYM_Arabic_teh: KeySym = KeySym(0x05ca);
pub const SYM_Arabic_theh: KeySym = KeySym(0x05cb);
pub const SYM_Arabic_jeem: KeySym = KeySym(0x05cc);
pub const SYM_Arabic_hah: KeySym = KeySym(0x05cd);
pub const SYM_Arabic_khah: KeySym = KeySym(0x05ce);
pub const SYM_Arabic_dal: KeySym = KeySym(0x05cf);
pub const SYM_Arabic_thal: KeySym = KeySym(0x05d0);
pub const SYM_Arabic_ra: KeySym = KeySym(0x05d1);
pub const SYM_Arabic_zain: KeySym = KeySym(0x05d2);
pub const SYM_Arabic_seen: KeySym = KeySym(0x05d3);
pub const SYM_Arabic_sheen: KeySym = KeySym(0x05d4);
pub const SYM_Arabic_sad: KeySym = KeySym(0x05d5);
pub const SYM_Arabic_dad: KeySym = KeySym(0x05d6);
pub const SYM_Arabic_tah: KeySym = KeySym(0x05d7);
pub const SYM_Arabic_zah: KeySym = KeySym(0x05d8);
pub const SYM_Arabic_ain: KeySym = KeySym(0x05d9);
pub const SYM_Arabic_ghain: KeySym = KeySym(0x05da);
pub const SYM_Arabic_tatweel: KeySym = KeySym(0x05e0);
pub const SYM_Arabic_feh: KeySym = KeySym(0x05e1);
pub const SYM_Arabic_qaf: KeySym = KeySym(0x05e2);
pub const SYM_Arabic_kaf: KeySym = KeySym(0x05e3);
pub const SYM_Arabic_lam: KeySym = KeySym(0x05e4);
pub const SYM_Arabic_meem: KeySym = KeySym(0x05e5);
pub const SYM_Arabic_noon: KeySym = KeySym(0x05e6);
pub const SYM_Arabic_ha: KeySym = KeySym(0x05e7);
pub const SYM_Arabic_heh: KeySym = KeySym(0x05e7);
pub const SYM_Arabic_waw: KeySym = KeySym(0x05e8);
pub const SYM_Arabic_alefmaksura: KeySym = KeySym(0x05e9);
pub const SYM_Arabic_yeh: KeySym = KeySym(0x05ea);
pub const SYM_Arabic_fathatan: KeySym = KeySym(0x05eb);
pub const SYM_Arabic_dammatan: KeySym = KeySym(0x05ec);
pub const SYM_Arabic_kasratan: KeySym = KeySym(0x05ed);
pub const SYM_Arabic_fatha: KeySym = KeySym(0x05ee);
pub const SYM_Arabic_damma: KeySym = KeySym(0x05ef);
pub const SYM_Arabic_kasra: KeySym = KeySym(0x05f0);
pub const SYM_Arabic_shadda: KeySym = KeySym(0x05f1);
pub const SYM_Arabic_sukun: KeySym = KeySym(0x05f2);
pub const SYM_Arabic_madda_above: KeySym = KeySym(0x1000653);
pub const SYM_Arabic_hamza_above: KeySym = KeySym(0x1000654);
pub const SYM_Arabic_hamza_below: KeySym = KeySym(0x1000655);
pub const SYM_Arabic_jeh: KeySym = KeySym(0x1000698);
pub const SYM_Arabic_veh: KeySym = KeySym(0x10006a4);
pub const SYM_Arabic_keheh: KeySym = KeySym(0x10006a9);
pub const SYM_Arabic_gaf: KeySym = KeySym(0x10006af);
pub const SYM_Arabic_noon_ghunna: KeySym = KeySym(0x10006ba);
pub const SYM_Arabic_heh_doachashmee: KeySym = KeySym(0x10006be);
pub const SYM_Farsi_yeh: KeySym = KeySym(0x10006cc);
pub const SYM_Arabic_farsi_yeh: KeySym = KeySym(0x10006cc);
pub const SYM_Arabic_yeh_baree: KeySym = KeySym(0x10006d2);
pub const SYM_Arabic_heh_goal: KeySym = KeySym(0x10006c1);
pub const SYM_Arabic_switch: KeySym = KeySym(0xff7e);
pub const SYM_Cyrillic_GHE_bar: KeySym = KeySym(0x1000492);
pub const SYM_Cyrillic_ghe_bar: KeySym = KeySym(0x1000493);
pub const SYM_Cyrillic_ZHE_descender: KeySym = KeySym(0x1000496);
pub const SYM_Cyrillic_zhe_descender: KeySym = KeySym(0x1000497);
pub const SYM_Cyrillic_KA_descender: KeySym = KeySym(0x100049a);
pub const SYM_Cyrillic_ka_descender: KeySym = KeySym(0x100049b);
pub const SYM_Cyrillic_KA_vertstroke: KeySym = KeySym(0x100049c);
pub const SYM_Cyrillic_ka_vertstroke: KeySym = KeySym(0x100049d);
pub const SYM_Cyrillic_EN_descender: KeySym = KeySym(0x10004a2);
pub const SYM_Cyrillic_en_descender: KeySym = KeySym(0x10004a3);
pub const SYM_Cyrillic_U_straight: KeySym = KeySym(0x10004ae);
pub const SYM_Cyrillic_u_straight: KeySym = KeySym(0x10004af);
pub const SYM_Cyrillic_U_straight_bar: KeySym = KeySym(0x10004b0);
pub const SYM_Cyrillic_u_straight_bar: KeySym = KeySym(0x10004b1);
pub const SYM_Cyrillic_HA_descender: KeySym = KeySym(0x10004b2);
pub const SYM_Cyrillic_ha_descender: KeySym = KeySym(0x10004b3);
pub const SYM_Cyrillic_CHE_descender: KeySym = KeySym(0x10004b6);
pub const SYM_Cyrillic_che_descender: KeySym = KeySym(0x10004b7);
pub const SYM_Cyrillic_CHE_vertstroke: KeySym = KeySym(0x10004b8);
pub const SYM_Cyrillic_che_vertstroke: KeySym = KeySym(0x10004b9);
pub const SYM_Cyrillic_SHHA: KeySym = KeySym(0x10004ba);
pub const SYM_Cyrillic_shha: KeySym = KeySym(0x10004bb);
pub const SYM_Cyrillic_SCHWA: KeySym = KeySym(0x10004d8);
pub const SYM_Cyrillic_schwa: KeySym = KeySym(0x10004d9);
pub const SYM_Cyrillic_I_macron: KeySym = KeySym(0x10004e2);
pub const SYM_Cyrillic_i_macron: KeySym = KeySym(0x10004e3);
pub const SYM_Cyrillic_O_bar: KeySym = KeySym(0x10004e8);
pub const SYM_Cyrillic_o_bar: KeySym = KeySym(0x10004e9);
pub const SYM_Cyrillic_U_macron: KeySym = KeySym(0x10004ee);
pub const SYM_Cyrillic_u_macron: KeySym = KeySym(0x10004ef);
pub const SYM_Serbian_dje: KeySym = KeySym(0x06a1);
pub const SYM_Macedonia_gje: KeySym = KeySym(0x06a2);
pub const SYM_Cyrillic_io: KeySym = KeySym(0x06a3);
pub const SYM_Ukrainian_ie: KeySym = KeySym(0x06a4);
pub const SYM_Ukranian_je: KeySym = KeySym(0x06a4);
pub const SYM_Macedonia_dse: KeySym = KeySym(0x06a5);
pub const SYM_Ukrainian_i: KeySym = KeySym(0x06a6);
pub const SYM_Ukranian_i: KeySym = KeySym(0x06a6);
pub const SYM_Ukrainian_yi: KeySym = KeySym(0x06a7);
pub const SYM_Ukranian_yi: KeySym = KeySym(0x06a7);
pub const SYM_Cyrillic_je: KeySym = KeySym(0x06a8);
pub const SYM_Serbian_je: KeySym = KeySym(0x06a8);
pub const SYM_Cyrillic_lje: KeySym = KeySym(0x06a9);
pub const SYM_Serbian_lje: KeySym = KeySym(0x06a9);
pub const SYM_Cyrillic_nje: KeySym = KeySym(0x06aa);
pub const SYM_Serbian_nje: KeySym = KeySym(0x06aa);
pub const SYM_Serbian_tshe: KeySym = KeySym(0x06ab);
pub const SYM_Macedonia_kje: KeySym = KeySym(0x06ac);
pub const SYM_Ukrainian_ghe_with_upturn: KeySym = KeySym(0x06ad);
pub const SYM_Byelorussian_shortu: KeySym = KeySym(0x06ae);
pub const SYM_Cyrillic_dzhe: KeySym = KeySym(0x06af);
pub const SYM_Serbian_dze: KeySym = KeySym(0x06af);
pub const SYM_numerosign: KeySym = KeySym(0x06b0);
pub const SYM_Serbian_DJE: KeySym = KeySym(0x06b1);
pub const SYM_Macedonia_GJE: KeySym = KeySym(0x06b2);
pub const SYM_Cyrillic_IO: KeySym = KeySym(0x06b3);
pub const SYM_Ukrainian_IE: KeySym = KeySym(0x06b4);
pub const SYM_Ukranian_JE: KeySym = KeySym(0x06b4);
pub const SYM_Macedonia_DSE: KeySym = KeySym(0x06b5);
pub const SYM_Ukrainian_I: KeySym = KeySym(0x06b6);
pub const SYM_Ukranian_I: KeySym = KeySym(0x06b6);
pub const SYM_Ukrainian_YI: KeySym = KeySym(0x06b7);
pub const SYM_Ukranian_YI: KeySym = KeySym(0x06b7);
pub const SYM_Cyrillic_JE: KeySym = KeySym(0x06b8);
pub const SYM_Serbian_JE: KeySym = KeySym(0x06b8);
pub const SYM_Cyrillic_LJE: KeySym = KeySym(0x06b9);
pub const SYM_Serbian_LJE: KeySym = KeySym(0x06b9);
pub const SYM_Cyrillic_NJE: KeySym = KeySym(0x06ba);
pub const SYM_Serbian_NJE: KeySym = KeySym(0x06ba);
pub const SYM_Serbian_TSHE: KeySym = KeySym(0x06bb);
pub const SYM_Macedonia_KJE: KeySym = KeySym(0x06bc);
pub const SYM_Ukrainian_GHE_WITH_UPTURN: KeySym = KeySym(0x06bd);
pub const SYM_Byelorussian_SHORTU: KeySym = KeySym(0x06be);
pub const SYM_Cyrillic_DZHE: KeySym = KeySym(0x06bf);
pub const SYM_Serbian_DZE: KeySym = KeySym(0x06bf);
pub const SYM_Cyrillic_yu: KeySym = KeySym(0x06c0);
pub const SYM_Cyrillic_a: KeySym = KeySym(0x06c1);
pub const SYM_Cyrillic_be: KeySym = KeySym(0x06c2);
pub const SYM_Cyrillic_tse: KeySym = KeySym(0x06c3);
pub const SYM_Cyrillic_de: KeySym = KeySym(0x06c4);
pub const SYM_Cyrillic_ie: KeySym = KeySym(0x06c5);
pub const SYM_Cyrillic_ef: KeySym = KeySym(0x06c6);
pub const SYM_Cyrillic_ghe: KeySym = KeySym(0x06c7);
pub const SYM_Cyrillic_ha: KeySym = KeySym(0x06c8);
pub const SYM_Cyrillic_i: KeySym = KeySym(0x06c9);
pub const SYM_Cyrillic_shorti: KeySym = KeySym(0x06ca);
pub const SYM_Cyrillic_ka: KeySym = KeySym(0x06cb);
pub const SYM_Cyrillic_el: KeySym = KeySym(0x06cc);
pub const SYM_Cyrillic_em: KeySym = KeySym(0x06cd);
pub const SYM_Cyrillic_en: KeySym = KeySym(0x06ce);
pub const SYM_Cyrillic_o: KeySym = KeySym(0x06cf);
pub const SYM_Cyrillic_pe: KeySym = KeySym(0x06d0);
pub const SYM_Cyrillic_ya: KeySym = KeySym(0x06d1);
pub const SYM_Cyrillic_er: KeySym = KeySym(0x06d2);
pub const SYM_Cyrillic_es: KeySym = KeySym(0x06d3);
pub const SYM_Cyrillic_te: KeySym = KeySym(0x06d4);
pub const SYM_Cyrillic_u: KeySym = KeySym(0x06d5);
pub const SYM_Cyrillic_zhe: KeySym = KeySym(0x06d6);
pub const SYM_Cyrillic_ve: KeySym = KeySym(0x06d7);
pub const SYM_Cyrillic_softsign: KeySym = KeySym(0x06d8);
pub const SYM_Cyrillic_yeru: KeySym = KeySym(0x06d9);
pub const SYM_Cyrillic_ze: KeySym = KeySym(0x06da);
pub const SYM_Cyrillic_sha: KeySym = KeySym(0x06db);
pub const SYM_Cyrillic_e: KeySym = KeySym(0x06dc);
pub const SYM_Cyrillic_shcha: KeySym = KeySym(0x06dd);
pub const SYM_Cyrillic_che: KeySym = KeySym(0x06de);
pub const SYM_Cyrillic_hardsign: KeySym = KeySym(0x06df);
pub const SYM_Cyrillic_YU: KeySym = KeySym(0x06e0);
pub const SYM_Cyrillic_A: KeySym = KeySym(0x06e1);
pub const SYM_Cyrillic_BE: KeySym = KeySym(0x06e2);
pub const SYM_Cyrillic_TSE: KeySym = KeySym(0x06e3);
pub const SYM_Cyrillic_DE: KeySym = KeySym(0x06e4);
pub const SYM_Cyrillic_IE: KeySym = KeySym(0x06e5);
pub const SYM_Cyrillic_EF: KeySym = KeySym(0x06e6);
pub const SYM_Cyrillic_GHE: KeySym = KeySym(0x06e7);
pub const SYM_Cyrillic_HA: KeySym = KeySym(0x06e8);
pub const SYM_Cyrillic_I: KeySym = KeySym(0x06e9);
pub const SYM_Cyrillic_SHORTI: KeySym = KeySym(0x06ea);
pub const SYM_Cyrillic_KA: KeySym = KeySym(0x06eb);
pub const SYM_Cyrillic_EL: KeySym = KeySym(0x06ec);
pub const SYM_Cyrillic_EM: KeySym = KeySym(0x06ed);
pub const SYM_Cyrillic_EN: KeySym = KeySym(0x06ee);
pub const SYM_Cyrillic_O: KeySym = KeySym(0x06ef);
pub const SYM_Cyrillic_PE: KeySym = KeySym(0x06f0);
pub const SYM_Cyrillic_YA: KeySym = KeySym(0x06f1);
pub const SYM_Cyrillic_ER: KeySym = KeySym(0x06f2);
pub const SYM_Cyrillic_ES: KeySym = KeySym(0x06f3);
pub const SYM_Cyrillic_TE: KeySym = KeySym(0x06f4);
pub const SYM_Cyrillic_U: KeySym = KeySym(0x06f5);
pub const SYM_Cyrillic_ZHE: KeySym = KeySym(0x06f6);
pub const SYM_Cyrillic_VE: KeySym = KeySym(0x06f7);
pub const SYM_Cyrillic_SOFTSIGN: KeySym = KeySym(0x06f8);
pub const SYM_Cyrillic_YERU: KeySym = KeySym(0x06f9);
pub const SYM_Cyrillic_ZE: KeySym = KeySym(0x06fa);
pub const SYM_Cyrillic_SHA: KeySym = KeySym(0x06fb);
pub const SYM_Cyrillic_E: KeySym = KeySym(0x06fc);
pub const SYM_Cyrillic_SHCHA: KeySym = KeySym(0x06fd);
pub const SYM_Cyrillic_CHE: KeySym = KeySym(0x06fe);
pub const SYM_Cyrillic_HARDSIGN: KeySym = KeySym(0x06ff);
pub const SYM_Greek_ALPHAaccent: KeySym = KeySym(0x07a1);
pub const SYM_Greek_EPSILONaccent: KeySym = KeySym(0x07a2);
pub const SYM_Greek_ETAaccent: KeySym = KeySym(0x07a3);
pub const SYM_Greek_IOTAaccent: KeySym = KeySym(0x07a4);
pub const SYM_Greek_IOTAdieresis: KeySym = KeySym(0x07a5);
pub const SYM_Greek_IOTAdiaeresis: KeySym = KeySym(0x07a5);
pub const SYM_Greek_OMICRONaccent: KeySym = KeySym(0x07a7);
pub const SYM_Greek_UPSILONaccent: KeySym = KeySym(0x07a8);
pub const SYM_Greek_UPSILONdieresis: KeySym = KeySym(0x07a9);
pub const SYM_Greek_OMEGAaccent: KeySym = KeySym(0x07ab);
pub const SYM_Greek_accentdieresis: KeySym = KeySym(0x07ae);
pub const SYM_Greek_horizbar: KeySym = KeySym(0x07af);
pub const SYM_Greek_alphaaccent: KeySym = KeySym(0x07b1);
pub const SYM_Greek_epsilonaccent: KeySym = KeySym(0x07b2);
pub const SYM_Greek_etaaccent: KeySym = KeySym(0x07b3);
pub const SYM_Greek_iotaaccent: KeySym = KeySym(0x07b4);
pub const SYM_Greek_iotadieresis: KeySym = KeySym(0x07b5);
pub const SYM_Greek_iotaaccentdieresis: KeySym = KeySym(0x07b6);
pub const SYM_Greek_omicronaccent: KeySym = KeySym(0x07b7);
pub const SYM_Greek_upsilonaccent: KeySym = KeySym(0x07b8);
pub const SYM_Greek_upsilondieresis: KeySym = KeySym(0x07b9);
pub const SYM_Greek_upsilonaccentdieresis: KeySym = KeySym(0x07ba);
pub const SYM_Greek_omegaaccent: KeySym = KeySym(0x07bb);
pub const SYM_Greek_ALPHA: KeySym = KeySym(0x07c1);
pub const SYM_Greek_BETA: KeySym = KeySym(0x07c2);
pub const SYM_Greek_GAMMA: KeySym = KeySym(0x07c3);
pub const SYM_Greek_DELTA: KeySym = KeySym(0x07c4);
pub const SYM_Greek_EPSILON: KeySym = KeySym(0x07c5);
pub const SYM_Greek_ZETA: KeySym = KeySym(0x07c6);
pub const SYM_Greek_ETA: KeySym = KeySym(0x07c7);
pub const SYM_Greek_THETA: KeySym = KeySym(0x07c8);
pub const SYM_Greek_IOTA: KeySym = KeySym(0x07c9);
pub const SYM_Greek_KAPPA: KeySym = KeySym(0x07ca);
pub const SYM_Greek_LAMDA: KeySym = KeySym(0x07cb);
pub const SYM_Greek_LAMBDA: KeySym = KeySym(0x07cb);
pub const SYM_Greek_MU: KeySym = KeySym(0x07cc);
pub const SYM_Greek_NU: KeySym = KeySym(0x07cd);
pub const SYM_Greek_XI: KeySym = KeySym(0x07ce);
pub const SYM_Greek_OMICRON: KeySym = KeySym(0x07cf);
pub const SYM_Greek_PI: KeySym = KeySym(0x07d0);
pub const SYM_Greek_RHO: KeySym = KeySym(0x07d1);
pub const SYM_Greek_SIGMA: KeySym = KeySym(0x07d2);
pub const SYM_Greek_TAU: KeySym = KeySym(0x07d4);
pub const SYM_Greek_UPSILON: KeySym = KeySym(0x07d5);
pub const SYM_Greek_PHI: KeySym = KeySym(0x07d6);
pub const SYM_Greek_CHI: KeySym = KeySym(0x07d7);
pub const SYM_Greek_PSI: KeySym = KeySym(0x07d8);
pub const SYM_Greek_OMEGA: KeySym = KeySym(0x07d9);
pub const SYM_Greek_alpha: KeySym = KeySym(0x07e1);
pub const SYM_Greek_beta: KeySym = KeySym(0x07e2);
pub const SYM_Greek_gamma: KeySym = KeySym(0x07e3);
pub const SYM_Greek_delta: KeySym = KeySym(0x07e4);
pub const SYM_Greek_epsilon: KeySym = KeySym(0x07e5);
pub const SYM_Greek_zeta: KeySym = KeySym(0x07e6);
pub const SYM_Greek_eta: KeySym = KeySym(0x07e7);
pub const SYM_Greek_theta: KeySym = KeySym(0x07e8);
pub const SYM_Greek_iota: KeySym = KeySym(0x07e9);
pub const SYM_Greek_kappa: KeySym = KeySym(0x07ea);
pub const SYM_Greek_lamda: KeySym = KeySym(0x07eb);
pub const SYM_Greek_lambda: KeySym = KeySym(0x07eb);
pub const SYM_Greek_mu: KeySym = KeySym(0x07ec);
pub const SYM_Greek_nu: KeySym = KeySym(0x07ed);
pub const SYM_Greek_xi: KeySym = KeySym(0x07ee);
pub const SYM_Greek_omicron: KeySym = KeySym(0x07ef);
pub const SYM_Greek_pi: KeySym = KeySym(0x07f0);
pub const SYM_Greek_rho: KeySym = KeySym(0x07f1);
pub const SYM_Greek_sigma: KeySym = KeySym(0x07f2);
pub const SYM_Greek_finalsmallsigma: KeySym = KeySym(0x07f3);
pub const SYM_Greek_tau: KeySym = KeySym(0x07f4);
pub const SYM_Greek_upsilon: KeySym = KeySym(0x07f5);
pub const SYM_Greek_phi: KeySym = KeySym(0x07f6);
pub const SYM_Greek_chi: KeySym = KeySym(0x07f7);
pub const SYM_Greek_psi: KeySym = KeySym(0x07f8);
pub const SYM_Greek_omega: KeySym = KeySym(0x07f9);
pub const SYM_Greek_switch: KeySym = KeySym(0xff7e);
pub const SYM_leftradical: KeySym = KeySym(0x08a1);
pub const SYM_topleftradical: KeySym = KeySym(0x08a2);
pub const SYM_horizconnector: KeySym = KeySym(0x08a3);
pub const SYM_topintegral: KeySym = KeySym(0x08a4);
pub const SYM_botintegral: KeySym = KeySym(0x08a5);
pub const SYM_vertconnector: KeySym = KeySym(0x08a6);
pub const SYM_topleftsqbracket: KeySym = KeySym(0x08a7);
pub const SYM_botleftsqbracket: KeySym = KeySym(0x08a8);
pub const SYM_toprightsqbracket: KeySym = KeySym(0x08a9);
pub const SYM_botrightsqbracket: KeySym = KeySym(0x08aa);
pub const SYM_topleftparens: KeySym = KeySym(0x08ab);
pub const SYM_botleftparens: KeySym = KeySym(0x08ac);
pub const SYM_toprightparens: KeySym = KeySym(0x08ad);
pub const SYM_botrightparens: KeySym = KeySym(0x08ae);
pub const SYM_leftmiddlecurlybrace: KeySym = KeySym(0x08af);
pub const SYM_rightmiddlecurlybrace: KeySym = KeySym(0x08b0);
pub const SYM_topleftsummation: KeySym = KeySym(0x08b1);
pub const SYM_botleftsummation: KeySym = KeySym(0x08b2);
pub const SYM_topvertsummationconnector: KeySym = KeySym(0x08b3);
pub const SYM_botvertsummationconnector: KeySym = KeySym(0x08b4);
pub const SYM_toprightsummation: KeySym = KeySym(0x08b5);
pub const SYM_botrightsummation: KeySym = KeySym(0x08b6);
pub const SYM_rightmiddlesummation: KeySym = KeySym(0x08b7);
pub const SYM_lessthanequal: KeySym = KeySym(0x08bc);
pub const SYM_notequal: KeySym = KeySym(0x08bd);
pub const SYM_greaterthanequal: KeySym = KeySym(0x08be);
pub const SYM_integral: KeySym = KeySym(0x08bf);
pub const SYM_therefore: KeySym = KeySym(0x08c0);
pub const SYM_variation: KeySym = KeySym(0x08c1);
pub const SYM_infinity: KeySym = KeySym(0x08c2);
pub const SYM_nabla: KeySym = KeySym(0x08c5);
pub const SYM_approximate: KeySym = KeySym(0x08c8);
pub const SYM_similarequal: KeySym = KeySym(0x08c9);
pub const SYM_ifonlyif: KeySym = KeySym(0x08cd);
pub const SYM_implies: KeySym = KeySym(0x08ce);
pub const SYM_identical: KeySym = KeySym(0x08cf);
pub const SYM_radical: KeySym = KeySym(0x08d6);
pub const SYM_includedin: KeySym = KeySym(0x08da);
pub const SYM_includes: KeySym = KeySym(0x08db);
pub const SYM_intersection: KeySym = KeySym(0x08dc);
pub const SYM_union: KeySym = KeySym(0x08dd);
pub const SYM_logicaland: KeySym = KeySym(0x08de);
pub const SYM_logicalor: KeySym = KeySym(0x08df);
pub const SYM_partialderivative: KeySym = KeySym(0x08ef);
pub const SYM_function: KeySym = KeySym(0x08f6);
pub const SYM_leftarrow: KeySym = KeySym(0x08fb);
pub const SYM_uparrow: KeySym = KeySym(0x08fc);
pub const SYM_rightarrow: KeySym = KeySym(0x08fd);
pub const SYM_downarrow: KeySym = KeySym(0x08fe);
pub const SYM_blank: KeySym = KeySym(0x09df);
pub const SYM_soliddiamond: KeySym = KeySym(0x09e0);
pub const SYM_checkerboard: KeySym = KeySym(0x09e1);
pub const SYM_ht: KeySym = KeySym(0x09e2);
pub const SYM_ff: KeySym = KeySym(0x09e3);
pub const SYM_cr: KeySym = KeySym(0x09e4);
pub const SYM_lf: KeySym = KeySym(0x09e5);
pub const SYM_nl: KeySym = KeySym(0x09e8);
pub const SYM_vt: KeySym = KeySym(0x09e9);
pub const SYM_lowrightcorner: KeySym = KeySym(0x09ea);
pub const SYM_uprightcorner: KeySym = KeySym(0x09eb);
pub const SYM_upleftcorner: KeySym = KeySym(0x09ec);
pub const SYM_lowleftcorner: KeySym = KeySym(0x09ed);
pub const SYM_crossinglines: KeySym = KeySym(0x09ee);
pub const SYM_horizlinescan1: KeySym = KeySym(0x09ef);
pub const SYM_horizlinescan3: KeySym = KeySym(0x09f0);
pub const SYM_horizlinescan5: KeySym = KeySym(0x09f1);
pub const SYM_horizlinescan7: KeySym = KeySym(0x09f2);
pub const SYM_horizlinescan9: KeySym = KeySym(0x09f3);
pub const SYM_leftt: KeySym = KeySym(0x09f4);
pub const SYM_rightt: KeySym = KeySym(0x09f5);
pub const SYM_bott: KeySym = KeySym(0x09f6);
pub const SYM_topt: KeySym = KeySym(0x09f7);
pub const SYM_vertbar: KeySym = KeySym(0x09f8);
pub const SYM_emspace: KeySym = KeySym(0x0aa1);
pub const SYM_enspace: KeySym = KeySym(0x0aa2);
pub const SYM_em3space: KeySym = KeySym(0x0aa3);
pub const SYM_em4space: KeySym = KeySym(0x0aa4);
pub const SYM_digitspace: KeySym = KeySym(0x0aa5);
pub const SYM_punctspace: KeySym = KeySym(0x0aa6);
pub const SYM_thinspace: KeySym = KeySym(0x0aa7);
pub const SYM_hairspace: KeySym = KeySym(0x0aa8);
pub const SYM_emdash: KeySym = KeySym(0x0aa9);
pub const SYM_endash: KeySym = KeySym(0x0aaa);
pub const SYM_signifblank: KeySym = KeySym(0x0aac);
pub const SYM_ellipsis: KeySym = KeySym(0x0aae);
pub const SYM_doubbaselinedot: KeySym = KeySym(0x0aaf);
pub const SYM_onethird: KeySym = KeySym(0x0ab0);
pub const SYM_twothirds: KeySym = KeySym(0x0ab1);
pub const SYM_onefifth: KeySym = KeySym(0x0ab2);
pub const SYM_twofifths: KeySym = KeySym(0x0ab3);
pub const SYM_threefifths: KeySym = KeySym(0x0ab4);
pub const SYM_fourfifths: KeySym = KeySym(0x0ab5);
pub const SYM_onesixth: KeySym = KeySym(0x0ab6);
pub const SYM_fivesixths: KeySym = KeySym(0x0ab7);
pub const SYM_careof: KeySym = KeySym(0x0ab8);
pub const SYM_figdash: KeySym = KeySym(0x0abb);
pub const SYM_leftanglebracket: KeySym = KeySym(0x0abc);
pub const SYM_decimalpoint: KeySym = KeySym(0x0abd);
pub const SYM_rightanglebracket: KeySym = KeySym(0x0abe);
pub const SYM_marker: KeySym = KeySym(0x0abf);
pub const SYM_oneeighth: KeySym = KeySym(0x0ac3);
pub const SYM_threeeighths: KeySym = KeySym(0x0ac4);
pub const SYM_fiveeighths: KeySym = KeySym(0x0ac5);
pub const SYM_seveneighths: KeySym = KeySym(0x0ac6);
pub const SYM_trademark: KeySym = KeySym(0x0ac9);
pub const SYM_signaturemark: KeySym = KeySym(0x0aca);
pub const SYM_trademarkincircle: KeySym = KeySym(0x0acb);
pub const SYM_leftopentriangle: KeySym = KeySym(0x0acc);
pub const SYM_rightopentriangle: KeySym = KeySym(0x0acd);
pub const SYM_emopencircle: KeySym = KeySym(0x0ace);
pub const SYM_emopenrectangle: KeySym = KeySym(0x0acf);
pub const SYM_leftsinglequotemark: KeySym = KeySym(0x0ad0);
pub const SYM_rightsinglequotemark: KeySym = KeySym(0x0ad1);
pub const SYM_leftdoublequotemark: KeySym = KeySym(0x0ad2);
pub const SYM_rightdoublequotemark: KeySym = KeySym(0x0ad3);
pub const SYM_prescription: KeySym = KeySym(0x0ad4);
pub const SYM_permille: KeySym = KeySym(0x0ad5);
pub const SYM_minutes: KeySym = KeySym(0x0ad6);
pub const SYM_seconds: KeySym = KeySym(0x0ad7);
pub const SYM_latincross: KeySym = KeySym(0x0ad9);
pub const SYM_hexagram: KeySym = KeySym(0x0ada);
pub const SYM_filledrectbullet: KeySym = KeySym(0x0adb);
pub const SYM_filledlefttribullet: KeySym = KeySym(0x0adc);
pub const SYM_filledrighttribullet: KeySym = KeySym(0x0add);
pub const SYM_emfilledcircle: KeySym = KeySym(0x0ade);
pub const SYM_emfilledrect: KeySym = KeySym(0x0adf);
pub const SYM_enopencircbullet: KeySym = KeySym(0x0ae0);
pub const SYM_enopensquarebullet: KeySym = KeySym(0x0ae1);
pub const SYM_openrectbullet: KeySym = KeySym(0x0ae2);
pub const SYM_opentribulletup: KeySym = KeySym(0x0ae3);
pub const SYM_opentribulletdown: KeySym = KeySym(0x0ae4);
pub const SYM_openstar: KeySym = KeySym(0x0ae5);
pub const SYM_enfilledcircbullet: KeySym = KeySym(0x0ae6);
pub const SYM_enfilledsqbullet: KeySym = KeySym(0x0ae7);
pub const SYM_filledtribulletup: KeySym = KeySym(0x0ae8);
pub const SYM_filledtribulletdown: KeySym = KeySym(0x0ae9);
pub const SYM_leftpointer: KeySym = KeySym(0x0aea);
pub const SYM_rightpointer: KeySym = KeySym(0x0aeb);
pub const SYM_club: KeySym = KeySym(0x0aec);
pub const SYM_diamond: KeySym = KeySym(0x0aed);
pub const SYM_heart: KeySym = KeySym(0x0aee);
pub const SYM_maltesecross: KeySym = KeySym(0x0af0);
pub const SYM_dagger: KeySym = KeySym(0x0af1);
pub const SYM_doubledagger: KeySym = KeySym(0x0af2);
pub const SYM_checkmark: KeySym = KeySym(0x0af3);
pub const SYM_ballotcross: KeySym = KeySym(0x0af4);
pub const SYM_musicalsharp: KeySym = KeySym(0x0af5);
pub const SYM_musicalflat: KeySym = KeySym(0x0af6);
pub const SYM_malesymbol: KeySym = KeySym(0x0af7);
pub const SYM_femalesymbol: KeySym = KeySym(0x0af8);
pub const SYM_telephone: KeySym = KeySym(0x0af9);
pub const SYM_telephonerecorder: KeySym = KeySym(0x0afa);
pub const SYM_phonographcopyright: KeySym = KeySym(0x0afb);
pub const SYM_caret: KeySym = KeySym(0x0afc);
pub const SYM_singlelowquotemark: KeySym = KeySym(0x0afd);
pub const SYM_doublelowquotemark: KeySym = KeySym(0x0afe);
pub const SYM_cursor: KeySym = KeySym(0x0aff);
pub const SYM_leftcaret: KeySym = KeySym(0x0ba3);
pub const SYM_rightcaret: KeySym = KeySym(0x0ba6);
pub const SYM_downcaret: KeySym = KeySym(0x0ba8);
pub const SYM_upcaret: KeySym = KeySym(0x0ba9);
pub const SYM_overbar: KeySym = KeySym(0x0bc0);
pub const SYM_downtack: KeySym = KeySym(0x0bc2);
pub const SYM_upshoe: KeySym = KeySym(0x0bc3);
pub const SYM_downstile: KeySym = KeySym(0x0bc4);
pub const SYM_underbar: KeySym = KeySym(0x0bc6);
pub const SYM_jot: KeySym = KeySym(0x0bca);
pub const SYM_quad: KeySym = KeySym(0x0bcc);
pub const SYM_uptack: KeySym = KeySym(0x0bce);
pub const SYM_circle: KeySym = KeySym(0x0bcf);
pub const SYM_upstile: KeySym = KeySym(0x0bd3);
pub const SYM_downshoe: KeySym = KeySym(0x0bd6);
pub const SYM_rightshoe: KeySym = KeySym(0x0bd8);
pub const SYM_leftshoe: KeySym = KeySym(0x0bda);
pub const SYM_lefttack: KeySym = KeySym(0x0bdc);
pub const SYM_righttack: KeySym = KeySym(0x0bfc);
pub const SYM_hebrew_doublelowline: KeySym = KeySym(0x0cdf);
pub const SYM_hebrew_aleph: KeySym = KeySym(0x0ce0);
pub const SYM_hebrew_bet: KeySym = KeySym(0x0ce1);
pub const SYM_hebrew_beth: KeySym = KeySym(0x0ce1);
pub const SYM_hebrew_gimel: KeySym = KeySym(0x0ce2);
pub const SYM_hebrew_gimmel: KeySym = KeySym(0x0ce2);
pub const SYM_hebrew_dalet: KeySym = KeySym(0x0ce3);
pub const SYM_hebrew_daleth: KeySym = KeySym(0x0ce3);
pub const SYM_hebrew_he: KeySym = KeySym(0x0ce4);
pub const SYM_hebrew_waw: KeySym = KeySym(0x0ce5);
pub const SYM_hebrew_zain: KeySym = KeySym(0x0ce6);
pub const SYM_hebrew_zayin: KeySym = KeySym(0x0ce6);
pub const SYM_hebrew_chet: KeySym = KeySym(0x0ce7);
pub const SYM_hebrew_het: KeySym = KeySym(0x0ce7);
pub const SYM_hebrew_tet: KeySym = KeySym(0x0ce8);
pub const SYM_hebrew_teth: KeySym = KeySym(0x0ce8);
pub const SYM_hebrew_yod: KeySym = KeySym(0x0ce9);
pub const SYM_hebrew_finalkaph: KeySym = KeySym(0x0cea);
pub const SYM_hebrew_kaph: KeySym = KeySym(0x0ceb);
pub const SYM_hebrew_lamed: KeySym = KeySym(0x0cec);
pub const SYM_hebrew_finalmem: KeySym = KeySym(0x0ced);
pub const SYM_hebrew_mem: KeySym = KeySym(0x0cee);
pub const SYM_hebrew_finalnun: KeySym = KeySym(0x0cef);
pub const SYM_hebrew_nun: KeySym = KeySym(0x0cf0);
pub const SYM_hebrew_samech: KeySym = KeySym(0x0cf1);
pub const SYM_hebrew_samekh: KeySym = KeySym(0x0cf1);
pub const SYM_hebrew_ayin: KeySym = KeySym(0x0cf2);
pub const SYM_hebrew_finalpe: KeySym = KeySym(0x0cf3);
pub const SYM_hebrew_pe: KeySym = KeySym(0x0cf4);
pub const SYM_hebrew_finalzade: KeySym = KeySym(0x0cf5);
pub const SYM_hebrew_finalzadi: KeySym = KeySym(0x0cf5);
pub const SYM_hebrew_zade: KeySym = KeySym(0x0cf6);
pub const SYM_hebrew_zadi: KeySym = KeySym(0x0cf6);
pub const SYM_hebrew_qoph: KeySym = KeySym(0x0cf7);
pub const SYM_hebrew_kuf: KeySym = KeySym(0x0cf7);
pub const SYM_hebrew_resh: KeySym = KeySym(0x0cf8);
pub const SYM_hebrew_shin: KeySym = KeySym(0x0cf9);
pub const SYM_hebrew_taw: KeySym = KeySym(0x0cfa);
pub const SYM_hebrew_taf: KeySym = KeySym(0x0cfa);
pub const SYM_Hebrew_switch: KeySym = KeySym(0xff7e);
pub const SYM_Thai_kokai: KeySym = KeySym(0x0da1);
pub const SYM_Thai_khokhai: KeySym = KeySym(0x0da2);
pub const SYM_Thai_khokhuat: KeySym = KeySym(0x0da3);
pub const SYM_Thai_khokhwai: KeySym = KeySym(0x0da4);
pub const SYM_Thai_khokhon: KeySym = KeySym(0x0da5);
pub const SYM_Thai_khorakhang: KeySym = KeySym(0x0da6);
pub const SYM_Thai_ngongu: KeySym = KeySym(0x0da7);
pub const SYM_Thai_chochan: KeySym = KeySym(0x0da8);
pub const SYM_Thai_choching: KeySym = KeySym(0x0da9);
pub const SYM_Thai_chochang: KeySym = KeySym(0x0daa);
pub const SYM_Thai_soso: KeySym = KeySym(0x0dab);
pub const SYM_Thai_chochoe: KeySym = KeySym(0x0dac);
pub const SYM_Thai_yoying: KeySym = KeySym(0x0dad);
pub const SYM_Thai_dochada: KeySym = KeySym(0x0dae);
pub const SYM_Thai_topatak: KeySym = KeySym(0x0daf);
pub const SYM_Thai_thothan: KeySym = KeySym(0x0db0);
pub const SYM_Thai_thonangmontho: KeySym = KeySym(0x0db1);
pub const SYM_Thai_thophuthao: KeySym = KeySym(0x0db2);
pub const SYM_Thai_nonen: KeySym = KeySym(0x0db3);
pub const SYM_Thai_dodek: KeySym = KeySym(0x0db4);
pub const SYM_Thai_totao: KeySym = KeySym(0x0db5);
pub const SYM_Thai_thothung: KeySym = KeySym(0x0db6);
pub const SYM_Thai_thothahan: KeySym = KeySym(0x0db7);
pub const SYM_Thai_thothong: KeySym = KeySym(0x0db8);
pub const SYM_Thai_nonu: KeySym = KeySym(0x0db9);
pub const SYM_Thai_bobaimai: KeySym = KeySym(0x0dba);
pub const SYM_Thai_popla: KeySym = KeySym(0x0dbb);
pub const SYM_Thai_phophung: KeySym = KeySym(0x0dbc);
pub const SYM_Thai_fofa: KeySym = KeySym(0x0dbd);
pub const SYM_Thai_phophan: KeySym = KeySym(0x0dbe);
pub const SYM_Thai_fofan: KeySym = KeySym(0x0dbf);
pub const SYM_Thai_phosamphao: KeySym = KeySym(0x0dc0);
pub const SYM_Thai_moma: KeySym = KeySym(0x0dc1);
pub const SYM_Thai_yoyak: KeySym = KeySym(0x0dc2);
pub const SYM_Thai_rorua: KeySym = KeySym(0x0dc3);
pub const SYM_Thai_ru: KeySym = KeySym(0x0dc4);
pub const SYM_Thai_loling: KeySym = KeySym(0x0dc5);
pub const SYM_Thai_lu: KeySym = KeySym(0x0dc6);
pub const SYM_Thai_wowaen: KeySym = KeySym(0x0dc7);
pub const SYM_Thai_sosala: KeySym = KeySym(0x0dc8);
pub const SYM_Thai_sorusi: KeySym = KeySym(0x0dc9);
pub const SYM_Thai_sosua: KeySym = KeySym(0x0dca);
pub const SYM_Thai_hohip: KeySym = KeySym(0x0dcb);
pub const SYM_Thai_lochula: KeySym = KeySym(0x0dcc);
pub const SYM_Thai_oang: KeySym = KeySym(0x0dcd);
pub const SYM_Thai_honokhuk: KeySym = KeySym(0x0dce);
pub const SYM_Thai_paiyannoi: KeySym = KeySym(0x0dcf);
pub const SYM_Thai_saraa: KeySym = KeySym(0x0dd0);
pub const SYM_Thai_maihanakat: KeySym = KeySym(0x0dd1);
pub const SYM_Thai_saraaa: KeySym = KeySym(0x0dd2);
pub const SYM_Thai_saraam: KeySym = KeySym(0x0dd3);
pub const SYM_Thai_sarai: KeySym = KeySym(0x0dd4);
pub const SYM_Thai_saraii: KeySym = KeySym(0x0dd5);
pub const SYM_Thai_saraue: KeySym = KeySym(0x0dd6);
pub const SYM_Thai_sarauee: KeySym = KeySym(0x0dd7);
pub const SYM_Thai_sarau: KeySym = KeySym(0x0dd8);
pub const SYM_Thai_sarauu: KeySym = KeySym(0x0dd9);
pub const SYM_Thai_phinthu: KeySym = KeySym(0x0dda);
pub const SYM_Thai_maihanakat_maitho: KeySym = KeySym(0x0dde);
pub const SYM_Thai_baht: KeySym = KeySym(0x0ddf);
pub const SYM_Thai_sarae: KeySym = KeySym(0x0de0);
pub const SYM_Thai_saraae: KeySym = KeySym(0x0de1);
pub const SYM_Thai_sarao: KeySym = KeySym(0x0de2);
pub const SYM_Thai_saraaimaimuan: KeySym = KeySym(0x0de3);
pub const SYM_Thai_saraaimaimalai: KeySym = KeySym(0x0de4);
pub const SYM_Thai_lakkhangyao: KeySym = KeySym(0x0de5);
pub const SYM_Thai_maiyamok: KeySym = KeySym(0x0de6);
pub const SYM_Thai_maitaikhu: KeySym = KeySym(0x0de7);
pub const SYM_Thai_maiek: KeySym = KeySym(0x0de8);
pub const SYM_Thai_maitho: KeySym = KeySym(0x0de9);
pub const SYM_Thai_maitri: KeySym = KeySym(0x0dea);
pub const SYM_Thai_maichattawa: KeySym = KeySym(0x0deb);
pub const SYM_Thai_thanthakhat: KeySym = KeySym(0x0dec);
pub const SYM_Thai_nikhahit: KeySym = KeySym(0x0ded);
pub const SYM_Thai_leksun: KeySym = KeySym(0x0df0);
pub const SYM_Thai_leknung: KeySym = KeySym(0x0df1);
pub const SYM_Thai_leksong: KeySym = KeySym(0x0df2);
pub const SYM_Thai_leksam: KeySym = KeySym(0x0df3);
pub const SYM_Thai_leksi: KeySym = KeySym(0x0df4);
pub const SYM_Thai_lekha: KeySym = KeySym(0x0df5);
pub const SYM_Thai_lekhok: KeySym = KeySym(0x0df6);
pub const SYM_Thai_lekchet: KeySym = KeySym(0x0df7);
pub const SYM_Thai_lekpaet: KeySym = KeySym(0x0df8);
pub const SYM_Thai_lekkao: KeySym = KeySym(0x0df9);
pub const SYM_Hangul: KeySym = KeySym(0xff31);
pub const SYM_Hangul_Start: KeySym = KeySym(0xff32);
pub const SYM_Hangul_End: KeySym = KeySym(0xff33);
pub const SYM_Hangul_Hanja: KeySym = KeySym(0xff34);
pub const SYM_Hangul_Jamo: KeySym = KeySym(0xff35);
pub const SYM_Hangul_Romaja: KeySym = KeySym(0xff36);
pub const SYM_Hangul_Codeinput: KeySym = KeySym(0xff37);
pub const SYM_Hangul_Jeonja: KeySym = KeySym(0xff38);
pub const SYM_Hangul_Banja: KeySym = KeySym(0xff39);
pub const SYM_Hangul_PreHanja: KeySym = KeySym(0xff3a);
pub const SYM_Hangul_PostHanja: KeySym = KeySym(0xff3b);
pub const SYM_Hangul_SingleCandidate: KeySym = KeySym(0xff3c);
pub const SYM_Hangul_MultipleCandidate: KeySym = KeySym(0xff3d);
pub const SYM_Hangul_PreviousCandidate: KeySym = KeySym(0xff3e);
pub const SYM_Hangul_Special: KeySym = KeySym(0xff3f);
pub const SYM_Hangul_switch: KeySym = KeySym(0xff7e);
pub const SYM_Hangul_Kiyeog: KeySym = KeySym(0x0ea1);
pub const SYM_Hangul_SsangKiyeog: KeySym = KeySym(0x0ea2);
pub const SYM_Hangul_KiyeogSios: KeySym = KeySym(0x0ea3);
pub const SYM_Hangul_Nieun: KeySym = KeySym(0x0ea4);
pub const SYM_Hangul_NieunJieuj: KeySym = KeySym(0x0ea5);
pub const SYM_Hangul_NieunHieuh: KeySym = KeySym(0x0ea6);
pub const SYM_Hangul_Dikeud: KeySym = KeySym(0x0ea7);
pub const SYM_Hangul_SsangDikeud: KeySym = KeySym(0x0ea8);
pub const SYM_Hangul_Rieul: KeySym = KeySym(0x0ea9);
pub const SYM_Hangul_RieulKiyeog: KeySym = KeySym(0x0eaa);
pub const SYM_Hangul_RieulMieum: KeySym = KeySym(0x0eab);
pub const SYM_Hangul_RieulPieub: KeySym = KeySym(0x0eac);
pub const SYM_Hangul_RieulSios: KeySym = KeySym(0x0ead);
pub const SYM_Hangul_RieulTieut: KeySym = KeySym(0x0eae);
pub const SYM_Hangul_RieulPhieuf: KeySym = KeySym(0x0eaf);
pub const SYM_Hangul_RieulHieuh: KeySym = KeySym(0x0eb0);
pub const SYM_Hangul_Mieum: KeySym = KeySym(0x0eb1);
pub const SYM_Hangul_Pieub: KeySym = KeySym(0x0eb2);
pub const SYM_Hangul_SsangPieub: KeySym = KeySym(0x0eb3);
pub const SYM_Hangul_PieubSios: KeySym = KeySym(0x0eb4);
pub const SYM_Hangul_Sios: KeySym = KeySym(0x0eb5);
pub const SYM_Hangul_SsangSios: KeySym = KeySym(0x0eb6);
pub const SYM_Hangul_Ieung: KeySym = KeySym(0x0eb7);
pub const SYM_Hangul_Jieuj: KeySym = KeySym(0x0eb8);
pub const SYM_Hangul_SsangJieuj: KeySym = KeySym(0x0eb9);
pub const SYM_Hangul_Cieuc: KeySym = KeySym(0x0eba);
pub const SYM_Hangul_Khieuq: KeySym = KeySym(0x0ebb);
pub const SYM_Hangul_Tieut: KeySym = KeySym(0x0ebc);
pub const SYM_Hangul_Phieuf: KeySym = KeySym(0x0ebd);
pub const SYM_Hangul_Hieuh: KeySym = KeySym(0x0ebe);
pub const SYM_Hangul_A: KeySym = KeySym(0x0ebf);
pub const SYM_Hangul_AE: KeySym = KeySym(0x0ec0);
pub const SYM_Hangul_YA: KeySym = KeySym(0x0ec1);
pub const SYM_Hangul_YAE: KeySym = KeySym(0x0ec2);
pub const SYM_Hangul_EO: KeySym = KeySym(0x0ec3);
pub const SYM_Hangul_E: KeySym = KeySym(0x0ec4);
pub const SYM_Hangul_YEO: KeySym = KeySym(0x0ec5);
pub const SYM_Hangul_YE: KeySym = KeySym(0x0ec6);
pub const SYM_Hangul_O: KeySym = KeySym(0x0ec7);
pub const SYM_Hangul_WA: KeySym = KeySym(0x0ec8);
pub const SYM_Hangul_WAE: KeySym = KeySym(0x0ec9);
pub const SYM_Hangul_OE: KeySym = KeySym(0x0eca);
pub const SYM_Hangul_YO: KeySym = KeySym(0x0ecb);
pub const SYM_Hangul_U: KeySym = KeySym(0x0ecc);
pub const SYM_Hangul_WEO: KeySym = KeySym(0x0ecd);
pub const SYM_Hangul_WE: KeySym = KeySym(0x0ece);
pub const SYM_Hangul_WI: KeySym = KeySym(0x0ecf);
pub const SYM_Hangul_YU: KeySym = KeySym(0x0ed0);
pub const SYM_Hangul_EU: KeySym = KeySym(0x0ed1);
pub const SYM_Hangul_YI: KeySym = KeySym(0x0ed2);
pub const SYM_Hangul_I: KeySym = KeySym(0x0ed3);
pub const SYM_Hangul_J_Kiyeog: KeySym = KeySym(0x0ed4);
pub const SYM_Hangul_J_SsangKiyeog: KeySym = KeySym(0x0ed5);
pub const SYM_Hangul_J_KiyeogSios: KeySym = KeySym(0x0ed6);
pub const SYM_Hangul_J_Nieun: KeySym = KeySym(0x0ed7);
pub const SYM_Hangul_J_NieunJieuj: KeySym = KeySym(0x0ed8);
pub const SYM_Hangul_J_NieunHieuh: KeySym = KeySym(0x0ed9);
pub const SYM_Hangul_J_Dikeud: KeySym = KeySym(0x0eda);
pub const SYM_Hangul_J_Rieul: KeySym = KeySym(0x0edb);
pub const SYM_Hangul_J_RieulKiyeog: KeySym = KeySym(0x0edc);
pub const SYM_Hangul_J_RieulMieum: KeySym = KeySym(0x0edd);
pub const SYM_Hangul_J_RieulPieub: KeySym = KeySym(0x0ede);
pub const SYM_Hangul_J_RieulSios: KeySym = KeySym(0x0edf);
pub const SYM_Hangul_J_RieulTieut: KeySym = KeySym(0x0ee0);
pub const SYM_Hangul_J_RieulPhieuf: KeySym = KeySym(0x0ee1);
pub const SYM_Hangul_J_RieulHieuh: KeySym = KeySym(0x0ee2);
pub const SYM_Hangul_J_Mieum: KeySym = KeySym(0x0ee3);
pub const SYM_Hangul_J_Pieub: KeySym = KeySym(0x0ee4);
pub const SYM_Hangul_J_PieubSios: KeySym = KeySym(0x0ee5);
pub const SYM_Hangul_J_Sios: KeySym = KeySym(0x0ee6);
pub const SYM_Hangul_J_SsangSios: KeySym = KeySym(0x0ee7);
pub const SYM_Hangul_J_Ieung: KeySym = KeySym(0x0ee8);
pub const SYM_Hangul_J_Jieuj: KeySym = KeySym(0x0ee9);
pub const SYM_Hangul_J_Cieuc: KeySym = KeySym(0x0eea);
pub const SYM_Hangul_J_Khieuq: KeySym = KeySym(0x0eeb);
pub const SYM_Hangul_J_Tieut: KeySym = KeySym(0x0eec);
pub const SYM_Hangul_J_Phieuf: KeySym = KeySym(0x0eed);
pub const SYM_Hangul_J_Hieuh: KeySym = KeySym(0x0eee);
pub const SYM_Hangul_RieulYeorinHieuh: KeySym = KeySym(0x0eef);
pub const SYM_Hangul_SunkyeongeumMieum: KeySym = KeySym(0x0ef0);
pub const SYM_Hangul_SunkyeongeumPieub: KeySym = KeySym(0x0ef1);
pub const SYM_Hangul_PanSios: KeySym = KeySym(0x0ef2);
pub const SYM_Hangul_KkogjiDalrinIeung: KeySym = KeySym(0x0ef3);
pub const SYM_Hangul_SunkyeongeumPhieuf: KeySym = KeySym(0x0ef4);
pub const SYM_Hangul_YeorinHieuh: KeySym = KeySym(0x0ef5);
pub const SYM_Hangul_AraeA: KeySym = KeySym(0x0ef6);
pub const SYM_Hangul_AraeAE: KeySym = KeySym(0x0ef7);
pub const SYM_Hangul_J_PanSios: KeySym = KeySym(0x0ef8);
pub const SYM_Hangul_J_KkogjiDalrinIeung: KeySym = KeySym(0x0ef9);
pub const SYM_Hangul_J_YeorinHieuh: KeySym = KeySym(0x0efa);
pub const SYM_Korean_Won: KeySym = KeySym(0x0eff);
pub const SYM_Armenian_ligature_ew: KeySym = KeySym(0x1000587);
pub const SYM_Armenian_full_stop: KeySym = KeySym(0x1000589);
pub const SYM_Armenian_verjaket: KeySym = KeySym(0x1000589);
pub const SYM_Armenian_separation_mark: KeySym = KeySym(0x100055d);
pub const SYM_Armenian_but: KeySym = KeySym(0x100055d);
pub const SYM_Armenian_hyphen: KeySym = KeySym(0x100058a);
pub const SYM_Armenian_yentamna: KeySym = KeySym(0x100058a);
pub const SYM_Armenian_exclam: KeySym = KeySym(0x100055c);
pub const SYM_Armenian_amanak: KeySym = KeySym(0x100055c);
pub const SYM_Armenian_accent: KeySym = KeySym(0x100055b);
pub const SYM_Armenian_shesht: KeySym = KeySym(0x100055b);
pub const SYM_Armenian_question: KeySym = KeySym(0x100055e);
pub const SYM_Armenian_paruyk: KeySym = KeySym(0x100055e);
pub const SYM_Armenian_AYB: KeySym = KeySym(0x1000531);
pub const SYM_Armenian_ayb: KeySym = KeySym(0x1000561);
pub const SYM_Armenian_BEN: KeySym = KeySym(0x1000532);
pub const SYM_Armenian_ben: KeySym = KeySym(0x1000562);
pub const SYM_Armenian_GIM: KeySym = KeySym(0x1000533);
pub const SYM_Armenian_gim: KeySym = KeySym(0x1000563);
pub const SYM_Armenian_DA: KeySym = KeySym(0x1000534);
pub const SYM_Armenian_da: KeySym = KeySym(0x1000564);
pub const SYM_Armenian_YECH: KeySym = KeySym(0x1000535);
pub const SYM_Armenian_yech: KeySym = KeySym(0x1000565);
pub const SYM_Armenian_ZA: KeySym = KeySym(0x1000536);
pub const SYM_Armenian_za: KeySym = KeySym(0x1000566);
pub const SYM_Armenian_E: KeySym = KeySym(0x1000537);
pub const SYM_Armenian_e: KeySym = KeySym(0x1000567);
pub const SYM_Armenian_AT: KeySym = KeySym(0x1000538);
pub const SYM_Armenian_at: KeySym = KeySym(0x1000568);
pub const SYM_Armenian_TO: KeySym = KeySym(0x1000539);
pub const SYM_Armenian_to: KeySym = KeySym(0x1000569);
pub const SYM_Armenian_ZHE: KeySym = KeySym(0x100053a);
pub const SYM_Armenian_zhe: KeySym = KeySym(0x100056a);
pub const SYM_Armenian_INI: KeySym = KeySym(0x100053b);
pub const SYM_Armenian_ini: KeySym = KeySym(0x100056b);
pub const SYM_Armenian_LYUN: KeySym = KeySym(0x100053c);
pub const SYM_Armenian_lyun: KeySym = KeySym(0x100056c);
pub const SYM_Armenian_KHE: KeySym = KeySym(0x100053d);
pub const SYM_Armenian_khe: KeySym = KeySym(0x100056d);
pub const SYM_Armenian_TSA: KeySym = KeySym(0x100053e);
pub const SYM_Armenian_tsa: KeySym = KeySym(0x100056e);
pub const SYM_Armenian_KEN: KeySym = KeySym(0x100053f);
pub const SYM_Armenian_ken: KeySym = KeySym(0x100056f);
pub const SYM_Armenian_HO: KeySym = KeySym(0x1000540);
pub const SYM_Armenian_ho: KeySym = KeySym(0x1000570);
pub const SYM_Armenian_DZA: KeySym = KeySym(0x1000541);
pub const SYM_Armenian_dza: KeySym = KeySym(0x1000571);
pub const SYM_Armenian_GHAT: KeySym = KeySym(0x1000542);
pub const SYM_Armenian_ghat: KeySym = KeySym(0x1000572);
pub const SYM_Armenian_TCHE: KeySym = KeySym(0x1000543);
pub const SYM_Armenian_tche: KeySym = KeySym(0x1000573);
pub const SYM_Armenian_MEN: KeySym = KeySym(0x1000544);
pub const SYM_Armenian_men: KeySym = KeySym(0x1000574);
pub const SYM_Armenian_HI: KeySym = KeySym(0x1000545);
pub const SYM_Armenian_hi: KeySym = KeySym(0x1000575);
pub const SYM_Armenian_NU: KeySym = KeySym(0x1000546);
pub const SYM_Armenian_nu: KeySym = KeySym(0x1000576);
pub const SYM_Armenian_SHA: KeySym = KeySym(0x1000547);
pub const SYM_Armenian_sha: KeySym = KeySym(0x1000577);
pub const SYM_Armenian_VO: KeySym = KeySym(0x1000548);
pub const SYM_Armenian_vo: KeySym = KeySym(0x1000578);
pub const SYM_Armenian_CHA: KeySym = KeySym(0x1000549);
pub const SYM_Armenian_cha: KeySym = KeySym(0x1000579);
pub const SYM_Armenian_PE: KeySym = KeySym(0x100054a);
pub const SYM_Armenian_pe: KeySym = KeySym(0x100057a);
pub const SYM_Armenian_JE: KeySym = KeySym(0x100054b);
pub const SYM_Armenian_je: KeySym = KeySym(0x100057b);
pub const SYM_Armenian_RA: KeySym = KeySym(0x100054c);
pub const SYM_Armenian_ra: KeySym = KeySym(0x100057c);
pub const SYM_Armenian_SE: KeySym = KeySym(0x100054d);
pub const SYM_Armenian_se: KeySym = KeySym(0x100057d);
pub const SYM_Armenian_VEV: KeySym = KeySym(0x100054e);
pub const SYM_Armenian_vev: KeySym = KeySym(0x100057e);
pub const SYM_Armenian_TYUN: KeySym = KeySym(0x100054f);
pub const SYM_Armenian_tyun: KeySym = KeySym(0x100057f);
pub const SYM_Armenian_RE: KeySym = KeySym(0x1000550);
pub const SYM_Armenian_re: KeySym = KeySym(0x1000580);
pub const SYM_Armenian_TSO: KeySym = KeySym(0x1000551);
pub const SYM_Armenian_tso: KeySym = KeySym(0x1000581);
pub const SYM_Armenian_VYUN: KeySym = KeySym(0x1000552);
pub const SYM_Armenian_vyun: KeySym = KeySym(0x1000582);
pub const SYM_Armenian_PYUR: KeySym = KeySym(0x1000553);
pub const SYM_Armenian_pyur: KeySym = KeySym(0x1000583);
pub const SYM_Armenian_KE: KeySym = KeySym(0x1000554);
pub const SYM_Armenian_ke: KeySym = KeySym(0x1000584);
pub const SYM_Armenian_O: KeySym = KeySym(0x1000555);
pub const SYM_Armenian_o: KeySym = KeySym(0x1000585);
pub const SYM_Armenian_FE: KeySym = KeySym(0x1000556);
pub const SYM_Armenian_fe: KeySym = KeySym(0x1000586);
pub const SYM_Armenian_apostrophe: KeySym = KeySym(0x100055a);
pub const SYM_Georgian_an: KeySym = KeySym(0x10010d0);
pub const SYM_Georgian_ban: KeySym = KeySym(0x10010d1);
pub const SYM_Georgian_gan: KeySym = KeySym(0x10010d2);
pub const SYM_Georgian_don: KeySym = KeySym(0x10010d3);
pub const SYM_Georgian_en: KeySym = KeySym(0x10010d4);
pub const SYM_Georgian_vin: KeySym = KeySym(0x10010d5);
pub const SYM_Georgian_zen: KeySym = KeySym(0x10010d6);
pub const SYM_Georgian_tan: KeySym = KeySym(0x10010d7);
pub const SYM_Georgian_in: KeySym = KeySym(0x10010d8);
pub const SYM_Georgian_kan: KeySym = KeySym(0x10010d9);
pub const SYM_Georgian_las: KeySym = KeySym(0x10010da);
pub const SYM_Georgian_man: KeySym = KeySym(0x10010db);
pub const SYM_Georgian_nar: KeySym = KeySym(0x10010dc);
pub const SYM_Georgian_on: KeySym = KeySym(0x10010dd);
pub const SYM_Georgian_par: KeySym = KeySym(0x10010de);
pub const SYM_Georgian_zhar: KeySym = KeySym(0x10010df);
pub const SYM_Georgian_rae: KeySym = KeySym(0x10010e0);
pub const SYM_Georgian_san: KeySym = KeySym(0x10010e1);
pub const SYM_Georgian_tar: KeySym = KeySym(0x10010e2);
pub const SYM_Georgian_un: KeySym = KeySym(0x10010e3);
pub const SYM_Georgian_phar: KeySym = KeySym(0x10010e4);
pub const SYM_Georgian_khar: KeySym = KeySym(0x10010e5);
pub const SYM_Georgian_ghan: KeySym = KeySym(0x10010e6);
pub const SYM_Georgian_qar: KeySym = KeySym(0x10010e7);
pub const SYM_Georgian_shin: KeySym = KeySym(0x10010e8);
pub const SYM_Georgian_chin: KeySym = KeySym(0x10010e9);
pub const SYM_Georgian_can: KeySym = KeySym(0x10010ea);
pub const SYM_Georgian_jil: KeySym = KeySym(0x10010eb);
pub const SYM_Georgian_cil: KeySym = KeySym(0x10010ec);
pub const SYM_Georgian_char: KeySym = KeySym(0x10010ed);
pub const SYM_Georgian_xan: KeySym = KeySym(0x10010ee);
pub const SYM_Georgian_jhan: KeySym = KeySym(0x10010ef);
pub const SYM_Georgian_hae: KeySym = KeySym(0x10010f0);
pub const SYM_Georgian_he: KeySym = KeySym(0x10010f1);
pub const SYM_Georgian_hie: KeySym = KeySym(0x10010f2);
pub const SYM_Georgian_we: KeySym = KeySym(0x10010f3);
pub const SYM_Georgian_har: KeySym = KeySym(0x10010f4);
pub const SYM_Georgian_hoe: KeySym = KeySym(0x10010f5);
pub const SYM_Georgian_fi: KeySym = KeySym(0x10010f6);
pub const SYM_Xabovedot: KeySym = KeySym(0x1001e8a);
pub const SYM_Ibreve: KeySym = KeySym(0x100012c);
pub const SYM_Zstroke: KeySym = KeySym(0x10001b5);
pub const SYM_Gcaron: KeySym = KeySym(0x10001e6);
pub const SYM_Ocaron: KeySym = KeySym(0x10001d1);
pub const SYM_Obarred: KeySym = KeySym(0x100019f);
pub const SYM_xabovedot: KeySym = KeySym(0x1001e8b);
pub const SYM_ibreve: KeySym = KeySym(0x100012d);
pub const SYM_zstroke: KeySym = KeySym(0x10001b6);
pub const SYM_gcaron: KeySym = KeySym(0x10001e7);
pub const SYM_ocaron: KeySym = KeySym(0x10001d2);
pub const SYM_obarred: KeySym = KeySym(0x1000275);
pub const SYM_SCHWA: KeySym = KeySym(0x100018f);
pub const SYM_schwa: KeySym = KeySym(0x1000259);
pub const SYM_EZH: KeySym = KeySym(0x10001b7);
pub const SYM_ezh: KeySym = KeySym(0x1000292);
pub const SYM_Lbelowdot: KeySym = KeySym(0x1001e36);
pub const SYM_lbelowdot: KeySym = KeySym(0x1001e37);
pub const SYM_Abelowdot: KeySym = KeySym(0x1001ea0);
pub const SYM_abelowdot: KeySym = KeySym(0x1001ea1);
pub const SYM_Ahook: KeySym = KeySym(0x1001ea2);
pub const SYM_ahook: KeySym = KeySym(0x1001ea3);
pub const SYM_Acircumflexacute: KeySym = KeySym(0x1001ea4);
pub const SYM_acircumflexacute: KeySym = KeySym(0x1001ea5);
pub const SYM_Acircumflexgrave: KeySym = KeySym(0x1001ea6);
pub const SYM_acircumflexgrave: KeySym = KeySym(0x1001ea7);
pub const SYM_Acircumflexhook: KeySym = KeySym(0x1001ea8);
pub const SYM_acircumflexhook: KeySym = KeySym(0x1001ea9);
pub const SYM_Acircumflextilde: KeySym = KeySym(0x1001eaa);
pub const SYM_acircumflextilde: KeySym = KeySym(0x1001eab);
pub const SYM_Acircumflexbelowdot: KeySym = KeySym(0x1001eac);
pub const SYM_acircumflexbelowdot: KeySym = KeySym(0x1001ead);
pub const SYM_Abreveacute: KeySym = KeySym(0x1001eae);
pub const SYM_abreveacute: KeySym = KeySym(0x1001eaf);
pub const SYM_Abrevegrave: KeySym = KeySym(0x1001eb0);
pub const SYM_abrevegrave: KeySym = KeySym(0x1001eb1);
pub const SYM_Abrevehook: KeySym = KeySym(0x1001eb2);
pub const SYM_abrevehook: KeySym = KeySym(0x1001eb3);
pub const SYM_Abrevetilde: KeySym = KeySym(0x1001eb4);
pub const SYM_abrevetilde: KeySym = KeySym(0x1001eb5);
pub const SYM_Abrevebelowdot: KeySym = KeySym(0x1001eb6);
pub const SYM_abrevebelowdot: KeySym = KeySym(0x1001eb7);
pub const SYM_Ebelowdot: KeySym = KeySym(0x1001eb8);
pub const SYM_ebelowdot: KeySym = KeySym(0x1001eb9);
pub const SYM_Ehook: KeySym = KeySym(0x1001eba);
pub const SYM_ehook: KeySym = KeySym(0x1001ebb);
pub const SYM_Etilde: KeySym = KeySym(0x1001ebc);
pub const SYM_etilde: KeySym = KeySym(0x1001ebd);
pub const SYM_Ecircumflexacute: KeySym = KeySym(0x1001ebe);
pub const SYM_ecircumflexacute: KeySym = KeySym(0x1001ebf);
pub const SYM_Ecircumflexgrave: KeySym = KeySym(0x1001ec0);
pub const SYM_ecircumflexgrave: KeySym = KeySym(0x1001ec1);
pub const SYM_Ecircumflexhook: KeySym = KeySym(0x1001ec2);
pub const SYM_ecircumflexhook: KeySym = KeySym(0x1001ec3);
pub const SYM_Ecircumflextilde: KeySym = KeySym(0x1001ec4);
pub const SYM_ecircumflextilde: KeySym = KeySym(0x1001ec5);
pub const SYM_Ecircumflexbelowdot: KeySym = KeySym(0x1001ec6);
pub const SYM_ecircumflexbelowdot: KeySym = KeySym(0x1001ec7);
pub const SYM_Ihook: KeySym = KeySym(0x1001ec8);
pub const SYM_ihook: KeySym = KeySym(0x1001ec9);
pub const SYM_Ibelowdot: KeySym = KeySym(0x1001eca);
pub const SYM_ibelowdot: KeySym = KeySym(0x1001ecb);
pub const SYM_Obelowdot: KeySym = KeySym(0x1001ecc);
pub const SYM_obelowdot: KeySym = KeySym(0x1001ecd);
pub const SYM_Ohook: KeySym = KeySym(0x1001ece);
pub const SYM_ohook: KeySym = KeySym(0x1001ecf);
pub const SYM_Ocircumflexacute: KeySym = KeySym(0x1001ed0);
pub const SYM_ocircumflexacute: KeySym = KeySym(0x1001ed1);
pub const SYM_Ocircumflexgrave: KeySym = KeySym(0x1001ed2);
pub const SYM_ocircumflexgrave: KeySym = KeySym(0x1001ed3);
pub const SYM_Ocircumflexhook: KeySym = KeySym(0x1001ed4);
pub const SYM_ocircumflexhook: KeySym = KeySym(0x1001ed5);
pub const SYM_Ocircumflextilde: KeySym = KeySym(0x1001ed6);
pub const SYM_ocircumflextilde: KeySym = KeySym(0x1001ed7);
pub const SYM_Ocircumflexbelowdot: KeySym = KeySym(0x1001ed8);
pub const SYM_ocircumflexbelowdot: KeySym = KeySym(0x1001ed9);
pub const SYM_Ohornacute: KeySym = KeySym(0x1001eda);
pub const SYM_ohornacute: KeySym = KeySym(0x1001edb);
pub const SYM_Ohorngrave: KeySym = KeySym(0x1001edc);
pub const SYM_ohorngrave: KeySym = KeySym(0x1001edd);
pub const SYM_Ohornhook: KeySym = KeySym(0x1001ede);
pub const SYM_ohornhook: KeySym = KeySym(0x1001edf);
pub const SYM_Ohorntilde: KeySym = KeySym(0x1001ee0);
pub const SYM_ohorntilde: KeySym = KeySym(0x1001ee1);
pub const SYM_Ohornbelowdot: KeySym = KeySym(0x1001ee2);
pub const SYM_ohornbelowdot: KeySym = KeySym(0x1001ee3);
pub const SYM_Ubelowdot: KeySym = KeySym(0x1001ee4);
pub const SYM_ubelowdot: KeySym = KeySym(0x1001ee5);
pub const SYM_Uhook: KeySym = KeySym(0x1001ee6);
pub const SYM_uhook: KeySym = KeySym(0x1001ee7);
pub const SYM_Uhornacute: KeySym = KeySym(0x1001ee8);
pub const SYM_uhornacute: KeySym = KeySym(0x1001ee9);
pub const SYM_Uhorngrave: KeySym = KeySym(0x1001eea);
pub const SYM_uhorngrave: KeySym = KeySym(0x1001eeb);
pub const SYM_Uhornhook: KeySym = KeySym(0x1001eec);
pub const SYM_uhornhook: KeySym = KeySym(0x1001eed);
pub const SYM_Uhorntilde: KeySym = KeySym(0x1001eee);
pub const SYM_uhorntilde: KeySym = KeySym(0x1001eef);
pub const SYM_Uhornbelowdot: KeySym = KeySym(0x1001ef0);
pub const SYM_uhornbelowdot: KeySym = KeySym(0x1001ef1);
pub const SYM_Ybelowdot: KeySym = KeySym(0x1001ef4);
pub const SYM_ybelowdot: KeySym = KeySym(0x1001ef5);
pub const SYM_Yhook: KeySym = KeySym(0x1001ef6);
pub const SYM_yhook: KeySym = KeySym(0x1001ef7);
pub const SYM_Ytilde: KeySym = KeySym(0x1001ef8);
pub const SYM_ytilde: KeySym = KeySym(0x1001ef9);
pub const SYM_Ohorn: KeySym = KeySym(0x10001a0);
pub const SYM_ohorn: KeySym = KeySym(0x10001a1);
pub const SYM_Uhorn: KeySym = KeySym(0x10001af);
pub const SYM_uhorn: KeySym = KeySym(0x10001b0);
pub const SYM_combining_tilde: KeySym = KeySym(0x1000303);
pub const SYM_combining_grave: KeySym = KeySym(0x1000300);
pub const SYM_combining_acute: KeySym = KeySym(0x1000301);
pub const SYM_combining_hook: KeySym = KeySym(0x1000309);
pub const SYM_combining_belowdot: KeySym = KeySym(0x1000323);
pub const SYM_EcuSign: KeySym = KeySym(0x10020a0);
pub const SYM_ColonSign: KeySym = KeySym(0x10020a1);
pub const SYM_CruzeiroSign: KeySym = KeySym(0x10020a2);
pub const SYM_FFrancSign: KeySym = KeySym(0x10020a3);
pub const SYM_LiraSign: KeySym = KeySym(0x10020a4);
pub const SYM_MillSign: KeySym = KeySym(0x10020a5);
pub const SYM_NairaSign: KeySym = KeySym(0x10020a6);
pub const SYM_PesetaSign: KeySym = KeySym(0x10020a7);
pub const SYM_RupeeSign: KeySym = KeySym(0x10020a8);
pub const SYM_WonSign: KeySym = KeySym(0x10020a9);
pub const SYM_NewSheqelSign: KeySym = KeySym(0x10020aa);
pub const SYM_DongSign: KeySym = KeySym(0x10020ab);
pub const SYM_EuroSign: KeySym = KeySym(0x20ac);
pub const SYM_zerosuperior: KeySym = KeySym(0x1002070);
pub const SYM_foursuperior: KeySym = KeySym(0x1002074);
pub const SYM_fivesuperior: KeySym = KeySym(0x1002075);
pub const SYM_sixsuperior: KeySym = KeySym(0x1002076);
pub const SYM_sevensuperior: KeySym = KeySym(0x1002077);
pub const SYM_eightsuperior: KeySym = KeySym(0x1002078);
pub const SYM_ninesuperior: KeySym = KeySym(0x1002079);
pub const SYM_zerosubscript: KeySym = KeySym(0x1002080);
pub const SYM_onesubscript: KeySym = KeySym(0x1002081);
pub const SYM_twosubscript: KeySym = KeySym(0x1002082);
pub const SYM_threesubscript: KeySym = KeySym(0x1002083);
pub const SYM_foursubscript: KeySym = KeySym(0x1002084);
pub const SYM_fivesubscript: KeySym = KeySym(0x1002085);
pub const SYM_sixsubscript: KeySym = KeySym(0x1002086);
pub const SYM_sevensubscript: KeySym = KeySym(0x1002087);
pub const SYM_eightsubscript: KeySym = KeySym(0x1002088);
pub const SYM_ninesubscript: KeySym = KeySym(0x1002089);
pub const SYM_partdifferential: KeySym = KeySym(0x1002202);
pub const SYM_emptyset: KeySym = KeySym(0x1002205);
pub const SYM_elementof: KeySym = KeySym(0x1002208);
pub const SYM_notelementof: KeySym = KeySym(0x1002209);
pub const SYM_containsas: KeySym = KeySym(0x100220B);
pub const SYM_squareroot: KeySym = KeySym(0x100221A);
pub const SYM_cuberoot: KeySym = KeySym(0x100221B);
pub const SYM_fourthroot: KeySym = KeySym(0x100221C);
pub const SYM_dintegral: KeySym = KeySym(0x100222C);
pub const SYM_tintegral: KeySym = KeySym(0x100222D);
pub const SYM_because: KeySym = KeySym(0x1002235);
pub const SYM_approxeq: KeySym = KeySym(0x1002248);
pub const SYM_notapproxeq: KeySym = KeySym(0x1002247);
pub const SYM_notidentical: KeySym = KeySym(0x1002262);
pub const SYM_stricteq: KeySym = KeySym(0x1002263);
pub const SYM_braille_dot_1: KeySym = KeySym(0xfff1);
pub const SYM_braille_dot_2: KeySym = KeySym(0xfff2);
pub const SYM_braille_dot_3: KeySym = KeySym(0xfff3);
pub const SYM_braille_dot_4: KeySym = KeySym(0xfff4);
pub const SYM_braille_dot_5: KeySym = KeySym(0xfff5);
pub const SYM_braille_dot_6: KeySym = KeySym(0xfff6);
pub const SYM_braille_dot_7: KeySym = KeySym(0xfff7);
pub const SYM_braille_dot_8: KeySym = KeySym(0xfff8);
pub const SYM_braille_dot_9: KeySym = KeySym(0xfff9);
pub const SYM_braille_dot_10: KeySym = KeySym(0xfffa);
pub const SYM_braille_blank: KeySym = KeySym(0x1002800);
pub const SYM_braille_dots_1: KeySym = KeySym(0x1002801);
pub const SYM_braille_dots_2: KeySym = KeySym(0x1002802);
pub const SYM_braille_dots_12: KeySym = KeySym(0x1002803);
pub const SYM_braille_dots_3: KeySym = KeySym(0x1002804);
pub const SYM_braille_dots_13: KeySym = KeySym(0x1002805);
pub const SYM_braille_dots_23: KeySym = KeySym(0x1002806);
pub const SYM_braille_dots_123: KeySym = KeySym(0x1002807);
pub const SYM_braille_dots_4: KeySym = KeySym(0x1002808);
pub const SYM_braille_dots_14: KeySym = KeySym(0x1002809);
pub const SYM_braille_dots_24: KeySym = KeySym(0x100280a);
pub const SYM_braille_dots_124: KeySym = KeySym(0x100280b);
pub const SYM_braille_dots_34: KeySym = KeySym(0x100280c);
pub const SYM_braille_dots_134: KeySym = KeySym(0x100280d);
pub const SYM_braille_dots_234: KeySym = KeySym(0x100280e);
pub const SYM_braille_dots_1234: KeySym = KeySym(0x100280f);
pub const SYM_braille_dots_5: KeySym = KeySym(0x1002810);
pub const SYM_braille_dots_15: KeySym = KeySym(0x1002811);
pub const SYM_braille_dots_25: KeySym = KeySym(0x1002812);
pub const SYM_braille_dots_125: KeySym = KeySym(0x1002813);
pub const SYM_braille_dots_35: KeySym = KeySym(0x1002814);
pub const SYM_braille_dots_135: KeySym = KeySym(0x1002815);
pub const SYM_braille_dots_235: KeySym = KeySym(0x1002816);
pub const SYM_braille_dots_1235: KeySym = KeySym(0x1002817);
pub const SYM_braille_dots_45: KeySym = KeySym(0x1002818);
pub const SYM_braille_dots_145: KeySym = KeySym(0x1002819);
pub const SYM_braille_dots_245: KeySym = KeySym(0x100281a);
pub const SYM_braille_dots_1245: KeySym = KeySym(0x100281b);
pub const SYM_braille_dots_345: KeySym = KeySym(0x100281c);
pub const SYM_braille_dots_1345: KeySym = KeySym(0x100281d);
pub const SYM_braille_dots_2345: KeySym = KeySym(0x100281e);
pub const SYM_braille_dots_12345: KeySym = KeySym(0x100281f);
pub const SYM_braille_dots_6: KeySym = KeySym(0x1002820);
pub const SYM_braille_dots_16: KeySym = KeySym(0x1002821);
pub const SYM_braille_dots_26: KeySym = KeySym(0x1002822);
pub const SYM_braille_dots_126: KeySym = KeySym(0x1002823);
pub const SYM_braille_dots_36: KeySym = KeySym(0x1002824);
pub const SYM_braille_dots_136: KeySym = KeySym(0x1002825);
pub const SYM_braille_dots_236: KeySym = KeySym(0x1002826);
pub const SYM_braille_dots_1236: KeySym = KeySym(0x1002827);
pub const SYM_braille_dots_46: KeySym = KeySym(0x1002828);
pub const SYM_braille_dots_146: KeySym = KeySym(0x1002829);
pub const SYM_braille_dots_246: KeySym = KeySym(0x100282a);
pub const SYM_braille_dots_1246: KeySym = KeySym(0x100282b);
pub const SYM_braille_dots_346: KeySym = KeySym(0x100282c);
pub const SYM_braille_dots_1346: KeySym = KeySym(0x100282d);
pub const SYM_braille_dots_2346: KeySym = KeySym(0x100282e);
pub const SYM_braille_dots_12346: KeySym = KeySym(0x100282f);
pub const SYM_braille_dots_56: KeySym = KeySym(0x1002830);
pub const SYM_braille_dots_156: KeySym = KeySym(0x1002831);
pub const SYM_braille_dots_256: KeySym = KeySym(0x1002832);
pub const SYM_braille_dots_1256: KeySym = KeySym(0x1002833);
pub const SYM_braille_dots_356: KeySym = KeySym(0x1002834);
pub const SYM_braille_dots_1356: KeySym = KeySym(0x1002835);
pub const SYM_braille_dots_2356: KeySym = KeySym(0x1002836);
pub const SYM_braille_dots_12356: KeySym = KeySym(0x1002837);
pub const SYM_braille_dots_456: KeySym = KeySym(0x1002838);
pub const SYM_braille_dots_1456: KeySym = KeySym(0x1002839);
pub const SYM_braille_dots_2456: KeySym = KeySym(0x100283a);
pub const SYM_braille_dots_12456: KeySym = KeySym(0x100283b);
pub const SYM_braille_dots_3456: KeySym = KeySym(0x100283c);
pub const SYM_braille_dots_13456: KeySym = KeySym(0x100283d);
pub const SYM_braille_dots_23456: KeySym = KeySym(0x100283e);
pub const SYM_braille_dots_123456: KeySym = KeySym(0x100283f);
pub const SYM_braille_dots_7: KeySym = KeySym(0x1002840);
pub const SYM_braille_dots_17: KeySym = KeySym(0x1002841);
pub const SYM_braille_dots_27: KeySym = KeySym(0x1002842);
pub const SYM_braille_dots_127: KeySym = KeySym(0x1002843);
pub const SYM_braille_dots_37: KeySym = KeySym(0x1002844);
pub const SYM_braille_dots_137: KeySym = KeySym(0x1002845);
pub const SYM_braille_dots_237: KeySym = KeySym(0x1002846);
pub const SYM_braille_dots_1237: KeySym = KeySym(0x1002847);
pub const SYM_braille_dots_47: KeySym = KeySym(0x1002848);
pub const SYM_braille_dots_147: KeySym = KeySym(0x1002849);
pub const SYM_braille_dots_247: KeySym = KeySym(0x100284a);
pub const SYM_braille_dots_1247: KeySym = KeySym(0x100284b);
pub const SYM_braille_dots_347: KeySym = KeySym(0x100284c);
pub const SYM_braille_dots_1347: KeySym = KeySym(0x100284d);
pub const SYM_braille_dots_2347: KeySym = KeySym(0x100284e);
pub const SYM_braille_dots_12347: KeySym = KeySym(0x100284f);
pub const SYM_braille_dots_57: KeySym = KeySym(0x1002850);
pub const SYM_braille_dots_157: KeySym = KeySym(0x1002851);
pub const SYM_braille_dots_257: KeySym = KeySym(0x1002852);
pub const SYM_braille_dots_1257: KeySym = KeySym(0x1002853);
pub const SYM_braille_dots_357: KeySym = KeySym(0x1002854);
pub const SYM_braille_dots_1357: KeySym = KeySym(0x1002855);
pub const SYM_braille_dots_2357: KeySym = KeySym(0x1002856);
pub const SYM_braille_dots_12357: KeySym = KeySym(0x1002857);
pub const SYM_braille_dots_457: KeySym = KeySym(0x1002858);
pub const SYM_braille_dots_1457: KeySym = KeySym(0x1002859);
pub const SYM_braille_dots_2457: KeySym = KeySym(0x100285a);
pub const SYM_braille_dots_12457: KeySym = KeySym(0x100285b);
pub const SYM_braille_dots_3457: KeySym = KeySym(0x100285c);
pub const SYM_braille_dots_13457: KeySym = KeySym(0x100285d);
pub const SYM_braille_dots_23457: KeySym = KeySym(0x100285e);
pub const SYM_braille_dots_123457: KeySym = KeySym(0x100285f);
pub const SYM_braille_dots_67: KeySym = KeySym(0x1002860);
pub const SYM_braille_dots_167: KeySym = KeySym(0x1002861);
pub const SYM_braille_dots_267: KeySym = KeySym(0x1002862);
pub const SYM_braille_dots_1267: KeySym = KeySym(0x1002863);
pub const SYM_braille_dots_367: KeySym = KeySym(0x1002864);
pub const SYM_braille_dots_1367: KeySym = KeySym(0x1002865);
pub const SYM_braille_dots_2367: KeySym = KeySym(0x1002866);
pub const SYM_braille_dots_12367: KeySym = KeySym(0x1002867);
pub const SYM_braille_dots_467: KeySym = KeySym(0x1002868);
pub const SYM_braille_dots_1467: KeySym = KeySym(0x1002869);
pub const SYM_braille_dots_2467: KeySym = KeySym(0x100286a);
pub const SYM_braille_dots_12467: KeySym = KeySym(0x100286b);
pub const SYM_braille_dots_3467: KeySym = KeySym(0x100286c);
pub const SYM_braille_dots_13467: KeySym = KeySym(0x100286d);
pub const SYM_braille_dots_23467: KeySym = KeySym(0x100286e);
pub const SYM_braille_dots_123467: KeySym = KeySym(0x100286f);
pub const SYM_braille_dots_567: KeySym = KeySym(0x1002870);
pub const SYM_braille_dots_1567: KeySym = KeySym(0x1002871);
pub const SYM_braille_dots_2567: KeySym = KeySym(0x1002872);
pub const SYM_braille_dots_12567: KeySym = KeySym(0x1002873);
pub const SYM_braille_dots_3567: KeySym = KeySym(0x1002874);
pub const SYM_braille_dots_13567: KeySym = KeySym(0x1002875);
pub const SYM_braille_dots_23567: KeySym = KeySym(0x1002876);
pub const SYM_braille_dots_123567: KeySym = KeySym(0x1002877);
pub const SYM_braille_dots_4567: KeySym = KeySym(0x1002878);
pub const SYM_braille_dots_14567: KeySym = KeySym(0x1002879);
pub const SYM_braille_dots_24567: KeySym = KeySym(0x100287a);
pub const SYM_braille_dots_124567: KeySym = KeySym(0x100287b);
pub const SYM_braille_dots_34567: KeySym = KeySym(0x100287c);
pub const SYM_braille_dots_134567: KeySym = KeySym(0x100287d);
pub const SYM_braille_dots_234567: KeySym = KeySym(0x100287e);
pub const SYM_braille_dots_1234567: KeySym = KeySym(0x100287f);
pub const SYM_braille_dots_8: KeySym = KeySym(0x1002880);
pub const SYM_braille_dots_18: KeySym = KeySym(0x1002881);
pub const SYM_braille_dots_28: KeySym = KeySym(0x1002882);
pub const SYM_braille_dots_128: KeySym = KeySym(0x1002883);
pub const SYM_braille_dots_38: KeySym = KeySym(0x1002884);
pub const SYM_braille_dots_138: KeySym = KeySym(0x1002885);
pub const SYM_braille_dots_238: KeySym = KeySym(0x1002886);
pub const SYM_braille_dots_1238: KeySym = KeySym(0x1002887);
pub const SYM_braille_dots_48: KeySym = KeySym(0x1002888);
pub const SYM_braille_dots_148: KeySym = KeySym(0x1002889);
pub const SYM_braille_dots_248: KeySym = KeySym(0x100288a);
pub const SYM_braille_dots_1248: KeySym = KeySym(0x100288b);
pub const SYM_braille_dots_348: KeySym = KeySym(0x100288c);
pub const SYM_braille_dots_1348: KeySym = KeySym(0x100288d);
pub const SYM_braille_dots_2348: KeySym = KeySym(0x100288e);
pub const SYM_braille_dots_12348: KeySym = KeySym(0x100288f);
pub const SYM_braille_dots_58: KeySym = KeySym(0x1002890);
pub const SYM_braille_dots_158: KeySym = KeySym(0x1002891);
pub const SYM_braille_dots_258: KeySym = KeySym(0x1002892);
pub const SYM_braille_dots_1258: KeySym = KeySym(0x1002893);
pub const SYM_braille_dots_358: KeySym = KeySym(0x1002894);
pub const SYM_braille_dots_1358: KeySym = KeySym(0x1002895);
pub const SYM_braille_dots_2358: KeySym = KeySym(0x1002896);
pub const SYM_braille_dots_12358: KeySym = KeySym(0x1002897);
pub const SYM_braille_dots_458: KeySym = KeySym(0x1002898);
pub const SYM_braille_dots_1458: KeySym = KeySym(0x1002899);
pub const SYM_braille_dots_2458: KeySym = KeySym(0x100289a);
pub const SYM_braille_dots_12458: KeySym = KeySym(0x100289b);
pub const SYM_braille_dots_3458: KeySym = KeySym(0x100289c);
pub const SYM_braille_dots_13458: KeySym = KeySym(0x100289d);
pub const SYM_braille_dots_23458: KeySym = KeySym(0x100289e);
pub const SYM_braille_dots_123458: KeySym = KeySym(0x100289f);
pub const SYM_braille_dots_68: KeySym = KeySym(0x10028a0);
pub const SYM_braille_dots_168: KeySym = KeySym(0x10028a1);
pub const SYM_braille_dots_268: KeySym = KeySym(0x10028a2);
pub const SYM_braille_dots_1268: KeySym = KeySym(0x10028a3);
pub const SYM_braille_dots_368: KeySym = KeySym(0x10028a4);
pub const SYM_braille_dots_1368: KeySym = KeySym(0x10028a5);
pub const SYM_braille_dots_2368: KeySym = KeySym(0x10028a6);
pub const SYM_braille_dots_12368: KeySym = KeySym(0x10028a7);
pub const SYM_braille_dots_468: KeySym = KeySym(0x10028a8);
pub const SYM_braille_dots_1468: KeySym = KeySym(0x10028a9);
pub const SYM_braille_dots_2468: KeySym = KeySym(0x10028aa);
pub const SYM_braille_dots_12468: KeySym = KeySym(0x10028ab);
pub const SYM_braille_dots_3468: KeySym = KeySym(0x10028ac);
pub const SYM_braille_dots_13468: KeySym = KeySym(0x10028ad);
pub const SYM_braille_dots_23468: KeySym = KeySym(0x10028ae);
pub const SYM_braille_dots_123468: KeySym = KeySym(0x10028af);
pub const SYM_braille_dots_568: KeySym = KeySym(0x10028b0);
pub const SYM_braille_dots_1568: KeySym = KeySym(0x10028b1);
pub const SYM_braille_dots_2568: KeySym = KeySym(0x10028b2);
pub const SYM_braille_dots_12568: KeySym = KeySym(0x10028b3);
pub const SYM_braille_dots_3568: KeySym = KeySym(0x10028b4);
pub const SYM_braille_dots_13568: KeySym = KeySym(0x10028b5);
pub const SYM_braille_dots_23568: KeySym = KeySym(0x10028b6);
pub const SYM_braille_dots_123568: KeySym = KeySym(0x10028b7);
pub const SYM_braille_dots_4568: KeySym = KeySym(0x10028b8);
pub const SYM_braille_dots_14568: KeySym = KeySym(0x10028b9);
pub const SYM_braille_dots_24568: KeySym = KeySym(0x10028ba);
pub const SYM_braille_dots_124568: KeySym = KeySym(0x10028bb);
pub const SYM_braille_dots_34568: KeySym = KeySym(0x10028bc);
pub const SYM_braille_dots_134568: KeySym = KeySym(0x10028bd);
pub const SYM_braille_dots_234568: KeySym = KeySym(0x10028be);
pub const SYM_braille_dots_1234568: KeySym = KeySym(0x10028bf);
pub const SYM_braille_dots_78: KeySym = KeySym(0x10028c0);
pub const SYM_braille_dots_178: KeySym = KeySym(0x10028c1);
pub const SYM_braille_dots_278: KeySym = KeySym(0x10028c2);
pub const SYM_braille_dots_1278: KeySym = KeySym(0x10028c3);
pub const SYM_braille_dots_378: KeySym = KeySym(0x10028c4);
pub const SYM_braille_dots_1378: KeySym = KeySym(0x10028c5);
pub const SYM_braille_dots_2378: KeySym = KeySym(0x10028c6);
pub const SYM_braille_dots_12378: KeySym = KeySym(0x10028c7);
pub const SYM_braille_dots_478: KeySym = KeySym(0x10028c8);
pub const SYM_braille_dots_1478: KeySym = KeySym(0x10028c9);
pub const SYM_braille_dots_2478: KeySym = KeySym(0x10028ca);
pub const SYM_braille_dots_12478: KeySym = KeySym(0x10028cb);
pub const SYM_braille_dots_3478: KeySym = KeySym(0x10028cc);
pub const SYM_braille_dots_13478: KeySym = KeySym(0x10028cd);
pub const SYM_braille_dots_23478: KeySym = KeySym(0x10028ce);
pub const SYM_braille_dots_123478: KeySym = KeySym(0x10028cf);
pub const SYM_braille_dots_578: KeySym = KeySym(0x10028d0);
pub const SYM_braille_dots_1578: KeySym = KeySym(0x10028d1);
pub const SYM_braille_dots_2578: KeySym = KeySym(0x10028d2);
pub const SYM_braille_dots_12578: KeySym = KeySym(0x10028d3);
pub const SYM_braille_dots_3578: KeySym = KeySym(0x10028d4);
pub const SYM_braille_dots_13578: KeySym = KeySym(0x10028d5);
pub const SYM_braille_dots_23578: KeySym = KeySym(0x10028d6);
pub const SYM_braille_dots_123578: KeySym = KeySym(0x10028d7);
pub const SYM_braille_dots_4578: KeySym = KeySym(0x10028d8);
pub const SYM_braille_dots_14578: KeySym = KeySym(0x10028d9);
pub const SYM_braille_dots_24578: KeySym = KeySym(0x10028da);
pub const SYM_braille_dots_124578: KeySym = KeySym(0x10028db);
pub const SYM_braille_dots_34578: KeySym = KeySym(0x10028dc);
pub const SYM_braille_dots_134578: KeySym = KeySym(0x10028dd);
pub const SYM_braille_dots_234578: KeySym = KeySym(0x10028de);
pub const SYM_braille_dots_1234578: KeySym = KeySym(0x10028df);
pub const SYM_braille_dots_678: KeySym = KeySym(0x10028e0);
pub const SYM_braille_dots_1678: KeySym = KeySym(0x10028e1);
pub const SYM_braille_dots_2678: KeySym = KeySym(0x10028e2);
pub const SYM_braille_dots_12678: KeySym = KeySym(0x10028e3);
pub const SYM_braille_dots_3678: KeySym = KeySym(0x10028e4);
pub const SYM_braille_dots_13678: KeySym = KeySym(0x10028e5);
pub const SYM_braille_dots_23678: KeySym = KeySym(0x10028e6);
pub const SYM_braille_dots_123678: KeySym = KeySym(0x10028e7);
pub const SYM_braille_dots_4678: KeySym = KeySym(0x10028e8);
pub const SYM_braille_dots_14678: KeySym = KeySym(0x10028e9);
pub const SYM_braille_dots_24678: KeySym = KeySym(0x10028ea);
pub const SYM_braille_dots_124678: KeySym = KeySym(0x10028eb);
pub const SYM_braille_dots_34678: KeySym = KeySym(0x10028ec);
pub const SYM_braille_dots_134678: KeySym = KeySym(0x10028ed);
pub const SYM_braille_dots_234678: KeySym = KeySym(0x10028ee);
pub const SYM_braille_dots_1234678: KeySym = KeySym(0x10028ef);
pub const SYM_braille_dots_5678: KeySym = KeySym(0x10028f0);
pub const SYM_braille_dots_15678: KeySym = KeySym(0x10028f1);
pub const SYM_braille_dots_25678: KeySym = KeySym(0x10028f2);
pub const SYM_braille_dots_125678: KeySym = KeySym(0x10028f3);
pub const SYM_braille_dots_35678: KeySym = KeySym(0x10028f4);
pub const SYM_braille_dots_135678: KeySym = KeySym(0x10028f5);
pub const SYM_braille_dots_235678: KeySym = KeySym(0x10028f6);
pub const SYM_braille_dots_1235678: KeySym = KeySym(0x10028f7);
pub const SYM_braille_dots_45678: KeySym = KeySym(0x10028f8);
pub const SYM_braille_dots_145678: KeySym = KeySym(0x10028f9);
pub const SYM_braille_dots_245678: KeySym = KeySym(0x10028fa);
pub const SYM_braille_dots_1245678: KeySym = KeySym(0x10028fb);
pub const SYM_braille_dots_345678: KeySym = KeySym(0x10028fc);
pub const SYM_braille_dots_1345678: KeySym = KeySym(0x10028fd);
pub const SYM_braille_dots_2345678: KeySym = KeySym(0x10028fe);
pub const SYM_braille_dots_12345678: KeySym = KeySym(0x10028ff);
pub const SYM_Sinh_ng: KeySym = KeySym(0x1000d82);
pub const SYM_Sinh_h2: KeySym = KeySym(0x1000d83);
pub const SYM_Sinh_a: KeySym = KeySym(0x1000d85);
pub const SYM_Sinh_aa: KeySym = KeySym(0x1000d86);
pub const SYM_Sinh_ae: KeySym = KeySym(0x1000d87);
pub const SYM_Sinh_aee: KeySym = KeySym(0x1000d88);
pub const SYM_Sinh_i: KeySym = KeySym(0x1000d89);
pub const SYM_Sinh_ii: KeySym = KeySym(0x1000d8a);
pub const SYM_Sinh_u: KeySym = KeySym(0x1000d8b);
pub const SYM_Sinh_uu: KeySym = KeySym(0x1000d8c);
pub const SYM_Sinh_ri: KeySym = KeySym(0x1000d8d);
pub const SYM_Sinh_rii: KeySym = KeySym(0x1000d8e);
pub const SYM_Sinh_lu: KeySym = KeySym(0x1000d8f);
pub const SYM_Sinh_luu: KeySym = KeySym(0x1000d90);
pub const SYM_Sinh_e: KeySym = KeySym(0x1000d91);
pub const SYM_Sinh_ee: KeySym = KeySym(0x1000d92);
pub const SYM_Sinh_ai: KeySym = KeySym(0x1000d93);
pub const SYM_Sinh_o: KeySym = KeySym(0x1000d94);
pub const SYM_Sinh_oo: KeySym = KeySym(0x1000d95);
pub const SYM_Sinh_au: KeySym = KeySym(0x1000d96);
pub const SYM_Sinh_ka: KeySym = KeySym(0x1000d9a);
pub const SYM_Sinh_kha: KeySym = KeySym(0x1000d9b);
pub const SYM_Sinh_ga: KeySym = KeySym(0x1000d9c);
pub const SYM_Sinh_gha: KeySym = KeySym(0x1000d9d);
pub const SYM_Sinh_ng2: KeySym = KeySym(0x1000d9e);
pub const SYM_Sinh_nga: KeySym = KeySym(0x1000d9f);
pub const SYM_Sinh_ca: KeySym = KeySym(0x1000da0);
pub const SYM_Sinh_cha: KeySym = KeySym(0x1000da1);
pub const SYM_Sinh_ja: KeySym = KeySym(0x1000da2);
pub const SYM_Sinh_jha: KeySym = KeySym(0x1000da3);
pub const SYM_Sinh_nya: KeySym = KeySym(0x1000da4);
pub const SYM_Sinh_jnya: KeySym = KeySym(0x1000da5);
pub const SYM_Sinh_nja: KeySym = KeySym(0x1000da6);
pub const SYM_Sinh_tta: KeySym = KeySym(0x1000da7);
pub const SYM_Sinh_ttha: KeySym = KeySym(0x1000da8);
pub const SYM_Sinh_dda: KeySym = KeySym(0x1000da9);
pub const SYM_Sinh_ddha: KeySym = KeySym(0x1000daa);
pub const SYM_Sinh_nna: KeySym = KeySym(0x1000dab);
pub const SYM_Sinh_ndda: KeySym = KeySym(0x1000dac);
pub const SYM_Sinh_tha: KeySym = KeySym(0x1000dad);
pub const SYM_Sinh_thha: KeySym = KeySym(0x1000dae);
pub const SYM_Sinh_dha: KeySym = KeySym(0x1000daf);
pub const SYM_Sinh_dhha: KeySym = KeySym(0x1000db0);
pub const SYM_Sinh_na: KeySym = KeySym(0x1000db1);
pub const SYM_Sinh_ndha: KeySym = KeySym(0x1000db3);
pub const SYM_Sinh_pa: KeySym = KeySym(0x1000db4);
pub const SYM_Sinh_pha: KeySym = KeySym(0x1000db5);
pub const SYM_Sinh_ba: KeySym = KeySym(0x1000db6);
pub const SYM_Sinh_bha: KeySym = KeySym(0x1000db7);
pub const SYM_Sinh_ma: KeySym = KeySym(0x1000db8);
pub const SYM_Sinh_mba: KeySym = KeySym(0x1000db9);
pub const SYM_Sinh_ya: KeySym = KeySym(0x1000dba);
pub const SYM_Sinh_ra: KeySym = KeySym(0x1000dbb);
pub const SYM_Sinh_la: KeySym = KeySym(0x1000dbd);
pub const SYM_Sinh_va: KeySym = KeySym(0x1000dc0);
pub const SYM_Sinh_sha: KeySym = KeySym(0x1000dc1);
pub const SYM_Sinh_ssha: KeySym = KeySym(0x1000dc2);
pub const SYM_Sinh_sa: KeySym = KeySym(0x1000dc3);
pub const SYM_Sinh_ha: KeySym = KeySym(0x1000dc4);
pub const SYM_Sinh_lla: KeySym = KeySym(0x1000dc5);
pub const SYM_Sinh_fa: KeySym = KeySym(0x1000dc6);
pub const SYM_Sinh_al: KeySym = KeySym(0x1000dca);
pub const SYM_Sinh_aa2: KeySym = KeySym(0x1000dcf);
pub const SYM_Sinh_ae2: KeySym = KeySym(0x1000dd0);
pub const SYM_Sinh_aee2: KeySym = KeySym(0x1000dd1);
pub const SYM_Sinh_i2: KeySym = KeySym(0x1000dd2);
pub const SYM_Sinh_ii2: KeySym = KeySym(0x1000dd3);
pub const SYM_Sinh_u2: KeySym = KeySym(0x1000dd4);
pub const SYM_Sinh_uu2: KeySym = KeySym(0x1000dd6);
pub const SYM_Sinh_ru2: KeySym = KeySym(0x1000dd8);
pub const SYM_Sinh_e2: KeySym = KeySym(0x1000dd9);
pub const SYM_Sinh_ee2: KeySym = KeySym(0x1000dda);
pub const SYM_Sinh_ai2: KeySym = KeySym(0x1000ddb);
pub const SYM_Sinh_o2: KeySym = KeySym(0x1000ddc);
pub const SYM_Sinh_oo2: KeySym = KeySym(0x1000ddd);
pub const SYM_Sinh_au2: KeySym = KeySym(0x1000dde);
pub const SYM_Sinh_lu2: KeySym = KeySym(0x1000ddf);
pub const SYM_Sinh_ruu2: KeySym = KeySym(0x1000df2);
pub const SYM_Sinh_luu2: KeySym = KeySym(0x1000df3);
pub const SYM_Sinh_kunddaliya: KeySym = KeySym(0x1000df4);
pub const SYM_XF86ModeLock: KeySym = KeySym(0x1008FF01);
pub const SYM_XF86MonBrightnessUp: KeySym = KeySym(0x1008FF02);
pub const SYM_XF86MonBrightnessDown: KeySym = KeySym(0x1008FF03);
pub const SYM_XF86KbdLightOnOff: KeySym = KeySym(0x1008FF04);
pub const SYM_XF86KbdBrightnessUp: KeySym = KeySym(0x1008FF05);
pub const SYM_XF86KbdBrightnessDown: KeySym = KeySym(0x1008FF06);
pub const SYM_XF86MonBrightnessCycle: KeySym = KeySym(0x1008FF07);
pub const SYM_XF86Standby: KeySym = KeySym(0x1008FF10);
pub const SYM_XF86AudioLowerVolume: KeySym = KeySym(0x1008FF11);
pub const SYM_XF86AudioMute: KeySym = KeySym(0x1008FF12);
pub const SYM_XF86AudioRaiseVolume: KeySym = KeySym(0x1008FF13);
pub const SYM_XF86AudioPlay: KeySym = KeySym(0x1008FF14);
pub const SYM_XF86AudioStop: KeySym = KeySym(0x1008FF15);
pub const SYM_XF86AudioPrev: KeySym = KeySym(0x1008FF16);
pub const SYM_XF86AudioNext: KeySym = KeySym(0x1008FF17);
pub const SYM_XF86HomePage: KeySym = KeySym(0x1008FF18);
pub const SYM_XF86Mail: KeySym = KeySym(0x1008FF19);
pub const SYM_XF86Start: KeySym = KeySym(0x1008FF1A);
pub const SYM_XF86Search: KeySym = KeySym(0x1008FF1B);
pub const SYM_XF86AudioRecord: KeySym = KeySym(0x1008FF1C);
pub const SYM_XF86Calculator: KeySym = KeySym(0x1008FF1D);
pub const SYM_XF86Memo: KeySym = KeySym(0x1008FF1E);
pub const SYM_XF86ToDoList: KeySym = KeySym(0x1008FF1F);
pub const SYM_XF86Calendar: KeySym = KeySym(0x1008FF20);
pub const SYM_XF86PowerDown: KeySym = KeySym(0x1008FF21);
pub const SYM_XF86ContrastAdjust: KeySym = KeySym(0x1008FF22);
pub const SYM_XF86RockerUp: KeySym = KeySym(0x1008FF23);
pub const SYM_XF86RockerDown: KeySym = KeySym(0x1008FF24);
pub const SYM_XF86RockerEnter: KeySym = KeySym(0x1008FF25);
pub const SYM_XF86Back: KeySym = KeySym(0x1008FF26);
pub const SYM_XF86Forward: KeySym = KeySym(0x1008FF27);
pub const SYM_XF86Stop: KeySym = KeySym(0x1008FF28);
pub const SYM_XF86Refresh: KeySym = KeySym(0x1008FF29);
pub const SYM_XF86PowerOff: KeySym = KeySym(0x1008FF2A);
pub const SYM_XF86WakeUp: KeySym = KeySym(0x1008FF2B);
pub const SYM_XF86Eject: KeySym = KeySym(0x1008FF2C);
pub const SYM_XF86ScreenSaver: KeySym = KeySym(0x1008FF2D);
pub const SYM_XF86WWW: KeySym = KeySym(0x1008FF2E);
pub const SYM_XF86Sleep: KeySym = KeySym(0x1008FF2F);
pub const SYM_XF86Favorites: KeySym = KeySym(0x1008FF30);
pub const SYM_XF86AudioPause: KeySym = KeySym(0x1008FF31);
pub const SYM_XF86AudioMedia: KeySym = KeySym(0x1008FF32);
pub const SYM_XF86MyComputer: KeySym = KeySym(0x1008FF33);
pub const SYM_XF86VendorHome: KeySym = KeySym(0x1008FF34);
pub const SYM_XF86LightBulb: KeySym = KeySym(0x1008FF35);
pub const SYM_XF86Shop: KeySym = KeySym(0x1008FF36);
pub const SYM_XF86History: KeySym = KeySym(0x1008FF37);
pub const SYM_XF86OpenURL: KeySym = KeySym(0x1008FF38);
pub const SYM_XF86AddFavorite: KeySym = KeySym(0x1008FF39);
pub const SYM_XF86HotLinks: KeySym = KeySym(0x1008FF3A);
pub const SYM_XF86BrightnessAdjust: KeySym = KeySym(0x1008FF3B);
pub const SYM_XF86Finance: KeySym = KeySym(0x1008FF3C);
pub const SYM_XF86Community: KeySym = KeySym(0x1008FF3D);
pub const SYM_XF86AudioRewind: KeySym = KeySym(0x1008FF3E);
pub const SYM_XF86BackForward: KeySym = KeySym(0x1008FF3F);
pub const SYM_XF86Launch0: KeySym = KeySym(0x1008FF40);
pub const SYM_XF86Launch1: KeySym = KeySym(0x1008FF41);
pub const SYM_XF86Launch2: KeySym = KeySym(0x1008FF42);
pub const SYM_XF86Launch3: KeySym = KeySym(0x1008FF43);
pub const SYM_XF86Launch4: KeySym = KeySym(0x1008FF44);
pub const SYM_XF86Launch5: KeySym = KeySym(0x1008FF45);
pub const SYM_XF86Launch6: KeySym = KeySym(0x1008FF46);
pub const SYM_XF86Launch7: KeySym = KeySym(0x1008FF47);
pub const SYM_XF86Launch8: KeySym = KeySym(0x1008FF48);
pub const SYM_XF86Launch9: KeySym = KeySym(0x1008FF49);
pub const SYM_XF86LaunchA: KeySym = KeySym(0x1008FF4A);
pub const SYM_XF86LaunchB: KeySym = KeySym(0x1008FF4B);
pub const SYM_XF86LaunchC: KeySym = KeySym(0x1008FF4C);
pub const SYM_XF86LaunchD: KeySym = KeySym(0x1008FF4D);
pub const SYM_XF86LaunchE: KeySym = KeySym(0x1008FF4E);
pub const SYM_XF86LaunchF: KeySym = KeySym(0x1008FF4F);
pub const SYM_XF86ApplicationLeft: KeySym = KeySym(0x1008FF50);
pub const SYM_XF86ApplicationRight: KeySym = KeySym(0x1008FF51);
pub const SYM_XF86Book: KeySym = KeySym(0x1008FF52);
pub const SYM_XF86CD: KeySym = KeySym(0x1008FF53);
pub const SYM_XF86Calculater: KeySym = KeySym(0x1008FF54);
pub const SYM_XF86Clear: KeySym = KeySym(0x1008FF55);
pub const SYM_XF86Close: KeySym = KeySym(0x1008FF56);
pub const SYM_XF86Copy: KeySym = KeySym(0x1008FF57);
pub const SYM_XF86Cut: KeySym = KeySym(0x1008FF58);
pub const SYM_XF86Display: KeySym = KeySym(0x1008FF59);
pub const SYM_XF86DOS: KeySym = KeySym(0x1008FF5A);
pub const SYM_XF86Documents: KeySym = KeySym(0x1008FF5B);
pub const SYM_XF86Excel: KeySym = KeySym(0x1008FF5C);
pub const SYM_XF86Explorer: KeySym = KeySym(0x1008FF5D);
pub const SYM_XF86Game: KeySym = KeySym(0x1008FF5E);
pub const SYM_XF86Go: KeySym = KeySym(0x1008FF5F);
pub const SYM_XF86iTouch: KeySym = KeySym(0x1008FF60);
pub const SYM_XF86LogOff: KeySym = KeySym(0x1008FF61);
pub const SYM_XF86Market: KeySym = KeySym(0x1008FF62);
pub const SYM_XF86Meeting: KeySym = KeySym(0x1008FF63);
pub const SYM_XF86MenuKB: KeySym = KeySym(0x1008FF65);
pub const SYM_XF86MenuPB: KeySym = KeySym(0x1008FF66);
pub const SYM_XF86MySites: KeySym = KeySym(0x1008FF67);
pub const SYM_XF86New: KeySym = KeySym(0x1008FF68);
pub const SYM_XF86News: KeySym = KeySym(0x1008FF69);
pub const SYM_XF86OfficeHome: KeySym = KeySym(0x1008FF6A);
pub const SYM_XF86Open: KeySym = KeySym(0x1008FF6B);
pub const SYM_XF86Option: KeySym = KeySym(0x1008FF6C);
pub const SYM_XF86Paste: KeySym = KeySym(0x1008FF6D);
pub const SYM_XF86Phone: KeySym = KeySym(0x1008FF6E);
pub const SYM_XF86Q: KeySym = KeySym(0x1008FF70);
pub const SYM_XF86Reply: KeySym = KeySym(0x1008FF72);
pub const SYM_XF86Reload: KeySym = KeySym(0x1008FF73);
pub const SYM_XF86RotateWindows: KeySym = KeySym(0x1008FF74);
pub const SYM_XF86RotationPB: KeySym = KeySym(0x1008FF75);
pub const SYM_XF86RotationKB: KeySym = KeySym(0x1008FF76);
pub const SYM_XF86Save: KeySym = KeySym(0x1008FF77);
pub const SYM_XF86ScrollUp: KeySym = KeySym(0x1008FF78);
pub const SYM_XF86ScrollDown: KeySym = KeySym(0x1008FF79);
pub const SYM_XF86ScrollClick: KeySym = KeySym(0x1008FF7A);
pub const SYM_XF86Send: KeySym = KeySym(0x1008FF7B);
pub const SYM_XF86Spell: KeySym = KeySym(0x1008FF7C);
pub const SYM_XF86SplitScreen: KeySym = KeySym(0x1008FF7D);
pub const SYM_XF86Support: KeySym = KeySym(0x1008FF7E);
pub const SYM_XF86TaskPane: KeySym = KeySym(0x1008FF7F);
pub const SYM_XF86Terminal: KeySym = KeySym(0x1008FF80);
pub const SYM_XF86Tools: KeySym = KeySym(0x1008FF81);
pub const SYM_XF86Travel: KeySym = KeySym(0x1008FF82);
pub const SYM_XF86UserPB: KeySym = KeySym(0x1008FF84);
pub const SYM_XF86User1KB: KeySym = KeySym(0x1008FF85);
pub const SYM_XF86User2KB: KeySym = KeySym(0x1008FF86);
pub const SYM_XF86Video: KeySym = KeySym(0x1008FF87);
pub const SYM_XF86WheelButton: KeySym = KeySym(0x1008FF88);
pub const SYM_XF86Word: KeySym = KeySym(0x1008FF89);
pub const SYM_XF86Xfer: KeySym = KeySym(0x1008FF8A);
pub const SYM_XF86ZoomIn: KeySym = KeySym(0x1008FF8B);
pub const SYM_XF86ZoomOut: KeySym = KeySym(0x1008FF8C);
pub const SYM_XF86Away: KeySym = KeySym(0x1008FF8D);
pub const SYM_XF86Messenger: KeySym = KeySym(0x1008FF8E);
pub const SYM_XF86WebCam: KeySym = KeySym(0x1008FF8F);
pub const SYM_XF86MailForward: KeySym = KeySym(0x1008FF90);
pub const SYM_XF86Pictures: KeySym = KeySym(0x1008FF91);
pub const SYM_XF86Music: KeySym = KeySym(0x1008FF92);
pub const SYM_XF86Battery: KeySym = KeySym(0x1008FF93);
pub const SYM_XF86Bluetooth: KeySym = KeySym(0x1008FF94);
pub const SYM_XF86WLAN: KeySym = KeySym(0x1008FF95);
pub const SYM_XF86UWB: KeySym = KeySym(0x1008FF96);
pub const SYM_XF86AudioForward: KeySym = KeySym(0x1008FF97);
pub const SYM_XF86AudioRepeat: KeySym = KeySym(0x1008FF98);
pub const SYM_XF86AudioRandomPlay: KeySym = KeySym(0x1008FF99);
pub const SYM_XF86Subtitle: KeySym = KeySym(0x1008FF9A);
pub const SYM_XF86AudioCycleTrack: KeySym = KeySym(0x1008FF9B);
pub const SYM_XF86CycleAngle: KeySym = KeySym(0x1008FF9C);
pub const SYM_XF86FrameBack: KeySym = KeySym(0x1008FF9D);
pub const SYM_XF86FrameForward: KeySym = KeySym(0x1008FF9E);
pub const SYM_XF86Time: KeySym = KeySym(0x1008FF9F);
pub const SYM_XF86Select: KeySym = KeySym(0x1008FFA0);
pub const SYM_XF86View: KeySym = KeySym(0x1008FFA1);
pub const SYM_XF86TopMenu: KeySym = KeySym(0x1008FFA2);
pub const SYM_XF86Red: KeySym = KeySym(0x1008FFA3);
pub const SYM_XF86Green: KeySym = KeySym(0x1008FFA4);
pub const SYM_XF86Yellow: KeySym = KeySym(0x1008FFA5);
pub const SYM_XF86Blue: KeySym = KeySym(0x1008FFA6);
pub const SYM_XF86Suspend: KeySym = KeySym(0x1008FFA7);
pub const SYM_XF86Hibernate: KeySym = KeySym(0x1008FFA8);
pub const SYM_XF86TouchpadToggle: KeySym = KeySym(0x1008FFA9);
pub const SYM_XF86TouchpadOn: KeySym = KeySym(0x1008FFB0);
pub const SYM_XF86TouchpadOff: KeySym = KeySym(0x1008FFB1);
pub const SYM_XF86AudioMicMute: KeySym = KeySym(0x1008FFB2);
pub const SYM_XF86Keyboard: KeySym = KeySym(0x1008FFB3);
pub const SYM_XF86WWAN: KeySym = KeySym(0x1008FFB4);
pub const SYM_XF86RFKill: KeySym = KeySym(0x1008FFB5);
pub const SYM_XF86AudioPreset: KeySym = KeySym(0x1008FFB6);
pub const SYM_XF86RotationLockToggle: KeySym = KeySym(0x1008FFB7);
pub const SYM_XF86FullScreen: KeySym = KeySym(0x1008FFB8);
pub const SYM_XF86Switch_VT_1: KeySym = KeySym(0x1008FE01);
pub const SYM_XF86Switch_VT_2: KeySym = KeySym(0x1008FE02);
pub const SYM_XF86Switch_VT_3: KeySym = KeySym(0x1008FE03);
pub const SYM_XF86Switch_VT_4: KeySym = KeySym(0x1008FE04);
pub const SYM_XF86Switch_VT_5: KeySym = KeySym(0x1008FE05);
pub const SYM_XF86Switch_VT_6: KeySym = KeySym(0x1008FE06);
pub const SYM_XF86Switch_VT_7: KeySym = KeySym(0x1008FE07);
pub const SYM_XF86Switch_VT_8: KeySym = KeySym(0x1008FE08);
pub const SYM_XF86Switch_VT_9: KeySym = KeySym(0x1008FE09);
pub const SYM_XF86Switch_VT_10: KeySym = KeySym(0x1008FE0A);
pub const SYM_XF86Switch_VT_11: KeySym = KeySym(0x1008FE0B);
pub const SYM_XF86Switch_VT_12: KeySym = KeySym(0x1008FE0C);
pub const SYM_XF86Ungrab: KeySym = KeySym(0x1008FE20);
pub const SYM_XF86ClearGrab: KeySym = KeySym(0x1008FE21);
pub const SYM_XF86Next_VMode: KeySym = KeySym(0x1008FE22);
pub const SYM_XF86Prev_VMode: KeySym = KeySym(0x1008FE23);
pub const SYM_XF86LogWindowTree: KeySym = KeySym(0x1008FE24);
pub const SYM_XF86LogGrabInfo: KeySym = KeySym(0x1008FE25);
pub const SYM_XF86BrightnessAuto: KeySym = KeySym(0x100810f4);
pub const SYM_XF86DisplayOff: KeySym = KeySym(0x100810f5);
pub const SYM_XF86Info: KeySym = KeySym(0x10081166);
pub const SYM_XF86AspectRatio: KeySym = KeySym(0x10081177);
pub const SYM_XF86DVD: KeySym = KeySym(0x10081185);
pub const SYM_XF86Audio: KeySym = KeySym(0x10081188);
pub const SYM_XF86ChannelUp: KeySym = KeySym(0x10081192);
pub const SYM_XF86ChannelDown: KeySym = KeySym(0x10081193);
pub const SYM_XF86Break: KeySym = KeySym(0x1008119b);
pub const SYM_XF86VideoPhone: KeySym = KeySym(0x100811a0);
pub const SYM_XF86ZoomReset: KeySym = KeySym(0x100811a4);
pub const SYM_XF86Editor: KeySym = KeySym(0x100811a6);
pub const SYM_XF86GraphicsEditor: KeySym = KeySym(0x100811a8);
pub const SYM_XF86Presentation: KeySym = KeySym(0x100811a9);
pub const SYM_XF86Database: KeySym = KeySym(0x100811aa);
pub const SYM_XF86Voicemail: KeySym = KeySym(0x100811ac);
pub const SYM_XF86Addressbook: KeySym = KeySym(0x100811ad);
pub const SYM_XF86DisplayToggle: KeySym = KeySym(0x100811af);
pub const SYM_XF86SpellCheck: KeySym = KeySym(0x100811b0);
pub const SYM_XF86ContextMenu: KeySym = KeySym(0x100811b6);
pub const SYM_XF86MediaRepeat: KeySym = KeySym(0x100811b7);
pub const SYM_XF8610ChannelsUp: KeySym = KeySym(0x100811b8);
pub const SYM_XF8610ChannelsDown: KeySym = KeySym(0x100811b9);
pub const SYM_XF86Images: KeySym = KeySym(0x100811ba);
pub const SYM_XF86NotificationCenter: KeySym = KeySym(0x100811bc);
pub const SYM_XF86PickupPhone: KeySym = KeySym(0x100811bd);
pub const SYM_XF86HangupPhone: KeySym = KeySym(0x100811be);
pub const SYM_XF86Fn: KeySym = KeySym(0x100811d0);
pub const SYM_XF86Fn_Esc: KeySym = KeySym(0x100811d1);
pub const SYM_XF86FnRightShift: KeySym = KeySym(0x100811e5);
pub const SYM_XF86Numeric0: KeySym = KeySym(0x10081200);
pub const SYM_XF86Numeric1: KeySym = KeySym(0x10081201);
pub const SYM_XF86Numeric2: KeySym = KeySym(0x10081202);
pub const SYM_XF86Numeric3: KeySym = KeySym(0x10081203);
pub const SYM_XF86Numeric4: KeySym = KeySym(0x10081204);
pub const SYM_XF86Numeric5: KeySym = KeySym(0x10081205);
pub const SYM_XF86Numeric6: KeySym = KeySym(0x10081206);
pub const SYM_XF86Numeric7: KeySym = KeySym(0x10081207);
pub const SYM_XF86Numeric8: KeySym = KeySym(0x10081208);
pub const SYM_XF86Numeric9: KeySym = KeySym(0x10081209);
pub const SYM_XF86NumericStar: KeySym = KeySym(0x1008120a);
pub const SYM_XF86NumericPound: KeySym = KeySym(0x1008120b);
pub const SYM_XF86NumericA: KeySym = KeySym(0x1008120c);
pub const SYM_XF86NumericB: KeySym = KeySym(0x1008120d);
pub const SYM_XF86NumericC: KeySym = KeySym(0x1008120e);
pub const SYM_XF86NumericD: KeySym = KeySym(0x1008120f);
pub const SYM_XF86CameraFocus: KeySym = KeySym(0x10081210);
pub const SYM_XF86WPSButton: KeySym = KeySym(0x10081211);
pub const SYM_XF86CameraZoomIn: KeySym = KeySym(0x10081215);
pub const SYM_XF86CameraZoomOut: KeySym = KeySym(0x10081216);
pub const SYM_XF86CameraUp: KeySym = KeySym(0x10081217);
pub const SYM_XF86CameraDown: KeySym = KeySym(0x10081218);
pub const SYM_XF86CameraLeft: KeySym = KeySym(0x10081219);
pub const SYM_XF86CameraRight: KeySym = KeySym(0x1008121a);
pub const SYM_XF86AttendantOn: KeySym = KeySym(0x1008121b);
pub const SYM_XF86AttendantOff: KeySym = KeySym(0x1008121c);
pub const SYM_XF86AttendantToggle: KeySym = KeySym(0x1008121d);
pub const SYM_XF86LightsToggle: KeySym = KeySym(0x1008121e);
pub const SYM_XF86ALSToggle: KeySym = KeySym(0x10081230);
pub const SYM_XF86Buttonconfig: KeySym = KeySym(0x10081240);
pub const SYM_XF86Taskmanager: KeySym = KeySym(0x10081241);
pub const SYM_XF86Journal: KeySym = KeySym(0x10081242);
pub const SYM_XF86ControlPanel: KeySym = KeySym(0x10081243);
pub const SYM_XF86AppSelect: KeySym = KeySym(0x10081244);
pub const SYM_XF86Screensaver: KeySym = KeySym(0x10081245);
pub const SYM_XF86VoiceCommand: KeySym = KeySym(0x10081246);
pub const SYM_XF86Assistant: KeySym = KeySym(0x10081247);
pub const SYM_XF86BrightnessMin: KeySym = KeySym(0x10081250);
pub const SYM_XF86BrightnessMax: KeySym = KeySym(0x10081251);
pub const SYM_XF86KbdInputAssistPrev: KeySym = KeySym(0x10081260);
pub const SYM_XF86KbdInputAssistNext: KeySym = KeySym(0x10081261);
pub const SYM_XF86KbdInputAssistPrevgroup: KeySym = KeySym(0x10081262);
pub const SYM_XF86KbdInputAssistNextgroup: KeySym = KeySym(0x10081263);
pub const SYM_XF86KbdInputAssistAccept: KeySym = KeySym(0x10081264);
pub const SYM_XF86KbdInputAssistCancel: KeySym = KeySym(0x10081265);
pub const SYM_XF86RightUp: KeySym = KeySym(0x10081266);
pub const SYM_XF86RightDown: KeySym = KeySym(0x10081267);
pub const SYM_XF86LeftUp: KeySym = KeySym(0x10081268);
pub const SYM_XF86LeftDown: KeySym = KeySym(0x10081269);
pub const SYM_XF86RootMenu: KeySym = KeySym(0x1008126a);
pub const SYM_XF86MediaTopMenu: KeySym = KeySym(0x1008126b);
pub const SYM_XF86Numeric11: KeySym = KeySym(0x1008126c);
pub const SYM_XF86Numeric12: KeySym = KeySym(0x1008126d);
pub const SYM_XF86AudioDesc: KeySym = KeySym(0x1008126e);
pub const SYM_XF863DMode: KeySym = KeySym(0x1008126f);
pub const SYM_XF86NextFavorite: KeySym = KeySym(0x10081270);
pub const SYM_XF86StopRecord: KeySym = KeySym(0x10081271);
pub const SYM_XF86PauseRecord: KeySym = KeySym(0x10081272);
pub const SYM_XF86VOD: KeySym = KeySym(0x10081273);
pub const SYM_XF86Unmute: KeySym = KeySym(0x10081274);
pub const SYM_XF86FastReverse: KeySym = KeySym(0x10081275);
pub const SYM_XF86SlowReverse: KeySym = KeySym(0x10081276);
pub const SYM_XF86Data: KeySym = KeySym(0x10081277);
pub const SYM_XF86OnScreenKeyboard: KeySym = KeySym(0x10081278);
pub const SYM_XF86PrivacyScreenToggle: KeySym = KeySym(0x10081279);
pub const SYM_XF86SelectiveScreenshot: KeySym = KeySym(0x1008127a);
pub const SYM_XF86Macro1: KeySym = KeySym(0x10081290);
pub const SYM_XF86Macro2: KeySym = KeySym(0x10081291);
pub const SYM_XF86Macro3: KeySym = KeySym(0x10081292);
pub const SYM_XF86Macro4: KeySym = KeySym(0x10081293);
pub const SYM_XF86Macro5: KeySym = KeySym(0x10081294);
pub const SYM_XF86Macro6: KeySym = KeySym(0x10081295);
pub const SYM_XF86Macro7: KeySym = KeySym(0x10081296);
pub const SYM_XF86Macro8: KeySym = KeySym(0x10081297);
pub const SYM_XF86Macro9: KeySym = KeySym(0x10081298);
pub const SYM_XF86Macro10: KeySym = KeySym(0x10081299);
pub const SYM_XF86Macro11: KeySym = KeySym(0x1008129a);
pub const SYM_XF86Macro12: KeySym = KeySym(0x1008129b);
pub const SYM_XF86Macro13: KeySym = KeySym(0x1008129c);
pub const SYM_XF86Macro14: KeySym = KeySym(0x1008129d);
pub const SYM_XF86Macro15: KeySym = KeySym(0x1008129e);
pub const SYM_XF86Macro16: KeySym = KeySym(0x1008129f);
pub const SYM_XF86Macro17: KeySym = KeySym(0x100812a0);
pub const SYM_XF86Macro18: KeySym = KeySym(0x100812a1);
pub const SYM_XF86Macro19: KeySym = KeySym(0x100812a2);
pub const SYM_XF86Macro20: KeySym = KeySym(0x100812a3);
pub const SYM_XF86Macro21: KeySym = KeySym(0x100812a4);
pub const SYM_XF86Macro22: KeySym = KeySym(0x100812a5);
pub const SYM_XF86Macro23: KeySym = KeySym(0x100812a6);
pub const SYM_XF86Macro24: KeySym = KeySym(0x100812a7);
pub const SYM_XF86Macro25: KeySym = KeySym(0x100812a8);
pub const SYM_XF86Macro26: KeySym = KeySym(0x100812a9);
pub const SYM_XF86Macro27: KeySym = KeySym(0x100812aa);
pub const SYM_XF86Macro28: KeySym = KeySym(0x100812ab);
pub const SYM_XF86Macro29: KeySym = KeySym(0x100812ac);
pub const SYM_XF86Macro30: KeySym = KeySym(0x100812ad);
pub const SYM_XF86MacroRecordStart: KeySym = KeySym(0x100812b0);
pub const SYM_XF86MacroRecordStop: KeySym = KeySym(0x100812b1);
pub const SYM_XF86MacroPresetCycle: KeySym = KeySym(0x100812b2);
pub const SYM_XF86MacroPreset1: KeySym = KeySym(0x100812b3);
pub const SYM_XF86MacroPreset2: KeySym = KeySym(0x100812b4);
pub const SYM_XF86MacroPreset3: KeySym = KeySym(0x100812b5);
pub const SYM_XF86KbdLcdMenu1: KeySym = KeySym(0x100812b8);
pub const SYM_XF86KbdLcdMenu2: KeySym = KeySym(0x100812b9);
pub const SYM_XF86KbdLcdMenu3: KeySym = KeySym(0x100812ba);
pub const SYM_XF86KbdLcdMenu4: KeySym = KeySym(0x100812bb);
pub const SYM_XF86KbdLcdMenu5: KeySym = KeySym(0x100812bc);
pub const SYM_SunFA_Grave: KeySym = KeySym(0x1005FF00);
pub const SYM_SunFA_Circum: KeySym = KeySym(0x1005FF01);
pub const SYM_SunFA_Tilde: KeySym = KeySym(0x1005FF02);
pub const SYM_SunFA_Acute: KeySym = KeySym(0x1005FF03);
pub const SYM_SunFA_Diaeresis: KeySym = KeySym(0x1005FF04);
pub const SYM_SunFA_Cedilla: KeySym = KeySym(0x1005FF05);
pub const SYM_SunF36: KeySym = KeySym(0x1005FF10);
pub const SYM_SunF37: KeySym = KeySym(0x1005FF11);
pub const SYM_SunSys_Req: KeySym = KeySym(0x1005FF60);
pub const SYM_SunPrint_Screen: KeySym = KeySym(0x0000FF61);
pub const SYM_SunCompose: KeySym = KeySym(0x0000FF20);
pub const SYM_SunAltGraph: KeySym = KeySym(0x0000FF7E);
pub const SYM_SunPageUp: KeySym = KeySym(0x0000FF55);
pub const SYM_SunPageDown: KeySym = KeySym(0x0000FF56);
pub const SYM_SunUndo: KeySym = KeySym(0x0000FF65);
pub const SYM_SunAgain: KeySym = KeySym(0x0000FF66);
pub const SYM_SunFind: KeySym = KeySym(0x0000FF68);
pub const SYM_SunStop: KeySym = KeySym(0x0000FF69);
pub const SYM_SunProps: KeySym = KeySym(0x1005FF70);
pub const SYM_SunFront: KeySym = KeySym(0x1005FF71);
pub const SYM_SunCopy: KeySym = KeySym(0x1005FF72);
pub const SYM_SunOpen: KeySym = KeySym(0x1005FF73);
pub const SYM_SunPaste: KeySym = KeySym(0x1005FF74);
pub const SYM_SunCut: KeySym = KeySym(0x1005FF75);
pub const SYM_SunPowerSwitch: KeySym = KeySym(0x1005FF76);
pub const SYM_SunAudioLowerVolume: KeySym = KeySym(0x1005FF77);
pub const SYM_SunAudioMute: KeySym = KeySym(0x1005FF78);
pub const SYM_SunAudioRaiseVolume: KeySym = KeySym(0x1005FF79);
pub const SYM_SunVideoDegauss: KeySym = KeySym(0x1005FF7A);
pub const SYM_SunVideoLowerBrightness: KeySym = KeySym(0x1005FF7B);
pub const SYM_SunVideoRaiseBrightness: KeySym = KeySym(0x1005FF7C);
pub const SYM_SunPowerSwitchShift: KeySym = KeySym(0x1005FF7D);
pub const SYM_Dring_accent: KeySym = KeySym(0x1000FEB0);
pub const SYM_Dcircumflex_accent: KeySym = KeySym(0x1000FE5E);
pub const SYM_Dcedilla_accent: KeySym = KeySym(0x1000FE2C);
pub const SYM_Dacute_accent: KeySym = KeySym(0x1000FE27);
pub const SYM_Dgrave_accent: KeySym = KeySym(0x1000FE60);
pub const SYM_Dtilde: KeySym = KeySym(0x1000FE7E);
pub const SYM_Ddiaeresis: KeySym = KeySym(0x1000FE22);
pub const SYM_DRemove: KeySym = KeySym(0x1000FF00);
pub const SYM_hpClearLine: KeySym = KeySym(0x1000FF6F);
pub const SYM_hpInsertLine: KeySym = KeySym(0x1000FF70);
pub const SYM_hpDeleteLine: KeySym = KeySym(0x1000FF71);
pub const SYM_hpInsertChar: KeySym = KeySym(0x1000FF72);
pub const SYM_hpDeleteChar: KeySym = KeySym(0x1000FF73);
pub const SYM_hpBackTab: KeySym = KeySym(0x1000FF74);
pub const SYM_hpKP_BackTab: KeySym = KeySym(0x1000FF75);
pub const SYM_hpModelock1: KeySym = KeySym(0x1000FF48);
pub const SYM_hpModelock2: KeySym = KeySym(0x1000FF49);
pub const SYM_hpReset: KeySym = KeySym(0x1000FF6C);
pub const SYM_hpSystem: KeySym = KeySym(0x1000FF6D);
pub const SYM_hpUser: KeySym = KeySym(0x1000FF6E);
pub const SYM_hpmute_acute: KeySym = KeySym(0x100000A8);
pub const SYM_hpmute_grave: KeySym = KeySym(0x100000A9);
pub const SYM_hpmute_asciicircum: KeySym = KeySym(0x100000AA);
pub const SYM_hpmute_diaeresis: KeySym = KeySym(0x100000AB);
pub const SYM_hpmute_asciitilde: KeySym = KeySym(0x100000AC);
pub const SYM_hplira: KeySym = KeySym(0x100000AF);
pub const SYM_hpguilder: KeySym = KeySym(0x100000BE);
pub const SYM_hpYdiaeresis: KeySym = KeySym(0x100000EE);
pub const SYM_hpIO: KeySym = KeySym(0x100000EE);
pub const SYM_hplongminus: KeySym = KeySym(0x100000F6);
pub const SYM_hpblock: KeySym = KeySym(0x100000FC);
pub const SYM_osfCopy: KeySym = KeySym(0x1004FF02);
pub const SYM_osfCut: KeySym = KeySym(0x1004FF03);
pub const SYM_osfPaste: KeySym = KeySym(0x1004FF04);
pub const SYM_osfBackTab: KeySym = KeySym(0x1004FF07);
pub const SYM_osfBackSpace: KeySym = KeySym(0x1004FF08);
pub const SYM_osfClear: KeySym = KeySym(0x1004FF0B);
pub const SYM_osfEscape: KeySym = KeySym(0x1004FF1B);
pub const SYM_osfAddMode: KeySym = KeySym(0x1004FF31);
pub const SYM_osfPrimaryPaste: KeySym = KeySym(0x1004FF32);
pub const SYM_osfQuickPaste: KeySym = KeySym(0x1004FF33);
pub const SYM_osfPageLeft: KeySym = KeySym(0x1004FF40);
pub const SYM_osfPageUp: KeySym = KeySym(0x1004FF41);
pub const SYM_osfPageDown: KeySym = KeySym(0x1004FF42);
pub const SYM_osfPageRight: KeySym = KeySym(0x1004FF43);
pub const SYM_osfActivate: KeySym = KeySym(0x1004FF44);
pub const SYM_osfMenuBar: KeySym = KeySym(0x1004FF45);
pub const SYM_osfLeft: KeySym = KeySym(0x1004FF51);
pub const SYM_osfUp: KeySym = KeySym(0x1004FF52);
pub const SYM_osfRight: KeySym = KeySym(0x1004FF53);
pub const SYM_osfDown: KeySym = KeySym(0x1004FF54);
pub const SYM_osfEndLine: KeySym = KeySym(0x1004FF57);
pub const SYM_osfBeginLine: KeySym = KeySym(0x1004FF58);
pub const SYM_osfEndData: KeySym = KeySym(0x1004FF59);
pub const SYM_osfBeginData: KeySym = KeySym(0x1004FF5A);
pub const SYM_osfPrevMenu: KeySym = KeySym(0x1004FF5B);
pub const SYM_osfNextMenu: KeySym = KeySym(0x1004FF5C);
pub const SYM_osfPrevField: KeySym = KeySym(0x1004FF5D);
pub const SYM_osfNextField: KeySym = KeySym(0x1004FF5E);
pub const SYM_osfSelect: KeySym = KeySym(0x1004FF60);
pub const SYM_osfInsert: KeySym = KeySym(0x1004FF63);
pub const SYM_osfUndo: KeySym = KeySym(0x1004FF65);
pub const SYM_osfMenu: KeySym = KeySym(0x1004FF67);
pub const SYM_osfCancel: KeySym = KeySym(0x1004FF69);
pub const SYM_osfHelp: KeySym = KeySym(0x1004FF6A);
pub const SYM_osfSelectAll: KeySym = KeySym(0x1004FF71);
pub const SYM_osfDeselectAll: KeySym = KeySym(0x1004FF72);
pub const SYM_osfReselect: KeySym = KeySym(0x1004FF73);
pub const SYM_osfExtend: KeySym = KeySym(0x1004FF74);
pub const SYM_osfRestore: KeySym = KeySym(0x1004FF78);
pub const SYM_osfDelete: KeySym = KeySym(0x1004FFFF);
pub const SYM_Reset: KeySym = KeySym(0x1000FF6C);
pub const SYM_System: KeySym = KeySym(0x1000FF6D);
pub const SYM_User: KeySym = KeySym(0x1000FF6E);
pub const SYM_ClearLine: KeySym = KeySym(0x1000FF6F);
pub const SYM_InsertLine: KeySym = KeySym(0x1000FF70);
pub const SYM_DeleteLine: KeySym = KeySym(0x1000FF71);
pub const SYM_InsertChar: KeySym = KeySym(0x1000FF72);
pub const SYM_DeleteChar: KeySym = KeySym(0x1000FF73);
pub const SYM_BackTab: KeySym = KeySym(0x1000FF74);
pub const SYM_KP_BackTab: KeySym = KeySym(0x1000FF75);
pub const SYM_Ext16bit_L: KeySym = KeySym(0x1000FF76);
pub const SYM_Ext16bit_R: KeySym = KeySym(0x1000FF77);
pub const SYM_mute_acute: KeySym = KeySym(0x100000a8);
pub const SYM_mute_grave: KeySym = KeySym(0x100000a9);
pub const SYM_mute_asciicircum: KeySym = KeySym(0x100000aa);
pub const SYM_mute_diaeresis: KeySym = KeySym(0x100000ab);
pub const SYM_mute_asciitilde: KeySym = KeySym(0x100000ac);
pub const SYM_lira: KeySym = KeySym(0x100000af);
pub const SYM_guilder: KeySym = KeySym(0x100000be);
pub const SYM_IO: KeySym = KeySym(0x100000ee);
pub const SYM_longminus: KeySym = KeySym(0x100000f6);
pub const SYM_block: KeySym = KeySym(0x100000fc);
