// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files)
// DO NOT EDIT

use crate::Value;
use glib::{
  object::{Cast, IsA},
  signal::{connect_raw, SignalHandlerId},
  translate::*,
  StaticType, ToValue,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "JSCWeakValue")]
    pub struct WeakValue(Object<ffi::JSCWeakValue, ffi::JSCWeakValueClass>);

    match fn {
        type_ => || ffi::jsc_weak_value_get_type(),
    }
}

impl WeakValue {
  #[doc(alias = "jsc_weak_value_new")]
  pub fn new(value: &impl IsA<Value>) -> WeakValue {
    unsafe { from_glib_full(ffi::jsc_weak_value_new(value.as_ref().to_glib_none().0)) }
  }

  // rustdoc-stripper-ignore-next
  /// Creates a new builder-pattern struct instance to construct [`WeakValue`] objects.
  ///
  /// This method returns an instance of [`WeakValueBuilder`] which can be used to create [`WeakValue`] objects.
  pub fn builder() -> WeakValueBuilder {
    WeakValueBuilder::default()
  }
}

impl Default for WeakValue {
  fn default() -> Self {
    glib::object::Object::new::<Self>(&[])
      .expect("Can't construct WeakValue object with default parameters")
  }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`WeakValue`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct WeakValueBuilder {
  value: Option<Value>,
}

impl WeakValueBuilder {
  // rustdoc-stripper-ignore-next
  /// Create a new [`WeakValueBuilder`].
  pub fn new() -> Self {
    Self::default()
  }

  // rustdoc-stripper-ignore-next
  /// Build the [`WeakValue`].
  pub fn build(self) -> WeakValue {
    let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
    if let Some(ref value) = self.value {
      properties.push(("value", value));
    }
    glib::Object::new::<WeakValue>(&properties).expect("Failed to create an instance of WeakValue")
  }

  pub fn value(mut self, value: &impl IsA<Value>) -> Self {
    self.value = Some(value.clone().upcast());
    self
  }
}

pub const NONE_WEAK_VALUE: Option<&WeakValue> = None;

pub trait WeakValueExt: 'static {
  #[doc(alias = "jsc_weak_value_get_value")]
  #[doc(alias = "get_value")]
  fn value(&self) -> Option<Value>;

  #[doc(alias = "cleared")]
  fn connect_cleared<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<WeakValue>> WeakValueExt for O {
  fn value(&self) -> Option<Value> {
    unsafe {
      from_glib_full(ffi::jsc_weak_value_get_value(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  fn connect_cleared<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn cleared_trampoline<P: IsA<WeakValue>, F: Fn(&P) + 'static>(
      this: *mut ffi::JSCWeakValue,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(WeakValue::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"cleared\0".as_ptr() as *const _,
        Some(transmute::<_, unsafe extern "C" fn()>(
          cleared_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }
}

impl fmt::Display for WeakValue {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    f.write_str("WeakValue")
  }
}
