# jamsocket-wasm-host

This crate loads a Jamsocket WebAssembly module and wraps it in an interface
that implements JamsocketService, so that it can be used interchangably with
native JamsocketService implementations. If you only want to serve WebAssembly
modules, you can use the `jamsocket` command-line application (which uses this
crate) instead of using this crate directly.

## WebAssembly interface

The host expects that the WebAssembly module provided to it will conform to
a particular interface (that is, has particular named imports and exports).
Eventually, WebAssembly extensions like Interface Types may allow us to
formalize this interface.

Code generated by `jamsocket-wasm-macro` automatically conforms to the interface,
but if you are implementing in a non-Rust language, it's up to you to ensure that
imports and exports are available and correctly typed, or else a runtime error
will occur when the module is loaded.

### Exports

The module is expected to export these functions:

- `fn jam_malloc(size: u32) -> u32`: Allocate `size` bytes of memory inside the WebAssembly module and return a pointer.
- `fn jam_free(loc: *mut u8, size: u32)`: Free `size` bytes of memory starting at `loc`.
- `fn initialize(room_id_ptr: *const u8, room_id_len: u32)`: Initialize the object with the provided room ID (passed as a pointer, length pair).
- `fn connect(client_id: u32)`: Called immediately after the given user has connected.
- `fn disconnect(client_id: u32)`: Called immediately after the given user has disconnected.
- `fn timer()`: Called if the instance set a timer which has triggered (see `set_timer()` under imports).
- `fn message(client_id: u32, ptr: *const u8, len: u32)`: Called when the instance receives a text message from a client. The message is passed as a (pointer, length) pair.
- `fn binary(client_id: u32, ptr: *const u8, len: u32)`: Called when the instance receives a binary message from a client. The message is passed as a (pointer, length) pair.

### Imports

The module may import any of these functions from the environment:

- `fn send_message(client_id: u32, message: *const u8, len: u32)`: Send the text message, provided as a (pointer, length) pair. If `client_id == 0`, the mesage will
be broadcast to all connected users.
- `fn send_binary(client_id: u32, message: *const u8, len: u32)`: Send the binary message, provided as a (pointer, length) pair. If `client_id == 0`, the mesage will
be broadcast to all connected users.
- `fn set_timer(ms_delay: u32)`: Asks the host runtime to call `timer()` in a given
number of milliseconds. Replaces any previous timer request. If `ms_delay` is 0,
the previous timer will be cancelled but no new timer will be set.
