pub use tracing::{debug, error, info, instrument, trace, warn, Level};

use std::io;
use tracing::subscriber::SetGlobalDefaultError;
use tracing_subscriber::{EnvFilter, FmtSubscriber};

pub fn init<T: AsRef<str>>(default_level: Option<&T>) -> Result<(), SetGlobalDefaultError> {
    // Set up the filter to use, defaulting to just the warn log level for all crates/modules.
    let filter = EnvFilter::try_from_default_env().unwrap_or(EnvFilter::new(
        default_level.map(|s| s.as_ref()).unwrap_or("warn"),
    ));

    // Create a subscriber writing to stderr with the filter set up above.
    let subscriber = FmtSubscriber::builder()
        .with_writer(io::stderr)
        .with_env_filter(filter)
        .finish();

    // Register the subscriber as the default.
    Ok(tracing::subscriber::set_global_default(subscriber)?)
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn it_works() {
        init(Some(&"warn")).unwrap();

        debug!("you should not see this");
        warn!("this is a warning");
        error!("this is an error");
    }
}
