#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]

use dlib::external_library;
use lazy_static::lazy_static;

pub const JACK_LIB: &'static str =
    if cfg!(windows) {
        if cfg!(target_arch = "x86") {
            "libjack.dll"
        } else {
            "libjack64.dll"
        }
    } else if cfg!(target_vendor = "apple") {
        "libjack.0.dylib"
    } else {
        "libjack.so.0"
    };

/// JACK port type for 8 bit raw midi
pub static RAW_MIDI_TYPE: &str = "8 bit raw midi";

/// JACK port type for 32 bit float mono audio
pub static FLOAT_MONO_AUDIO: &str = "32 bit float mono audio";

/* automatically generated by rust-bindgen */

#[cfg(not(target_os = "windows"))]
pub type jack_native_thread_t = ::libc::pthread_t;
pub type jack_uuid_t = u64;
pub type jack_shmsize_t = i32;
pub type jack_nframes_t = u32;
pub type jack_time_t = u64;
pub type jack_intclient_t = u64;
pub enum Struct__jack_port {}
pub type jack_port_t = Struct__jack_port;
pub enum Struct__jack_client {}
pub type jack_client_t = Struct__jack_client;
pub type jack_port_id_t = u32;
pub type jack_port_type_id_t = u32;
pub type Enum_JackOptions = ::libc::c_uint;
pub const JackNullOption: ::libc::c_uint = 0;
pub const JackNoStartServer: ::libc::c_uint = 1;
pub const JackUseExactName: ::libc::c_uint = 2;
pub const JackServerName: ::libc::c_uint = 4;
pub const JackLoadName: ::libc::c_uint = 8;
pub const JackLoadInit: ::libc::c_uint = 16;
pub const JackSessionID: ::libc::c_uint = 32;
pub type jack_options_t = Enum_JackOptions;
pub type Enum_JackStatus = ::libc::c_uint;
pub const JackFailure: ::libc::c_uint = 1;
pub const JackInvalidOption: ::libc::c_uint = 2;
pub const JackNameNotUnique: ::libc::c_uint = 4;
pub const JackServerStarted: ::libc::c_uint = 8;
pub const JackServerFailed: ::libc::c_uint = 16;
pub const JackServerError: ::libc::c_uint = 32;
pub const JackNoSuchClient: ::libc::c_uint = 64;
pub const JackLoadFailure: ::libc::c_uint = 128;
pub const JackInitFailure: ::libc::c_uint = 256;
pub const JackShmFailure: ::libc::c_uint = 512;
pub const JackVersionError: ::libc::c_uint = 1024;
pub const JackBackendError: ::libc::c_uint = 2048;
pub const JackClientZombie: ::libc::c_uint = 4096;
pub type jack_status_t = Enum_JackStatus;
pub type Enum_JackLatencyCallbackMode = ::libc::c_uint;
pub const JackCaptureLatency: ::libc::c_uint = 0;
pub const JackPlaybackLatency: ::libc::c_uint = 1;
pub type jack_latency_callback_mode_t = Enum_JackLatencyCallbackMode;
pub type JackLatencyCallback = ::std::option::Option<
    unsafe extern "C" fn(mode: jack_latency_callback_mode_t, arg: *mut ::libc::c_void) -> (),
>;
#[repr(C, packed)]
#[derive(Copy)]
pub struct Struct__jack_latency_range {
    pub min: jack_nframes_t,
    pub max: jack_nframes_t,
}
impl ::std::clone::Clone for Struct__jack_latency_range {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::std::default::Default for Struct__jack_latency_range {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type jack_latency_range_t = Struct__jack_latency_range;
pub type JackProcessCallback = ::std::option::Option<
    unsafe extern "C" fn(nframes: jack_nframes_t, arg: *mut ::libc::c_void) -> ::libc::c_int,
>;
pub type JackThreadCallback =
    ::std::option::Option<unsafe extern "C" fn(arg: *mut ::libc::c_void) -> *mut ::libc::c_void>;
pub type JackThreadInitCallback =
    ::std::option::Option<unsafe extern "C" fn(arg: *mut ::libc::c_void) -> ()>;
pub type JackGraphOrderCallback =
    ::std::option::Option<unsafe extern "C" fn(arg: *mut ::libc::c_void) -> ::libc::c_int>;
pub type JackXRunCallback =
    ::std::option::Option<unsafe extern "C" fn(arg: *mut ::libc::c_void) -> ::libc::c_int>;
pub type JackBufferSizeCallback = ::std::option::Option<
    unsafe extern "C" fn(nframes: jack_nframes_t, arg: *mut ::libc::c_void) -> ::libc::c_int,
>;
pub type JackSampleRateCallback = ::std::option::Option<
    unsafe extern "C" fn(nframes: jack_nframes_t, arg: *mut ::libc::c_void) -> ::libc::c_int,
>;
pub type JackPortRegistrationCallback = ::std::option::Option<
    unsafe extern "C" fn(port: jack_port_id_t, arg1: ::libc::c_int, arg: *mut ::libc::c_void) -> (),
>;
pub type JackClientRegistrationCallback = ::std::option::Option<
    unsafe extern "C" fn(
        name: *const ::libc::c_char,
        arg1: ::libc::c_int,
        arg: *mut ::libc::c_void,
    ) -> (),
>;
pub type JackPortConnectCallback = ::std::option::Option<
    unsafe extern "C" fn(
        a: jack_port_id_t,
        b: jack_port_id_t,
        connect: ::libc::c_int,
        arg: *mut ::libc::c_void,
    ) -> (),
>;
pub type JackPortRenameCallback = ::std::option::Option<
    unsafe extern "C" fn(
        port: jack_port_id_t,
        old_name: *const ::libc::c_char,
        new_name: *const ::libc::c_char,
        arg: *mut ::libc::c_void,
    ) -> ::libc::c_int,
>;
pub type JackFreewheelCallback = ::std::option::Option<
    unsafe extern "C" fn(starting: ::libc::c_int, arg: *mut ::libc::c_void) -> (),
>;
pub type JackShutdownCallback =
    ::std::option::Option<unsafe extern "C" fn(arg: *mut ::libc::c_void) -> ()>;
pub type JackInfoShutdownCallback = ::std::option::Option<
    unsafe extern "C" fn(
        code: jack_status_t,
        reason: *const ::libc::c_char,
        arg: *mut ::libc::c_void,
    ) -> (),
>;
pub type jack_default_audio_sample_t = ::libc::c_float;
pub type Enum_JackPortFlags = ::libc::c_uint;
pub const JackPortIsInput: ::libc::c_uint = 1;
pub const JackPortIsOutput: ::libc::c_uint = 2;
pub const JackPortIsPhysical: ::libc::c_uint = 4;
pub const JackPortCanMonitor: ::libc::c_uint = 8;
pub const JackPortIsTerminal: ::libc::c_uint = 16;
pub type Enum_Unnamed1 = ::libc::c_uint;
pub const JackTransportStopped: ::libc::c_uint = 0;
pub const JackTransportRolling: ::libc::c_uint = 1;
pub const JackTransportLooping: ::libc::c_uint = 2;
pub const JackTransportStarting: ::libc::c_uint = 3;
pub const JackTransportNetStarting: ::libc::c_uint = 4;
pub type jack_transport_state_t = Enum_Unnamed1;
pub type jack_unique_t = u64;
pub type Enum_Unnamed2 = ::libc::c_uint;
pub const JackPositionBBT: ::libc::c_uint = 16;
pub const JackPositionTimecode: ::libc::c_uint = 32;
pub const JackBBTFrameOffset: ::libc::c_uint = 64;
pub const JackAudioVideoRatio: ::libc::c_uint = 128;
pub const JackVideoFrameOffset: ::libc::c_uint = 256;
pub type jack_position_bits_t = Enum_Unnamed2;
#[repr(C, packed)]
#[derive(Copy)]
pub struct Struct__jack_position {
    pub unique_1: jack_unique_t,
    pub usecs: jack_time_t,
    pub frame_rate: jack_nframes_t,
    pub frame: jack_nframes_t,
    pub valid: jack_position_bits_t,
    pub bar: i32,
    pub beat: i32,
    pub tick: i32,
    pub bar_start_tick: ::libc::c_double,
    pub beats_per_bar: ::libc::c_float,
    pub beat_type: ::libc::c_float,
    pub ticks_per_beat: ::libc::c_double,
    pub beats_per_minute: ::libc::c_double,
    pub frame_time: ::libc::c_double,
    pub next_time: ::libc::c_double,
    pub bbt_offset: jack_nframes_t,
    pub audio_frames_per_video_frame: ::libc::c_float,
    pub video_offset: jack_nframes_t,
    pub padding: [i32; 7usize],
    pub unique_2: jack_unique_t,
}
impl ::std::clone::Clone for Struct__jack_position {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::std::default::Default for Struct__jack_position {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type jack_position_t = Struct__jack_position;
pub type JackSyncCallback = ::std::option::Option<
    unsafe extern "C" fn(
        state: jack_transport_state_t,
        pos: *mut jack_position_t,
        arg: *mut ::libc::c_void,
    ) -> ::libc::c_int,
>;
pub type TimebaseCallback = ::std::option::Option<
    unsafe extern "C" fn(
        state: jack_transport_state_t,
        nframes: jack_nframes_t,
        pos: *mut jack_position_t,
        new_pos: ::libc::c_int,
        arg: *mut ::libc::c_void,
    ) -> (),
>;
pub type Enum_Unnamed3 = ::libc::c_uint;
pub const JackTransportState: ::libc::c_uint = 1;
pub const JackTransportPosition: ::libc::c_uint = 2;
pub const JackTransportLoop: ::libc::c_uint = 4;
pub const JackTransportSMPTE: ::libc::c_uint = 8;
pub const JackTransportBBT: ::libc::c_uint = 16;
pub type jack_transport_bits_t = Enum_Unnamed3;
#[repr(C)]
#[derive(Copy)]
pub struct Struct_Unnamed4 {
    pub frame_rate: jack_nframes_t,
    pub usecs: jack_time_t,
    pub valid: jack_transport_bits_t,
    pub transport_state: jack_transport_state_t,
    pub frame: jack_nframes_t,
    pub loop_start: jack_nframes_t,
    pub loop_end: jack_nframes_t,
    pub smpte_offset: ::libc::c_long,
    pub smpte_frame_rate: ::libc::c_float,
    pub bar: ::libc::c_int,
    pub beat: ::libc::c_int,
    pub tick: ::libc::c_int,
    pub bar_start_tick: ::libc::c_double,
    pub beats_per_bar: ::libc::c_float,
    pub beat_type: ::libc::c_float,
    pub ticks_per_beat: ::libc::c_double,
    pub beats_per_minute: ::libc::c_double,
}
impl ::std::clone::Clone for Struct_Unnamed4 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::std::default::Default for Struct_Unnamed4 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type jack_transport_info_t = Struct_Unnamed4;
#[cfg(not(target_os = "windows"))]
pub type jack_thread_creator_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::libc::pthread_t,
        arg2: *const ::libc::pthread_attr_t,
        function: ::std::option::Option<
            extern "C" fn(arg1: *mut ::libc::c_void) -> *mut ::libc::c_void,
        >,
        arg: *mut ::libc::c_void,
    ) -> ::libc::c_int,
>;
pub type Enum_JackSessionEventType = ::libc::c_uint;
pub const JackSessionSave: ::libc::c_uint = 1;
pub const JackSessionSaveAndQuit: ::libc::c_uint = 2;
pub const JackSessionSaveTemplate: ::libc::c_uint = 3;
pub type jack_session_event_type_t = Enum_JackSessionEventType;
pub type Enum_JackSessionFlags = ::libc::c_uint;
pub const JackSessionSaveError: ::libc::c_uint = 1;
pub const JackSessionNeedTerminal: ::libc::c_uint = 2;
pub type jack_session_flags_t = Enum_JackSessionFlags;
#[repr(C)]
#[derive(Copy)]
pub struct Struct__jack_session_event {
    pub _type: jack_session_event_type_t,
    pub session_dir: *const ::libc::c_char,
    pub client_uuid: *const ::libc::c_char,
    pub command_line: *mut ::libc::c_char,
    pub flags: jack_session_flags_t,
    pub future: u32,
}
impl ::std::clone::Clone for Struct__jack_session_event {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::std::default::Default for Struct__jack_session_event {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type jack_session_event_t = Struct__jack_session_event;
pub type JackSessionCallback = ::std::option::Option<
    unsafe extern "C" fn(event: *mut jack_session_event_t, arg: *mut ::libc::c_void) -> (),
>;
#[repr(C)]
#[derive(Copy)]
pub struct Struct_Unnamed5 {
    pub uuid: *const ::libc::c_char,
    pub client_name: *const ::libc::c_char,
    pub command: *const ::libc::c_char,
    pub flags: jack_session_flags_t,
}
impl ::std::clone::Clone for Struct_Unnamed5 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::std::default::Default for Struct_Unnamed5 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type jack_session_command_t = Struct_Unnamed5;
pub type JSList = Struct__JSList;
pub type JCompareFunc = ::std::option::Option<
    unsafe extern "C" fn(a: *mut ::libc::c_void, b: *mut ::libc::c_void) -> ::libc::c_int,
>;
#[repr(C)]
#[derive(Copy)]
pub struct Struct__JSList {
    pub data: *mut ::libc::c_void,
    pub next: *mut JSList,
}
impl ::std::clone::Clone for Struct__JSList {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::std::default::Default for Struct__JSList {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type Enum_Unnamed6 = ::libc::c_uint;
pub const JackParamInt: ::libc::c_uint = 1;
pub const JackParamUInt: ::libc::c_uint = 2;
pub const JackParamChar: ::libc::c_uint = 3;
pub const JackParamString: ::libc::c_uint = 4;
pub const JackParamBool: ::libc::c_uint = 5;
pub type jackctl_param_type_t = Enum_Unnamed6;
pub type Enum_Unnamed7 = ::libc::c_uint;
pub const JackMaster: ::libc::c_uint = 1;
pub const JackSlave: ::libc::c_uint = 2;
pub type jackctl_driver_type_t = Enum_Unnamed7;
#[repr(C)]
#[derive(Copy)]
pub struct Union_jackctl_parameter_value {
    pub _bindgen_data_: [u32; 32usize],
}
impl Union_jackctl_parameter_value {
    pub unsafe fn ui(&mut self) -> *mut u32 {
        let raw: *mut u8 = ::std::mem::transmute(&self._bindgen_data_);
        ::std::mem::transmute(raw.offset(0))
    }
    pub unsafe fn i(&mut self) -> *mut i32 {
        let raw: *mut u8 = ::std::mem::transmute(&self._bindgen_data_);
        ::std::mem::transmute(raw.offset(0))
    }
    pub unsafe fn c(&mut self) -> *mut ::libc::c_char {
        let raw: *mut u8 = ::std::mem::transmute(&self._bindgen_data_);
        ::std::mem::transmute(raw.offset(0))
    }
    pub unsafe fn str(&mut self) -> *mut [::libc::c_char; 128usize] {
        let raw: *mut u8 = ::std::mem::transmute(&self._bindgen_data_);
        ::std::mem::transmute(raw.offset(0))
    }
    pub unsafe fn b(&mut self) -> *mut u8 {
        let raw: *mut u8 = ::std::mem::transmute(&self._bindgen_data_);
        ::std::mem::transmute(raw.offset(0))
    }
}
impl ::std::clone::Clone for Union_jackctl_parameter_value {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::std::default::Default for Union_jackctl_parameter_value {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub enum Struct_jackctl_server {}
pub type jackctl_server_t = Struct_jackctl_server;
pub enum Struct_jackctl_driver {}
pub type jackctl_driver_t = Struct_jackctl_driver;
pub enum Struct_jackctl_internal {}
pub type jackctl_internal_t = Struct_jackctl_internal;
pub enum Struct_jackctl_parameter {}
pub type jackctl_parameter_t = Struct_jackctl_parameter;
pub enum Struct_jackctl_sigmask {}
pub type jackctl_sigmask_t = Struct_jackctl_sigmask;
#[repr(C)]
#[derive(Copy)]
pub struct Struct_Unnamed8 {
    pub key: *const ::libc::c_char,
    pub data: *const ::libc::c_char,
    pub _type: *const ::libc::c_char,
}
impl ::std::clone::Clone for Struct_Unnamed8 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::std::default::Default for Struct_Unnamed8 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type jack_property_t = Struct_Unnamed8;
#[repr(C)]
#[derive(Copy)]
pub struct Struct_Unnamed9 {
    pub subject: jack_uuid_t,
    pub property_cnt: u32,
    pub properties: *mut jack_property_t,
    pub property_size: u32,
}
impl ::std::clone::Clone for Struct_Unnamed9 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::std::default::Default for Struct_Unnamed9 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type jack_description_t = Struct_Unnamed9;
pub type Enum_Unnamed10 = ::libc::c_uint;
pub const PropertyCreated: ::libc::c_uint = 0;
pub const PropertyChanged: ::libc::c_uint = 1;
pub const PropertyDeleted: ::libc::c_uint = 2;
pub type jack_property_change_t = Enum_Unnamed10;
pub type JackPropertyChangeCallback = ::std::option::Option<
    unsafe extern "C" fn(
        subject: jack_uuid_t,
        key: *const ::libc::c_char,
        change: jack_property_change_t,
        arg: *mut ::libc::c_void,
    ) -> (),
>;
pub type jack_midi_data_t = ::libc::c_uchar;
#[repr(C)]
#[derive(Copy)]
pub struct Struct__jack_midi_event {
    pub time: jack_nframes_t,
    pub size: ::libc::size_t,
    pub buffer: *mut jack_midi_data_t,
}
impl ::std::clone::Clone for Struct__jack_midi_event {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::std::default::Default for Struct__jack_midi_event {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type jack_midi_event_t = Struct__jack_midi_event;
#[repr(C)]
#[derive(Copy)]
pub struct Struct_Unnamed11 {
    pub buf: *mut ::libc::c_char,
    pub len: ::libc::size_t,
}
impl ::std::clone::Clone for Struct_Unnamed11 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::std::default::Default for Struct_Unnamed11 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type jack_ringbuffer_data_t = Struct_Unnamed11;
#[repr(C)]
#[derive(Copy)]
pub struct Struct_Unnamed12 {
    pub buf: *mut ::libc::c_char,
    pub write_ptr: ::libc::size_t,
    pub read_ptr: ::libc::size_t,
    pub size: ::libc::size_t,
    pub size_mask: ::libc::size_t,
    pub mlocked: ::libc::c_int,
}
impl ::std::clone::Clone for Struct_Unnamed12 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::std::default::Default for Struct_Unnamed12 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type jack_ringbuffer_t = Struct_Unnamed12;
extern "C" {}

external_library!(
    JackMetadata,
    "jack",
    statics: JACK_METADATA_PRETTY_NAME: *const ::libc::c_char,
    JACK_METADATA_HARDWARE: *const ::libc::c_char,
    JACK_METADATA_CONNECTED: *const ::libc::c_char,
    JACK_METADATA_PORT_GROUP: *const ::libc::c_char,
    JACK_METADATA_ICON_SMALL: *const ::libc::c_char,
    JACK_METADATA_ICON_LARGE: *const ::libc::c_char,
);
// statics:
// // jack_error_callback:
// //     ::std::option::Option<unsafe extern "C" fn(*const ::libc::c_char) -> ()>,
// // jack_info_callback:
// //     ::std::option::Option<unsafe extern "C" fn(*const ::libc::c_char) -> ()>,

external_library!(
    JackError,
    "jack",
    statics: jack_error_callback: Option<unsafe extern "C" fn(*const ::libc::c_char) -> ()>,
    jack_info_callback: Option<unsafe extern "C" fn(*const ::libc::c_char) -> ()>,
);

external_library!(
    JackCtl,
    "jack",
    functions:
        fn jackctl_setup_signals(::libc::c_uint) -> *mut jackctl_sigmask_t,
        fn jackctl_wait_signals(*mut jackctl_sigmask_t) -> (),
        fn jackctl_server_create(
            ::std::option::Option<
                unsafe extern "C" fn(*const ::libc::c_char) -> u8,
            >,
            ::std::option::Option<
                unsafe extern "C" fn(*const ::libc::c_char) -> (),
            >
        ) -> *mut jackctl_server_t,
        fn jackctl_server_destroy(*mut jackctl_server_t) -> (),
        fn jackctl_server_open(*mut jackctl_server_t, *mut jackctl_driver_t) -> u8,
        fn jackctl_server_start(*mut jackctl_server_t) -> u8,
        fn jackctl_server_stop(*mut jackctl_server_t) -> u8,
        fn jackctl_server_close(*mut jackctl_server_t) -> u8,
        fn jackctl_server_get_drivers_list(*mut jackctl_server_t) -> *const JSList,
        fn jackctl_server_get_parameters(*mut jackctl_server_t) -> *const JSList,
        fn jackctl_server_get_internals_list(*mut jackctl_server_t) -> *const JSList,
        fn jackctl_server_load_internal(
            *mut jackctl_server_t,
            *mut jackctl_internal_t
        ) -> u8,
        fn jackctl_server_unload_internal(
            *mut jackctl_server_t,
            *mut jackctl_internal_t
        ) -> u8,
        fn jackctl_server_add_slave(
            *mut jackctl_server_t,
            *mut jackctl_driver_t
        ) -> u8,
        fn jackctl_server_remove_slave(
            *mut jackctl_server_t,
            *mut jackctl_driver_t
        ) -> u8,
        fn jackctl_server_switch_master(
            *mut jackctl_server_t,
            *mut jackctl_driver_t
        ) -> u8,
        fn jackctl_driver_get_name( *mut jackctl_driver_t) -> *const ::libc::c_char,
        fn jackctl_driver_get_type( *mut jackctl_driver_t) -> jackctl_driver_type_t,
        fn jackctl_driver_get_parameters( *mut jackctl_driver_t) -> *const JSList,
        fn jackctl_driver_params_parse(
            *mut jackctl_driver_t,
            ::libc::c_int,
            *mut *mut ::libc::c_char
        ) -> ::libc::c_int,
        fn jackctl_internal_get_name(*mut jackctl_internal_t) -> *const ::libc::c_char,
        fn jackctl_internal_get_parameters(*mut jackctl_internal_t) -> *const JSList,
        fn jackctl_parameter_get_name(*mut jackctl_parameter_t)
            -> *const ::libc::c_char,
        fn jackctl_parameter_get_short_description(
            *mut jackctl_parameter_t
        ) -> *const ::libc::c_char,
        fn jackctl_parameter_get_long_description(
            *mut jackctl_parameter_t
        ) -> *const ::libc::c_char,
        fn jackctl_parameter_get_type(*mut jackctl_parameter_t) -> jackctl_param_type_t,
        fn jackctl_parameter_get_id(*mut jackctl_parameter_t) -> ::libc::c_char,
        fn jackctl_parameter_is_set(*mut jackctl_parameter_t) -> u8,
        fn jackctl_parameter_reset(*mut jackctl_parameter_t) -> u8,
        fn jackctl_parameter_get_value(
            *mut jackctl_parameter_t
        ) -> Union_jackctl_parameter_value,
        fn jackctl_parameter_set_value(
            *mut jackctl_parameter_t,
            *const Union_jackctl_parameter_value
        ) -> u8,
        fn jackctl_parameter_get_default_value(
            *mut jackctl_parameter_t
        ) -> Union_jackctl_parameter_value,
        fn jackctl_parameter_has_range_constraint(*mut jackctl_parameter_t) -> u8,
        fn jackctl_parameter_has_enum_constraint(*mut jackctl_parameter_t) -> u8,
        fn jackctl_parameter_get_enum_constraints_count(*mut jackctl_parameter_t)
            -> u32,
        fn jackctl_parameter_get_enum_constraint_value(
            *mut jackctl_parameter_t,
            u32
        ) -> Union_jackctl_parameter_value,
        fn jackctl_parameter_get_enum_constraint_description(
            *mut jackctl_parameter_t,
            u32
        ) -> *const ::libc::c_char,
        fn jackctl_parameter_get_range_constraint(
            *mut jackctl_parameter_t,
            *mut Union_jackctl_parameter_value,
            *mut Union_jackctl_parameter_value
        ) -> (),
        fn jackctl_parameter_constraint_is_strict(*mut jackctl_parameter_t) -> u8,
        fn jackctl_parameter_constraint_is_fake_value(*mut jackctl_parameter_t) -> u8,
);

external_library!(
    JackLib,
    "jack",
        functions:
        fn jack_release_timebase(*mut jack_client_t) -> ::libc::c_int,
        fn jack_set_sync_callback(
             *mut jack_client_t,
             JackSyncCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_set_sync_timeout(*mut jack_client_t, jack_time_t)
            -> ::libc::c_int,
        fn jack_set_timebase_callback(
            *mut jack_client_t,
            ::libc::c_int,
            TimebaseCallback,
            *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_transport_locate(
            *mut jack_client_t,
            jack_nframes_t
        ) -> ::libc::c_int,
        fn jack_transport_query(
            *const jack_client_t,
            *mut jack_position_t
        ) -> jack_transport_state_t,
        fn jack_get_current_transport_frame(*const jack_client_t) -> jack_nframes_t,
        fn jack_transport_reposition(
             *mut jack_client_t,
             *const jack_position_t
        ) -> ::libc::c_int,
        fn jack_transport_start( *mut jack_client_t) -> (),
        fn jack_transport_stop( *mut jack_client_t) -> (),
        fn jack_get_transport_info(
             *mut jack_client_t,
             *mut jack_transport_info_t
        ) -> (),
        fn jack_set_transport_info(
             *mut jack_client_t,
             *mut jack_transport_info_t
        ) -> (),
        fn jack_client_new( *const ::libc::c_char) -> *mut jack_client_t,
        fn jack_client_close( *mut jack_client_t) -> ::libc::c_int,
        fn jack_client_name_size() -> ::libc::c_int,
        fn jack_get_client_name( *mut jack_client_t) -> *mut ::libc::c_char,
        fn jack_get_uuid_for_client_name(
             *mut jack_client_t,
             *const ::libc::c_char
        ) -> *mut ::libc::c_char,
        fn jack_get_client_name_by_uuid(
             *mut jack_client_t,
             *const ::libc::c_char
        ) -> *mut ::libc::c_char,
        fn jack_internal_client_new(
             *const ::libc::c_char,
             *const ::libc::c_char,
             *const ::libc::c_char
        ) -> ::libc::c_int,
        fn jack_internal_client_close( *const ::libc::c_char) -> (),
        fn jack_activate( *mut jack_client_t) -> ::libc::c_int,
        fn jack_deactivate( *mut jack_client_t) -> ::libc::c_int,
        // #[cfg(not(target_os = "windows"))]
        // fn jack_client_thread_id( *mut jack_client_t) -> jack_native_thread_t,
        fn jack_is_realtime( *mut jack_client_t) -> ::libc::c_int,
        fn jack_thread_wait( *mut jack_client_t, ::libc::c_int) -> jack_nframes_t,
        fn jack_cycle_wait( *mut jack_client_t) -> jack_nframes_t,
        fn jack_cycle_signal( *mut jack_client_t, ::libc::c_int) -> (),
        fn jack_set_process_thread(
            *mut jack_client_t,
            JackThreadCallback,
            *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_set_thread_init_callback(
             *mut jack_client_t,
             JackThreadInitCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_on_shutdown(
             *mut jack_client_t,
             JackShutdownCallback,
             *mut ::libc::c_void
        ) -> (),
        fn jack_on_info_shutdown(
             *mut jack_client_t,
             JackInfoShutdownCallback,
             *mut ::libc::c_void
        ) -> (),
        fn jack_set_process_callback(
             *mut jack_client_t,
             JackProcessCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_set_freewheel_callback(
             *mut jack_client_t,
             JackFreewheelCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_set_buffer_size_callback(
             *mut jack_client_t,
             JackBufferSizeCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_set_sample_rate_callback(
             *mut jack_client_t,
             JackSampleRateCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_set_client_registration_callback(
             *mut jack_client_t,
             JackClientRegistrationCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_set_port_registration_callback(
             *mut jack_client_t,
             JackPortRegistrationCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_set_port_connect_callback(
             *mut jack_client_t,
             JackPortConnectCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_set_port_rename_callback(
             *mut jack_client_t,
             JackPortRenameCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_set_graph_order_callback(
             *mut jack_client_t,
             JackGraphOrderCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_set_xrun_callback(
             *mut jack_client_t,
             JackXRunCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_set_latency_callback(
             *mut jack_client_t,
             JackLatencyCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_set_freewheel( *mut jack_client_t,  ::libc::c_int) -> ::libc::c_int,
        fn jack_set_buffer_size(
             *mut jack_client_t,
             jack_nframes_t
        ) -> ::libc::c_int,
        fn jack_get_sample_rate( *mut jack_client_t) -> jack_nframes_t,
        fn jack_get_buffer_size( *mut jack_client_t) -> jack_nframes_t,
        fn jack_engine_takeover_timebase( *mut jack_client_t) -> ::libc::c_int,
        fn jack_cpu_load( *mut jack_client_t) -> ::libc::c_float,
        fn jack_port_register(
             *mut jack_client_t,
             *const ::libc::c_char,
             *const ::libc::c_char,
             ::libc::c_ulong,
             ::libc::c_ulong
        ) -> *mut jack_port_t,
        fn jack_port_unregister(
             *mut jack_client_t,
             *mut jack_port_t
        ) -> ::libc::c_int,
        fn jack_port_get_buffer(
             *mut jack_port_t,
             jack_nframes_t
        ) -> *mut ::libc::c_void,
        fn jack_port_uuid( *const jack_port_t) -> jack_uuid_t,
        fn jack_port_name( *const jack_port_t) -> *const ::libc::c_char,
        fn jack_port_short_name( *const jack_port_t) -> *const ::libc::c_char,
        fn jack_port_flags( *const jack_port_t) -> ::libc::c_int,
        fn jack_port_type( *const jack_port_t) -> *const ::libc::c_char,
        fn jack_port_is_mine(
             *const jack_client_t,
             *const jack_port_t
        ) -> ::libc::c_int,
        fn jack_port_connected( *const jack_port_t) -> ::libc::c_int,
        fn jack_port_connected_to(
             *const jack_port_t,
             *const ::libc::c_char
        ) -> ::libc::c_int,
        fn jack_port_get_connections( *const jack_port_t) -> *mut *const ::libc::c_char,
        fn jack_port_get_all_connections(
             *const jack_client_t,
             *const jack_port_t
        ) -> *mut *const ::libc::c_char,
        fn jack_port_tie( *mut jack_port_t,  *mut jack_port_t) -> ::libc::c_int,
        fn jack_port_untie( *mut jack_port_t) -> ::libc::c_int,
        fn jack_port_set_name(
             *mut jack_port_t,
             *const ::libc::c_char
        ) -> ::libc::c_int,
        fn jack_port_set_alias(
             *mut jack_port_t,
             *const ::libc::c_char
        ) -> ::libc::c_int,
        fn jack_port_unset_alias(
             *mut jack_port_t,
             *const ::libc::c_char
        ) -> ::libc::c_int,
        fn jack_port_get_aliases(
             *const jack_port_t,
             *mut *mut ::libc::c_char
        ) -> ::libc::c_int,
        fn jack_port_request_monitor( *mut jack_port_t,  ::libc::c_int)
            -> ::libc::c_int,
        fn jack_port_request_monitor_by_name(
             *mut jack_client_t,
             *const ::libc::c_char,
             ::libc::c_int
        ) -> ::libc::c_int,
        fn jack_port_ensure_monitor( *mut jack_port_t,  ::libc::c_int) -> ::libc::c_int,
        fn jack_port_monitoring_input( *mut jack_port_t) -> ::libc::c_int,
        fn jack_connect(
             *mut jack_client_t,
             *const ::libc::c_char,
             *const ::libc::c_char
        ) -> ::libc::c_int,
        fn jack_disconnect(
             *mut jack_client_t,
             *const ::libc::c_char,
             *const ::libc::c_char
        ) -> ::libc::c_int,
        fn jack_port_disconnect(
             *mut jack_client_t,
             *mut jack_port_t
        ) -> ::libc::c_int,
        fn jack_port_name_size() -> ::libc::c_int,
        fn jack_port_type_size() -> ::libc::c_int,
        fn jack_port_type_get_buffer_size(
             *mut jack_client_t,
             *const ::libc::c_char
        ) -> ::libc::size_t,
        fn jack_port_set_latency( *mut jack_port_t,  jack_nframes_t) -> (),
        fn jack_port_get_latency_range(
             *mut jack_port_t,
             jack_latency_callback_mode_t,
             *mut jack_latency_range_t
        ) -> (),
        fn jack_port_set_latency_range(
             *mut jack_port_t,
             jack_latency_callback_mode_t,
             *mut jack_latency_range_t
        ) -> (),
        fn jack_recompute_total_latencies( *mut jack_client_t) -> ::libc::c_int,
        fn jack_port_get_latency( *mut jack_port_t) -> jack_nframes_t,
        fn jack_port_get_total_latency(
             *mut jack_client_t,
             *mut jack_port_t
        ) -> jack_nframes_t,
        fn jack_recompute_total_latency(
             *mut jack_client_t,
             *mut jack_port_t
        ) -> ::libc::c_int,
        fn jack_get_ports(
             *mut jack_client_t,
             *const ::libc::c_char,
             *const ::libc::c_char,
             ::libc::c_ulong
        ) -> *mut *const ::libc::c_char,
        fn jack_port_by_name(
             *mut jack_client_t,
             *const ::libc::c_char
        ) -> *mut jack_port_t,
        fn jack_port_by_id( *mut jack_client_t,  jack_port_id_t)
            -> *mut jack_port_t,
        fn jack_frames_since_cycle_start( *const jack_client_t) -> jack_nframes_t,
        fn jack_frame_time( *const jack_client_t) -> jack_nframes_t,
        fn jack_last_frame_time( *const jack_client_t) -> jack_nframes_t,

        fn jack_frames_to_time( *const jack_client_t,  jack_nframes_t) -> jack_time_t,
        fn jack_time_to_frames( *const jack_client_t,  jack_time_t) -> jack_nframes_t,
        fn jack_get_time() -> jack_time_t,
        fn jack_set_error_function(
             ::std::option::Option<unsafe extern "C" fn(*const ::libc::c_char) -> ()>
        ) -> (),
        fn jack_set_info_function(
             ::std::option::Option<unsafe extern "C" fn(*const ::libc::c_char) -> ()>
        ) -> (),
        fn jack_free(*mut ::libc::c_void) -> (),
        fn jack_client_real_time_priority( *mut jack_client_t) -> ::libc::c_int,
        fn jack_client_max_real_time_priority( *mut jack_client_t) -> ::libc::c_int,
        // #[cfg(not(target_os = "windows"))]
        // fn jack_acquire_real_time_scheduling(
        //     thread: jack_native_thread_t,
        //     priority: ::libc::c_int,
        // ) -> ::libc::c_int,
        // #[cfg(not(target_os = "windows"))]
        // fn jack_client_create_thread(
        //     client: *mut jack_client_t,
        //     thread: *mut jack_native_thread_t,
        //     priority: ::libc::c_int,
        //     realtime: ::libc::c_int,
        //     start_routine: ::std::option::Option<
        //         unsafe extern "C" fn(arg1: *mut ::libc::c_void) -> *mut ::libc::c_void,
        //     >,
        //     arg: *mut ::libc::c_void,
        // ) -> ::libc::c_int,
        // #[cfg(not(target_os = "windows"))]
        // fn jack_drop_real_time_scheduling(thread: jack_native_thread_t) -> ::libc::c_int,
        // #[cfg(not(target_os = "windows"))]
        // fn jack_client_stop_thread(
        //     client: *mut jack_client_t,
        //     thread: jack_native_thread_t,
        // ) -> ::libc::c_int,
        // #[cfg(not(target_os = "windows"))]
        // fn jack_client_kill_thread(
        //     client: *mut jack_client_t,
        //     thread: jack_native_thread_t,
        // ) -> ::libc::c_int,
        // #[cfg(not(target_os = "windows"))]
        // fn jack_set_thread_creator(creator: jack_thread_creator_t) -> (),
        fn jack_set_session_callback(
             *mut jack_client_t,
             JackSessionCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_session_reply(
             *mut jack_client_t,
             *mut jack_session_event_t
        ) -> ::libc::c_int,
        fn jack_session_event_free( *mut jack_session_event_t) -> (),
        fn jack_client_get_uuid( *mut jack_client_t) -> *mut ::libc::c_char,
        fn jack_session_notify(
             *mut jack_client_t,
             *const ::libc::c_char,
             jack_session_event_type_t,
             *const ::libc::c_char
        ) -> *mut jack_session_command_t,
        fn jack_session_commands_free(*mut jack_session_command_t) -> (),
        fn jack_reserve_client_name(
             *mut jack_client_t,
             *const ::libc::c_char,
             *const ::libc::c_char
        ) -> ::libc::c_int,
        fn jack_client_has_session_callback(
            *mut jack_client_t,
            *const ::libc::c_char
        ) -> ::libc::c_int,
        // fn jack_error(format: *const ::libc::c_char, ...) -> (),
        // fn jack_info(format: *const ::libc::c_char, ...) -> (),
        // fn jack_log(format: *const ::libc::c_char, ...) -> (),
        fn jack_set_property(
            *mut jack_client_t,
            jack_uuid_t,
            *const ::libc::c_char,
            *const ::libc::c_char,
            *const ::libc::c_char
        ) -> ::libc::c_int,
        fn jack_get_property(
            jack_uuid_t,
            *const ::libc::c_char,
            *mut *mut ::libc::c_char,
            *mut *mut ::libc::c_char
        ) -> ::libc::c_int,
        fn jack_free_description(
            *mut jack_description_t,
            ::libc::c_int
        ) -> (),
        fn jack_get_properties(
            jack_uuid_t,
            *mut jack_description_t
        ) -> ::libc::c_int,
        fn jack_get_all_properties(*mut *mut jack_description_t) -> ::libc::c_int,
        fn jack_remove_property(
             *mut jack_client_t,
             jack_uuid_t,
             *const ::libc::c_char
        ) -> ::libc::c_int,
        fn jack_remove_properties(
             *mut jack_client_t,
             jack_uuid_t
        ) -> ::libc::c_int,
        fn jack_remove_all_properties( *mut jack_client_t) -> ::libc::c_int,
        fn jack_set_property_change_callback(
             *mut jack_client_t,
             JackPropertyChangeCallback,
             *mut ::libc::c_void
        ) -> ::libc::c_int,
        fn jack_get_internal_client_name(
             *mut jack_client_t,
             jack_intclient_t
        ) -> *mut ::libc::c_char,
        fn jack_internal_client_handle(
             *mut jack_client_t,
             *const ::libc::c_char,
             *mut jack_status_t
        ) -> jack_intclient_t,
        fn jack_internal_client_unload(
             *mut jack_client_t,
             jack_intclient_t
        ) -> jack_status_t,
        fn jack_get_max_delayed_usecs(*mut jack_client_t) -> ::libc::c_float,
        fn jack_get_xrun_delayed_usecs( *mut jack_client_t) -> ::libc::c_float,
        fn jack_reset_max_delayed_usecs( *mut jack_client_t) -> (),
        fn jack_midi_get_event_count( *mut ::libc::c_void) -> u32,
        fn jack_midi_event_get(
             *mut jack_midi_event_t,
             *mut ::libc::c_void,
             u32
        ) -> ::libc::c_int,
        fn jack_midi_clear_buffer(*mut ::libc::c_void) -> (),
        fn jack_midi_max_event_size(*mut ::libc::c_void) -> ::libc::size_t,
        fn jack_midi_event_reserve(
            *mut ::libc::c_void,
            jack_nframes_t,
            ::libc::size_t
        ) -> *mut jack_midi_data_t,
        fn jack_midi_event_write(
            *mut ::libc::c_void,
            jack_nframes_t,
            *const jack_midi_data_t,
            ::libc::size_t
        ) -> ::libc::c_int,
        fn jack_midi_get_lost_event_count( *mut ::libc::c_void) -> u32,
        fn jack_ringbuffer_create( ::libc::size_t) -> *mut jack_ringbuffer_t,
        fn jack_ringbuffer_free( *mut jack_ringbuffer_t) -> (),
        fn jack_ringbuffer_get_read_vector(
             *const jack_ringbuffer_t,
             *mut jack_ringbuffer_data_t
        ) -> (),
        fn jack_ringbuffer_get_write_vector(
             *const jack_ringbuffer_t,
             *mut jack_ringbuffer_data_t
        ) -> (),
        fn jack_ringbuffer_read(
             *mut jack_ringbuffer_t,
             *mut ::libc::c_char,
             ::libc::size_t
        ) -> ::libc::size_t,
        fn jack_ringbuffer_peek(
            *mut jack_ringbuffer_t,
            *mut ::libc::c_char,
            ::libc::size_t
        ) -> ::libc::size_t,
        fn jack_ringbuffer_read_advance(*mut jack_ringbuffer_t,  ::libc::size_t) -> (),
        fn jack_ringbuffer_read_space( *const jack_ringbuffer_t) -> ::libc::size_t,
        fn jack_ringbuffer_mlock( *mut jack_ringbuffer_t) -> ::libc::c_int,
        fn jack_ringbuffer_reset( *mut jack_ringbuffer_t) -> (),
        fn jack_ringbuffer_write(
             *mut jack_ringbuffer_t,
             *const ::libc::c_char,
             ::libc::size_t
        ) -> ::libc::size_t,
        fn jack_ringbuffer_write_advance( *mut jack_ringbuffer_t,  ::libc::size_t) -> (),
        fn jack_ringbuffer_write_space( *const jack_ringbuffer_t) -> ::libc::size_t,
    varargs:
        fn jack_internal_client_load(
            *mut jack_client_t,
            *const ::libc::c_char,
            jack_options_t,
            *mut jack_status_t,
            jack_intclient_t
        ) -> jack_intclient_t,
        fn jack_client_open(*const ::libc::c_char, jack_options_t, *mut jack_status_t) -> *mut jack_client_t,
);

external_library!(
    JackUuid,
    "jack",
    functions:
    fn jack_uuid_to_index(jack_uuid_t) -> u32,
    fn jack_uuid_copy(*mut jack_uuid_t, jack_uuid_t) -> (),
    fn jack_uuid_compare(jack_uuid_t, jack_uuid_t) -> ::std::os::raw::c_int,
    fn jack_uuid_clear(*mut jack_uuid_t) -> (),
    fn jack_uuid_parse(
        *const ::std::os::raw::c_char,
        *mut jack_uuid_t
    ) -> ::std::os::raw::c_int,
    fn jack_uuid_unparse(jack_uuid_t, *mut ::std::os::raw::c_char) -> (),
    fn jack_uuid_empty(jack_uuid_t) -> ::std::os::raw::c_int,
);

#[cfg(feature = "dlopen")]
impl std::fmt::Debug for JackLib {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("JackLib").finish()
    }
}

// The following functions are not available in some JACK versions. Use with caution.
external_library!(
JackOptional,
"jack",
functions:
    fn jack_get_version(
         *mut ::libc::c_int,
         *mut ::libc::c_int,
         *mut ::libc::c_int,
         *mut ::libc::c_int
    ) -> (),
    fn jack_get_version_string() -> *const ::libc::c_char,
    fn jack_get_client_pid( *const ::libc::c_char) -> ::libc::c_int,
    fn jack_port_type_id( *const jack_port_t) -> jack_port_type_id_t,
    fn jack_midi_reset_buffer(*mut ::libc::c_void) -> (),
    fn jack_ringbuffer_reset_size( *mut jack_ringbuffer_t,  ::libc::size_t) -> (),
);

type jack_get_cycle_times_t = unsafe extern "C" fn(
    client: *const jack_client_t,
    current_frames: *mut jack_nframes_t,
    current_usecs: *mut jack_time_t,
    next_usecs: *mut jack_time_t,
    period_usecs: *mut ::libc::c_float,
) -> ::libc::c_int;

lazy_static! {
    pub static ref jack_get_cycle_times: Option<jack_get_cycle_times_t> = {
        unsafe { libloading::Library::new(JACK_LIB) }
            .ok()
            .and_then(|lib| unsafe {
                lib.get::<jack_get_cycle_times_t>(b"jack_get_cycle_times\0")
                    .ok()
                    .map(|sym| sym.into_raw())
                    .map(|sym| *sym.deref() as jack_get_cycle_times_t)
            })
    };
}
