module DFF
(/*AUTOARG*/
 // Outputs
    Q,
 // Inputs
    clk, rstn, EN, D
);

    input    clk;
    input    rstn;
    input    EN;
    input    D;
    output   Q;

    /*AUTOREG*/
    // Beginning of automatic regs (for this module's undeclared outputs)
    reg      Q;
    // End of automatics

    /*AUTOWIRE*/

    always @(posedge clk or negedge rstn) begin
        if (!rstn) begin
            Q <= 1'b0;
        end else begin
            if (EN) begin
                Q <= D;
            end
        end
    end

endmodule // DFF