`timescale 1ns/1ps

module tb_DFF;

    reg     clk, rstn;
    reg     EN, D;

    /*AUTOWIRE*/
    // Beginning of automatic wires (for undeclared instantiated-module outputs)
    wire    Q;    // From DFF of DFF.v
    // End of automatics

    DFF  DFF
    (/*AUTOINST*/
     // Outputs
     .Q        (Q),
     // Inputs
     .clk        (clk),
     .rstn        (rstn),
     .EN        (EN),
     .D        (D));
 
    initial begin
        rstn = 1'b0;
        #10;
        rstn = 1'b1;
    end

    initial begin
        clk = 1'b0;
        wait (rstn == 1'b1);
        forever begin
            #10;
            clk = ~clk;
        end
    end

    initial begin
        EN = 1'b0;
        repeat(5)@(posedge clk);
        EN = 1'b1;
        @(posedge clk);
        EN = 1'b0;
    end

    initial begin
        D = 1'b0;
        repeat(3)@(posedge clk);
        D = 1'b1;
        repeat(4)@(posedge clk);
        D = 1'b0;
    end
 
    initial begin
       #200;
       $finish;
    end
 
    //initial begin
    //    $dumpfile("sim_output.vcd");
    //    $dumpvars(0,tb_DFF);
    //end

endmodule // tb_DFF