pub struct Func {
    pub name: &'static str,
}

#[allow(dead_code)]
#[allow(non_upper_case_globals)]
pub mod known_funcs {
    macro_rules! funcs {
    (
        $($name:ident,)*
    ) => {
            $(
                pub const $name: super::Func = super::Func {
                    name: stringify!($name),
                };
            )*
            pub const ALL_NAMES: &[&str] = &[
                $(stringify!($name)),*
            ];
        };
    }

    // All known function names
    funcs! {
        // Please sort these in a lexicographical order
        acre_alm,
        acre_alm_ngk,
        acre_cyc,
        acre_cyc_ngk,
        acre_dtq,
        acre_flg,
        acre_isr,
        acre_mbf,
        acre_mpf,
        acre_mtx,
        acre_pdq,
        acre_sem,
        acre_spn,
        acre_tsk,
        act_tsk,
        adj_tim,
        can_act,
        can_wup,
        chg_ipm,
        chg_pri,
        chg_spr,
        clr_flg,
        clr_int,
        del_alm,
        del_cyc,
        del_dtq,
        del_flg,
        del_isr,
        del_mbf,
        del_mpf,
        del_mtx,
        del_pdq,
        del_sem,
        del_spn,
        del_tsk,
        dis_dsp,
        dis_int,
        dis_ter,
        dly_tsk,
        ena_dsp,
        ena_int,
        ena_ter,
        exd_tsk,
        ext_ker,
        ext_tsk,
        fch_hrt,
        fsnd_dtq,
        get_inf,
        get_ipm,
        get_lod,
        get_mpf,
        get_nth,
        get_pid,
        get_pri,
        get_tid,
        get_tim,
        get_tst,
        ini_dtq,
        ini_flg,
        ini_mbf,
        ini_mpf,
        ini_mtx,
        ini_pdq,
        ini_sem,
        loc_cpu,
        loc_mtx,
        loc_spn,
        mact_tsk,
        mget_lod,
        mget_nth,
        mig_tsk,
        mrot_rdq,
        msta_alm,
        msta_cyc,
        pget_mpf,
        ploc_mtx,
        pol_flg,
        pol_sem,
        prb_int,
        prcv_dtq,
        prcv_mbf,
        prcv_pdq,
        psnd_dtq,
        psnd_mbf,
        psnd_pdq,
        ras_int,
        ras_ter,
        rcv_dtq,
        rcv_mbf,
        rcv_pdq,
        ref_alm,
        ref_cyc,
        ref_dtq,
        ref_flg,
        ref_mbf,
        ref_mpf,
        ref_mtx,
        ref_ovr,
        ref_pdq,
        ref_sem,
        ref_spn,
        ref_tsk,
        rel_mpf,
        rel_wai,
        rot_rdq,
        rsm_tsk,
        set_flg,
        set_tim,
        sig_sem,
        slp_tsk,
        snd_dtq,
        snd_mbf,
        snd_pdq,
        sns_ctx,
        sns_dpn,
        sns_dsp,
        sns_ker,
        sns_loc,
        sns_ter,
        sta_alm,
        sta_cyc,
        sta_ovr,
        stp_alm,
        stp_cyc,
        stp_ovr,
        sus_tsk,
        ter_tsk,
        tget_mpf,
        tloc_mtx,
        trcv_dtq,
        trcv_mbf,
        trcv_pdq,
        try_spn,
        tslp_tsk,
        tsnd_dtq,
        tsnd_mbf,
        tsnd_pdq,
        twai_flg,
        twai_sem,
        unl_cpu,
        unl_mtx,
        unl_spn,
        wai_flg,
        wai_sem,
        wup_tsk,
        xsns_dpn,
    }
}
