#[cfg(test)]
mod tests {
    use crate::Language;

    #[test]
    fn from_str() {
        assert_eq!(Language::from_str("eng").unwrap(), Language::English);
        assert_eq!(Language::from_str("fr").unwrap(), Language::French);
        assert_eq!(Language::from_str("zho").unwrap(), Language::Chinese);
        assert_eq!(Language::from_str("enm").unwrap(), Language::EnglishMiddle);
    }

    #[test]
    fn from_alpha2() {
        assert_eq!(Language::from_alpha2_str("en").unwrap(), Language::English);
        assert_eq!(Language::from_alpha2_str("fr").unwrap(), Language::French);
        assert!(Language::from_alpha2_str("zho").is_none())
    }

    #[test]
    fn from_alpha3b() {
        assert_eq!(Language::from_alpha3_b_str("eng").unwrap(), Language::English);
        assert_eq!(Language::from_alpha3_b_str("chi").unwrap(), Language::Chinese);
        assert_eq!(Language::from_alpha3_b_str("fre").unwrap(), Language::French);
        assert!(Language::from_alpha3_b_str("zho").is_none())
    }

    #[test]
    fn from_alpha3t() {
        assert_eq!(Language::from_alpha3_t_str("zho").unwrap(), Language::Chinese);
        assert_eq!(Language::from_alpha3_t_str("fra").unwrap(), Language::French);
        assert!(Language::from_alpha3_t_str("chi").is_none());
        assert!(Language::from_alpha3_t_str("fre").is_none());
    }

    #[test]
    fn english_name() {
        assert_eq!(Language::English.english_name(), "English");
        assert_eq!(Language::NKo.english_name(), "N'Ko");
        assert_eq!(Language::French.english_name(), "French");
        assert_eq!(Language::EnglishMiddle.english_name(), "English, Middle (1100-1500)");
    }
}

mod languages;

pub use languages::Language;