extern crate iref;

use iref::Iri;

fn main() -> Result<(), iref::Error> {
	let iri = Iri::new("https://www.rust-lang.org/foo/bar?query#frag")?;

	println!("scheme: {}", iri.scheme());
	println!("authority: {}", iri.authority().unwrap());
	println!("path: {}", iri.path());
	println!("query: {}", iri.query().unwrap());
	println!("fragment: {}", iri.fragment().unwrap());

	Ok(())
}
