#!/bin/bash

set -euo pipefail
IFS=$'\n\t'

SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
cd $SCRIPT_DIR

PROJ_NAME=$(basename "$SCRIPT_DIR")

DOCKER_REGISTRY=${DOCKER_REGISTRY:=docker.io}
DOCKER_REPOSITORY=${DOCKER_REPOSITORY:="nickbp/${PROJ_NAME}"}
IMAGE_PLATFORMS="linux/amd64,linux/arm64"
COMMIT_SHA=$(git rev-parse --short HEAD)
export BUILDAH_FORMAT=docker # 'oci' default doesn't list architectures on hub.docker.com

echo "Building $PROJ_NAME => ${DOCKER_REGISTRY}/${DOCKER_REPOSITORY}:${COMMIT_SHA}"

time buildah build --manifest "${PROJ_NAME}_${COMMIT_SHA}" --jobs=4 --platform="${IMAGE_PLATFORMS}"
time buildah manifest push --all "${PROJ_NAME}_${COMMIT_SHA}" "docker://${DOCKER_REGISTRY}/${DOCKER_REPOSITORY}:${COMMIT_SHA}"
