use iotdb_client_rs::{
    client::{DataSet, MeasurementSchema, Tablet, Value},
    protocal::{TSCompressionType, TSDataType, TSEncoding},
};

fn main() {
    // let names = vec!["Bob", "Steve", "Jane"];
    // let salary = vec![10, 5, 15];
    // let permutation = permutation::sort(&salary[..]);
    // let ordered_names = permutation.apply_slice(&names[..]);
    // let ordered_salaries = permutation.apply_slice(&salary[..]);
    // assert!(ordered_names == vec!["Steve", "Bob", "Jane"]);
    // assert!(ordered_salaries == vec![5, 10, 15]);

    let mut tablet = Tablet::new(
        "root.sg_rs.device2",
        vec![
            MeasurementSchema::new(
                String::from("status"),
                TSDataType::Boolean,
                TSEncoding::Plain,
                TSCompressionType::SNAPPY,
                None,
            ),
            MeasurementSchema::new(
                String::from("restart_count"),
                TSDataType::Int32,
                TSEncoding::RLE,
                TSCompressionType::SNAPPY,
                None,
            ),
            MeasurementSchema::new(
                String::from("tick_count"),
                TSDataType::Int64,
                TSEncoding::RLE,
                TSCompressionType::SNAPPY,
                None,
            ),
            MeasurementSchema::new(
                String::from("temperature"),
                TSDataType::Float,
                TSEncoding::Plain,
                TSCompressionType::SNAPPY,
                None,
            ),
            MeasurementSchema::new(
                String::from("price"),
                TSDataType::Double,
                TSEncoding::Gorilla,
                TSCompressionType::SNAPPY,
                None,
            ),
            MeasurementSchema::new(
                String::from("description"),
                TSDataType::Text,
                TSEncoding::Plain,
                TSCompressionType::SNAPPY,
                None,
            ),
        ],
    );
    (0..3).rev().for_each(|row| {
        let ts = 0 + row as i64;
        tablet.add_row(
            vec![
                Value::Bool(ts % 2 == 0),
                Value::Int32(row),
                Value::Int64(row as i64),
                Value::Float(row as f32 + 0.1),
                Value::Double(row as f64 + 0.2),
                Value::Text(format!("ts: {}", ts).to_string()),
            ],
            ts,
        );
    });

    let column_count = tablet.get_column_count();
    let row_count = tablet.get_row_count();

    for row in 0..row_count {
        for col in 0..column_count {
            print!("{:?}\t", tablet.get_value_at(col, row));
        }
        println!()
    }

    tablet.sort();

    for row in 0..row_count {
        for col in 0..column_count {
            print!("{:?}\t", tablet.get_value_at(col, row));
        }
        println!()
    }
}
