# Changelog

## \[2.2.2]

- Updated dependencies to fix compilation.
  - [0838d48e](https://github.com/iotaledger/iota.rs/commit/0838d48e4683ab8d10f685c444f4ed097cf76493) Update dependencies ([#767](https://github.com/iotaledger/iota.rs/pull/767)) on 2021-12-09

## \[2.2.1]

- Fixed binaries upload
  - [1b5044b1](https://github.com/iotaledger/iota.rs/commit/1b5044b17eb63cd33cf0cbbc72fb08286b64f3ef) fix workflow for binaries, clean wasm readme ([#738](https://github.com/iotaledger/iota.rs/pull/738)) on 2021-11-04

## \[2.2.0]

- Changed "discovered" to "autopeered" in the result from getPeers().
  - [f43b9dea](https://github.com/iotaledger/iota.rs/commit/f43b9deac867cc52bff92a6c400ff54cbd06add2) add change file and updated covector workflow on 2021-11-03

## \[2.1.1]

- Removed dependencies that failed to compile on a Raspberry Pi.
  - [f3692e13](https://github.com/iotaledger/iota.rs/commit/f3692e1385aa5e45b61e6222f738415af0a264ba) Lock dependencies to a specific version ([#719](https://github.com/iotaledger/iota.rs/pull/719)) on 2021-10-21

## \[2.1.0]

- Updated default testnet nodes
  - [4f060388](https://github.com/iotaledger/iota.rs/commit/4f060388a19ece1deee6b54748b13498078d0cef) Wasm binding ([#631](https://github.com/iotaledger/iota.rs/pull/631)) on 2021-09-27
- Added fallback to local PoW if no provided node has remote PoW enabled
  - [4f060388](https://github.com/iotaledger/iota.rs/commit/4f060388a19ece1deee6b54748b13498078d0cef) Wasm binding ([#631](https://github.com/iotaledger/iota.rs/pull/631)) on 2021-09-27

## \[2.0.0]

- Changed input() to accept the output id as string instead of the transaction id and the output index
  Add functionality for offline signing: offlineMode(), findInputs(), prepareTransaction(), signTransaction(), finishMessage()
  - [9489d319](https://github.com/iotaledger/iota.rs/commit/9489d319e971a18f44e4c88d38789f6b6b4d4d7e) Nodejs offline signing ([#674](https://github.com/iotaledger/iota.rs/pull/674)) on 2021-09-23

## \[1.0.1]

- Fix consolidation for higher start indexes
  - [3ca3a2d7](https://github.com/iotaledger/iota.rs/commit/3ca3a2d7ee9a25556ca7fe2a4eb1221bdb6accfe) Handle higher start indexes in consolidation ([#666](https://github.com/iotaledger/iota.rs/pull/666)) on 2021-09-08

## \[1.0.0]

- Fixed custom provided API timeouts
  - [5f8fd262](https://github.com/iotaledger/iota.rs/commit/5f8fd262526aa09e2f548b3711964ea8fc18bc0b) Fix API timeouts for node.js binding, update message format for MQTT and default reconnect attempts ([#652](https://github.com/iotaledger/iota.rs/pull/652)) on 2021-08-25
- Return messages in MQTT in the same format as from all other functions (byte arrays converted to hex strings)
  Changed default max reconnection attempts to be unlimited
  - [98dad972](https://github.com/iotaledger/iota.rs/commit/98dad972549339d32fba6c06057a9df7582e0b51) Mqtt websocket first iteration ([#561](https://github.com/iotaledger/iota.rs/pull/561)) on 2021-05-17
  - [24a4b3fb](https://github.com/iotaledger/iota.rs/commit/24a4b3fbffd2a5108eecbf43308fe8bbb9ddfe4a) apply version updates ([#563](https://github.com/iotaledger/iota.rs/pull/563)) on 2021-05-18
  - [5f8fd262](https://github.com/iotaledger/iota.rs/commit/5f8fd262526aa09e2f548b3711964ea8fc18bc0b) Fix API timeouts for node.js binding, update message format for MQTT and default reconnect attempts ([#652](https://github.com/iotaledger/iota.rs/pull/652)) on 2021-08-25

## \[0.7.0]

- Add hexPublicKeyToBech32Address method
  - [572bc72b](https://github.com/iotaledger/iota.rs/commit/572bc72b7a945528475132dbb9e86e0b21f08796) Add hexPublicKeyToBech32Address on 2021-08-13

## \[0.6.6]

- Import TextEncoder for older Node.js versions
  - [2c718365](https://github.com/iotaledger/iota.rs/commit/2c71836544ddd63571e6fd47cdf555a94afb322e) Import TextEncoder for older Node.js versions on 2021-08-06

## \[0.6.5]

- Order parent messages always, fix POST JSON request.
  - [1d6a84c4](https://github.com/iotaledger/iota.rs/commit/1d6a84c4fde2c1c0e46380509f9c66123842ca72) add change file on 2021-07-14

## \[0.6.4]

- Fixed receipt payload conversion.
  - [86857df1](https://github.com/iotaledger/iota.rs/commit/86857df1815dd26ea7d2d62b410efe1c76328e93) update dependencies on 2021-07-12

## \[0.6.3]

- Fixed ts interfaces
  - [49100701](https://github.com/iotaledger/iota.rs/commit/491007014eedce0cf8d90d4272b547ae83854094) add change file on 2021-07-07

## \[0.6.2]

- Fixed retryUntilIncluded.
  - [1703e299](https://github.com/iotaledger/iota.rs/commit/1703e299cc973d194ee0e82de87fec6c347afcf2) Fix retry_until_included ([#599](https://github.com/iotaledger/iota.rs/pull/599)) on 2021-07-01

## \[0.6.1]

- Add permanode option.
  - [8537f390](https://github.com/iotaledger/iota.rs/commit/8537f3901a3e9860df32aa982943de171670da3e) Add basic permanode support ([#586](https://github.com/iotaledger/iota.rs/pull/586)) on 2021-06-03

## \[0.6.0]

- Added getMessageId function.
  - [b1935f36](https://github.com/iotaledger/iota.rs/commit/b1935f36542ed805209c1ce684aa12fc1de8af7a) nodejs add getMessageId on 2021-05-25

## \[0.5.1]

- Set git repo and rev to allow JS bindings to be built from source
  - [282de0a6](https://github.com/iotaledger/iota.rs/commit/282de0a6db2e8522b040c7aee1228840a6296cf1) fix(ci,bindings/nodejs): Set rev to allow building from source ([#573](https://github.com/iotaledger/iota.rs/pull/573)) on 2021-05-20
- Build bindings on Ubuntu 18.04 to support older versions of glibc
  - [9ee430ca](https://github.com/iotaledger/iota.rs/commit/9ee430cac5b21d61676c239f91414a00831be309) fix(ci): Build Node.js bindings on Ubuntu 18.04 ([#576](https://github.com/iotaledger/iota.rs/pull/576)) on 2021-05-20

## \[0.5.0]

- Add JWT support and fix default nodes.
  - [b94c0ae1](https://github.com/iotaledger/iota.rs/commit/b94c0ae150c935e3771d12061f534f301d39c33c) add changes file on 2021-05-14
- Validate mnemonic in mnemonicToHexSeed()
  - [e9c89e04](https://github.com/iotaledger/iota.rs/commit/e9c89e049d030fca17adfd63aa161b6911f846d1) add changes file on 2021-05-04
  - [cce6254f](https://github.com/iotaledger/iota.rs/commit/cce6254f37af65a08e5daf53dae6c3f3ba9f9abd) apply version updates ([#538](https://github.com/iotaledger/iota.rs/pull/538)) on 2021-05-09
  - [4b159da2](https://github.com/iotaledger/iota.rs/commit/4b159da25ea0f8db3eea5a6b2748eefb366d1f4d) validate mnemonic in mnemonic_to_hex_seed ([#568](https://github.com/iotaledger/iota.rs/pull/568)) on 2021-05-18
- MQTT uses websocket as default
  Indexation topic with non hex content will be converted to hex automatically
  - [98dad972](https://github.com/iotaledger/iota.rs/commit/98dad972549339d32fba6c06057a9df7582e0b51) Mqtt websocket first iteration ([#561](https://github.com/iotaledger/iota.rs/pull/561)) on 2021-05-17

## \[0.4.0]

- Use camelCase for attributes.
- Add consolidation function.
  - [7e54d183](https://github.com/iotaledger/iota.rs/commit/7e54d183e4e70172dca54b475676f2b1ddeb730f) add changes file on 2021-05-05
- Fix hexToBech32 when bech32\_hrp is optional.
  - [75a073e2](https://github.com/iotaledger/iota.rs/commit/75a073e2dc69a9d065c2bc50732c0b8e104743d9) update readme and use iota_client on 2021-05-03
- Don't overwrite custom provided input range.
  - [294920f7](https://github.com/iotaledger/iota.rs/commit/294920f791714df46ecd9ec09ab6a8f7947f3458) add changes file on 2021-05-04
- Add generateMnemonic and mnemonicToHexSeed.
  - [e9c89e04](https://github.com/iotaledger/iota.rs/commit/e9c89e049d030fca17adfd63aa161b6911f846d1) add changes file on 2021-05-04

## \[0.3.2]

- Fix hexToBech32 when bech32\_hrp is optional.
  - [f67b445d](https://github.com/iotaledger/iota.rs/commit/f67b445d848b4cc4120a68600cd84ef0bb84de45) nodejs/fix hexToBech32 and update versions ([#533](https://github.com/iotaledger/iota.rs/pull/533)) on 2021-05-03
- Update types and make account_index for GetUnspentAddressBuilder optional.
  - [30585801](https://github.com/iotaledger/iota.rs/commit/305858017cabff456619f5ef0034dfa1973c5117) update nodejs types, optional account_index ([#518](https://github.com/iotaledger/iota.rs/pull/518)) on 2021-04-27

## \[0.3.1]

- Update minPoWScore in nodeinfo.
  - [b578d23a](https://github.com/iotaledger/iota.rs/commit/b578d23a9c212bc3851d4c3c4a8292af1fbd34de) update nodejs docs on 2021-04-11

## \[0.3.0]

- Added functions to convert addresses from bech32 to hex and vice versa.
  - [115184a8](https://github.com/iotaledger/iota.rs/commit/115184a8c712e3432cc960273278780ddc1b768a) Added hex_to_bech32 and bech32\_to_hex methods ([#471](https://github.com/iotaledger/iota.rs/pull/471)) on 2021-04-07
- Add optional quorum, primaryNode, primaryPowNode and return url together with the nodeinfo when calling getInfo().
  - [7a9ef60f](https://github.com/iotaledger/iota.rs/commit/7a9ef60fea1c865d59c744e0f6cc54371a4cebda) Node manager ([#457](https://github.com/iotaledger/iota.rs/pull/457)) on 2021-04-08
- Return addresses bech32 encoded also for balance and output endpoints.
  - [a2e09d1a](https://github.com/iotaledger/iota.rs/commit/a2e09d1a329404cdaf74890eae562fe992483b10) return address bech32 encoded for balance and outputs on 2021-04-07

## \[0.2.0]

- Fix import and installation + example in readme.
  - [5c96ab33](https://github.com/iotaledger/iota.rs/commit/5c96ab3379d992343c11ba3d7ae35ecaa22b4a0a) Fix import and installation + example in readme. ([#431](https://github.com/iotaledger/iota.rs/pull/431)) on 2021-03-18

## \[0.1.0]

- Added optional gapLimit to getBalance.
  - [cf1405e5](https://github.com/iotaledger/iota.rs/commit/cf1405e54383d71fac84c421b1b945cbe4959259) add gap_limit to GetBalanceBuilder ([#427](https://github.com/iotaledger/iota.rs/pull/427)) on 2021-03-18
