#![feature(proc_macro_hygiene, decl_macro)]

#[macro_use]
extern crate rocket;

use rocket_contrib::json::Json;
use serde::Deserialize;
use serde::Serialize;

#[derive(Debug, Deserialize, Serialize)]
struct Event {
    id: u64,
    name: Option<String>,
    app_eui: Option<String>,
    dev_eui: Option<String>,
    devaddr: Option<String>,
    downlink_url: Option<String>,
    fcnt: Option<String>,
    port: Option<u64>,
    payload: Option<String>,
    reported_at: Option<i64>,
}

#[get("/")]
fn index() -> &'static str {
    "Helium IoT"
}

#[post("/event", data = "<event>")]
fn event(event: Json<Event>) -> Json<Event> {
    return Json(event.into_inner());
}

fn main() {
    rocket::ignite().mount("/", routes![index, event]).launch();
}
